/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.remote.handlers;

import com.jaspersoft.jasperserver.api.common.domain.ValidationError;
import com.jaspersoft.jasperserver.api.common.domain.ValidationErrorFilter;
import com.jaspersoft.jasperserver.api.common.domain.ValidationErrors;
import com.jaspersoft.jasperserver.api.common.domain.impl.UniversalValidationErrorFilter;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.remote.AbstractService;
import com.jaspersoft.jasperserver.remote.ManagementServices;
import com.jaspersoft.jasperserver.remote.ResourceActionResolver;
import com.jaspersoft.jasperserver.remote.ResourceHandler;
import com.jaspersoft.jasperserver.remote.ResourceResolverAdapter;
import com.jaspersoft.jasperserver.remote.ServiceException;
import com.jaspersoft.jasperserver.remote.handlers.ResourceContainer;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractResourceHandler
implements ResourceHandler,
ResourceResolverAdapter {
    private static final Log log = LogFactory.getLog(AbstractResourceHandler.class);
    private ResourceActionResolver resourceActionResolver;

    public void setResourceActionHandler(ResourceActionResolver resourceActionResolver) {
        this.resourceActionResolver = resourceActionResolver;
    }

    public ResourceActionResolver getResourceActionResolver() {
        return this.resourceActionResolver;
    }

    public ResourceDescriptor get(Resource resource, Map options) throws ServiceException {
        ResourceDescriptor descriptor = new ResourceDescriptor();
        this.setCommonAttributes(resource, descriptor);
        this.doGet(resource, descriptor, options);
        return descriptor;
    }

    protected void setCommonAttributes(Resource resource, ResourceDescriptor descriptor) {
        descriptor.setUriString(resource.getURIString());
        descriptor.setDescription(resource.getDescription());
        descriptor.setLabel(resource.getLabel());
        descriptor.setName(resource.getName());
        descriptor.setResourceType(resource.getResourceType());
        descriptor.setParentFolder(resource.getParentFolder());
        descriptor.setVersion(resource.getVersion());
        descriptor.setCreationDate(resource.getCreationDate());
    }

    protected abstract void doGet(Resource var1, ResourceDescriptor var2, Map var3) throws ServiceException;

    protected void validate(Resource resource) throws ServiceException {
        UniversalValidationErrorFilter filter = resource.isNew() ? UniversalValidationErrorFilter.getInstance() : null;
        RepositoryService repositoryService = AbstractService.getContext().getManagementServices().getRepository();
        ValidationErrors errors = null;
        errors = resource instanceof Folder ? repositoryService.validateFolder(null, (Folder)resource, (ValidationErrorFilter)filter) : repositoryService.validateResource(null, resource, (ValidationErrorFilter)filter);
        if (errors.isError()) {
            String errorString = "";
            List errorsList = errors.getErrors();
            for (int i = 0; i < errorsList.size(); ++i) {
                ValidationError ve = (ValidationError)errorsList.get(i);
                if (errorString.length() > 0) {
                    errorString = errorString + "\n";
                }
                errorString = errorString + AbstractService.getContext().getMessage(ve.getErrorCode(), ve.getErrorArguments(), ve.getDefaultMessage());
            }
            throw new ServiceException(400, errorString);
        }
    }

    public ResourceDescriptor update(ResourceDescriptor descriptor, Map options) throws ServiceException {
        return this.update(descriptor, options, true);
    }

    public ResourceDescriptor update(ResourceDescriptor descriptor, Map options, boolean save) throws ServiceException {
        Resource subResource;
        ResourceHandler pResourceHandler;
        ManagementServices managementServices = AbstractService.getContext().getManagementServices();
        RepositoryService repositoryService = managementServices.getRepository();
        Resource parentResource = this.getParentResource(descriptor);
        ResourceContainer parentHandler = null;
        if (parentResource != null && (pResourceHandler = managementServices.getHandlerRegistry().getHandler(parentResource)) instanceof ResourceContainer) {
            parentHandler = (ResourceContainer)((Object)pResourceHandler);
        }
        if (descriptor.getIsNew()) {
            if (parentHandler == null) {
                Resource resource = this.createResource(descriptor);
                this.validate(resource);
                if (save) {
                    if (resource instanceof Folder) {
                        repositoryService.saveFolder(null, (Folder)resource);
                    } else {
                        repositoryService.saveResource(null, resource);
                    }
                }
                return managementServices.createResourceDescriptor(resource.getURIString());
            }
            subResource = parentHandler.attachSubResource(parentResource, descriptor);
            if (subResource != null) {
                this.validate(parentResource);
                if (save) {
                    repositoryService.saveResource(null, parentResource);
                }
                return managementServices.createResourceDescriptor(subResource);
            }
            throw new ServiceException(403, AbstractService.getContext().getMessage("webservices.error.cannotCreateResource", new String[]{parentResource.getParentFolder()}));
        }
        if (parentHandler == null) {
            log.debug((Object)("Put: modifying " + descriptor.getWsType()));
            Class resourceType = this.getResourceType();
            Object resource = null;
            resource = "folder".equals(descriptor.getWsType()) ? managementServices.getRepository().getFolder(null, descriptor.getUriString()) : managementServices.getRepository().getResource(null, descriptor.getUriString(), resourceType);
            if (resource == null) {
                throw new ServiceException(404, AbstractService.getContext().getMessage("webservices.error.resourceNotFound", new Object[0]));
            }
            this.updateResource((Resource)resource, descriptor, options);
            this.validate((Resource)resource);
            if (save) {
                if (resource instanceof Folder) {
                    repositoryService.saveFolder(null, resource);
                } else {
                    repositoryService.saveResource(null, (Resource)resource);
                }
            }
            return managementServices.createResourceDescriptor((Resource)resource);
        }
        subResource = parentHandler.attachSubResource(parentResource, descriptor);
        if (subResource != null) {
            this.validate(subResource);
            if (save) {
                repositoryService.saveResource(null, parentResource);
            }
            return managementServices.createResourceDescriptor(subResource);
        }
        throw new ServiceException(1, AbstractService.getContext().getManagementServices().getMessage("webservices.error.cannotCreateResource", new String[]{parentResource.getParentFolder()}, AbstractService.getContext().getLocale()));
    }

    protected Resource getModifyingParentResource(Map options) throws ServiceException {
        String reportUnitUrl;
        ReportUnit resource = null;
        if (options != null && options.containsKey("MODIFY_REPORTUNIT_URI") && (reportUnitUrl = (String)options.get("MODIFY_REPORTUNIT_URI")) != null && reportUnitUrl.length() > 0) {
            log.debug((Object)("Put: adding/modifying resource in reportUnit " + reportUnitUrl));
            ReportUnit reportUnit = (ReportUnit)AbstractService.getContext().getManagementServices().getRepository().getResource(null, reportUnitUrl);
            if (reportUnit == null) {
                throw new ServiceException(404, AbstractService.getContext().getMessage("webservices.error.reportUnitNotFound"));
            }
            resource = reportUnit;
        }
        return resource;
    }

    protected Resource createResource(ResourceDescriptor descriptor) throws ServiceException {
        Class resourceType = this.getResourceType();
        Resource resource = AbstractService.getContext().getManagementServices().getRepository().newResource(null, resourceType);
        resource.setParentFolder(descriptor.getParentFolder());
        resource.setVersion(-1);
        resource.setName(descriptor.getName());
        resource.setURIString(descriptor.getUriString());
        this.updateResource(resource, descriptor, null);
        return resource;
    }

    protected Resource createChildResource(ResourceDescriptor descriptor) throws ServiceException {
        String childType = descriptor.getWsType();
        ResourceHandler handler = AbstractService.getContext().getManagementServices().getHandlerRegistry().getHandler(childType);
        if (handler == null || !(handler instanceof AbstractResourceHandler)) {
            log.warn((Object)(handler.getClass().getName() + " does not implement AbstractResourceHandler"));
            return null;
        }
        return ((AbstractResourceHandler)handler).createResource(descriptor);
    }

    protected void updateResource(Resource resource, ResourceDescriptor descriptor, Map options) {
        resource.setLabel(descriptor.getLabel());
        resource.setDescription(descriptor.getDescription());
    }

    public boolean isDataSource(ResourceDescriptor rd) {
        String type = rd.getWsType();
        ResourceHandler handler = this.getManagementServices().getHandlerRegistry().getHandler(type);
        if (handler != null) {
            Class resourceType = handler.getResourceType();
            ResourceHandler parentHandler = this.getManagementServices().getHandlerRegistry().getHandler("datasource");
            Class parentResourceType = parentHandler.getResourceType();
            return parentResourceType.isAssignableFrom(resourceType);
        }
        return false;
    }

    protected ManagementServices getManagementServices() {
        return AbstractService.getContext().getManagementServices();
    }

    private Resource getParentResource(ResourceDescriptor descriptor) {
        String parentResourceUri;
        String resourceUri = descriptor.getUriString();
        int lastSeparatorPos = descriptor.getUriString().lastIndexOf("/");
        String string = parentResourceUri = lastSeparatorPos == 0 ? null : resourceUri.substring(0, lastSeparatorPos);
        if (parentResourceUri == null) {
            return null;
        }
        if (parentResourceUri.endsWith("_files")) {
            parentResourceUri.substring(0, parentResourceUri.length() - "_files".length());
        }
        try {
            return AbstractService.getContext().getManagementServices().locateResource(parentResourceUri);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public void delete(ResourceDescriptor descriptor) throws ServiceException {
        AbstractService context = AbstractService.getContext();
        ResourceActionResolver resourceActionResolver = context.getManagementServices().getResourceActionResolver();
        if (resourceActionResolver.isResourceDeletable(descriptor.getUriString())) {
            if (descriptor.getWsType().equals("folder")) {
                this.getManagementServices().getRepository().deleteFolder(null, descriptor.getUriString());
            } else {
                ResourceHandler pResourceHandler;
                Resource parentResource = this.getParentResource(descriptor);
                if (parentResource != null && (pResourceHandler = context.getManagementServices().getHandlerRegistry().getHandler(parentResource)) instanceof ResourceContainer) {
                    ((ResourceContainer)((Object)pResourceHandler)).detachSubResource(parentResource, descriptor);
                    this.getManagementServices().getRepository().saveResource(null, parentResource);
                }
                this.getManagementServices().getRepository().deleteResource(null, descriptor.getUriString());
            }
        } else {
            throw new ServiceException(403, context.getMessage("webservices.error.notDeletableResource", null));
        }
    }
}

