/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.remote.handlers;

import com.jaspersoft.jasperserver.api.metadata.common.domain.ContentResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResourceData;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.remote.AbstractService;
import com.jaspersoft.jasperserver.remote.ResourceDataSource;
import com.jaspersoft.jasperserver.remote.ServiceException;
import com.jaspersoft.jasperserver.remote.handlers.RepositoryResourceHandler;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.activation.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ContentResourceHandler
extends RepositoryResourceHandler {
    private static final Log log = LogFactory.getLog(ContentResourceHandler.class);
    private static final String MAIN_ATTACHMENT_ID = "attachment";

    public Class getResourceType() {
        return ContentResource.class;
    }

    protected void doGet(Resource resource, ResourceDescriptor descriptor, Map options) throws ServiceException {
        ContentResource contentRes = (ContentResource)resource;
        descriptor.setWsType("contentResource");
        descriptor.setResourceProperty("CONTENT_TYPE", contentRes.getFileType());
        if (options == null || options.containsKey("NO_ATTACHMENT")) {
            descriptor.setHasData(false);
        } else {
            descriptor.setHasData(true);
            this.addMainAttachment(descriptor);
            if (!options.containsKey("NO_SUBRESOURCE_ATTACHMENTS")) {
                this.addSubAttachments(contentRes, descriptor);
            }
        }
    }

    protected void updateResource(Resource resource, ResourceDescriptor descriptor, Map options) throws ServiceException {
        List children;
        super.updateResource(resource, descriptor, options);
        ContentResource contentRes = (ContentResource)resource;
        String fileType = descriptor.getResourcePropertyValue("CONTENT_TYPE");
        if (fileType != null) {
            contentRes.setFileType(fileType);
        }
        if (descriptor.getHasData()) {
            DataSource ds = this.locateDataAttachment(descriptor);
            this.readData(contentRes, ds);
        }
        ArrayList<ContentResource> subresources = new ArrayList<ContentResource>((children = descriptor.getChildren()) == null ? 0 : children.size());
        if (children != null) {
            for (ResourceDescriptor subdescriptor : children) {
                ContentResource subresource = (ContentResource)this.createChildResource(subdescriptor);
                subresources.add(subresource);
            }
        }
        contentRes.setResources(subresources);
    }

    protected DataSource locateDataAttachment(ResourceDescriptor resourceDescriptor) throws ServiceException {
        DataSource ds;
        String contentName = resourceDescriptor.getResourcePropertyValue("DATA_ATTACHMENT_ID");
        if (contentName == null) {
            contentName = resourceDescriptor.getName();
        }
        if ((ds = AbstractService.getContext().getInputAttachments().get(contentName)) == null) {
            throw new ServiceException(2, AbstractService.getContext().getMessage("webservices.error.content.resource.data.not.present", new Object[]{contentName}));
        }
        return ds;
    }

    protected String getAttachmentContentID(ContentResource contentRes) {
        return contentRes.getName();
    }

    protected void readData(ContentResource resource, DataSource dataSource) throws ServiceException {
        boolean close = true;
        InputStream dataStream = null;
        try {
            dataStream = dataSource.getInputStream();
            resource.readData(dataStream);
            close = false;
            dataStream.close();
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        finally {
            if (close && dataStream != null) {
                try {
                    dataStream.close();
                }
                catch (IOException e) {
                    log.error((Object)"Error closing attachment stream", (Throwable)e);
                }
            }
        }
    }

    protected void addMainAttachment(ResourceDescriptor descriptor) {
        FileResourceData fileData = AbstractService.getContext().getManagementServices().getRepository().getContentResourceData(null, descriptor.getUriString());
        ResourceDataSource attachmentSource = new ResourceDataSource(descriptor.getName(), fileData);
        AbstractService.getContext().getOutputAttachments().put(MAIN_ATTACHMENT_ID, attachmentSource);
        descriptor.setResourceProperty("DATA_ATTACHMENT_ID", MAIN_ATTACHMENT_ID);
    }

    protected void addSubAttachments(ContentResource contentRes, ResourceDescriptor descriptor) {
        List resources;
        if (contentRes.getFileType().equals("html") && (resources = contentRes.getResources()) != null && !resources.isEmpty()) {
            for (ContentResource subResource : resources) {
                FileResourceData subData = AbstractService.getContext().getManagementServices().getRepository().getContentResourceData(null, subResource.getURIString());
                ResourceDataSource subAttachment = new ResourceDataSource(subResource.getName(), subData);
                AbstractService.getContext().getOutputAttachments().put(subResource.getName(), subAttachment);
                descriptor.setResourceProperty("DATA_ATTACHMENT_ID", MAIN_ATTACHMENT_ID);
            }
        }
    }
}

