/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.remote.scheduling;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJob;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobSummary;
import com.jaspersoft.jasperserver.api.engine.scheduling.service.ReportSchedulingService;
import com.jaspersoft.jasperserver.api.logging.audit.context.AuditContext;
import com.jaspersoft.jasperserver.api.logging.audit.domain.AuditEvent;
import com.jaspersoft.jasperserver.remote.ServiceException;
import com.jaspersoft.jasperserver.remote.scheduling.ReportJobBeanTraslator;
import com.jaspersoft.jasperserver.remote.scheduling.ReportSchedulerService;
import com.jaspersoft.jasperserver.remote.scheduling.models.Job;
import com.jaspersoft.jasperserver.remote.scheduling.models.JobSummary;
import java.util.List;
import java.util.Locale;
import org.springframework.context.i18n.LocaleContextHolder;

public class ReportSchedulerServiceImpl
implements ReportSchedulerService {
    private ReportSchedulingService scheduler;
    private ReportJobBeanTraslator beanTraslator;
    private AuditContext auditContext;

    protected void createAuditReportSchedulingEvent(final String jobType) {
        this.auditContext.doInAuditContext(new AuditContext.AuditContextCallback(){

            public void execute() {
                ReportSchedulerServiceImpl.this.auditContext.createAuditEvent(jobType);
            }
        });
    }

    protected void closeReportSchedulingAuditEvent(String jobType) {
        this.auditContext.doInAuditContext(jobType, new AuditContext.AuditContextCallbackWithEvent(){

            public void execute(AuditEvent auditEvent) {
                ReportSchedulerServiceImpl.this.auditContext.closeAuditEvent(auditEvent);
            }
        });
    }

    public void deleteJob(long id) throws ServiceException {
        this.createAuditReportSchedulingEvent("deleteReportScheduling");
        this.scheduler.removeScheduledJob(this.makeExecutionContext(), id);
        this.closeReportSchedulingAuditEvent("deleteReportScheduling");
    }

    public void deleteJobs(long[] ids) throws ServiceException {
        this.scheduler.removeScheduledJobs(this.makeExecutionContext(), ids);
    }

    public Job getJob(long id) throws ServiceException {
        ReportJob reportJob = this.scheduler.getScheduledJob(this.makeExecutionContext(), id);
        if (reportJob == null) {
            throw new JSException("report.scheduling.ws.job.not.found", new Object[]{new Long(id)});
        }
        Job job = this.beanTraslator.toServiceBean(reportJob);
        return job;
    }

    public Job scheduleJob(Job job) throws ServiceException {
        ReportJob reportJob = new ReportJob();
        this.beanTraslator.copy(reportJob, job);
        reportJob.setVersion(-1);
        this.createAuditReportSchedulingEvent("scheduleReport");
        ReportJob savedJob = this.scheduler.scheduleJob(this.makeExecutionContext(), reportJob);
        this.closeReportSchedulingAuditEvent("scheduleReport");
        Job savedServiceJob = this.beanTraslator.toServiceBean(savedJob);
        return savedServiceJob;
    }

    public Job updateJob(Job job) throws ServiceException {
        ReportJob reportJob = new ReportJob();
        this.beanTraslator.copy(reportJob, job);
        ExecutionContext executionContext = this.makeExecutionContext();
        this.createAuditReportSchedulingEvent("updateReportScheduling");
        this.scheduler.updateScheduledJob(executionContext, reportJob);
        this.closeReportSchedulingAuditEvent("updateReportScheduling");
        ReportJob savedJob = this.scheduler.getScheduledJob(executionContext, reportJob.getId());
        Job savedServiceJob = this.beanTraslator.toServiceBean(savedJob);
        return savedServiceJob;
    }

    public JobSummary[] getAllJobs() throws ServiceException {
        List scheduledJobs = this.scheduler.getScheduledJobs(this.makeExecutionContext());
        return this.toSummaryArray(scheduledJobs);
    }

    public JobSummary[] getReportJobs(String reportURI) throws ServiceException {
        List scheduledJobs = this.scheduler.getScheduledJobs(this.makeExecutionContext(), reportURI);
        return this.toSummaryArray(scheduledJobs);
    }

    protected JobSummary[] toSummaryArray(List reportJobSummaries) {
        JobSummary[] jobs;
        if (reportJobSummaries == null || reportJobSummaries.isEmpty()) {
            jobs = null;
        } else {
            jobs = new JobSummary[reportJobSummaries.size()];
            int idx = 0;
            for (ReportJobSummary reportJob : reportJobSummaries) {
                jobs[idx] = this.beanTraslator.toServiceSummary(reportJob);
                ++idx;
            }
        }
        return jobs;
    }

    protected ExecutionContext makeExecutionContext() {
        ExecutionContextImpl executionContext = new ExecutionContextImpl();
        executionContext.setLocale(this.getLocale());
        return executionContext;
    }

    protected Locale getLocale() {
        return LocaleContextHolder.getLocale();
    }

    public ReportSchedulingService getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(ReportSchedulingService scheduler) {
        this.scheduler = scheduler;
    }

    public ReportJobBeanTraslator getBeanTraslator() {
        return this.beanTraslator;
    }

    public void setBeanTraslator(ReportJobBeanTraslator beanTraslator) {
        this.beanTraslator = beanTraslator;
    }

    public AuditContext getAuditContext() {
        return this.auditContext;
    }

    public void setAuditContext(AuditContext auditContext) {
        this.auditContext = auditContext;
    }
}

