/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.remote.services;

import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.remote.AbstractService;
import com.jaspersoft.jasperserver.remote.ServiceException;
import com.jaspersoft.jasperserver.ws.scheduling.Job;
import com.jaspersoft.jasperserver.ws.scheduling.JobSummary;
import java.util.HashMap;
import java.util.Map;
import org.apache.axis.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetService
extends AbstractService {
    private static final Log log = LogFactory.getLog(GetService.class);

    public GetService(ApplicationContext context) {
        super(context);
    }

    public ResourceDescriptor getResource(String resourceURI, Map<String, Object> options) throws ServiceException {
        Resource resource = this.getManagementServices().locateResource(resourceURI);
        if (resource == null) {
            log.warn((Object)("Get: null resourceDescriptor for " + resourceURI));
            throw new ServiceException(404, this.getMessage("webservices.error.resourceNotFound"));
        }
        ResourceDescriptor rd = this.getManagementServices().createResourceDescriptor(resource, this.processDescriptorOptions(options));
        return rd;
    }

    protected Map processDescriptorOptions(Map options) {
        if (options == null) {
            options = new HashMap<String, Boolean>();
        }
        if (!options.containsKey("ReportUnitContents")) {
            options.put("ReportUnitContents", Boolean.TRUE);
        }
        return options;
    }

    public Job getJob(long jobId) throws ServiceException {
        try {
            return this.getManagementServices().getSchedulerService().getJob(jobId);
        }
        catch (AxisFault axisFault) {
            throw new ServiceException(500, axisFault.getLocalizedMessage());
        }
    }

    public JobSummary[] getJobSummery(String reportURI) throws ServiceException {
        try {
            return this.getManagementServices().getSchedulerService().getReportJobs(reportURI);
        }
        catch (AxisFault axisFault) {
            throw new ServiceException(500, axisFault.getLocalizedMessage());
        }
    }
}

