/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.remote.utils;

import com.jaspersoft.jasperserver.api.logging.audit.context.AuditContext;
import com.jaspersoft.jasperserver.api.logging.audit.domain.AuditEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuditHelper {
    protected static final Log log = LogFactory.getLog(AuditHelper.class);
    protected AuditContext auditContext;

    public AuditHelper(AuditContext auditContext) {
        this.auditContext = auditContext;
    }

    public void createAuditEvent(final String auditEventType) {
        this.auditContext.doInAuditContext(new AuditContext.AuditContextCallback(){

            public void execute() {
                AuditHelper.this.auditContext.createAuditEvent(auditEventType);
            }
        });
    }

    public void addPropertyToAuditEvent(String auditEventType, final String propertyName, final Object property) {
        this.auditContext.doInAuditContext(auditEventType, new AuditContext.AuditContextCallbackWithEvent(){

            public void execute(AuditEvent auditEvent) {
                AuditHelper.this.auditContext.addPropertyToAuditEvent(propertyName, property, auditEvent);
            }
        });
    }

    public void addExceptionToAllAuditEvents(final Throwable exception) {
        this.auditContext.doInAuditContext(new String[]{"saveResource", "updateResource", "deleteResource", "copyResource", "moveResource", "createFolder", "updateFolder", "deleteFolder", "copyFolder", "moveFolder", "runReport"}, new AuditContext.AuditContextCallbackWithEvent(){

            public void execute(AuditEvent auditEvent) {
                AuditHelper.this.auditContext.addPropertyToAuditEvent("exception", (Object)exception, auditEvent);
            }
        });
    }

    public void createAuditEvent(String operation, String wsType, boolean isNew) {
        if ("copy".equals(operation)) {
            if ("folder".equals(wsType)) {
                this.createAuditEvent("copyFolder");
            } else {
                this.createAuditEvent("copyResource");
            }
        } else if ("move".equals(operation)) {
            if ("folder".equals(wsType)) {
                this.createAuditEvent("moveFolder");
            } else {
                this.createAuditEvent("moveResource");
            }
        } else if ("delete".equals(operation)) {
            if ("folder".equals(wsType)) {
                this.createAuditEvent("deleteFolder");
            } else {
                this.createAuditEvent("deleteResource");
            }
        } else if ("put".equals(operation)) {
            if ("folder".equals(wsType)) {
                if (isNew) {
                    this.createAuditEvent("createFolder");
                } else {
                    this.createAuditEvent("updateFolder");
                }
            } else if (isNew) {
                this.createAuditEvent("saveResource");
            } else {
                this.createAuditEvent("updateResource");
            }
        } else if ("get".equals(operation) && !"folder".equals(wsType)) {
            this.createAuditEvent("accessResource");
        }
    }
}

