/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.core.util;

import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceLookup;
import java.util.List;
import java.util.Map;

public class CollectionUtil {
    public static String listToDebugString(List list) {
        StringBuilder sb = new StringBuilder("[");
        for (Object o : list) {
            String item = o.toString();
            if (o instanceof ResourceLookup) {
                item = ((ResourceLookup)o).getURIString();
            }
            sb.append(item).append(", ");
        }
        return sb.append("]").toString();
    }

    public static String mapToDebugString(Map map) {
        StringBuilder sb = new StringBuilder("\n{").append("\n");
        for (Object k : map.keySet()) {
            Object v = map.get(k);
            if (k instanceof Class) {
                sb.append("\t").append(((Class)k).getName()).append(" : ");
            } else {
                sb.append(k).append(" : ");
            }
            if (v instanceof List) {
                sb.append(CollectionUtil.listToDebugString((List)v)).append(", ");
            } else {
                sb.append(v).append(", ");
            }
            sb.append("\n");
        }
        sb.replace(sb.length() - 3, sb.length(), "");
        return sb.append("\n}\n").toString();
    }

    public static byte[] copyOfRange(byte[] original, int from, int to) {
        int newLength = to - from;
        if (newLength < 0) {
            throw new IllegalArgumentException(from + " > " + to);
        }
        byte[] copy = new byte[newLength];
        System.arraycopy(original, from, copy, 0, Math.min(original.length - from, newLength));
        return copy;
    }
}

