/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.shade.org.codehaus.plexus.util.cli.shell;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.surefire.shade.org.codehaus.plexus.util.cli.CommandLineException;
import org.apache.maven.surefire.shade.org.codehaus.plexus.util.cli.CommandLineUtils;

public class Shell
implements Cloneable {
    private String shellCommand;
    private List shellArgs = new ArrayList();
    private boolean quotedArgumentsEnabled = true;
    private String executable;
    private File workingDir;
    private boolean quotedExecutableEnabled = true;
    private boolean doubleQuotedArgumentEscaped = false;
    private boolean singleQuotedArgumentEscaped = false;
    private boolean doubleQuotedExecutableEscaped = false;
    private boolean singleQuotedExecutableEscaped = false;

    public void setShellCommand(String shellCommand) {
        this.shellCommand = shellCommand;
    }

    public String getShellCommand() {
        return this.shellCommand;
    }

    public void setShellArgs(String[] shellArgs) {
        this.shellArgs.clear();
        this.shellArgs.addAll(Arrays.asList(shellArgs));
    }

    public String[] getShellArgs() {
        if (this.shellArgs == null || this.shellArgs.isEmpty()) {
            return null;
        }
        return this.shellArgs.toArray(new String[this.shellArgs.size()]);
    }

    public List getCommandLine(String executable, String[] arguments) {
        return this.getRawCommandLine(executable, arguments);
    }

    private List getRawCommandLine(String executable, String[] arguments) {
        ArrayList<String> commandLine = new ArrayList<String>();
        try {
            StringBuffer sb = new StringBuffer();
            if (executable != null) {
                if (this.isQuotedExecutableEnabled()) {
                    sb.append(CommandLineUtils.quote(executable, this.isSingleQuotedExecutableEscaped(), this.isDoubleQuotedExecutableEscaped(), false));
                } else {
                    sb.append(executable);
                }
            }
            for (int i = 0; i < arguments.length; ++i) {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                if (this.isQuotedArgumentsEnabled()) {
                    sb.append(CommandLineUtils.quote(arguments[i], this.isSingleQuotedArgumentEscaped(), this.isDoubleQuotedArgumentEscaped(), false));
                    continue;
                }
                sb.append(arguments[i]);
            }
            commandLine.add(sb.toString());
        }
        catch (CommandLineException e) {
            throw new RuntimeException(e.getMessage());
        }
        return commandLine;
    }

    protected boolean isDoubleQuotedArgumentEscaped() {
        return this.doubleQuotedArgumentEscaped;
    }

    protected boolean isSingleQuotedArgumentEscaped() {
        return this.singleQuotedArgumentEscaped;
    }

    protected boolean isDoubleQuotedExecutableEscaped() {
        return this.doubleQuotedExecutableEscaped;
    }

    protected boolean isSingleQuotedExecutableEscaped() {
        return this.singleQuotedExecutableEscaped;
    }

    public List getShellCommandLine(String[] arguments) {
        ArrayList<String> commandLine = new ArrayList<String>();
        if (this.getShellCommand() != null) {
            commandLine.add(this.getShellCommand());
        }
        if (this.getShellArgs() != null) {
            commandLine.addAll(this.getShellArgsList());
        }
        commandLine.addAll(this.getCommandLine(this.getExecutable(), arguments));
        return commandLine;
    }

    public List getShellArgsList() {
        return this.shellArgs;
    }

    public void addShellArg(String arg) {
        this.shellArgs.add(arg);
    }

    public void setQuotedArgumentsEnabled(boolean quotedArgumentsEnabled) {
        this.quotedArgumentsEnabled = quotedArgumentsEnabled;
    }

    public boolean isQuotedArgumentsEnabled() {
        return this.quotedArgumentsEnabled;
    }

    public void setQuotedExecutableEnabled(boolean quotedExecutableEnabled) {
        this.quotedExecutableEnabled = quotedExecutableEnabled;
    }

    public boolean isQuotedExecutableEnabled() {
        return this.quotedExecutableEnabled;
    }

    public void setExecutable(String executable) {
        if (executable == null || executable.length() == 0) {
            return;
        }
        this.executable = executable.replace('/', File.separatorChar).replace('\\', File.separatorChar);
    }

    public String getExecutable() {
        return this.executable;
    }

    public void setWorkingDirectory(String path) {
        if (path != null) {
            this.workingDir = new File(path);
        }
    }

    public void setWorkingDirectory(File workingDir) {
        this.workingDir = workingDir;
    }

    public File getWorkingDirectory() {
        return this.workingDir;
    }

    public void clearArguments() {
        this.shellArgs.clear();
    }

    public Object clone() {
        Shell shell = new Shell();
        shell.setExecutable(this.getExecutable());
        shell.setWorkingDirectory(this.getWorkingDirectory());
        shell.setShellArgs(this.getShellArgs());
        return shell;
    }

    public String getOriginalExecutable() {
        return this.executable;
    }

    public List getOriginalCommandLine(String executable, String[] arguments) {
        return this.getRawCommandLine(executable, arguments);
    }

    protected void setDoubleQuotedArgumentEscaped(boolean doubleQuotedArgumentEscaped) {
        this.doubleQuotedArgumentEscaped = doubleQuotedArgumentEscaped;
    }

    protected void setDoubleQuotedExecutableEscaped(boolean doubleQuotedExecutableEscaped) {
        this.doubleQuotedExecutableEscaped = doubleQuotedExecutableEscaped;
    }

    protected void setSingleQuotedArgumentEscaped(boolean singleQuotedArgumentEscaped) {
        this.singleQuotedArgumentEscaped = singleQuotedArgumentEscaped;
    }

    protected void setSingleQuotedExecutableEscaped(boolean singleQuotedExecutableEscaped) {
        this.singleQuotedExecutableEscaped = singleQuotedExecutableEscaped;
    }
}

