/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.Statistics;
import net.sf.ehcache.Status;
import net.sf.ehcache.bootstrap.BootstrapCacheLoader;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.DiskStoreConfiguration;
import net.sf.ehcache.config.TerracottaConfiguration;
import net.sf.ehcache.event.CacheEventListener;
import net.sf.ehcache.event.RegisteredEventListeners;
import net.sf.ehcache.exceptionhandler.CacheExceptionHandler;
import net.sf.ehcache.extension.CacheExtension;
import net.sf.ehcache.loader.CacheLoader;
import net.sf.ehcache.statistics.CacheUsageListener;
import net.sf.ehcache.statistics.LiveCacheStatistics;
import net.sf.ehcache.statistics.LiveCacheStatisticsData;
import net.sf.ehcache.statistics.LiveCacheStatisticsWrapper;
import net.sf.ehcache.statistics.sampled.SampledCacheStatistics;
import net.sf.ehcache.statistics.sampled.SampledCacheStatisticsWrapper;
import net.sf.ehcache.store.DiskStore;
import net.sf.ehcache.store.LruMemoryStore;
import net.sf.ehcache.store.MemoryStore;
import net.sf.ehcache.store.MemoryStoreEvictionPolicy;
import net.sf.ehcache.store.Policy;
import net.sf.ehcache.store.Store;
import net.sf.ehcache.util.NamedThreadFactory;
import net.sf.ehcache.util.TimeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cache
implements Ehcache {
    public static final String DEFAULT_CACHE_NAME = "default";
    public static final String NET_SF_EHCACHE_DISABLED = "net.sf.ehcache.disabled";
    public static final String NET_SF_EHCACHE_USE_CLASSIC_LRU = "net.sf.ehcache.use.classic.lru";
    public static final long DEFAULT_EXPIRY_THREAD_INTERVAL_SECONDS = 120L;
    private static final int DEFAULT_SPOOL_BUFFER_SIZE = 30;
    private static final Logger LOG = LoggerFactory.getLogger((String)Cache.class.getName());
    private static final MemoryStoreEvictionPolicy DEFAULT_MEMORY_STORE_EVICTION_POLICY = MemoryStoreEvictionPolicy.LRU;
    private static InetAddress localhost;
    private static final int BACK_OFF_TIME_MILLIS = 50;
    private static final int EXECUTOR_KEEP_ALIVE_TIME = 60000;
    private static final int EXECUTOR_MAXIMUM_POOL_SIZE;
    private static final int EXECUTOR_CORE_POOL_SIZE = 1;
    private volatile boolean disabled = Boolean.getBoolean("net.sf.ehcache.disabled");
    private final boolean useClassicLru = Boolean.getBoolean("net.sf.ehcache.use.classic.lru");
    private volatile Store diskStore;
    private volatile String diskStorePath;
    private volatile Status status;
    private volatile CacheConfiguration configuration;
    private volatile Store memoryStore;
    private volatile RegisteredEventListeners registeredEventListeners;
    private volatile List<CacheExtension> registeredCacheExtensions;
    private volatile String guid;
    private volatile CacheManager cacheManager;
    private volatile BootstrapCacheLoader bootstrapCacheLoader;
    private volatile CacheExceptionHandler cacheExceptionHandler;
    private volatile List<CacheLoader> registeredCacheLoaders;
    private volatile ExecutorService executorService;
    private volatile LiveCacheStatisticsData liveCacheStatisticsData;
    private volatile SampledCacheStatisticsWrapper sampledCacheStatistics;

    public Cache(String name, int maxElementsInMemory, boolean overflowToDisk, boolean eternal, long timeToLiveSeconds, long timeToIdleSeconds) {
        this(name, maxElementsInMemory, DEFAULT_MEMORY_STORE_EVICTION_POLICY, overflowToDisk, null, eternal, timeToLiveSeconds, timeToIdleSeconds, false, 120L, null, null);
    }

    public Cache(String name, int maxElementsInMemory, boolean overflowToDisk, boolean eternal, long timeToLiveSeconds, long timeToIdleSeconds, boolean diskPersistent, long diskExpiryThreadIntervalSeconds) {
        this(name, maxElementsInMemory, DEFAULT_MEMORY_STORE_EVICTION_POLICY, overflowToDisk, null, eternal, timeToLiveSeconds, timeToIdleSeconds, diskPersistent, diskExpiryThreadIntervalSeconds, null, null);
        LOG.warn("An API change between ehcache-1.1 and ehcache-1.2 results in the persistence path being set to " + DiskStoreConfiguration.getDefaultPath() + " when the ehcache-1.1 constructor is used. " + "Please change to the 1.2 constructor.");
    }

    public Cache(String name, int maxElementsInMemory, MemoryStoreEvictionPolicy memoryStoreEvictionPolicy, boolean overflowToDisk, String diskStorePath, boolean eternal, long timeToLiveSeconds, long timeToIdleSeconds, boolean diskPersistent, long diskExpiryThreadIntervalSeconds, RegisteredEventListeners registeredEventListeners) {
        this(name, maxElementsInMemory, memoryStoreEvictionPolicy, overflowToDisk, diskStorePath, eternal, timeToLiveSeconds, timeToIdleSeconds, diskPersistent, diskExpiryThreadIntervalSeconds, registeredEventListeners, null);
    }

    public Cache(String name, int maxElementsInMemory, MemoryStoreEvictionPolicy memoryStoreEvictionPolicy, boolean overflowToDisk, String diskStorePath, boolean eternal, long timeToLiveSeconds, long timeToIdleSeconds, boolean diskPersistent, long diskExpiryThreadIntervalSeconds, RegisteredEventListeners registeredEventListeners, BootstrapCacheLoader bootstrapCacheLoader) {
        this(name, maxElementsInMemory, memoryStoreEvictionPolicy, overflowToDisk, diskStorePath, eternal, timeToLiveSeconds, timeToIdleSeconds, diskPersistent, diskExpiryThreadIntervalSeconds, registeredEventListeners, bootstrapCacheLoader, 0);
    }

    public Cache(String name, int maxElementsInMemory, MemoryStoreEvictionPolicy memoryStoreEvictionPolicy, boolean overflowToDisk, String diskStorePath, boolean eternal, long timeToLiveSeconds, long timeToIdleSeconds, boolean diskPersistent, long diskExpiryThreadIntervalSeconds, RegisteredEventListeners registeredEventListeners, BootstrapCacheLoader bootstrapCacheLoader, int maxElementsOnDisk) {
        this(name, maxElementsInMemory, memoryStoreEvictionPolicy, overflowToDisk, diskStorePath, eternal, timeToLiveSeconds, timeToIdleSeconds, diskPersistent, diskExpiryThreadIntervalSeconds, registeredEventListeners, bootstrapCacheLoader, maxElementsOnDisk, 0, true, false, null, true);
    }

    public Cache(String name, int maxElementsInMemory, MemoryStoreEvictionPolicy memoryStoreEvictionPolicy, boolean overflowToDisk, String diskStorePath, boolean eternal, long timeToLiveSeconds, long timeToIdleSeconds, boolean diskPersistent, long diskExpiryThreadIntervalSeconds, RegisteredEventListeners registeredEventListeners, BootstrapCacheLoader bootstrapCacheLoader, int maxElementsOnDisk, int diskSpoolBufferSizeMB) {
        this(name, maxElementsInMemory, memoryStoreEvictionPolicy, overflowToDisk, diskStorePath, eternal, timeToLiveSeconds, timeToIdleSeconds, diskPersistent, diskExpiryThreadIntervalSeconds, registeredEventListeners, bootstrapCacheLoader, maxElementsOnDisk, diskSpoolBufferSizeMB, true, false, null, true);
    }

    public Cache(String name, int maxElementsInMemory, MemoryStoreEvictionPolicy memoryStoreEvictionPolicy, boolean overflowToDisk, String diskStorePath, boolean eternal, long timeToLiveSeconds, long timeToIdleSeconds, boolean diskPersistent, long diskExpiryThreadIntervalSeconds, RegisteredEventListeners registeredEventListeners, BootstrapCacheLoader bootstrapCacheLoader, int maxElementsOnDisk, int diskSpoolBufferSizeMB, boolean clearOnFlush) {
        this(name, maxElementsInMemory, memoryStoreEvictionPolicy, overflowToDisk, diskStorePath, eternal, timeToLiveSeconds, timeToIdleSeconds, diskPersistent, diskExpiryThreadIntervalSeconds, registeredEventListeners, bootstrapCacheLoader, maxElementsOnDisk, diskSpoolBufferSizeMB, clearOnFlush, false, null, true);
    }

    public Cache(String name, int maxElementsInMemory, MemoryStoreEvictionPolicy memoryStoreEvictionPolicy, boolean overflowToDisk, String diskStorePath, boolean eternal, long timeToLiveSeconds, long timeToIdleSeconds, boolean diskPersistent, long diskExpiryThreadIntervalSeconds, RegisteredEventListeners registeredEventListeners, BootstrapCacheLoader bootstrapCacheLoader, int maxElementsOnDisk, int diskSpoolBufferSizeMB, boolean clearOnFlush, boolean isTerracottaClustered, String terracottaValueMode, boolean terracottaCoherentReads) {
        this.changeStatus(Status.STATUS_UNINITIALISED);
        this.configuration = new CacheConfiguration();
        this.configuration.setName(name);
        this.configuration.setMaxElementsInMemory(maxElementsInMemory);
        this.configuration.setMemoryStoreEvictionPolicyFromObject(memoryStoreEvictionPolicy);
        this.configuration.setOverflowToDisk(overflowToDisk);
        this.configuration.setEternal(eternal);
        this.configuration.setTimeToLiveSeconds(timeToLiveSeconds);
        this.configuration.setTimeToIdleSeconds(timeToIdleSeconds);
        this.configuration.setDiskPersistent(diskPersistent);
        this.configuration.setMaxElementsOnDisk(maxElementsOnDisk);
        this.configuration.setClearOnFlush(clearOnFlush);
        this.guid = this.createGuid();
        this.diskStorePath = diskStorePath == null ? DiskStoreConfiguration.getDefaultPath() : diskStorePath;
        this.registeredEventListeners = registeredEventListeners == null ? new RegisteredEventListeners(this) : registeredEventListeners;
        this.registeredCacheExtensions = new CopyOnWriteArrayList<CacheExtension>();
        this.registeredCacheLoaders = new CopyOnWriteArrayList<CacheLoader>();
        if (diskExpiryThreadIntervalSeconds == 0L) {
            this.configuration.setDiskExpiryThreadIntervalSeconds(120L);
        } else {
            this.configuration.setDiskExpiryThreadIntervalSeconds(diskExpiryThreadIntervalSeconds);
        }
        if (diskSpoolBufferSizeMB == 0) {
            this.configuration.setDiskSpoolBufferSizeMB(30);
        } else {
            this.configuration.setDiskSpoolBufferSizeMB(diskSpoolBufferSizeMB);
        }
        if (memoryStoreEvictionPolicy == null) {
            this.configuration.setMemoryStoreEvictionPolicyFromObject(DEFAULT_MEMORY_STORE_EVICTION_POLICY);
        }
        this.bootstrapCacheLoader = bootstrapCacheLoader;
        TerracottaConfiguration tcConfig = new TerracottaConfiguration();
        tcConfig.setClustered(isTerracottaClustered);
        if (terracottaValueMode != null) {
            tcConfig.setValueMode(terracottaValueMode);
        }
        tcConfig.setCoherentReads(terracottaCoherentReads);
        this.configuration.addTerracotta(tcConfig);
        this.liveCacheStatisticsData = new LiveCacheStatisticsWrapper(this);
        this.sampledCacheStatistics = new SampledCacheStatisticsWrapper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialise() {
        Cache cache = this;
        synchronized (cache) {
            if (!this.status.equals(Status.STATUS_UNINITIALISED)) {
                throw new IllegalStateException("Cannot initialise the " + this.configuration.getName() + " cache because its status is not STATUS_UNINITIALISED");
            }
            if (this.configuration.getMaxElementsInMemory() == 0) {
                LOG.warn("Cache: " + this.configuration.getName() + " has a maxElementsInMemory of 0. It is strongly recommended to " + "have a maximumSize of at least 1. Performance is halved by not using a MemoryStore.");
            }
            this.diskStore = this.createDiskStore();
            this.memoryStore = this.isTerracottaClustered() ? this.cacheManager.createTerracottaStore(this) : (this.useClassicLru && this.configuration.getMemoryStoreEvictionPolicy().equals(MemoryStoreEvictionPolicy.LRU) ? new LruMemoryStore(this, this.diskStore) : MemoryStore.create(this, this.diskStore));
            this.changeStatus(Status.STATUS_ALIVE);
            this.initialiseRegisteredCacheExtensions();
            this.initialiseRegisteredCacheLoaders();
            this.getCacheEventNotificationService().registerListener(this.liveCacheStatisticsData);
            this.liveCacheStatisticsData.setStatisticsAccuracy(1);
            this.liveCacheStatisticsData.setStatisticsEnabled(true);
            this.registerCacheUsageListener(this.sampledCacheStatistics);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Initialised cache: " + this.configuration.getName());
        }
        if (this.disabled) {
            LOG.warn("Cache: " + this.configuration.getName() + " is disabled because the " + NET_SF_EHCACHE_DISABLED + " property was set to true. No elements will be added to the cache.");
        }
    }

    protected Store createDiskStore() {
        if (this.isDiskStore()) {
            return new DiskStore(this, this.diskStorePath);
        }
        return null;
    }

    protected boolean isDiskStore() {
        return this.configuration.isOverflowToDisk() || this.configuration.isDiskPersistent();
    }

    protected boolean isTerracottaClustered() {
        return this.configuration.isTerracottaClustered();
    }

    @Override
    public void bootstrap() {
        if (!this.disabled && this.bootstrapCacheLoader != null) {
            this.bootstrapCacheLoader.load(this);
        }
    }

    private void changeStatus(Status status) {
        this.status = status;
    }

    @Override
    public final void put(Element element) throws IllegalArgumentException, IllegalStateException, CacheException {
        this.put(element, false);
    }

    @Override
    public final void put(Element element, boolean doNotNotifyCacheReplicators) throws IllegalArgumentException, IllegalStateException, CacheException {
        boolean elementExists;
        this.checkStatus();
        if (this.disabled) {
            return;
        }
        if (element == null) {
            if (doNotNotifyCacheReplicators) {
                LOG.debug("Element from replicated put is null. This happens because the element is a SoftReference and it has been collected.Increase heap memory on the JVM or set -Xms to be the same as -Xmx to avoid this problem.");
            }
            return;
        }
        if (element.getObjectKey() == null) {
            return;
        }
        element.resetAccessStatistics();
        Object key = element.getObjectKey();
        boolean bl = elementExists = this.isElementInMemory(key) || this.isElementOnDisk(key);
        if (elementExists) {
            element.updateUpdateStatistics();
        }
        this.applyDefaultsToElementWithoutLifespanSet(element);
        this.backOffIfDiskSpoolFull();
        this.memoryStore.put(element);
        if (elementExists) {
            this.registeredEventListeners.notifyElementUpdated(element, doNotNotifyCacheReplicators);
        } else {
            this.registeredEventListeners.notifyElementPut(element, doNotNotifyCacheReplicators);
        }
    }

    private void backOffIfDiskSpoolFull() {
        if (this.diskStore != null && this.diskStore.bufferFull()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void applyDefaultsToElementWithoutLifespanSet(Element element) {
        if (!element.isLifespanSet()) {
            element.setTimeToLive(TimeUtil.convertTimeToInt(this.configuration.getTimeToLiveSeconds()));
            element.setTimeToIdle(TimeUtil.convertTimeToInt(this.configuration.getTimeToIdleSeconds()));
            element.setEternal(this.configuration.isEternal());
        }
    }

    @Override
    public final void putQuiet(Element element) throws IllegalArgumentException, IllegalStateException, CacheException {
        this.checkStatus();
        if (this.disabled) {
            return;
        }
        if (element == null || element.getObjectKey() == null) {
            return;
        }
        this.applyDefaultsToElementWithoutLifespanSet(element);
        this.memoryStore.put(element);
    }

    @Override
    public final Element get(Serializable key) throws IllegalStateException, CacheException {
        return this.get((Object)key);
    }

    @Override
    public final Element get(Object key) throws IllegalStateException, CacheException {
        this.checkStatus();
        long start = System.currentTimeMillis();
        Element element = this.searchInMemoryStore(key, true, true);
        if (element == null && this.isDiskStore()) {
            element = this.searchInDiskStore(key, true, true);
        }
        if (element == null) {
            this.liveCacheStatisticsData.cacheMissNotFound();
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.configuration.getName() + " cache - Miss");
            }
        }
        long end = System.currentTimeMillis();
        this.liveCacheStatisticsData.addGetTimeMillis(end - start);
        return element;
    }

    @Override
    public Element getWithLoader(Object key, CacheLoader loader, Object loaderArgument) throws CacheException {
        Element element = this.get(key);
        if (element != null) {
            return element;
        }
        if (this.registeredCacheLoaders.size() == 0 && loader == null) {
            return null;
        }
        try {
            element = this.getQuiet(key);
            if (element != null) {
                return element;
            }
            Future future = this.asynchronousLoad(key, loader, loaderArgument);
            future.get();
        }
        catch (Exception e) {
            throw new CacheException("Exception on load for key " + key, e);
        }
        return this.getQuiet(key);
    }

    @Override
    public void load(Object key) throws CacheException {
        if (this.registeredCacheLoaders.size() == 0) {
            LOG.debug("The CacheLoader is null. Returning.");
            return;
        }
        boolean existsOnCall = this.isKeyInCache(key);
        if (existsOnCall) {
            LOG.debug("The key {} exists in the cache. Returning.", key);
            return;
        }
        this.asynchronousLoad(key, null, null);
    }

    @Override
    public Map getAllWithLoader(Collection keys, Object loaderArgument) throws CacheException {
        if (keys == null) {
            return new HashMap(0);
        }
        HashMap map = new HashMap(keys.size());
        ArrayList missingKeys = new ArrayList(keys.size());
        if (this.registeredCacheLoaders.size() > 0) {
            Object key = null;
            try {
                map = new HashMap(keys.size());
                for (Object key1 : keys) {
                    key = key1;
                    if (this.isKeyInCache(key)) {
                        Element element = this.get(key);
                        if (element != null) {
                            map.put(key, element.getObjectValue());
                            continue;
                        }
                        map.put(key, null);
                        continue;
                    }
                    missingKeys.add(key);
                }
                Future future = this.asynchronousLoadAll(missingKeys, loaderArgument);
                future.get();
                for (Object missingKey : missingKeys) {
                    key = missingKey;
                    Element element = this.get(key);
                    if (element != null) {
                        map.put(key, element.getObjectValue());
                        continue;
                    }
                    map.put(key, null);
                }
            }
            catch (InterruptedException e) {
                throw new CacheException(e.getMessage() + " for key " + key, e);
            }
            catch (ExecutionException e) {
                throw new CacheException(e.getMessage() + " for key " + key, e);
            }
        } else {
            for (Object key : keys) {
                Element element = this.get(key);
                if (element != null) {
                    map.put(key, element.getObjectValue());
                    continue;
                }
                map.put(key, null);
            }
        }
        return map;
    }

    @Override
    public void loadAll(Collection keys, Object argument) throws CacheException {
        if (this.registeredCacheLoaders.size() == 0) {
            LOG.debug("The CacheLoader is null. Returning.");
            return;
        }
        if (keys == null) {
            return;
        }
        this.asynchronousLoadAll(keys, argument);
    }

    @Override
    public final Element getQuiet(Serializable key) throws IllegalStateException, CacheException {
        return this.getQuiet((Object)key);
    }

    @Override
    public final Element getQuiet(Object key) throws IllegalStateException, CacheException {
        this.checkStatus();
        Element element = this.searchInMemoryStore(key, false, false);
        if (element == null && this.isDiskStore()) {
            element = this.searchInDiskStore(key, false, false);
        }
        return element;
    }

    @Override
    public final List getKeys() throws IllegalStateException, CacheException {
        this.checkStatus();
        ArrayList<Object> allKeyList = new ArrayList<Object>();
        List<Object> keyList = Arrays.asList(this.memoryStore.getKeyArray());
        allKeyList.addAll(keyList);
        if (this.isDiskStore()) {
            Object[] diskKeys;
            HashSet<Object> allKeys = new HashSet<Object>();
            allKeys.addAll(keyList);
            for (Object diskKey : diskKeys = this.diskStore.getKeyArray()) {
                if (!allKeys.add(diskKey)) continue;
                allKeyList.add(diskKey);
            }
        }
        return allKeyList;
    }

    @Override
    public final List getKeysWithExpiryCheck() throws IllegalStateException, CacheException {
        List allKeyList = this.getKeys();
        ArrayList nonExpiredKeys = new ArrayList(allKeyList.size());
        int allKeyListSize = allKeyList.size();
        for (int i = 0; i < allKeyListSize; ++i) {
            Object key = allKeyList.get(i);
            Element element = this.getQuiet(key);
            if (element == null) continue;
            nonExpiredKeys.add(key);
        }
        nonExpiredKeys.trimToSize();
        return nonExpiredKeys;
    }

    @Override
    public final List getKeysNoDuplicateCheck() throws IllegalStateException {
        this.checkStatus();
        ArrayList<Object> allKeys = new ArrayList<Object>();
        List<Object> memoryKeySet = Arrays.asList(this.memoryStore.getKeyArray());
        allKeys.addAll(memoryKeySet);
        if (this.isDiskStore()) {
            List<Object> diskKeySet = Arrays.asList(this.diskStore.getKeyArray());
            allKeys.addAll(diskKeySet);
        }
        return allKeys;
    }

    private Element searchInMemoryStore(Object key, boolean updateStatistics, boolean notifyListeners) {
        Element element = updateStatistics ? this.memoryStore.get(key) : this.memoryStore.getQuiet(key);
        if (element != null) {
            if (this.isExpired(element)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(this.configuration.getName() + " Memory cache hit, but element expired");
                }
                if (updateStatistics) {
                    this.liveCacheStatisticsData.cacheMissExpired();
                }
                this.remove(key, true, notifyListeners, false);
                element = null;
            } else if (updateStatistics) {
                element.updateAccessStatistics();
                if (LOG.isDebugEnabled()) {
                    LOG.debug(this.getName() + "Cache: " + this.getName() + "MemoryStore hit for " + key);
                }
                this.liveCacheStatisticsData.cacheHitInMemory();
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug(this.getName() + "Cache: " + this.getName() + "MemoryStore miss for " + key);
        }
        return element;
    }

    private Element searchInDiskStore(Object key, boolean updateStatistics, boolean notifyListeners) {
        if (!(key instanceof Serializable)) {
            return null;
        }
        Serializable serializableKey = (Serializable)key;
        Element element = updateStatistics ? this.diskStore.get(serializableKey) : this.diskStore.getQuiet(serializableKey);
        if (element != null) {
            if (this.isExpired(element)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(this.configuration.getName() + " cache - Disk Store hit, but element expired");
                }
                this.liveCacheStatisticsData.cacheMissExpired();
                this.remove(key, true, notifyListeners, false);
                element = null;
            } else {
                if (updateStatistics) {
                    element.updateAccessStatistics();
                }
                this.liveCacheStatisticsData.cacheHitOnDisk();
                this.memoryStore.put(element);
            }
        }
        return element;
    }

    @Override
    public final boolean remove(Serializable key) throws IllegalStateException {
        return this.remove((Object)key);
    }

    @Override
    public final boolean remove(Object key) throws IllegalStateException {
        return this.remove(key, false);
    }

    @Override
    public final boolean remove(Serializable key, boolean doNotNotifyCacheReplicators) throws IllegalStateException {
        return this.remove((Object)key, doNotNotifyCacheReplicators);
    }

    @Override
    public final boolean remove(Object key, boolean doNotNotifyCacheReplicators) throws IllegalStateException {
        return this.remove(key, false, true, doNotNotifyCacheReplicators);
    }

    @Override
    public final boolean removeQuiet(Serializable key) throws IllegalStateException {
        return this.remove(key, false, false, false);
    }

    @Override
    public final boolean removeQuiet(Object key) throws IllegalStateException {
        return this.remove(key, false, false, false);
    }

    private boolean remove(Object key, boolean expiry, boolean notifyListeners, boolean doNotNotifyCacheReplicators) throws IllegalStateException {
        this.checkStatus();
        boolean removed = false;
        Element elementFromMemoryStore = this.memoryStore.remove(key);
        Element elementFromDiskStore = null;
        if (this.isDiskStore() && key instanceof Serializable) {
            Serializable serializableKey = (Serializable)key;
            elementFromDiskStore = this.diskStore.remove(serializableKey);
        }
        boolean removeNotified = false;
        if (elementFromMemoryStore != null) {
            if (expiry) {
                this.registeredEventListeners.notifyElementExpiry(elementFromMemoryStore, doNotNotifyCacheReplicators);
            } else if (notifyListeners) {
                removeNotified = true;
                this.registeredEventListeners.notifyElementRemoved(elementFromMemoryStore, doNotNotifyCacheReplicators);
            }
            removed = true;
        } else if (elementFromDiskStore != null) {
            if (expiry) {
                this.registeredEventListeners.notifyElementExpiry(elementFromDiskStore, doNotNotifyCacheReplicators);
            } else if (notifyListeners) {
                removeNotified = true;
                this.registeredEventListeners.notifyElementRemoved(elementFromDiskStore, doNotNotifyCacheReplicators);
            }
            removed = true;
        }
        if (notifyListeners && !expiry && !removeNotified) {
            Element syntheticElement = new Element(key, null);
            this.registeredEventListeners.notifyElementRemoved(syntheticElement, doNotNotifyCacheReplicators);
        }
        return removed;
    }

    @Override
    public void removeAll() throws IllegalStateException, CacheException {
        this.removeAll(false);
    }

    @Override
    public void removeAll(boolean doNotNotifyCacheReplicators) throws IllegalStateException, CacheException {
        this.checkStatus();
        this.memoryStore.removeAll();
        if (this.isDiskStore()) {
            this.diskStore.removeAll();
        }
        this.registeredEventListeners.notifyRemoveAll(doNotNotifyCacheReplicators);
    }

    @Override
    public synchronized void dispose() throws IllegalStateException {
        this.checkStatusNotDisposed();
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
        this.disposeRegisteredCacheExtensions();
        this.disposeRegisteredCacheLoaders();
        this.registeredEventListeners.dispose();
        if (this.memoryStore != null) {
            this.memoryStore.dispose();
        }
        if (this.diskStore != null) {
            this.diskStore.dispose();
        }
        this.changeStatus(Status.STATUS_SHUTDOWN);
    }

    private void initialiseRegisteredCacheExtensions() {
        for (CacheExtension cacheExtension : this.registeredCacheExtensions) {
            cacheExtension.init();
        }
    }

    private void disposeRegisteredCacheExtensions() {
        for (CacheExtension cacheExtension : this.registeredCacheExtensions) {
            cacheExtension.dispose();
        }
    }

    private void initialiseRegisteredCacheLoaders() {
        for (CacheLoader cacheLoader : this.registeredCacheLoaders) {
            cacheLoader.init();
        }
    }

    private void disposeRegisteredCacheLoaders() {
        for (CacheLoader cacheLoader : this.registeredCacheLoaders) {
            cacheLoader.dispose();
        }
    }

    @Override
    public CacheConfiguration getCacheConfiguration() {
        return this.configuration;
    }

    @Override
    public final synchronized void flush() throws IllegalStateException, CacheException {
        this.checkStatus();
        try {
            this.memoryStore.flush();
            if (this.isDiskStore()) {
                this.diskStore.flush();
            }
        }
        catch (IOException e) {
            throw new CacheException("Unable to flush cache: " + this.configuration.getName() + ". Initial cause was " + e.getMessage(), e);
        }
    }

    @Override
    public final int getSize() throws IllegalStateException, CacheException {
        this.checkStatus();
        if (this.memoryStore.isCacheCoherent()) {
            return this.memoryStore.getTerracottaClusteredSize();
        }
        return this.getKeys().size();
    }

    @Override
    public int getSizeBasedOnAccuracy(int statisticsAccuracy) throws IllegalStateException, CacheException {
        if (statisticsAccuracy == 1) {
            return this.getSize();
        }
        if (statisticsAccuracy == 2) {
            return this.getKeysWithExpiryCheck().size();
        }
        if (statisticsAccuracy == 0) {
            return this.getKeysNoDuplicateCheck().size();
        }
        throw new IllegalArgumentException("Unknown statistics accuracy: " + statisticsAccuracy);
    }

    @Override
    public final long calculateInMemorySize() throws IllegalStateException, CacheException {
        this.checkStatus();
        return this.memoryStore.getSizeInBytes();
    }

    @Override
    public final long getMemoryStoreSize() throws IllegalStateException {
        this.checkStatus();
        return this.memoryStore.getSize();
    }

    @Override
    public final int getDiskStoreSize() throws IllegalStateException {
        this.checkStatus();
        if (this.isTerracottaClustered()) {
            return this.memoryStore.getTerracottaClusteredSize();
        }
        if (this.isDiskStore()) {
            return this.diskStore.getSize();
        }
        return 0;
    }

    @Override
    public final Status getStatus() {
        return this.status;
    }

    private void checkStatus() throws IllegalStateException {
        if (!this.status.equals(Status.STATUS_ALIVE)) {
            throw new IllegalStateException("The " + this.configuration.getName() + " Cache is not alive.");
        }
    }

    private void checkStatusNotDisposed() throws IllegalStateException {
        if (this.status.equals(Status.STATUS_SHUTDOWN)) {
            throw new IllegalStateException("The " + this.configuration.getName() + " Cache is disposed.");
        }
    }

    @Override
    public final String getName() {
        return this.configuration.getName();
    }

    @Override
    public final void setName(String name) throws IllegalArgumentException {
        if (!this.status.equals(Status.STATUS_UNINITIALISED)) {
            throw new IllegalStateException("Only uninitialised caches can have their names set.");
        }
        this.configuration.setName(name);
    }

    @Override
    public String toString() {
        StringBuilder dump = new StringBuilder();
        dump.append("[").append(" name = ").append(this.configuration.getName()).append(" status = ").append(this.status).append(" eternal = ").append(this.configuration.isEternal()).append(" overflowToDisk = ").append(this.configuration.isOverflowToDisk()).append(" maxElementsInMemory = ").append(this.configuration.getMaxElementsInMemory()).append(" maxElementsOnDisk = ").append(this.configuration.getMaxElementsOnDisk()).append(" memoryStoreEvictionPolicy = ").append(this.configuration.getMemoryStoreEvictionPolicy()).append(" timeToLiveSeconds = ").append(this.configuration.getTimeToLiveSeconds()).append(" timeToIdleSeconds = ").append(this.configuration.getTimeToIdleSeconds()).append(" diskPersistent = ").append(this.configuration.isDiskPersistent()).append(" diskExpiryThreadIntervalSeconds = ").append(this.configuration.getDiskExpiryThreadIntervalSeconds()).append(this.registeredEventListeners).append(" hitCount = ").append(this.getLiveCacheStatisticsNoCheck().getCacheHitCount()).append(" memoryStoreHitCount = ").append(this.getLiveCacheStatisticsNoCheck().getInMemoryHitCount()).append(" diskStoreHitCount = ").append(this.getLiveCacheStatisticsNoCheck().getOnDiskHitCount()).append(" missCountNotFound = ").append(this.getLiveCacheStatisticsNoCheck().getCacheMissCount()).append(" missCountExpired = ").append(this.getLiveCacheStatisticsNoCheck().getCacheMissCountExpired()).append(" ]");
        return dump.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isExpired(Element element) throws IllegalStateException, NullPointerException {
        this.checkStatus();
        Element element2 = element;
        synchronized (element2) {
            return element.isExpired();
        }
    }

    @Override
    public final Object clone() throws CloneNotSupportedException {
        if (this.memoryStore != null || this.diskStore != null) {
            throw new CloneNotSupportedException("Cannot clone an initialized cache.");
        }
        Cache copy = (Cache)super.clone();
        copy.liveCacheStatisticsData = new LiveCacheStatisticsWrapper(copy);
        copy.sampledCacheStatistics = new SampledCacheStatisticsWrapper();
        copy.configuration = this.configuration.clone();
        copy.guid = this.createGuid();
        RegisteredEventListeners registeredEventListenersFromCopy = copy.getCacheEventNotificationService();
        if (registeredEventListenersFromCopy == null || registeredEventListenersFromCopy.getCacheEventListeners().size() == 0) {
            copy.registeredEventListeners = new RegisteredEventListeners(copy);
        } else {
            copy.registeredEventListeners = new RegisteredEventListeners(copy);
            Set cacheEventListeners = this.registeredEventListeners.getCacheEventListeners();
            for (Object cacheEventListener1 : cacheEventListeners) {
                CacheEventListener cacheEventListener = (CacheEventListener)cacheEventListener1;
                CacheEventListener cacheEventListenerClone = (CacheEventListener)cacheEventListener.clone();
                copy.registeredEventListeners.registerListener(cacheEventListenerClone);
            }
        }
        copy.registeredCacheExtensions = new CopyOnWriteArrayList<CacheExtension>();
        for (CacheExtension registeredCacheExtension : this.registeredCacheExtensions) {
            copy.registerCacheExtension(registeredCacheExtension.clone(copy));
        }
        copy.registeredCacheLoaders = new CopyOnWriteArrayList<CacheLoader>();
        for (CacheLoader registeredCacheLoader : this.registeredCacheLoaders) {
            copy.registerCacheLoader(registeredCacheLoader.clone(copy));
        }
        if (this.bootstrapCacheLoader != null) {
            BootstrapCacheLoader bootstrapCacheLoaderClone = (BootstrapCacheLoader)this.bootstrapCacheLoader.clone();
            copy.setBootstrapCacheLoader(bootstrapCacheLoaderClone);
        }
        return copy;
    }

    final Store getDiskStore() throws IllegalStateException {
        this.checkStatus();
        return this.diskStore;
    }

    final Store getMemoryStore() throws IllegalStateException {
        this.checkStatus();
        return this.memoryStore;
    }

    @Override
    public final RegisteredEventListeners getCacheEventNotificationService() {
        return this.registeredEventListeners;
    }

    @Override
    public final boolean isElementInMemory(Serializable key) {
        return this.isElementInMemory((Object)key);
    }

    @Override
    public final boolean isElementInMemory(Object key) {
        return this.memoryStore.containsKey(key);
    }

    @Override
    public final boolean isElementOnDisk(Serializable key) {
        return this.isElementOnDisk((Object)key);
    }

    @Override
    public final boolean isElementOnDisk(Object key) {
        if (!(key instanceof Serializable)) {
            return false;
        }
        Serializable serializableKey = (Serializable)key;
        if (this.isDiskStore()) {
            return this.diskStore != null && this.diskStore.containsKey(serializableKey);
        }
        return false;
    }

    @Override
    public final String getGuid() {
        return this.guid;
    }

    @Override
    public final CacheManager getCacheManager() {
        return this.cacheManager;
    }

    @Override
    public void clearStatistics() throws IllegalStateException {
        this.checkStatus();
        this.liveCacheStatisticsData.clearStatistics();
        this.registeredEventListeners.clearCounters();
    }

    @Override
    public int getStatisticsAccuracy() {
        return this.getLiveCacheStatistics().getStatisticsAccuracy();
    }

    @Override
    public void setStatisticsAccuracy(int statisticsAccuracy) {
        this.liveCacheStatisticsData.setStatisticsAccuracy(statisticsAccuracy);
    }

    @Override
    public void evictExpiredElements() {
        Object[] keys;
        for (Object key : keys = this.memoryStore.getKeyArray()) {
            this.searchInMemoryStore(key, false, true);
        }
        if (this.isDiskStore()) {
            this.diskStore.expireElements();
        }
    }

    @Override
    public boolean isKeyInCache(Object key) {
        if (key == null) {
            return false;
        }
        return this.isElementInMemory(key) || this.isElementOnDisk(key);
    }

    @Override
    public boolean isValueInCache(Object value) {
        boolean isSerializable = value instanceof Serializable;
        List<Object> keys = isSerializable ? this.getKeys() : Arrays.asList(this.memoryStore.getKeyArray());
        for (Object key : keys) {
            Serializable elementValue;
            Element element = this.get(key);
            if (element == null || !((elementValue = element.getValue()) == null ? value == null : elementValue.equals(value))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Statistics getStatistics() throws IllegalStateException {
        int size = this.getSizeBasedOnAccuracy(this.getLiveCacheStatistics().getStatisticsAccuracy());
        return new Statistics(this, this.getLiveCacheStatistics().getStatisticsAccuracy(), this.getLiveCacheStatistics().getCacheHitCount(), this.getLiveCacheStatistics().getOnDiskHitCount(), this.getLiveCacheStatistics().getInMemoryHitCount(), this.getLiveCacheStatistics().getCacheMissCount(), size, this.getAverageGetTime(), this.getLiveCacheStatistics().getEvictedCount(), this.getMemoryStoreSize(), this.getDiskStoreSize());
    }

    @Override
    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Override
    public BootstrapCacheLoader getBootstrapCacheLoader() {
        return this.bootstrapCacheLoader;
    }

    @Override
    public void setBootstrapCacheLoader(BootstrapCacheLoader bootstrapCacheLoader) throws CacheException {
        if (!this.status.equals(Status.STATUS_UNINITIALISED)) {
            throw new CacheException("A bootstrap cache loader can only be set before the cache is initialized. " + this.configuration.getName());
        }
        this.bootstrapCacheLoader = bootstrapCacheLoader;
    }

    @Override
    public void setDiskStorePath(String diskStorePath) throws CacheException {
        if (!this.status.equals(Status.STATUS_UNINITIALISED)) {
            throw new CacheException("A DiskStore path can only be set before the cache is initialized. " + this.configuration.getName());
        }
        this.diskStorePath = diskStorePath;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Ehcache)) {
            return false;
        }
        Ehcache other = (Ehcache)object;
        return this.guid.equals(other.getGuid());
    }

    public int hashCode() {
        return this.guid.hashCode();
    }

    private String createGuid() {
        StringBuilder buffer = new StringBuilder().append(localhost).append("-").append(UUID.randomUUID());
        return buffer.toString();
    }

    @Override
    public void registerCacheExtension(CacheExtension cacheExtension) {
        this.registeredCacheExtensions.add(cacheExtension);
    }

    @Override
    public List<CacheExtension> getRegisteredCacheExtensions() {
        return this.registeredCacheExtensions;
    }

    @Override
    public void unregisterCacheExtension(CacheExtension cacheExtension) {
        cacheExtension.dispose();
        this.registeredCacheExtensions.remove(cacheExtension);
    }

    @Override
    public float getAverageGetTime() {
        return this.getLiveCacheStatistics().getAverageGetTimeMillis();
    }

    @Override
    public void setCacheExceptionHandler(CacheExceptionHandler cacheExceptionHandler) {
        this.cacheExceptionHandler = cacheExceptionHandler;
    }

    @Override
    public CacheExceptionHandler getCacheExceptionHandler() {
        return this.cacheExceptionHandler;
    }

    @Override
    public void registerCacheLoader(CacheLoader cacheLoader) {
        this.registeredCacheLoaders.add(cacheLoader);
    }

    @Override
    public void unregisterCacheLoader(CacheLoader cacheLoader) {
        this.registeredCacheLoaders.remove(cacheLoader);
    }

    @Override
    public List<CacheLoader> getRegisteredCacheLoaders() {
        return this.registeredCacheLoaders;
    }

    Future asynchronousLoad(final Object key, final CacheLoader specificLoader, final Object argument) {
        return this.getExecutorService().submit(new Runnable(){

            public void run() throws CacheException {
                try {
                    boolean existsOnRun = Cache.this.isKeyInCache(key);
                    if (!existsOnRun) {
                        Object value;
                        if (specificLoader == null) {
                            if (Cache.this.registeredCacheLoaders.size() == 0) {
                                return;
                            }
                            value = Cache.this.loadWithRegisteredLoaders(argument, key);
                        } else {
                            value = argument == null ? specificLoader.load(key) : specificLoader.load(key, argument);
                        }
                        if (value != null) {
                            Cache.this.put(new Element(key, value), false);
                        }
                    }
                }
                catch (Throwable e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Problem during load. Load will not be completed. Cause was " + e.getCause(), e);
                    }
                    throw new CacheException("Problem during load. Load will not be completed. Cause was " + e.getCause(), e);
                }
            }
        });
    }

    private Object loadWithRegisteredLoaders(Object argument, Object key) throws CacheException {
        Object value = null;
        if (argument == null) {
            CacheLoader registeredCacheLoader;
            Iterator<CacheLoader> i$ = this.registeredCacheLoaders.iterator();
            while (i$.hasNext() && (value = (registeredCacheLoader = i$.next()).load(key)) == null) {
            }
        } else {
            CacheLoader registeredCacheLoader;
            Iterator<CacheLoader> i$ = this.registeredCacheLoaders.iterator();
            while (i$.hasNext() && (value = (registeredCacheLoader = i$.next()).load(key, argument)) == null) {
            }
        }
        return value;
    }

    Future asynchronousLoadAll(final Collection keys, final Object argument) {
        return this.getExecutorService().submit(new Runnable(){

            public void run() {
                block4: {
                    try {
                        HashSet<Object> nonLoadedKeys = new HashSet<Object>();
                        for (Object key : keys) {
                            if (Cache.this.isKeyInCache(key)) continue;
                            nonLoadedKeys.add(key);
                        }
                        Map map = Cache.this.loadWithRegisteredLoaders(argument, nonLoadedKeys);
                        for (Object key : map.keySet()) {
                            Cache.this.put(new Element(key, map.get(key)));
                        }
                    }
                    catch (Throwable e) {
                        if (!LOG.isErrorEnabled()) break block4;
                        LOG.error("Problem during load. Load will not be completed. Cause was " + e.getCause(), e);
                    }
                }
            }
        });
    }

    Map loadWithRegisteredLoaders(Object argument, Set<Object> nonLoadedKeys) {
        HashMap result = new HashMap();
        for (CacheLoader registeredCacheLoader : this.registeredCacheLoaders) {
            if (nonLoadedKeys.isEmpty()) break;
            Map resultForThisCacheLoader = null;
            resultForThisCacheLoader = argument == null ? registeredCacheLoader.loadAll(nonLoadedKeys) : registeredCacheLoader.loadAll(nonLoadedKeys, argument);
            if (resultForThisCacheLoader == null) continue;
            nonLoadedKeys.removeAll(resultForThisCacheLoader.keySet());
            result.putAll(resultForThisCacheLoader);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ExecutorService getExecutorService() {
        if (this.executorService == null) {
            Cache cache = this;
            synchronized (cache) {
                boolean inGoogleAppEngine;
                try {
                    Class.forName("com.google.apphosting.api.DeadlineExceededException");
                    inGoogleAppEngine = true;
                }
                catch (ClassNotFoundException cnfe) {
                    inGoogleAppEngine = false;
                }
                this.executorService = inGoogleAppEngine ? new AbstractExecutorService(){

                    @Override
                    public void execute(Runnable command) {
                        command.run();
                    }

                    @Override
                    public List<Runnable> shutdownNow() {
                        return Collections.emptyList();
                    }

                    @Override
                    public void shutdown() {
                    }

                    @Override
                    public boolean isTerminated() {
                        return this.isShutdown();
                    }

                    @Override
                    public boolean isShutdown() {
                        return false;
                    }

                    @Override
                    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
                        return true;
                    }
                } : new ThreadPoolExecutor(1, EXECUTOR_MAXIMUM_POOL_SIZE, 60000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory("Cache Executor Service"));
            }
        }
        return this.executorService;
    }

    @Override
    public boolean isDisabled() {
        return this.disabled;
    }

    @Override
    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public Policy getMemoryStoreEvictionPolicy() {
        return this.memoryStore.getEvictionPolicy();
    }

    public void setMemoryStoreEvictionPolicy(Policy policy) {
        this.memoryStore.setEvictionPolicy(policy);
    }

    @Override
    public LiveCacheStatistics getLiveCacheStatistics() throws IllegalStateException {
        this.checkStatus();
        return (LiveCacheStatistics)((Object)this.liveCacheStatisticsData);
    }

    private LiveCacheStatistics getLiveCacheStatisticsNoCheck() {
        return (LiveCacheStatistics)((Object)this.liveCacheStatisticsData);
    }

    @Override
    public void registerCacheUsageListener(CacheUsageListener cacheUsageListener) throws IllegalStateException {
        this.checkStatus();
        this.liveCacheStatisticsData.registerCacheUsageListener(cacheUsageListener);
    }

    @Override
    public void removeCacheUsageListener(CacheUsageListener cacheUsageListener) throws IllegalStateException {
        this.checkStatus();
        this.liveCacheStatisticsData.removeCacheUsageListener(cacheUsageListener);
    }

    @Override
    public boolean isStatisticsEnabled() {
        return this.getLiveCacheStatistics().isStatisticsEnabled();
    }

    @Override
    public void setStatisticsEnabled(boolean enableStatistics) {
        this.liveCacheStatisticsData.setStatisticsEnabled(enableStatistics);
        if (!enableStatistics) {
            this.setSampledStatisticsEnabled(false);
        }
    }

    @Override
    public SampledCacheStatistics getSampledCacheStatistics() {
        return this.sampledCacheStatistics;
    }

    @Override
    public void setSampledStatisticsEnabled(boolean enableStatistics) {
        if (this.cacheManager == null) {
            throw new IllegalStateException("You must add the cache to a CacheManager before enabling/disabling sampled statistics.");
        }
        if (enableStatistics) {
            this.setStatisticsEnabled(true);
            this.sampledCacheStatistics.enableSampledStatistics(this.cacheManager.getTimer());
        } else {
            this.sampledCacheStatistics.disableSampledStatistics();
        }
    }

    @Override
    public boolean isSampledStatisticsEnabled() {
        return this.sampledCacheStatistics.isSampledStatisticsEnabled();
    }

    @Override
    public Object getInternalContext() {
        return this.memoryStore.getInternalContext();
    }

    static {
        EXECUTOR_MAXIMUM_POOL_SIZE = Math.min(10, Runtime.getRuntime().availableProcessors());
        try {
            localhost = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            LOG.error("Unable to set localhost. This prevents creation of a GUID. Cause was: " + e.getMessage(), (Throwable)e);
        }
        catch (NoClassDefFoundError e) {
            LOG.debug("InetAddress is being blocked by your runtime environment. e.g. Google App Engine. Ehcache will work as a local cache.");
        }
    }
}

