/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.tbutils.res;

import com.tonbeller.tbutils.res.Dumper;
import com.tonbeller.tbutils.res.ResourceProvider;
import java.util.Collection;
import java.util.Collections;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import org.apache.log4j.Logger;

public class JNDIResourceProvider
implements ResourceProvider {
    Context context = null;
    boolean disabled = false;
    private static Logger logger = Logger.getLogger(JNDIResourceProvider.class);
    public static final String JNDI_NULL = "jndi.null";

    public String getString(String key) {
        if (this.disabled) {
            return null;
        }
        try {
            Object obj;
            if (this.context == null) {
                InitialContext initCtx = new InitialContext();
                this.context = (Context)initCtx.lookup("java:comp/env");
            }
            if ((obj = this.context.lookup(key)) == null) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("key is null: " + key));
                }
                return null;
            }
            String str = obj.toString();
            if (JNDI_NULL.equals(str)) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("key is jndi.null: " + key));
                }
                return null;
            }
            return str;
        }
        catch (NameNotFoundException e) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("key not found: " + key));
            }
            return null;
        }
        catch (NoInitialContextException e) {
            logger.warn((Object)"JNDI Context not found, assuming test environment");
            this.disabled = true;
            return null;
        }
        catch (NamingException e) {
            logger.error((Object)key, (Throwable)e);
            return null;
        }
    }

    public Collection keySet() {
        return Collections.EMPTY_SET;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            if (this.context != null) {
                this.context.close();
            }
        }
        catch (NamingException e) {
            logger.error((Object)"error closing context", (Throwable)e);
        }
        finally {
            this.context = null;
        }
    }

    public void dump(Dumper d) {
        d.dump(this);
    }

    public String getName() {
        return "JNDI Lookup " + (this.disabled ? "disabled" : "enabled");
    }
}

