/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.table;

import com.tonbeller.tbutils.res.Resources;
import com.tonbeller.wcf.component.Component;
import com.tonbeller.wcf.controller.RequestContext;
import com.tonbeller.wcf.form.FormComponent;
import com.tonbeller.wcf.selection.AbstractSelectionModel;
import com.tonbeller.wcf.table.TableColumn;
import com.tonbeller.wcf.table.TableComponent;
import com.tonbeller.wcf.tree.AbstractTreeModel;
import com.tonbeller.wcf.tree.MutableTreeModelDecorator;
import com.tonbeller.wcf.tree.NodeRenderer;
import com.tonbeller.wcf.tree.TreeComponent;
import com.tonbeller.wcf.tree.TreeHandler;
import com.tonbeller.wcf.tree.TreeModel;
import com.tonbeller.wcf.utils.DomUtils;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jaxen.JaxenException;
import org.jaxen.dom.DOMXPath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TablePropertiesFormComponent
extends FormComponent {
    private Element closeElement;
    private TableComponent tableComp;
    private Element titleElement;
    private Resources resources;
    private TreeModel mutableTreeModel;
    private TreeModel columnTreeModel;
    private TreeComponent treeComp;
    private static Logger logger = Logger.getLogger(TablePropertiesFormComponent.class);

    public TablePropertiesFormComponent(String id, Component parent, Document document, TableComponent table) {
        super(id, parent, document);
        this.tableComp = table;
        this.columnTreeModel = new TableColumnTreeModel();
        this.mutableTreeModel = new MutableTreeModelDecorator(this.columnTreeModel);
        try {
            DOMXPath dx = new DOMXPath("//title");
            this.titleElement = (Element)dx.selectSingleNode((Object)this.getDocument());
            dx = new DOMXPath("./imgButton");
            this.closeElement = (Element)dx.selectSingleNode((Object)this.titleElement);
        }
        catch (JaxenException e) {
            logger.error((Object)"?", (Throwable)e);
        }
    }

    public void initialize(RequestContext context) throws Exception {
        super.initialize(context);
        this.resources = Resources.instance();
        if (this.resources == null) {
            this.resources = context.getResources(TablePropertiesFormComponent.class);
        }
        try {
            DOMXPath dx = new DOMXPath("//skip[@id='" + this.getId() + ".tree']");
            Element te = (Element)dx.selectSingleNode((Object)this.getDocument());
            TreeHandler th = (TreeHandler)this.getHandler(te);
            this.treeComp = th.getTree();
            this.treeComp.setNodeRenderer(new TableColumnNodeRenderer());
            this.treeComp.setSelectionModel(new TableColumnSelectionModel());
        }
        catch (JaxenException e) {
            logger.error(null, (Throwable)e);
        }
        String title = this.tableComp.getModel().getTitle();
        title = title != null ? this.resources.getString("jsp.wcf.table.props.title.args", title) : this.resources.getString("jsp.wcf.table.props.title.noargs");
        this.setTitle(title);
    }

    public void onApply(RequestContext context) throws Exception {
        if (this.isCloseable()) {
            this.setVisible(false);
        }
    }

    public void onCancel(RequestContext context) throws Exception {
        if (this.isCloseable()) {
            this.setVisible(false);
        }
    }

    public TreeModel getColumnTreeModel() {
        return this.mutableTreeModel;
    }

    public TableComponent getTable() {
        return this.tableComp;
    }

    public String getTitle() {
        return this.titleElement.getAttribute("value");
    }

    public void setTitle(String title) {
        this.titleElement.setAttribute("value", title);
    }

    public boolean isCloseable() {
        return !this.closeElement.hasAttribute("hidden");
    }

    public void setCloseable(boolean b) {
        if (b) {
            DomUtils.removeAttribute(this.closeElement, "hidden");
        } else {
            this.closeElement.setAttribute("hidden", "true");
        }
    }

    void columnTreeModelChanged() {
        this.columnTreeModel.fireModelChanged(true);
    }

    private class TableColumnSelectionModel
    extends AbstractSelectionModel {
        public TableColumnSelectionModel() {
            super(2);
        }

        public Set getSelection() {
            HashSet<TableColumn> set = new HashSet<TableColumn>();
            TableColumn[] cols = TablePropertiesFormComponent.this.tableComp.getTableColumns();
            for (int i = 0; i < cols.length; ++i) {
                if (cols[i].isHidden()) continue;
                set.add(cols[i]);
            }
            return set;
        }

        public void add(Object obj) {
            ((TableColumn)obj).setHidden(false);
        }

        public void remove(Object obj) {
            ((TableColumn)obj).setHidden(true);
        }

        public void clear() {
            TableColumn[] cols = TablePropertiesFormComponent.this.tableComp.getTableColumns();
            for (int i = 0; i < cols.length; ++i) {
                cols[i].setHidden(true);
            }
        }
    }

    private class TableColumnNodeRenderer
    implements NodeRenderer {
        private TableColumnNodeRenderer() {
        }

        public Element renderNode(RequestContext context, Document factory, Object node) {
            int colIndex = ((TableColumn)node).getColumnIndex();
            String label = TablePropertiesFormComponent.this.tableComp.getModel().getColumnTitle(colIndex);
            Element nodeElem = factory.createElement("tree-node");
            nodeElem.setAttribute("label", label);
            return nodeElem;
        }
    }

    private class TableColumnTreeModel
    extends AbstractTreeModel {
        private TableColumnTreeModel() {
        }

        public Object[] getRoots() {
            return TablePropertiesFormComponent.this.tableComp.getTableColumns();
        }

        public boolean hasChildren(Object node) {
            return false;
        }

        public Object[] getChildren(Object node) {
            return null;
        }

        public Object getParent(Object node) {
            return null;
        }
    }
}

