/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.rest;

import com.jaspersoft.jasperserver.remote.ServiceException;
import com.jaspersoft.jasperserver.remote.ServicesUtils;
import com.jaspersoft.jasperserver.rest.RESTServicRegistry;
import com.jaspersoft.jasperserver.rest.RESTService;
import com.jaspersoft.jasperserver.rest.RESTUtils;
import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class RESTServlet
extends HttpServlet {
    private static final Log log = LogFactory.getLog(RESTServlet.class);
    private static final String BEAN_NAME_REST_SERVICE_REGISTRY = "restServiceRegistry";
    private static ServicesUtils servicesUtils = null;
    private static ApplicationContext applicationContext = null;
    private static RESTServicRegistry registry = null;

    public void init() throws ServletException {
        applicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
        servicesUtils = new ServicesUtils(applicationContext);
        registry = (RESTServicRegistry)applicationContext.getBean(BEAN_NAME_REST_SERVICE_REGISTRY);
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Object pw = null;
        try {
            String serviceName = null;
            String path = req.getPathInfo();
            if (path == null) {
                RESTUtils.setStatusAndBody(404, resp, "Service not valid");
                return;
            }
            serviceName = RESTUtils.extractServiceName(path);
            if (log.isDebugEnabled()) {
                log.debug((Object)("REST Service requested: " + serviceName));
            }
            if (serviceName == null || serviceName.length() == 0) {
                RESTUtils.setStatusAndBody(404, resp, "Service not valid");
                return;
            }
            RESTService service = registry.getService(serviceName);
            if (service == null) {
                RESTUtils.setStatusAndBody(404, resp, "Service not valid");
                return;
            }
            service.execute(req, resp);
        }
        catch (ServiceException ex) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Error executing a REST service: " + ex.getErrorCode()), (Throwable)ex);
            }
            switch (ex.getErrorCode()) {
                case 404: {
                    RESTUtils.setStatusAndBody(404, resp, ex.getLocalizedMessage());
                    break;
                }
                case 400: {
                    RESTUtils.setStatusAndBody(400, resp, ex.getLocalizedMessage());
                    break;
                }
                case 403: {
                    RESTUtils.setStatusAndBody(403, resp, ex.getLocalizedMessage());
                    break;
                }
                default: {
                    RESTUtils.setStatusAndBody(500, resp, ex.getLocalizedMessage());
                    break;
                }
            }
        }
        catch (UnsupportedOperationException ex) {
            log.error((Object)"Error executing a REST service", (Throwable)ex);
            RESTUtils.setStatusAndBody(501, resp, ex.getLocalizedMessage());
        }
        catch (Exception ex) {
            log.error((Object)"Error executing a REST service", (Throwable)ex);
            RESTUtils.setStatusAndBody(500, resp, ex.getLocalizedMessage());
        }
    }
}

