/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.rest.services;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ListItem;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.OperationResult;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.core.util.XMLUtil;
import com.jaspersoft.jasperserver.remote.AbstractService;
import com.jaspersoft.jasperserver.remote.ServiceException;
import com.jaspersoft.jasperserver.remote.services.RunReportService;
import com.jaspersoft.jasperserver.rest.RESTAbstractService;
import com.jaspersoft.jasperserver.rest.RESTUtils;
import com.jaspersoft.jasperserver.rest.model.Report;
import com.jaspersoft.jasperserver.ws.xml.Unmarshaller;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.activation.DataSource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.sf.jasperreports.engine.JasperPrint;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RESTReport
extends RESTAbstractService {
    private static final Log log = LogFactory.getLog(RESTReport.class);

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServiceException {
        HttpSession session;
        Report report;
        String uuid = RESTUtils.extractRepositoryUri(req.getPathInfo());
        if (uuid.startsWith("/")) {
            uuid = uuid.substring(1);
        }
        if ((report = (Report)(session = req.getSession()).getAttribute(uuid)) == null) {
            RESTUtils.setStatusAndBody(404, resp, "Report not found (uuid not found in session)");
            return;
        }
        String file = req.getParameter("file");
        if (file != null) {
            if (!report.getAttachments().containsKey(file)) {
                RESTUtils.setStatusAndBody(404, resp, "Report not found (requested file not available for this report)");
                return;
            }
            DataSource ds = report.getAttachments().get(file);
            RESTUtils.sendFile(ds, resp);
            return;
        }
        resp.setContentType("text/xml; charset=UTF-8");
        RESTUtils.setStatusAndBody(200, resp, report.toXml());
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServiceException {
        String uuid = RESTUtils.extractRepositoryUri(req.getPathInfo());
        if (uuid.startsWith("/")) {
            uuid = uuid.substring(1);
        }
        HashMap<String, String> options = new HashMap<String, String>();
        Enumeration en = req.getParameterNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            options.put(key, req.getParameter(key));
        }
        HttpSession session = req.getSession();
        Report report = (Report)session.getAttribute(uuid);
        if (report == null) {
            RESTUtils.setStatusAndBody(404, resp, "Report not found (uuid not found in session)");
            return;
        }
        JasperPrint jp = report.getJasperPrint();
        RunReportService service = new RunReportService(this.context);
        OperationResult or = service.exportReport(report.getOriginalUri(), jp, options);
        if (or.getReturnCode() != 0) {
            RESTUtils.setStatusAndBody(400, resp, or.getMessage());
            return;
        }
        if (service.getAttributes().get("jasperPrint") != null) {
            jp = (JasperPrint)service.getAttributes().get("jasperPrint");
            report.setJasperPrint(jp);
        }
        Map attachments = service.getOutputAttachments();
        report.setAttachments(attachments);
        resp.setContentType("text/xml; charset=UTF-8");
        RESTUtils.setStatusAndBody(201, resp, report.toXml());
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServiceException {
        OperationResult or;
        RunReportService service = new RunReportService(this.context);
        HashMap<String, String> options = new HashMap<String, String>();
        Enumeration en = req.getParameterNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            options.put(key, req.getParameter(key));
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        HttpServletRequest mreq = RESTUtils.extractAttachments((AbstractService)service, req);
        String resourceDescriptorXml = null;
        if (mreq instanceof MultipartHttpServletRequest) {
            resourceDescriptorXml = mreq.getParameter("ResourceDescriptor");
        } else {
            try {
                resourceDescriptorXml = IOUtils.toString((InputStream)req.getInputStream());
            }
            catch (IOException ex) {
                throw new ServiceException(500, ex.getLocalizedMessage());
            }
        }
        if (resourceDescriptorXml == null) {
            RESTUtils.setStatusAndBody(400, resp, "Missing parameter ResourceDescriptor " + service.getInputAttachments());
            return;
        }
        InputSource is = new InputSource(new StringReader(resourceDescriptorXml));
        Document doc = null;
        ResourceDescriptor rd = null;
        try {
            doc = XMLUtil.getNewDocumentBuilder().parse(is);
            rd = Unmarshaller.readResourceDescriptor((Element)doc.getDocumentElement());
        }
        catch (SAXException ex) {
            RESTUtils.setStatusAndBody(400, resp, "Invalid resource descriptor");
            return;
        }
        catch (ServiceException se) {
            if (se.getErrorCode() == 404) {
                RESTUtils.setStatusAndBody(404, resp, se.getLocalizedMessage());
            }
            throw se;
        }
        catch (Exception ex) {
            throw new ServiceException(500, ex.getLocalizedMessage());
        }
        String uri = rd.getUriString();
        List params = rd.getParameters();
        for (int i = 0; i < params.size(); ++i) {
            ListItem parameter = (ListItem)params.get(i);
            if (parameter.isIsListItem()) {
                ArrayList<Object> collection = (ArrayList<Object>)parameters.get(parameter.getLabel());
                if (collection == null) {
                    collection = new ArrayList<Object>();
                    parameters.put(parameter.getLabel(), collection);
                }
                collection.add(parameter.getValue());
                continue;
            }
            parameters.put(parameter.getLabel(), parameter.getValue());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Running report " + uri + " with parameters: " + parameters + " and options: " + options));
        }
        if ((or = service.runReport(uri, parameters, options)).getReturnCode() != 0) {
            RESTUtils.setStatusAndBody(400, resp, or.getMessage());
            return;
        }
        JasperPrint jp = (JasperPrint)service.getAttributes().get("jasperPrint");
        Map attachments = service.getOutputAttachments();
        HttpSession session = req.getSession();
        String executionId = UUID.randomUUID().toString();
        Report report = new Report();
        report.setUuid(executionId);
        report.setOriginalUri(uri);
        report.setAttachments(attachments);
        report.setJasperPrint(jp);
        session.setAttribute(report.getUuid(), (Object)report);
        resp.setContentType("text/xml; charset=UTF-8");
        RESTUtils.setStatusAndBody(201, resp, report.toXml());
    }
}

