/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.rest.services;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.core.util.XMLUtil;
import com.jaspersoft.jasperserver.remote.AbstractService;
import com.jaspersoft.jasperserver.remote.ServiceException;
import com.jaspersoft.jasperserver.remote.services.DeleteService;
import com.jaspersoft.jasperserver.remote.services.GetService;
import com.jaspersoft.jasperserver.remote.services.PostService;
import com.jaspersoft.jasperserver.remote.services.PutService;
import com.jaspersoft.jasperserver.rest.RESTAbstractService;
import com.jaspersoft.jasperserver.rest.RESTUtils;
import com.jaspersoft.jasperserver.ws.xml.Marshaller;
import com.jaspersoft.jasperserver.ws.xml.Unmarshaller;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.activation.DataSource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RESTResource
extends RESTAbstractService {
    private static final Log log = LogFactory.getLog(RESTResource.class);

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServiceException {
        String uri = RESTUtils.extractRepositoryUri(req.getPathInfo());
        if (uri == null || uri.length() == 0) {
            uri = "/";
        }
        GetService service = new GetService(this.context);
        HashMap<String, Object> options = new HashMap<String, Object>();
        if (req.getParameter("IC_GET_QUERY_DATA") != null) {
            options.put("IC_GET_QUERY_DATA", req.getParameter("IC_GET_QUERY_DATA"));
            Map<String, Object> parameters = RESTUtils.extractParameters(req);
            if (parameters.size() > 0) {
                options.put("PARAMS_ARG", parameters);
            }
        }
        ResourceDescriptor rd = null;
        try {
            rd = service.getResource(uri, options);
        }
        catch (ServiceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            RESTUtils.setStatusAndBody(500, resp, ex.getLocalizedMessage());
            return;
        }
        if (rd == null) {
            RESTUtils.setStatusAndBody(404, resp, "");
            return;
        }
        String file = req.getParameter("file");
        if (file != null) {
            Map attachments = service.getOutputAttachments();
            if (attachments.containsKey(file)) {
                DataSource ds = (DataSource)attachments.get(file);
                RESTUtils.sendFile(ds, resp);
                return;
            }
            RESTUtils.setStatusAndBody(404, resp, "The specified file is not present in this resource");
            return;
        }
        Marshaller m = new Marshaller();
        String xml = m.writeResourceDescriptor(rd);
        RESTUtils.setStatusAndBody(200, resp, xml);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServiceException {
        PutService service = new PutService(this.context);
        HttpServletRequest mreq = RESTUtils.extractAttachments((AbstractService)service, req);
        String resourceDescriptorXml = null;
        if (mreq instanceof MultipartHttpServletRequest) {
            resourceDescriptorXml = mreq.getParameter("ResourceDescriptor");
        } else {
            try {
                resourceDescriptorXml = IOUtils.toString((InputStream)req.getInputStream());
            }
            catch (IOException ex) {
                throw new ServiceException(500, ex.getLocalizedMessage());
            }
        }
        if (resourceDescriptorXml == null) {
            RESTUtils.setStatusAndBody(400, resp, "Missing parameter ResourceDescriptor " + service.getInputAttachments());
            return;
        }
        InputSource is = new InputSource(new StringReader(resourceDescriptorXml));
        Document doc = null;
        ResourceDescriptor rd = null;
        try {
            doc = XMLUtil.getNewDocumentBuilder().parse(is);
            rd = Unmarshaller.readResourceDescriptor((Element)doc.getDocumentElement());
            rd.setIsNew(true);
            ResourceDescriptor createdRd = service.putResource(rd, true);
            Marshaller m = new Marshaller();
            String xml = m.writeResourceDescriptor(createdRd);
            RESTUtils.setStatusAndBody(201, resp, xml);
        }
        catch (SAXException ex) {
            RESTUtils.setStatusAndBody(400, resp, "Invalid resource descriptor");
            return;
        }
        catch (ServiceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            log.error((Object)("Unexpected error during resource save: " + ex.getMessage()), (Throwable)ex);
            throw new ServiceException(500, ex.getLocalizedMessage());
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServiceException {
        String sourceURI = RESTUtils.extractRepositoryUri(req.getPathInfo());
        String destURI = RESTUtils.getDetinationUri(req);
        if (destURI != null) {
            PostService service = new PostService(this.context);
            if (req.getParameterMap().containsKey("copyTo")) {
                service.copyResource(sourceURI, destURI);
            } else {
                service.moveResource(sourceURI, destURI);
            }
        } else {
            PutService service = new PutService(this.context);
            HttpServletRequest mreq = RESTUtils.extractAttachments((AbstractService)service, req);
            String resourceDescriptorXml = null;
            if (mreq instanceof MultipartHttpServletRequest) {
                resourceDescriptorXml = mreq.getParameter("ResourceDescriptor");
            } else {
                try {
                    resourceDescriptorXml = IOUtils.toString((InputStream)req.getInputStream());
                }
                catch (IOException ex) {
                    throw new ServiceException(500, ex.getLocalizedMessage());
                }
            }
            if (resourceDescriptorXml == null) {
                RESTUtils.setStatusAndBody(400, resp, "Missing parameter ResourceDescriptor " + service.getInputAttachments());
                return;
            }
            InputSource is = new InputSource(new StringReader(resourceDescriptorXml));
            Document doc = null;
            ResourceDescriptor rd = null;
            try {
                doc = XMLUtil.getNewDocumentBuilder().parse(is);
                rd = Unmarshaller.readResourceDescriptor((Element)doc.getDocumentElement());
                rd.setIsNew(false);
                if (rd.getUriString() == null || !rd.getUriString().equals(sourceURI)) {
                    RESTUtils.setStatusAndBody(400, resp, "Request and descriptor uri are not equals");
                }
                ResourceDescriptor createdRd = service.putResource(rd, true);
                Marshaller m = new Marshaller();
                String xml = m.writeResourceDescriptor(createdRd);
                RESTUtils.setStatusAndBody(200, resp, xml);
            }
            catch (SAXException ex) {
                log.error((Object)"error parsing...", (Throwable)ex);
                RESTUtils.setStatusAndBody(400, resp, "Invalid resource descriptor");
                return;
            }
            catch (ServiceException ex) {
                log.error((Object)"error executing the service...", (Throwable)ex);
                throw ex;
            }
            catch (Exception ex) {
                log.error((Object)"error executing the service...", (Throwable)ex);
                throw new ServiceException(500, ex.getLocalizedMessage());
            }
        }
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServiceException {
        String uri = RESTUtils.extractRepositoryUri(req.getPathInfo());
        DeleteService service = new DeleteService(this.context);
        service.deleteResource(uri);
        resp.setStatus(200);
    }
}

