/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.rest.test;

import com.jaspersoft.jasperserver.rest.test.RESTTest;
import com.jaspersoft.jasperserver.rest.test.RESTTestUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.message.BasicNameValuePair;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class POSTTest
extends RESTTest {
    @Before
    public void setUp() {
        super.setUp();
        this.httpReq = new HttpPost();
    }

    @Test
    public void Post200CreateNewFile_V1() throws Exception {
        this.putSampleImageFileResource("/resource/ContentFiles/JUNIT_IMAGE_FILE");
        String fileRd = "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/descriptors/update/imageFile_URI.ContentFiles.myImage_1.xml";
        String fileBins = "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/jasperSoftLogo.jpg";
        MultipartEntity reqEntity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
        reqEntity.addPart("ResourceDescriptor", (ContentBody)new StringBody(RESTTestUtils.getResourceDescriptor(new File(fileRd))));
        FileBody bin = new FileBody(new File(fileBins));
        reqEntity.addPart("/ContentFiles/JUNIT_IMAGE_FILE", (ContentBody)bin);
        ((HttpEntityEnclosingRequestBase)this.httpReq).setEntity((HttpEntity)reqEntity);
        this.httpRes = this.executeCall(this.httpReq, "/resource/ContentFiles/JUNIT_IMAGE_FILE");
        Assert.assertTrue((String)"basic response check did not pass", (boolean)this.isValidResposnse());
        this.deleteResource("/resource/ContentFiles/JUNIT_IMAGE_FILE");
    }

    @Test
    public void Post200NewDataType() throws Exception {
        this.putSampleResource("/dataType_URI.datasources.DataType1.xml", "/resource/ContentFiles/JUNIT_DATA_TYPE");
        BasicHttpEntity reqEntity = new BasicHttpEntity();
        reqEntity.setContent((InputStream)new FileInputStream(new File("src/main/java/com/jaspersoft/jasperserver/rest/test/resources/descriptors/update/dataType_URI.datasources.DataType1.xml")));
        ((HttpEntityEnclosingRequestBase)this.httpReq).setEntity((HttpEntity)reqEntity);
        this.httpRes = this.executeCall(this.httpReq, "/resource/ContentFiles/JUNIT_DATA_TYPE");
        Assert.assertTrue((String)"basic response check did not pass", (boolean)this.isValidResposnse());
        this.deleteResource("/resource/ContentFiles/JUNIT_DATA_TYPE");
    }

    @Test
    public void Post200CopyFile() throws Exception {
        this.putSampleFolder();
        this.putSampleResource("/dataType_URI.datasources.DataType1.xml", "/resource/ContentFiles/JUNIT_DATA_TYPE");
        ArrayList<NameValuePair> qparams = new ArrayList<NameValuePair>();
        qparams.add((NameValuePair)new BasicNameValuePair("copyTo", "/ContentFiles/JUNIT_NEW_FOLDER/COPY_TO_TEST"));
        this.httpRes = this.executeCall(this.httpReq, "/resource/ContentFiles/JUNIT_DATA_TYPE", qparams);
        Assert.assertTrue((String)"basic response check did not pass", (boolean)this.isValidResposnse());
        this.deleteResource("/resource/ContentFiles/JUNIT_NEW_FOLDER");
        this.deleteResource("/resource/ContentFiles/JUNIT_DATA_TYPE");
    }

    @Test
    public void Post200CopyFolder() throws Exception {
        ArrayList<NameValuePair> qparams = new ArrayList<NameValuePair>();
        qparams.add((NameValuePair)new BasicNameValuePair("copyTo", "/datasources/JUNIT"));
        this.httpRes = this.executeCall(this.httpReq, "/resource/reports/samples", qparams);
        Assert.assertTrue((String)"basic response check did not pass", (boolean)this.isValidResposnse());
    }

    @Test
    public void Post200MoveFile() throws Exception {
        this.putSampleFolder();
        this.putSampleResource("/dataType_URI.datasources.DataType1.xml", "/resource/ContentFiles/JUNIT_DATA_TYPE");
        ArrayList<NameValuePair> qparams = new ArrayList<NameValuePair>();
        qparams.add((NameValuePair)new BasicNameValuePair("moveTo", "/ContentFiles/JUNIT_NEW_FOLDER"));
        this.httpRes = this.executeCall(this.httpReq, "/resource/ContentFiles/JUNIT_DATA_TYPE", qparams);
        Assert.assertTrue((String)"basic response check did not pass", (boolean)this.isValidResposnse());
        this.deleteResource("/resource/ContentFiles/JUNIT_NEW_FOLDER");
    }
}

