/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.util.LocaleHelper;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.metadata.user.service.UserAuthorityService;
import com.jaspersoft.jasperserver.api.metadata.user.service.impl.HttpOnlyResponseWrapper;
import com.jaspersoft.jasperserver.war.common.JasperServerConstImpl;
import java.io.IOException;
import java.util.Date;
import java.util.Locale;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.security.Authentication;
import org.springframework.security.context.SecurityContextHolder;

public class UserPreferencesFilter
implements Filter {
    private static String USER_LOCALE_PARAM = "userLocale";
    private static String USER_TIMEZONE_PARAM = "userTimezone";
    private static String USER_NAME = "j_username";
    private static String USER_PASSWORD = "j_newpassword1";
    private int cookieAge;
    UserAuthorityService userService;

    public UserAuthorityService getUserService() {
        return this.userService;
    }

    public void setUserService(UserAuthorityService userService) {
        this.userService = userService;
    }

    public void init(FilterConfig config) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String sessionTimezone;
        Cookie cookie;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpSession session = httpRequest.getSession();
        String userLocale = request.getParameter(USER_LOCALE_PARAM);
        String userTimezone = request.getParameter(USER_TIMEZONE_PARAM);
        HttpOnlyResponseWrapper httpOnlyResponseWrapper = new HttpOnlyResponseWrapper((HttpServletResponse)response);
        if (SecurityContextHolder.getContext().getAuthentication() == null) {
            session.removeAttribute("js_uname");
            session.removeAttribute("js_upassword");
        }
        Locale sessionLocale = (Locale)session.getAttribute(JasperServerConstImpl.getUserLocaleSessionAttr());
        if (userLocale != null && userLocale.length() > 0) {
            Locale locale = LocaleHelper.getInstance().getLocale(userLocale);
            if (sessionLocale == null || !sessionLocale.equals(locale)) {
                session.setAttribute(JasperServerConstImpl.getUserLocaleSessionAttr(), (Object)locale);
                cookie = new Cookie(JasperServerConstImpl.getUserLocaleSessionAttr(), userLocale);
                cookie.setMaxAge(this.cookieAge);
                httpOnlyResponseWrapper.addCookie(cookie);
            }
        }
        if (sessionLocale != null) {
            LocaleContextHolder.setLocale((Locale)sessionLocale);
        }
        if (!(userTimezone == null || userTimezone.length() <= 0 || (sessionTimezone = (String)session.getAttribute(JasperServerConstImpl.getUserTimezoneSessionAttr())) != null && sessionTimezone.equals(userTimezone))) {
            session.setAttribute(JasperServerConstImpl.getUserTimezoneSessionAttr(), (Object)userTimezone);
            cookie = new Cookie(JasperServerConstImpl.getUserTimezoneSessionAttr(), userTimezone);
            cookie.setMaxAge(this.cookieAge);
            httpOnlyResponseWrapper.addCookie(cookie);
        }
        String userName = request.getParameter(USER_NAME);
        String userNewPassword = request.getParameter(USER_PASSWORD);
        String passwordExpiredDays = request.getParameter("passwordExpiredDays");
        String testFilter = (String)session.getAttribute("js_uname");
        if (testFilter == null) {
            if (userName != null) {
                session.setAttribute("js_uname", (Object)userName);
            }
            if (userNewPassword != null) {
                session.setAttribute("js_upassword", (Object)userNewPassword);
            }
            if (passwordExpiredDays != null) {
                session.setAttribute("passwordExpiredDays", (Object)passwordExpiredDays);
            }
        } else {
            userName = (String)session.getAttribute("js_uname");
            userNewPassword = (String)session.getAttribute("js_upassword");
            Authentication auth = SecurityContextHolder.getContext().getAuthentication();
            if (userNewPassword != null && !"".equals(userNewPassword.trim())) {
                User user = this.getUser(null, auth);
                user.setPassword(userNewPassword);
                user.setPreviousPasswordChangeTime(new Date());
                this.userService.putUser(null, user);
                session.removeAttribute("js_uname");
                session.removeAttribute("js_upassword");
                session.removeAttribute("passwordExpiredDays");
                chain.doFilter(request, response);
                return;
            }
            session.removeAttribute("js_uname");
            session.removeAttribute("js_upassword");
            String nDate = (String)session.getAttribute("passwordExpiredDays");
            if (nDate != null) {
                int totalDate = 0;
                try {
                    totalDate = Integer.parseInt(nDate);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                if (totalDate > 0 && this.isPasswordExpired(null, auth, totalDate)) {
                    RequestDispatcher rd = request.getRequestDispatcher("/exituser.html?showPasswordChange=true");
                    rd.forward(request, response);
                    return;
                }
            }
            session.removeAttribute("passwordExpiredDays");
        }
        chain.doFilter(request, response);
    }

    protected boolean isPasswordExpired(ExecutionContext context, Authentication auth, int nDays) {
        return this.userService.isPasswordExpired(context, auth.getName(), nDays);
    }

    protected User getUser(ExecutionContext context, Authentication auth) {
        return this.userService.getUser(context, auth.getName());
    }

    public void destroy() {
    }

    public int getCookieAge() {
        return this.cookieAge;
    }

    public void setCookieAge(int cookieAge) {
        this.cookieAge = cookieAge;
    }
}

