/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.action;

import com.jaspersoft.jasperserver.api.JSDuplicateResourceException;
import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.metadata.common.domain.DataType;
import com.jaspersoft.jasperserver.api.metadata.common.domain.InputControl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ListOfValues;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Query;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceLookup;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterCriteria;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterElement;
import com.jaspersoft.jasperserver.war.common.ConfigurationBean;
import com.jaspersoft.jasperserver.war.common.JasperServerConstImpl;
import com.jaspersoft.jasperserver.war.common.JasperServerUtil;
import com.jaspersoft.jasperserver.war.dto.DataTypeWrapper;
import com.jaspersoft.jasperserver.war.dto.InputControlWrapper;
import com.jaspersoft.jasperserver.war.dto.ListOfValuesDTO;
import com.jaspersoft.jasperserver.war.dto.QueryWrapper;
import com.jaspersoft.jasperserver.war.dto.ResourceReferenceDTO;
import com.jaspersoft.jasperserver.war.model.impl.TypedTreeDataProvider;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.MessageSource;
import org.springframework.webflow.action.FormAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.ScopeType;

public class DefineInputControlsAction
extends FormAction {
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private static final String ATTRIBUTE_RESOURCE_ID_NOT_SUPPORTED_SYMBOLS = "resourceIdNotSupportedSymbols";
    private static final String FORM_OBJECT_KEY = "control";
    private static final String CONSTANTS_KEY = "constants";
    private static final String DATATYPE_KEY = "dataType";
    private static final String QUERY_KEY = "query";
    private static final String LOV_KEY = "listOfValuesDTO";
    private static final String INPUTCONTROLURI_PARAM = "resource";
    private static final String PARENT_FOLDER_ATTR = "parentFolder";
    private static final String DATATYPE_TREE_DATA_PROVIDER = "dataTypeTreeDataProvider";
    private static final String LISTOFVALUES_TREE_DATA_PROVIDER = "listOfValuesTreeDataProvider";
    private static final String QUERY_TREE_DATA_PROVIDER = "queryTreeDataProvider";
    private static final String OLAP_TREE_DATA_PROVIDER = "oLAPTreeDataProvider";
    private RepositoryService repository;
    private String queryReferenceReqAttrName;
    private String queryReferenceOutpuAttrName;
    private TypedTreeDataProvider dataTypeTreeDataProvider;
    private TypedTreeDataProvider listOfValuesTreeDataProvider;
    private TypedTreeDataProvider queryTreeDataProvider;
    private TypedTreeDataProvider oLAPTreeDataProvider;
    private MessageSource messageSource;
    private ConfigurationBean configuration;

    public RepositoryService getRepository() {
        return this.repository;
    }

    public void setRepository(RepositoryService repository) {
        this.repository = repository;
    }

    public DefineInputControlsAction() {
        this.setFormObjectClass(InputControlWrapper.class);
        this.setFormObjectName(FORM_OBJECT_KEY);
        this.setFormObjectScope(ScopeType.FLOW);
    }

    public Event initControlDefinition(RequestContext context) throws Exception {
        InputControlWrapper formObject = (InputControlWrapper)this.getFormObject(context);
        context.getFlowScope().put(CONSTANTS_KEY, (Object)new JasperServerConstImpl());
        context.getExternalContext().getSessionMap().put(DATATYPE_TREE_DATA_PROVIDER, (Object)this.dataTypeTreeDataProvider);
        context.getExternalContext().getSessionMap().put(LISTOFVALUES_TREE_DATA_PROVIDER, (Object)this.listOfValuesTreeDataProvider);
        context.getExternalContext().getSessionMap().put(QUERY_TREE_DATA_PROVIDER, (Object)this.queryTreeDataProvider);
        context.getExternalContext().getSessionMap().put(OLAP_TREE_DATA_PROVIDER, (Object)this.queryTreeDataProvider);
        if (formObject.isAloneNewMode()) {
            InputControl ic = formObject.getInputControl();
            FilterCriteria criteria = FilterCriteria.createFilter();
            criteria.addFilterElement((FilterElement)FilterCriteria.createParentFolderFilter((String)ic.getParentFolder()));
            ResourceLookup[] resources = this.repository.findResource(JasperServerUtil.getExecutionContext(context), criteria);
            List<ResourceLookup> allResources = Arrays.asList(resources);
            formObject.setAllResources(allResources);
        }
        context.getFlowScope().put(ATTRIBUTE_RESOURCE_ID_NOT_SUPPORTED_SYMBOLS, (Object)this.configuration.getResourceIdNotSupportedSymbols());
        return this.success();
    }

    public Event prepareForControlType(RequestContext context) throws Exception {
        String uri;
        InputControlWrapper formObject = (InputControlWrapper)this.getFormObject(context);
        InputControl control = formObject.getInputControl();
        int selectedType = control.getType();
        if (selectedType == 0) {
            this.log("Selected type was null");
            selectedType = 2;
        }
        FilterCriteria criteria = null;
        if (selectedType == 6 || selectedType == 3 || selectedType == 8 || selectedType == 10) {
            criteria = FilterCriteria.createFilter(ListOfValues.class);
            if (control.getListOfValues() != null) {
                uri = control.getListOfValues().getReferenceURI();
                if (uri != null) {
                    formObject.setExistingPath(uri);
                    formObject.setSource(JasperServerConstImpl.getFieldChoiceRepo());
                } else {
                    formObject.setSource(JasperServerConstImpl.getFieldChoiceLocal());
                }
            } else {
                formObject.setSource(JasperServerConstImpl.getFieldChoiceLocal());
            }
        }
        if (selectedType == 7 || selectedType == 4 || selectedType == 9 || selectedType == 11) {
            criteria = FilterCriteria.createFilter(Query.class);
            if (control.getQuery() != null) {
                uri = control.getQuery().getReferenceURI();
                if (uri != null) {
                    formObject.setExistingPath(uri);
                    formObject.setSource(JasperServerConstImpl.getFieldChoiceRepo());
                } else {
                    formObject.setSource(JasperServerConstImpl.getFieldChoiceLocal());
                }
            } else {
                formObject.setSource(JasperServerConstImpl.getFieldChoiceLocal());
            }
        }
        if (selectedType == 5 || selectedType == 2) {
            criteria = FilterCriteria.createFilter(DataType.class);
            if (control.getDataType() != null) {
                uri = control.getDataType().getReferenceURI();
                if (uri != null) {
                    formObject.setExistingPath(uri);
                    formObject.setSource(JasperServerConstImpl.getFieldChoiceRepo());
                } else {
                    formObject.setSource(JasperServerConstImpl.getFieldChoiceLocal());
                }
            } else {
                formObject.setSource(JasperServerConstImpl.getFieldChoiceLocal());
            }
        }
        if (selectedType == 1) {
            return this.success();
        }
        this.log("control type=" + selectedType);
        ArrayList<String> existingPathsList = new ArrayList<String>();
        ResourceLookup[] lookups = this.repository.findResource(JasperServerUtil.getExecutionContext(context), criteria);
        if (lookups != null) {
            this.log("Found lookups size=" + lookups.length);
            for (int i = 0; i < lookups.length; ++i) {
                existingPathsList.add(lookups[i].getURIString());
                if (lookups[i] != null) {
                    this.log("Found path=" + lookups[i].getURIString());
                    continue;
                }
                this.log("Found null Lookup at " + i);
            }
        }
        formObject.setExistingPathList(existingPathsList);
        return this.success();
    }

    public Event handleDataTypeControl(RequestContext context) throws Exception {
        DataTypeWrapper wrapper;
        InputControlWrapper formObject = (InputControlWrapper)this.getFormObject(context);
        if (formObject == null) {
            return this.error();
        }
        InputControl control = formObject.getInputControl();
        formObject.setSource(context.getRequestParameters().get("source"));
        if (formObject.getSource().equals(JasperServerConstImpl.getFieldChoiceLocal())) {
            DataType dt = null;
            if (control.getDataType() == null || control.getDataType().getLocalResource() == null) {
                dt = (DataType)this.repository.newResource(null, DataType.class);
                control.setDataType(dt);
                wrapper = new DataTypeWrapper(dt);
            } else {
                byte type;
                if (control.getDataType().isLocal()) {
                    dt = (DataType)control.getDataType().getLocalResource();
                    if (dt.getDecimals() != null) {
                        formObject.setDtDecimals(dt.getDecimals().toString());
                    }
                    if (dt.getMaxLength() != null) {
                        formObject.setDtMaxLength(dt.getMaxLength().toString());
                    }
                }
                wrapper = new DataTypeWrapper((DataType)control.getDataType().getLocalResource());
                if (dt != null && ((type = dt.getType()) == 3 || type == 4)) {
                    DateFormat df = this.getFormat(type);
                    if (dt.getMinValue() != null && !dt.getMinValue().equals("")) {
                        wrapper.setMinValueText(df.format((Date)dt.getMinValue()));
                    }
                    if (dt.getMaxValue() != null && !dt.getMaxValue().equals("")) {
                        wrapper.setMaxValueText(df.format((Date)dt.getMaxValue()));
                    }
                }
            }
        } else {
            String path = context.getRequestParameters().get("existingPath");
            control.setDataTypeReference(path);
            return this.yes();
        }
        wrapper.setMode(wrapper.getDataType().isNew() ? (byte)3 : 4);
        context.getFlowScope().put(DATATYPE_KEY, (Object)wrapper);
        return this.success();
    }

    public Event handleLovControl(RequestContext context) throws Exception {
        ListOfValuesDTO listOfValues;
        InputControlWrapper formObject = (InputControlWrapper)this.getFormObject(context);
        if (formObject == null) {
            return this.error();
        }
        InputControl control = formObject.getInputControl();
        formObject.setSource(context.getRequestParameters().get("source"));
        if (formObject.getSource().equals(JasperServerConstImpl.getFieldChoiceLocal())) {
            if (control.getListOfValues() == null || control.getListOfValues().getLocalResource() == null) {
                ListOfValues lov = (ListOfValues)this.repository.newResource(null, ListOfValues.class);
                control.setListOfValues(lov);
                listOfValues = new ListOfValuesDTO(lov);
                listOfValues.setMode((byte)3);
            } else {
                listOfValues = new ListOfValuesDTO((ListOfValues)control.getListOfValues().getLocalResource());
                listOfValues.setMode((byte)4);
            }
        } else {
            String path = context.getRequestParameters().get("existingPath");
            control.setListOfValuesReference(path);
            return this.yes();
        }
        context.getFlowScope().put(LOV_KEY, (Object)listOfValues);
        return this.success();
    }

    public Event handleQueryControl(RequestContext context) throws Exception {
        QueryWrapper wrapper;
        InputControlWrapper formObject = (InputControlWrapper)this.getFormObject(context);
        if (formObject == null) {
            return this.error();
        }
        InputControl control = formObject.getInputControl();
        formObject.setSource(context.getRequestParameters().get("source"));
        if (formObject.getSource().equals(JasperServerConstImpl.getFieldChoiceLocal())) {
            Query dt = null;
            if (control.getQuery() == null || control.getQuery().getLocalResource() == null) {
                dt = (Query)this.repository.newResource(null, Query.class);
                control.setQuery(dt);
                wrapper = new QueryWrapper(dt);
            } else {
                wrapper = new QueryWrapper((Query)control.getQuery().getLocalResource());
            }
        } else {
            String path = context.getRequestParameters().get("existingPath");
            control.setQueryReference(path);
            return this.yes();
        }
        wrapper.setMode(wrapper.getQuery().isNew() ? (byte)3 : 4);
        context.getFlowScope().put(QUERY_KEY, (Object)wrapper);
        return this.success();
    }

    public Event saveInputControl(RequestContext context) throws Exception {
        InputControlWrapper formObject = (InputControlWrapper)this.getFormObject(context);
        InputControl control = formObject.getInputControl();
        if (control.getType() == 2 || control.getType() == 5) {
            DataType dataType = (DataType)control.getDataType().getLocalResource();
            if (formObject.getDtMaxLength() != null && formObject.getDtMaxLength().length() > 0) {
                dataType.setMaxLength(new Integer(formObject.getDtMaxLength()));
            }
            if (formObject.getDtDecimals() != null && formObject.getDtDecimals().length() > 0) {
                dataType.setDecimals(new Integer(formObject.getDtDecimals()));
            }
        }
        if (formObject.isStandAloneMode()) {
            try {
                this.repository.saveResource(null, (Resource)control);
                return this.yes();
            }
            catch (JSDuplicateResourceException e) {
                this.getFormErrors(context).rejectValue("inputControl.name", "InputControlsFlowValidator.error.already.exists");
                return this.error();
            }
        }
        return this.success();
    }

    public Object createFormObject(RequestContext context) {
        InputControl control;
        String parentFolder;
        InputControlWrapper formObject = null;
        String resourceUri = context.getRequestParameters().get(INPUTCONTROLURI_PARAM);
        if (resourceUri != null && resourceUri.trim().length() != 0) {
            InputControl resource = (InputControl)this.repository.getResource(null, resourceUri);
            if (resource == null) {
                throw new JSException("jsexception.could.not.find.resource.with.uri", new Object[]{resourceUri});
            }
            this.log("Found resource with uri=" + resourceUri);
            formObject = new InputControlWrapper(resource);
            parentFolder = (String)context.getFlowScope().get(PARENT_FOLDER_ATTR);
            if (parentFolder == null) {
                parentFolder = context.getRequestParameters().get("ParentFolderUri");
                context.getFlowScope().put(PARENT_FOLDER_ATTR, (Object)parentFolder);
            }
            formObject.setMode((byte)2);
        }
        if (formObject == null) {
            InputControl inputControl = (InputControl)this.repository.newResource(null, InputControl.class);
            parentFolder = (String)context.getFlowScope().get(PARENT_FOLDER_ATTR);
            if (parentFolder == null) {
                parentFolder = context.getRequestParameters().get("ParentFolderUri");
                context.getFlowScope().put(PARENT_FOLDER_ATTR, (Object)parentFolder);
            }
            inputControl.setParentFolder(parentFolder);
            formObject = new InputControlWrapper(inputControl);
            formObject.setMode((byte)1);
        }
        if ((control = formObject.getInputControl()).getParentFolder() == null) {
            control.setParentFolder("/");
        }
        formObject.setSource(JasperServerConstImpl.getFieldChoiceRepo());
        return formObject;
    }

    public Event addVisibleColumn(RequestContext context) throws Exception {
        InputControlWrapper formObject = (InputControlWrapper)this.getFormObject(context);
        formObject.getInputControl().addQueryVisibleColumn(formObject.getNewVisibleColumn());
        return this.success();
    }

    public Event removeVisibleColumn(RequestContext context) throws Exception {
        InputControlWrapper formObject = (InputControlWrapper)this.getFormObject(context);
        if (context.getRequestParameters().contains("itemToDelete")) {
            String[] selectedColumns = context.getRequestParameters().getArray("itemToDelete");
            for (int i = 0; i < selectedColumns.length; ++i) {
                formObject.getInputControl().removeQueryVisibleColumn(selectedColumns[i]);
            }
        }
        return this.success();
    }

    private void log(String text) {
        this.log.debug((Object)text);
    }

    public static String getFORM_OBJECT_KEY() {
        return FORM_OBJECT_KEY;
    }

    public Event prepareQuery(RequestContext context) throws Exception {
        InputControlWrapper formObject = (InputControlWrapper)this.getFormObject(context);
        ResourceReference queryRef = formObject.getInputControl().getQuery();
        ResourceReferenceDTO queryRefDTO = new ResourceReferenceDTO(queryRef);
        context.getRequestScope().put(this.getQueryReferenceReqAttrName(), (Object)queryRefDTO);
        return this.success();
    }

    public Event setQueryReference(RequestContext context) throws Exception {
        ResourceReferenceDTO queryRef = (ResourceReferenceDTO)context.getFlowScope().getRequired(this.getQueryReferenceOutpuAttrName(), ResourceReferenceDTO.class);
        InputControlWrapper formObject = (InputControlWrapper)this.getFormObject(context);
        formObject.getInputControl().setQuery(queryRef.toResourceReference());
        return this.success();
    }

    public String getQueryReferenceReqAttrName() {
        return this.queryReferenceReqAttrName;
    }

    public void setQueryReferenceReqAttrName(String queryReferenceReqAttrName) {
        this.queryReferenceReqAttrName = queryReferenceReqAttrName;
    }

    public String getQueryReferenceOutpuAttrName() {
        return this.queryReferenceOutpuAttrName;
    }

    public void setQueryReferenceOutpuAttrName(String queryReferenceOutpuAttrName) {
        this.queryReferenceOutpuAttrName = queryReferenceOutpuAttrName;
    }

    private DateFormat getFormat(byte type) {
        if (type == 3) {
            return JasperServerUtil.createCalendarDateFormat(this.messageSource);
        }
        return JasperServerUtil.createCalendarDateTimeFormat(this.messageSource);
    }

    public MessageSource getMessageSource() {
        return this.messageSource;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public TypedTreeDataProvider getDataTypeTreeDataProvider() {
        return this.dataTypeTreeDataProvider;
    }

    public void setDataTypeTreeDataProvider(TypedTreeDataProvider typedTreeDataProvider) {
        this.dataTypeTreeDataProvider = typedTreeDataProvider;
    }

    public TypedTreeDataProvider getListOfValuesTreeDataProvider() {
        return this.listOfValuesTreeDataProvider;
    }

    public void setListOfValuesTreeDataProvider(TypedTreeDataProvider listOfValuesTreeDataProvider) {
        this.listOfValuesTreeDataProvider = listOfValuesTreeDataProvider;
    }

    public TypedTreeDataProvider getQueryTreeDataProvider() {
        return this.queryTreeDataProvider;
    }

    public void setQueryTreeDataProvider(TypedTreeDataProvider queryTreeDataProvider) {
        this.queryTreeDataProvider = queryTreeDataProvider;
    }

    public TypedTreeDataProvider getOLAPTreeDataProvider() {
        return this.oLAPTreeDataProvider;
    }

    public void setOLAPTreeDataProvider(TypedTreeDataProvider oLAPTreeDataProvider) {
        this.oLAPTreeDataProvider = oLAPTreeDataProvider;
    }

    public void setConfiguration(ConfigurationBean configuration) {
        this.configuration = configuration;
    }
}

