/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.action.hyperlinks;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.engine.jasperreports.domain.impl.ReportUnitResult;
import com.jaspersoft.jasperserver.war.action.hyperlinks.HyperlinkProducerFlowFactory;
import com.jaspersoft.jasperserver.war.util.SessionObjectSerieAccessor;
import java.io.Serializable;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JRPrintAnchorIndex;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRHyperlinkProducer;

public class LocalAnchorHyperlinkProducerFactory
implements HyperlinkProducerFlowFactory,
Serializable {
    private static final long serialVersionUID = 1L;
    private SessionObjectSerieAccessor jasperPrintAccessor;
    private String jasperPrintNameRequestAttribute;
    private String flowControllerMapping;
    private String navigateEventID;
    private String pageIndexParameter;

    public JRHyperlinkProducer getHyperlinkProducer(HttpServletRequest request, HttpServletResponse response) {
        return new LocalAnchorHyperlinkProducer(request, response);
    }

    public String getJasperPrintNameRequestAttribute() {
        return this.jasperPrintNameRequestAttribute;
    }

    public void setJasperPrintNameRequestAttribute(String jasperPrintNameRequestAttribute) {
        this.jasperPrintNameRequestAttribute = jasperPrintNameRequestAttribute;
    }

    public String getFlowControllerMapping() {
        return this.flowControllerMapping;
    }

    public void setFlowControllerMapping(String flowControllerMapping) {
        this.flowControllerMapping = flowControllerMapping;
    }

    public String getNavigateEventID() {
        return this.navigateEventID;
    }

    public void setNavigateEventID(String navigateEventID) {
        this.navigateEventID = navigateEventID;
    }

    public String getPageIndexParameter() {
        return this.pageIndexParameter;
    }

    public void setPageIndexParameter(String pageIndexParameter) {
        this.pageIndexParameter = pageIndexParameter;
    }

    public SessionObjectSerieAccessor getJasperPrintAccessor() {
        return this.jasperPrintAccessor;
    }

    public void setJasperPrintAccessor(SessionObjectSerieAccessor jasperPrintAccessor) {
        this.jasperPrintAccessor = jasperPrintAccessor;
    }

    protected class LocalAnchorHyperlinkProducer
    implements JRHyperlinkProducer {
        private final HttpServletResponse response;
        private final String appContext;
        private final JasperPrint jasperPrint;
        private final String flowExecutionKey;

        public LocalAnchorHyperlinkProducer(HttpServletRequest request, HttpServletResponse response) {
            this.response = response;
            this.appContext = request.getContextPath();
            this.flowExecutionKey = (String)request.getAttribute("flowExecutionKey");
            String jasperPrintName = (String)request.getAttribute(LocalAnchorHyperlinkProducerFactory.this.getJasperPrintNameRequestAttribute());
            ReportUnitResult result = (ReportUnitResult)LocalAnchorHyperlinkProducerFactory.this.getJasperPrintAccessor().getObject(request, jasperPrintName);
            JasperPrint jasperPrint = this.jasperPrint = result == null ? null : result.getJasperPrint();
            if (this.jasperPrint == null) {
                throw new JSException("jsexception.jasperprint.not.found", new Object[]{jasperPrintName});
            }
        }

        public String getHyperlink(JRPrintHyperlink hyperlink) {
            Map anchorIndexes;
            JRPrintAnchorIndex anchorIndex;
            String ref = null;
            String anchor = hyperlink.getHyperlinkAnchor();
            if (anchor != null && (anchorIndex = (JRPrintAnchorIndex)(anchorIndexes = this.jasperPrint.getAnchorIndexes()).get(anchor)) != null) {
                int page = anchorIndex.getPageIndex();
                ref = this.createAnchorURL(anchor, page);
            }
            return ref;
        }

        protected String createAnchorURL(String anchor, int page) {
            StringBuffer uri = new StringBuffer(200);
            uri.append(this.appContext);
            uri.append(LocalAnchorHyperlinkProducerFactory.this.getFlowControllerMapping());
            uri.append("?_eventId_");
            uri.append(LocalAnchorHyperlinkProducerFactory.this.getNavigateEventID());
            uri.append("=&");
            uri.append(LocalAnchorHyperlinkProducerFactory.this.getPageIndexParameter());
            uri.append("=");
            uri.append(page);
            uri.append("&_flowExecutionKey=");
            uri.append(this.flowExecutionKey);
            uri.append("#");
            uri.append(anchor);
            return this.response.encodeURL(uri.toString());
        }
    }
}

