/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.common;

import java.io.IOException;
import java.util.Iterator;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;

public class UploadMultipartFilter
implements Filter {
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        CommonsMultipartResolver resolver = new CommonsMultipartResolver();
        HttpServletRequest hRequest = (HttpServletRequest)request;
        if (resolver.isMultipart(hRequest) && hRequest.getContentLength() != -1) {
            MultipartHttpServletRequest mreq = resolver.resolveMultipart(hRequest);
            if (mreq != null) {
                int lastIndex;
                String fullName;
                Iterator iterator = mreq.getFileNames();
                String fieldName = null;
                while (iterator.hasNext()) {
                    fieldName = (String)iterator.next();
                }
                MultipartFile file = mreq.getFile(fieldName);
                if (file != null && (fullName = file.getOriginalFilename()) != null && fullName.trim().length() != 0 && (lastIndex = fullName.lastIndexOf(".")) != -1) {
                    String fileName = fullName.substring(0, lastIndex);
                    String extension = fullName.substring(lastIndex + 1);
                    mreq.setAttribute("uploadedFileName", (Object)fileName);
                    mreq.setAttribute("uploadedFileExt", (Object)extension);
                }
            }
            chain.doFilter((ServletRequest)mreq, response);
        } else {
            chain.doFilter(request, response);
        }
    }

    public void init(FilterConfig arg0) throws ServletException {
    }

    public void destroy() {
    }
}

