/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.control;

import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.util.JRLoader;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.Controller;
import org.springframework.web.servlet.view.AbstractView;

public class ReportResourceController
implements Controller {
    private String resourceNameParameter;

    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws JRException {
        byte[] data = null;
        String mimeType = null;
        String resourceName = request.getParameter(this.getImageNameParameter());
        if (resourceName != null && resourceName.contains("net/sf/jasperreports")) {
            data = JRLoader.loadBytesFromResource((String)resourceName);
        }
        if (resourceName.endsWith(".js")) {
            response.setContentType("text/javascript");
        } else if (resourceName.endsWith(".css")) {
            response.setContentType("text/css");
        }
        ResourceView view = new ResourceView(mimeType, data);
        return new ModelAndView((View)view);
    }

    public String getResourceNameParameter() {
        return this.resourceNameParameter;
    }

    public String getImageNameParameter() {
        return this.resourceNameParameter;
    }

    public void setResourceNameParameter(String resourceNameParameter) {
        this.resourceNameParameter = resourceNameParameter;
    }

    protected static class ResourceView
    extends AbstractView {
        private final String mimeType;
        private final byte[] data;

        public ResourceView(String mimeType, byte[] data) {
            this.mimeType = mimeType;
            this.data = data;
        }

        protected void renderMergedOutputModel(Map model, HttpServletRequest request, HttpServletResponse response) throws Exception {
            if (this.data != null && this.data.length > 0) {
                if (this.mimeType != null) {
                    response.setHeader("Content-Type", this.mimeType);
                }
                response.setContentLength(this.data.length);
                ServletOutputStream ouputStream = response.getOutputStream();
                ouputStream.write(this.data, 0, this.data.length);
                ouputStream.flush();
                ouputStream.close();
            } else {
                response.getOutputStream().close();
            }
        }
    }
}

