/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.security;

import com.jaspersoft.jasperserver.war.security.FlowDefinitionSource;
import org.springframework.security.Authentication;
import org.springframework.security.ConfigAttribute;
import org.springframework.security.ConfigAttributeDefinition;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.vote.AbstractAclVoter;

public class FlowRoleAccessVoter
extends AbstractAclVoter {
    private FlowDefinitionSource flowDefinitionSource;
    private String flowAccessAttribute;

    public FlowRoleAccessVoter() {
        this.setProcessDomainObjectClass(String.class);
    }

    public boolean supports(ConfigAttribute attribute) {
        String attr = attribute.getAttribute();
        return attr != null && attr.equals(this.getFlowAccessAttribute());
    }

    public int vote(Authentication authentication, Object object, ConfigAttributeDefinition config) {
        int result = 0;
        for (ConfigAttribute attribute : config.getConfigAttributes()) {
            if (!this.supports(attribute)) continue;
            result = this.voteFlowAccess(authentication, object);
        }
        return result;
    }

    protected int voteFlowAccess(Authentication authentication, Object object) {
        int result;
        String flowId = (String)this.getDomainObjectInstance(object);
        if (flowId == null) {
            result = 0;
        } else {
            result = -1;
            ConfigAttributeDefinition flowAttributes = this.getFlowDefinitionSource().getAttributes(flowId);
            for (ConfigAttribute attribute : flowAttributes.getConfigAttributes()) {
                if (!this.matchesAuthority(authentication, attribute.getAttribute())) continue;
                result = 1;
                break;
            }
        }
        return result;
    }

    protected boolean matchesAuthority(Authentication authentication, String attribute) {
        GrantedAuthority[] authorities = authentication.getAuthorities();
        boolean matches = false;
        for (int i = 0; i < authorities.length; ++i) {
            if (!attribute.equals(authorities[i].getAuthority())) continue;
            matches = true;
            break;
        }
        return matches;
    }

    public FlowDefinitionSource getFlowDefinitionSource() {
        return this.flowDefinitionSource;
    }

    public void setFlowDefinitionSource(FlowDefinitionSource flowDefinitionSource) {
        this.flowDefinitionSource = flowDefinitionSource;
    }

    public String getFlowAccessAttribute() {
        return this.flowAccessAttribute;
    }

    public void setFlowAccessAttribute(String flowAccessAttribute) {
        this.flowAccessAttribute = flowAccessAttribute;
    }
}

