/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.support;

import java.util.Collection;
import javax.naming.CompositeName;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.ldap.LdapContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.ldap.AttributeInUseException;
import org.springframework.ldap.AttributeModificationException;
import org.springframework.ldap.AuthenticationException;
import org.springframework.ldap.AuthenticationNotSupportedException;
import org.springframework.ldap.CannotProceedException;
import org.springframework.ldap.CommunicationException;
import org.springframework.ldap.ConfigurationException;
import org.springframework.ldap.ContextNotEmptyException;
import org.springframework.ldap.InsufficientResourcesException;
import org.springframework.ldap.InterruptedNamingException;
import org.springframework.ldap.InvalidAttributeIdentifierException;
import org.springframework.ldap.InvalidAttributeValueException;
import org.springframework.ldap.InvalidAttributesException;
import org.springframework.ldap.InvalidNameException;
import org.springframework.ldap.InvalidSearchControlsException;
import org.springframework.ldap.InvalidSearchFilterException;
import org.springframework.ldap.LdapReferralException;
import org.springframework.ldap.LimitExceededException;
import org.springframework.ldap.LinkException;
import org.springframework.ldap.LinkLoopException;
import org.springframework.ldap.MalformedLinkException;
import org.springframework.ldap.NameAlreadyBoundException;
import org.springframework.ldap.NameNotFoundException;
import org.springframework.ldap.NamingException;
import org.springframework.ldap.NoInitialContextException;
import org.springframework.ldap.NoPermissionException;
import org.springframework.ldap.NoSuchAttributeException;
import org.springframework.ldap.NotContextException;
import org.springframework.ldap.OperationNotSupportedException;
import org.springframework.ldap.PartialResultException;
import org.springframework.ldap.SchemaViolationException;
import org.springframework.ldap.ServiceUnavailableException;
import org.springframework.ldap.SizeLimitExceededException;
import org.springframework.ldap.TimeLimitExceededException;
import org.springframework.ldap.UncategorizedLdapException;
import org.springframework.ldap.support.AttributeValueCallbackHandler;
import org.springframework.util.Assert;

public final class LdapUtils {
    private static final Log logger = LogFactory.getLog((Class)LdapUtils.class);

    private LdapUtils() {
    }

    public static void closeContext(DirContext context) {
        if (context != null) {
            try {
                context.close();
            }
            catch (NamingException ex) {
                logger.debug((Object)"Could not close JNDI DirContext", (Throwable)((Object)ex));
            }
            catch (Throwable ex) {
                logger.debug((Object)"Unexpected exception on closing JNDI DirContext", ex);
            }
        }
    }

    public static NamingException convertLdapException(javax.naming.NamingException ex) {
        Assert.notNull((Object)ex, (String)"NamingException must not be null");
        if (ex.getClass().equals(javax.naming.directory.AttributeInUseException.class)) {
            return new AttributeInUseException((javax.naming.directory.AttributeInUseException)ex);
        }
        if (ex.getClass().equals(javax.naming.directory.AttributeModificationException.class)) {
            return new AttributeModificationException((javax.naming.directory.AttributeModificationException)ex);
        }
        if (ex.getClass().equals(javax.naming.CannotProceedException.class)) {
            return new CannotProceedException((javax.naming.CannotProceedException)ex);
        }
        if (ex.getClass().equals(javax.naming.CommunicationException.class)) {
            return new CommunicationException((javax.naming.CommunicationException)ex);
        }
        if (ex.getClass().equals(javax.naming.ConfigurationException.class)) {
            return new ConfigurationException((javax.naming.ConfigurationException)ex);
        }
        if (ex.getClass().equals(javax.naming.ContextNotEmptyException.class)) {
            return new ContextNotEmptyException((javax.naming.ContextNotEmptyException)ex);
        }
        if (ex.getClass().equals(javax.naming.InsufficientResourcesException.class)) {
            return new InsufficientResourcesException((javax.naming.InsufficientResourcesException)ex);
        }
        if (ex.getClass().equals(javax.naming.InterruptedNamingException.class)) {
            return new InterruptedNamingException((javax.naming.InterruptedNamingException)ex);
        }
        if (ex.getClass().equals(javax.naming.directory.InvalidAttributeIdentifierException.class)) {
            return new InvalidAttributeIdentifierException((javax.naming.directory.InvalidAttributeIdentifierException)ex);
        }
        if (ex.getClass().equals(javax.naming.directory.InvalidAttributesException.class)) {
            return new InvalidAttributesException((javax.naming.directory.InvalidAttributesException)ex);
        }
        if (ex.getClass().equals(javax.naming.directory.InvalidAttributeValueException.class)) {
            return new InvalidAttributeValueException((javax.naming.directory.InvalidAttributeValueException)ex);
        }
        if (ex.getClass().equals(javax.naming.InvalidNameException.class)) {
            return new InvalidNameException((javax.naming.InvalidNameException)ex);
        }
        if (ex.getClass().equals(javax.naming.directory.InvalidSearchControlsException.class)) {
            return new InvalidSearchControlsException((javax.naming.directory.InvalidSearchControlsException)ex);
        }
        if (ex.getClass().equals(javax.naming.directory.InvalidSearchFilterException.class)) {
            return new InvalidSearchFilterException((javax.naming.directory.InvalidSearchFilterException)ex);
        }
        if (ex instanceof javax.naming.ldap.LdapReferralException) {
            return new LdapReferralException((javax.naming.ldap.LdapReferralException)ex);
        }
        if (ex.getClass().equals(javax.naming.SizeLimitExceededException.class)) {
            return new SizeLimitExceededException((javax.naming.SizeLimitExceededException)ex);
        }
        if (ex.getClass().equals(javax.naming.TimeLimitExceededException.class)) {
            return new TimeLimitExceededException((javax.naming.TimeLimitExceededException)ex);
        }
        if (ex.getClass().equals(javax.naming.LimitExceededException.class)) {
            return new LimitExceededException((javax.naming.LimitExceededException)ex);
        }
        if (ex.getClass().equals(javax.naming.LinkLoopException.class)) {
            return new LinkLoopException((javax.naming.LinkLoopException)ex);
        }
        if (ex.getClass().equals(javax.naming.MalformedLinkException.class)) {
            return new MalformedLinkException((javax.naming.MalformedLinkException)ex);
        }
        if (ex.getClass().equals(javax.naming.LinkException.class)) {
            return new LinkException((javax.naming.LinkException)ex);
        }
        if (ex.getClass().equals(javax.naming.NameAlreadyBoundException.class)) {
            return new NameAlreadyBoundException((javax.naming.NameAlreadyBoundException)ex);
        }
        if (ex.getClass().equals(javax.naming.NameNotFoundException.class)) {
            return new NameNotFoundException((javax.naming.NameNotFoundException)ex);
        }
        if (ex.getClass().equals(javax.naming.NoPermissionException.class)) {
            return new NoPermissionException((javax.naming.NoPermissionException)ex);
        }
        if (ex.getClass().equals(javax.naming.AuthenticationException.class)) {
            return new AuthenticationException((javax.naming.AuthenticationException)ex);
        }
        if (ex.getClass().equals(javax.naming.AuthenticationNotSupportedException.class)) {
            return new AuthenticationNotSupportedException((javax.naming.AuthenticationNotSupportedException)ex);
        }
        if (ex.getClass().equals(javax.naming.NoInitialContextException.class)) {
            return new NoInitialContextException((javax.naming.NoInitialContextException)ex);
        }
        if (ex.getClass().equals(javax.naming.directory.NoSuchAttributeException.class)) {
            return new NoSuchAttributeException((javax.naming.directory.NoSuchAttributeException)ex);
        }
        if (ex.getClass().equals(javax.naming.NotContextException.class)) {
            return new NotContextException((javax.naming.NotContextException)ex);
        }
        if (ex.getClass().equals(javax.naming.OperationNotSupportedException.class)) {
            return new OperationNotSupportedException((javax.naming.OperationNotSupportedException)ex);
        }
        if (ex.getClass().equals(javax.naming.PartialResultException.class)) {
            return new PartialResultException((javax.naming.PartialResultException)ex);
        }
        if (ex.getClass().equals(javax.naming.directory.SchemaViolationException.class)) {
            return new SchemaViolationException((javax.naming.directory.SchemaViolationException)ex);
        }
        if (ex.getClass().equals(javax.naming.ServiceUnavailableException.class)) {
            return new ServiceUnavailableException((javax.naming.ServiceUnavailableException)ex);
        }
        return new UncategorizedLdapException(ex);
    }

    public static Class getActualTargetClass(DirContext context) {
        if (context instanceof LdapContext) {
            return LdapContext.class;
        }
        return DirContext.class;
    }

    public static void collectAttributeValues(Attributes attributes, String name, Collection collection) {
        Assert.notNull((Object)attributes, (String)"Attributes must not be null");
        Attribute attribute = attributes.get(name);
        if (attribute == null) {
            throw new NoSuchAttributeException("No attribute with name '" + name + "'");
        }
        LdapUtils.iterateAttributeValues(attribute, new CollectingAttributeValueCallbackHandler(collection));
    }

    public static void iterateAttributeValues(Attribute attribute, AttributeValueCallbackHandler callbackHandler) {
        Assert.notNull((Object)attribute, (String)"Attribute must not be null");
        Assert.notNull((Object)callbackHandler, (String)"callbackHandler must not be null");
        for (int i = 0; i < attribute.size(); ++i) {
            try {
                callbackHandler.handleAttributeValue(attribute.getID(), attribute.get(i), i);
                continue;
            }
            catch (javax.naming.NamingException e) {
                throw LdapUtils.convertLdapException(e);
            }
        }
    }

    public static String convertCompositeNameToString(CompositeName compositeName) {
        if (compositeName.size() > 0) {
            return compositeName.get(0);
        }
        return "";
    }

    private static final class CollectingAttributeValueCallbackHandler
    implements AttributeValueCallbackHandler {
        private final Collection collection;

        public CollectingAttributeValueCallbackHandler(Collection collection) {
            Assert.notNull((Object)collection, (String)"Collection must not be null");
            this.collection = collection;
        }

        public final void handleAttributeValue(String attributeName, Object attributeValue, int index) {
            this.collection.add(attributeValue);
        }
    }
}

