/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.search.filter;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.search.SearchCriteria;
import com.jaspersoft.jasperserver.search.common.SearchAttributes;
import com.jaspersoft.jasperserver.search.filter.BaseSearchFilter;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class AccessTypeFilter
extends BaseSearchFilter {
    public void applyRestrictions(String type, ExecutionContext context, SearchCriteria criteria) {
        String accessFilter;
        SearchAttributes searchAttributes = this.getSearchAttributes(context);
        User user = null;
        if (context.getAttributes() != null) {
            for (Object o : context.getAttributes()) {
                if (!(o instanceof User)) continue;
                user = (User)o;
            }
        }
        if (user != null && searchAttributes != null && searchAttributes.getState() != null && (accessFilter = searchAttributes.getState().getCustomFiltersMap().get("accessTypeFilter")) != null && !accessFilter.equals("accessTypeFilter-all")) {
            String alias = criteria.getAlias("accessEvents", "ae");
            criteria.add((Criterion)Restrictions.eq((String)(alias + ".updating"), (Object)accessFilter.equals("accessTypeFilter-changedByMe")));
            String userAlias = criteria.getAlias(alias + ".user", "u");
            criteria.add((Criterion)Restrictions.eq((String)(userAlias + ".username"), (Object)user.getUsername()));
            String tenantId = user.getTenantId() == null ? "organizations" : user.getTenantId();
            String tenantAlias = criteria.getAlias(userAlias + ".tenant", "t");
            criteria.add((Criterion)Restrictions.eq((String)(tenantAlias + ".tenantId"), (Object)tenantId));
        }
    }
}

