package com.jaspersoft.jasperserver.rest.services;

import com.jaspersoft.jasperserver.remote.ServiceException;
import com.jaspersoft.jasperserver.remote.services.GetService;
import com.jaspersoft.jasperserver.rest.RESTAbstractService;
import com.jaspersoft.jasperserver.rest.RESTUtils;
import com.jaspersoft.jasperserver.ws.scheduling.Job;
import com.jaspersoft.jasperserver.ws.scheduling.JobSummary;
import com.jaspersoft.jasperserver.ws.xml.Marshaller;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Created by IntelliJ IDEA.
 * User: carbiv
 * Date: 7/22/11
 * Time: 3:18 PM
 * To change this template use File | Settings | File Templates.
 */
public class RESTJobSummery extends RESTAbstractService {
    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServiceException
    {
        // Get the uri of the resource
        String url = RESTUtils.extractRepositoryUri(req.getPathInfo());

        if ( url==null ){
            throw new ServiceException(ServiceException.RESOURCE_BAD_REQUEST, "could not identify job");
        }

        // get the resources....
        GetService service = new GetService(context);

        JobSummary[] summaries = service.getJobSummery( url );

        Marshaller m = new Marshaller();
        String xml = null; //m.writeResourceDescriptor(job);
        // send the xml...
        RESTUtils.setStatusAndBody(HttpServletResponse.SC_OK, resp, xml);

    }
}
