/*
 * Copyright (C) 2005 - 2011 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.jaspersoft.jasperserver.war.action.hyperlinks;

import java.util.Locale;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import net.sf.jasperreports.engine.JRHyperlink;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.export.JRHyperlinkProducer;
import net.sf.jasperreports.engine.type.HyperlinkTargetEnum;

import org.springframework.context.i18n.LocaleContextHolder;

import com.jaspersoft.jasperserver.api.engine.jasperreports.util.BaseReportExecutionHyperlinkProducerFactory;

/**
 * @author Lucian Chirita (lucianc@users.sourceforge.net)
 * @version $Id: ReportExecutionHyperlinkProducerFactory.java 20688 2011-07-26 15:40:14Z tdanciu $
 */
public class ReportExecutionHyperlinkProducerFactory extends BaseReportExecutionHyperlinkProducerFactory implements HyperlinkProducerFlowFactory {
	
	private static final long serialVersionUID = 1L;
	
	private String attributeReportLocale;
	private String urlParameterReportLocale;
	
	public JRHyperlinkProducer getHyperlinkProducer(HttpServletRequest request, HttpServletResponse response) {
		HyperlinkProducer hyperlinkProducer = new HyperlinkProducer(request, response);
		return hyperlinkProducer;
	}
	
	
	public class HyperlinkProducer extends BaseHyperlinkProducer {
		
		private final HttpServletResponse response;
		private final String contextPath;
		private final String flowExecutionKey;
		private final String reportUnit;
		private final Locale reportLocale;

		public HyperlinkProducer(final HttpServletRequest request, HttpServletResponse response) {
			this.response = response;
			flowExecutionKey = (String) request.getAttribute("flowExecutionKey");
			contextPath = request.getContextPath();
			reportUnit = (String) request.getAttribute(getUrlParameterReportUnit());
			reportLocale = (Locale) request.getAttribute(getAttributeReportLocale());
		}
		
		public String getHyperlink(JRPrintHyperlink hyperlink) {
			String uri = super.getHyperlink(hyperlink);
			return response.encodeURL(uri);
		}
		
		protected void appendSubflowParams(StringBuffer sb) {
			if (flowExecutionKey != null) {
				sb.append("&_eventId_drillReport=");
				sb.append("&_flowExecutionKey=");
				sb.append(encode(flowExecutionKey));
			}
		}

		protected void appendAdditionalParameters(JRPrintHyperlink hyperlink, StringBuffer sb) {
			if (hyperlink.getHyperlinkTargetValue() == HyperlinkTargetEnum.SELF) {
				appendSubflowParams(sb);
			}
			
			if (reportUnit != null && sb.indexOf(getUrlParameterReportUnit()) < 0) {
				appendParameter(sb, getUrlParameterReportUnit(), reportUnit);
			}
			
			if (reportLocale != null) {
				appendParameter(sb, getUrlParameterReportLocale(), reportLocale.toString());
			}
		}

		protected void appendHyperlinkStart(JRPrintHyperlink hyperlink, StringBuffer sb) {			
			sb.append(contextPath);
		}

		protected Locale getLocale() {
			return LocaleContextHolder.getLocale();
		}
	}

	public String getAttributeReportLocale() {
		return attributeReportLocale;
	}

	public void setAttributeReportLocale(String attributeReportLocale) {
		this.attributeReportLocale = attributeReportLocale;
	}

	public String getUrlParameterReportLocale() {
		return urlParameterReportLocale;
	}

	public void setUrlParameterReportLocale(String urlParameterReportLocale) {
		this.urlParameterReportLocale = urlParameterReportLocale;
	}

}
