/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.driver.xmla;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.olap4j.Axis;
import org.olap4j.Cell;
import org.olap4j.CellSet;
import org.olap4j.CellSetAxis;
import org.olap4j.CellSetAxisMetaData;
import org.olap4j.CellSetMetaData;
import org.olap4j.OlapException;
import org.olap4j.Position;
import org.olap4j.driver.xmla.MetadataReader;
import org.olap4j.driver.xmla.XmlaOlap4jCell;
import org.olap4j.driver.xmla.XmlaOlap4jCellProperty;
import org.olap4j.driver.xmla.XmlaOlap4jCellSetAxis;
import org.olap4j.driver.xmla.XmlaOlap4jCellSetAxisMetaData;
import org.olap4j.driver.xmla.XmlaOlap4jCellSetMemberProperty;
import org.olap4j.driver.xmla.XmlaOlap4jCellSetMetaData;
import org.olap4j.driver.xmla.XmlaOlap4jCube;
import org.olap4j.driver.xmla.XmlaOlap4jMember;
import org.olap4j.driver.xmla.XmlaOlap4jPosition;
import org.olap4j.driver.xmla.XmlaOlap4jPositionMember;
import org.olap4j.driver.xmla.XmlaOlap4jPreparedStatement;
import org.olap4j.driver.xmla.XmlaOlap4jStatement;
import org.olap4j.driver.xmla.XmlaOlap4jUtil;
import org.olap4j.impl.Olap4jUtil;
import org.olap4j.mdx.ParseTreeNode;
import org.olap4j.metadata.Dimension;
import org.olap4j.metadata.Hierarchy;
import org.olap4j.metadata.Level;
import org.olap4j.metadata.Member;
import org.olap4j.metadata.NamedList;
import org.olap4j.metadata.Property;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class XmlaOlap4jCellSet
implements CellSet {
    final XmlaOlap4jStatement olap4jStatement;
    protected boolean closed;
    private XmlaOlap4jCellSetMetaData metaData;
    private final Map<Integer, Cell> cellMap = new HashMap<Integer, Cell>();
    private final List<XmlaOlap4jCellSetAxis> axisList = new ArrayList<XmlaOlap4jCellSetAxis>();
    private final List<CellSetAxis> immutableAxisList = Olap4jUtil.cast(Collections.unmodifiableList(this.axisList));
    private XmlaOlap4jCellSetAxis filterAxis;
    private static final boolean DEBUG = false;
    private static final List<String> standardProperties = Arrays.asList("UName", "Caption", "LName", "LNum", "DisplayInfo");

    XmlaOlap4jCellSet(XmlaOlap4jStatement olap4jStatement) {
        assert (olap4jStatement != null);
        this.olap4jStatement = olap4jStatement;
        this.closed = false;
    }

    void populate() throws OlapException {
        Document doc;
        byte[] bytes = this.olap4jStatement.getBytes();
        try {
            doc = XmlaOlap4jUtil.parse(bytes);
        }
        catch (IOException e) {
            throw this.olap4jStatement.olap4jConnection.helper.createException("error creating CellSet", e);
        }
        catch (SAXException e) {
            throw this.olap4jStatement.olap4jConnection.helper.createException("error creating CellSet", e);
        }
        Element envelope = doc.getDocumentElement();
        assert (envelope.getLocalName().equals("Envelope"));
        assert (envelope.getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/envelope/"));
        Element body = XmlaOlap4jUtil.findChild(envelope, "http://schemas.xmlsoap.org/soap/envelope/", "Body");
        Element fault = XmlaOlap4jUtil.findChild(body, "http://schemas.xmlsoap.org/soap/envelope/", "Fault");
        if (fault != null) {
            Element faultstring = XmlaOlap4jUtil.findChild(fault, null, "faultstring");
            String message = faultstring.getTextContent();
            throw this.olap4jStatement.olap4jConnection.helper.createException("XMLA provider gave exception: " + message);
        }
        Element executeResponse = XmlaOlap4jUtil.findChild(body, "urn:schemas-microsoft-com:xml-analysis", "ExecuteResponse");
        Element returnElement = XmlaOlap4jUtil.findChild(executeResponse, "urn:schemas-microsoft-com:xml-analysis", "return");
        Element root = XmlaOlap4jUtil.findChild(returnElement, "urn:schemas-microsoft-com:xml-analysis:mddataset", "root");
        this.metaData = this.olap4jStatement instanceof XmlaOlap4jPreparedStatement ? ((XmlaOlap4jPreparedStatement)this.olap4jStatement).cellSetMetaData : this.createMetaData(root);
        Element axesNode = XmlaOlap4jUtil.findChild(root, "urn:schemas-microsoft-com:xml-analysis:mddataset", "Axes");
        for (Element axisNode : XmlaOlap4jUtil.findChildren(axesNode, "urn:schemas-microsoft-com:xml-analysis:mddataset", "Axis")) {
            String axisName = axisNode.getAttribute("name");
            Axis axis = this.lookupAxis(axisName);
            XmlaOlap4jCellSetAxis cellSetAxis = new XmlaOlap4jCellSetAxis(this, axis);
            switch (axis) {
                case FILTER: {
                    this.filterAxis = cellSetAxis;
                    break;
                }
                default: {
                    this.axisList.add(cellSetAxis);
                }
            }
            Element tuplesNode = XmlaOlap4jUtil.findChild(axisNode, "urn:schemas-microsoft-com:xml-analysis:mddataset", "Tuples");
            int ordinal = 0;
            HashMap<Property, String> propertyValues = new HashMap<Property, String>();
            MetadataReader metadataReader = this.metaData.cube.getMetadataReader();
            HashMap<String, XmlaOlap4jMember> memberMap = new HashMap<String, XmlaOlap4jMember>();
            ArrayList<String> uniqueNames = new ArrayList<String>();
            for (Element tupleNode : XmlaOlap4jUtil.findChildren(tuplesNode, "urn:schemas-microsoft-com:xml-analysis:mddataset", "Tuple")) {
                for (Element memberNode : XmlaOlap4jUtil.findChildren(tupleNode, "urn:schemas-microsoft-com:xml-analysis:mddataset", "Member")) {
                    String uname = XmlaOlap4jUtil.stringElement(memberNode, "UName");
                    uniqueNames.add(uname);
                }
            }
            metadataReader.lookupMembersByUniqueName(uniqueNames, memberMap);
            for (Element tupleNode : XmlaOlap4jUtil.findChildren(tuplesNode, "urn:schemas-microsoft-com:xml-analysis:mddataset", "Tuple")) {
                ArrayList<Member> members = new ArrayList<Member>();
                for (Element memberNode : XmlaOlap4jUtil.findChildren(tupleNode, "urn:schemas-microsoft-com:xml-analysis:mddataset", "Member")) {
                    String hierarchyName = memberNode.getAttribute("Hierarchy");
                    String uname = XmlaOlap4jUtil.stringElement(memberNode, "UName");
                    Member member = (Member)memberMap.get(uname);
                    if (member == null) {
                        String caption = XmlaOlap4jUtil.stringElement(memberNode, "Caption");
                        int lnum = XmlaOlap4jUtil.integerElement(memberNode, "LNum");
                        Hierarchy hierarchy = this.lookupHierarchy(this.metaData.cube, hierarchyName);
                        Level level = (Level)hierarchy.getLevels().get(lnum);
                        member = new XmlaOlap4jSurpriseMember(level, hierarchy, lnum, caption, uname);
                    }
                    propertyValues.clear();
                    for (Element childNode : XmlaOlap4jUtil.childElements(memberNode)) {
                        XmlaOlap4jCellSetMemberProperty property = ((XmlaOlap4jCellSetAxisMetaData)cellSetAxis.getAxisMetaData()).lookupProperty(hierarchyName, childNode.getLocalName());
                        if (property == null) continue;
                        String value = childNode.getTextContent();
                        propertyValues.put(property, value);
                    }
                    if (!propertyValues.isEmpty()) {
                        member = new XmlaOlap4jPositionMember(member, propertyValues);
                    }
                    members.add(member);
                }
                cellSetAxis.positions.add(new XmlaOlap4jPosition(members, ordinal++));
            }
        }
        HashMap<Property, Object> propertyValues = new HashMap<Property, Object>();
        Element cellDataNode = XmlaOlap4jUtil.findChild(root, "urn:schemas-microsoft-com:xml-analysis:mddataset", "CellData");
        for (Element cell : XmlaOlap4jUtil.findChildren(cellDataNode, "urn:schemas-microsoft-com:xml-analysis:mddataset", "Cell")) {
            propertyValues.clear();
            int cellOrdinal = Integer.valueOf(cell.getAttribute("CellOrdinal"));
            Object value = this.getTypedValue(cell);
            String formattedValue = XmlaOlap4jUtil.stringElement(cell, "FmtValue");
            String formatString = XmlaOlap4jUtil.stringElement(cell, "FormatString");
            Olap4jUtil.discard(formatString);
            for (Element element : XmlaOlap4jUtil.childElements(cell)) {
                String tag = element.getLocalName();
                Property property = this.metaData.propertiesByTag.get(tag);
                if (property == null) continue;
                propertyValues.put(property, element.getTextContent());
            }
            this.cellMap.put(cellOrdinal, new XmlaOlap4jCell(this, cellOrdinal, value, formattedValue, propertyValues));
        }
    }

    private Object getTypedValue(Element cell) throws OlapException {
        Element elm = XmlaOlap4jUtil.findChild(cell, "urn:schemas-microsoft-com:xml-analysis:mddataset", "Value");
        if (elm == null) {
            return null;
        }
        String type = elm.getAttribute("xsi:type");
        try {
            if (type.equals("xsd:int")) {
                return XmlaOlap4jUtil.intElement(cell, "Value");
            }
            if (type.equals("xsd:integer")) {
                return XmlaOlap4jUtil.integerElement(cell, "Value");
            }
            if (type.equals("xsd:double")) {
                return XmlaOlap4jUtil.doubleElement(cell, "Value");
            }
            if (type.equals("xsd:float")) {
                return XmlaOlap4jUtil.floatElement(cell, "Value");
            }
            if (type.equals("xsd:long")) {
                return XmlaOlap4jUtil.longElement(cell, "Value");
            }
            if (type.equals("xsd:boolean")) {
                return XmlaOlap4jUtil.booleanElement(cell, "Value");
            }
            return XmlaOlap4jUtil.stringElement(cell, "Value");
        }
        catch (Exception e) {
            throw new OlapException("Error while casting a cell value to the correct java type for its XSD type " + type, e);
        }
    }

    private XmlaOlap4jCellSetMetaData createMetaData(Element root) throws OlapException {
        Element olapInfo = XmlaOlap4jUtil.findChild(root, "urn:schemas-microsoft-com:xml-analysis:mddataset", "OlapInfo");
        Element cubeInfo = XmlaOlap4jUtil.findChild(olapInfo, "urn:schemas-microsoft-com:xml-analysis:mddataset", "CubeInfo");
        Element cubeNode = XmlaOlap4jUtil.findChild(cubeInfo, "urn:schemas-microsoft-com:xml-analysis:mddataset", "Cube");
        Element cubeNameNode = XmlaOlap4jUtil.findChild(cubeNode, "urn:schemas-microsoft-com:xml-analysis:mddataset", "CubeName");
        String cubeName = XmlaOlap4jUtil.gatherText(cubeNameNode);
        XmlaOlap4jCube cube = this.olap4jStatement.olap4jConnection.olap4jSchema.cubes.get(cubeName);
        if (cube == null) {
            throw this.olap4jStatement.olap4jConnection.helper.createException("Internal error: cube '" + cubeName + "' not found");
        }
        Element axesInfo = XmlaOlap4jUtil.findChild(olapInfo, "urn:schemas-microsoft-com:xml-analysis:mddataset", "AxesInfo");
        List<Element> axisInfos = XmlaOlap4jUtil.findChildren(axesInfo, "urn:schemas-microsoft-com:xml-analysis:mddataset", "AxisInfo");
        ArrayList<CellSetAxisMetaData> axisMetaDataList = new ArrayList<CellSetAxisMetaData>();
        XmlaOlap4jCellSetAxisMetaData filterAxisMetaData = null;
        block3: for (Element axisInfo : axisInfos) {
            String axisName = axisInfo.getAttribute("name");
            Axis axis = this.lookupAxis(axisName);
            List<Element> hierarchyInfos = XmlaOlap4jUtil.findChildren(axisInfo, "urn:schemas-microsoft-com:xml-analysis:mddataset", "HierarchyInfo");
            ArrayList<Hierarchy> hierarchyList = new ArrayList<Hierarchy>();
            ArrayList<XmlaOlap4jCellSetMemberProperty> propertyList = new ArrayList<XmlaOlap4jCellSetMemberProperty>();
            for (Element hierarchyInfo : hierarchyInfos) {
                String hierarchyName = hierarchyInfo.getAttribute("name");
                Hierarchy hierarchy = this.lookupHierarchy(cube, hierarchyName);
                hierarchyList.add(hierarchy);
                for (Element childNode : XmlaOlap4jUtil.childElements(hierarchyInfo)) {
                    String tag = childNode.getLocalName();
                    if (standardProperties.contains(tag)) continue;
                    String propertyUniqueName = childNode.getAttribute("name");
                    XmlaOlap4jCellSetMemberProperty property = new XmlaOlap4jCellSetMemberProperty(propertyUniqueName, hierarchy, tag);
                    propertyList.add(property);
                }
            }
            XmlaOlap4jCellSetAxisMetaData axisMetaData = new XmlaOlap4jCellSetAxisMetaData(this.olap4jStatement.olap4jConnection, axis, hierarchyList, propertyList);
            switch (axis) {
                case FILTER: {
                    filterAxisMetaData = axisMetaData;
                    continue block3;
                }
            }
            axisMetaDataList.add(axisMetaData);
        }
        Element cellInfo = XmlaOlap4jUtil.findChild(olapInfo, "urn:schemas-microsoft-com:xml-analysis:mddataset", "CellInfo");
        ArrayList<XmlaOlap4jCellProperty> cellProperties = new ArrayList<XmlaOlap4jCellProperty>();
        for (Element element : XmlaOlap4jUtil.childElements(cellInfo)) {
            cellProperties.add(new XmlaOlap4jCellProperty(element.getLocalName(), element.getAttribute("name")));
        }
        return new XmlaOlap4jCellSetMetaData(this.olap4jStatement, cube, filterAxisMetaData, axisMetaDataList, cellProperties);
    }

    private Hierarchy lookupHierarchy(XmlaOlap4jCube cube, String hierarchyName) throws OlapException {
        Hierarchy hierarchy = cube.getHierarchies().get(hierarchyName);
        if (hierarchy == null) {
            for (Hierarchy hierarchy1 : cube.getHierarchies()) {
                if (!hierarchy1.getUniqueName().equals(hierarchyName)) continue;
                hierarchy = hierarchy1;
                break;
            }
            if (hierarchy == null) {
                throw this.olap4jStatement.olap4jConnection.helper.createException("Internal error: hierarchy '" + hierarchyName + "' not found in cube '" + cube.getName() + "'");
            }
        }
        return hierarchy;
    }

    private Axis lookupAxis(String axisName) {
        if (axisName.startsWith("Axis")) {
            Integer ordinal = Integer.valueOf(axisName.substring("Axis".length()));
            return Axis.values()[Axis.COLUMNS.ordinal() + ordinal];
        }
        return Axis.FILTER;
    }

    @Override
    public CellSetMetaData getMetaData() {
        return this.metaData;
    }

    @Override
    public Cell getCell(List<Integer> coordinates) {
        return this.getCellInternal(this.coordinatesToOrdinal(coordinates));
    }

    @Override
    public Cell getCell(int ordinal) {
        return this.getCellInternal(ordinal);
    }

    @Override
    public Cell getCell(Position ... positions) {
        if (positions.length != this.getAxes().size()) {
            throw new IllegalArgumentException("cell coordinates should have dimension " + this.getAxes().size());
        }
        ArrayList<Integer> coords = new ArrayList<Integer>(positions.length);
        for (Position position : positions) {
            coords.add(position.getOrdinal());
        }
        return this.getCell(coords);
    }

    private Cell getCellInternal(int pos) {
        Cell cell = this.cellMap.get(pos);
        if (cell == null) {
            if (pos < 0 || pos >= this.maxOrdinal()) {
                throw new IndexOutOfBoundsException();
            }
            return new XmlaOlap4jCell(this, pos, null, "", Collections.<Property, Object>emptyMap());
        }
        return cell;
    }

    private String getBoundsAsString() {
        StringBuilder buf = new StringBuilder();
        int k = 0;
        for (CellSetAxis axis : this.getAxes()) {
            if (k++ > 0) {
                buf.append(", ");
            }
            buf.append(axis.getPositionCount());
        }
        return buf.toString();
    }

    @Override
    public List<CellSetAxis> getAxes() {
        return this.immutableAxisList;
    }

    @Override
    public CellSetAxis getFilterAxis() {
        return this.filterAxis;
    }

    private int maxOrdinal() {
        int modulo = 1;
        for (XmlaOlap4jCellSetAxis axis : this.axisList) {
            modulo *= axis.getPositionCount();
        }
        return modulo;
    }

    @Override
    public List<Integer> ordinalToCoordinates(int ordinal) {
        List<CellSetAxis> axes = this.getAxes();
        ArrayList<Integer> list = new ArrayList<Integer>(axes.size());
        int modulo = 1;
        for (CellSetAxis axis : axes) {
            int prevModulo = modulo;
            list.add(ordinal % (modulo *= axis.getPositionCount()) / prevModulo);
        }
        if (ordinal < 0 || ordinal >= modulo) {
            throw new IndexOutOfBoundsException("Cell ordinal " + ordinal + ") lies outside CellSet bounds (" + this.getBoundsAsString() + ")");
        }
        return list;
    }

    @Override
    public int coordinatesToOrdinal(List<Integer> coordinates) {
        List<CellSetAxis> axes = this.getAxes();
        if (coordinates.size() != axes.size()) {
            throw new IllegalArgumentException("Coordinates have different dimension " + coordinates.size() + " than axes " + axes.size());
        }
        int modulo = 1;
        int ordinal = 0;
        int k = 0;
        for (CellSetAxis axis : axes) {
            Integer coordinate;
            if ((coordinate = coordinates.get(k++)) < 0 || coordinate >= axis.getPositionCount()) {
                throw new IndexOutOfBoundsException("Coordinate " + coordinate + " of axis " + k + " is out of range (" + this.getBoundsAsString() + ")");
            }
            ordinal += coordinate * modulo;
            modulo *= axis.getPositionCount();
        }
        return ordinal;
    }

    @Override
    public boolean next() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws SQLException {
        this.closed = true;
    }

    @Override
    public boolean wasNull() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clearWarnings() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getCursorName() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isFirst() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isLast() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void beforeFirst() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void afterLast() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean first() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean last() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean previous() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getFetchDirection() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getFetchSize() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getType() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getConcurrency() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void insertRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement getStatement() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class XmlaOlap4jSurpriseMember
    implements Member {
        private final Level level;
        private final Hierarchy hierarchy;
        private final int lnum;
        private final String caption;
        private final String uname;

        XmlaOlap4jSurpriseMember(Level level, Hierarchy hierarchy, int lnum, String caption, String uname) {
            this.level = level;
            this.hierarchy = hierarchy;
            this.lnum = lnum;
            this.caption = caption;
            this.uname = uname;
        }

        @Override
        public NamedList<? extends Member> getChildMembers() {
            return Olap4jUtil.emptyNamedList();
        }

        @Override
        public int getChildMemberCount() {
            return 0;
        }

        @Override
        public Member getParentMember() {
            return null;
        }

        @Override
        public Level getLevel() {
            return this.level;
        }

        @Override
        public Hierarchy getHierarchy() {
            return this.hierarchy;
        }

        @Override
        public Dimension getDimension() {
            return this.hierarchy.getDimension();
        }

        @Override
        public Member.Type getMemberType() {
            return Member.Type.UNKNOWN;
        }

        @Override
        public boolean isAll() {
            return false;
        }

        @Override
        public boolean isChildOrEqualTo(Member member) {
            return false;
        }

        @Override
        public boolean isCalculated() {
            return false;
        }

        @Override
        public int getSolveOrder() {
            return 0;
        }

        @Override
        public ParseTreeNode getExpression() {
            return null;
        }

        @Override
        public List<Member> getAncestorMembers() {
            return Collections.emptyList();
        }

        @Override
        public boolean isCalculatedInQuery() {
            return true;
        }

        @Override
        public Object getPropertyValue(Property property) {
            return null;
        }

        @Override
        public String getPropertyFormattedValue(Property property) {
            return null;
        }

        @Override
        public void setProperty(Property property, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public NamedList<Property> getProperties() {
            return Olap4jUtil.emptyNamedList();
        }

        @Override
        public int getOrdinal() {
            return -1;
        }

        @Override
        public boolean isHidden() {
            return false;
        }

        @Override
        public int getDepth() {
            return this.lnum;
        }

        @Override
        public Member getDataMember() {
            return null;
        }

        @Override
        public String getName() {
            return this.caption;
        }

        @Override
        public String getUniqueName() {
            return this.uname;
        }

        @Override
        public String getCaption(Locale locale) {
            return this.caption;
        }

        @Override
        public String getDescription(Locale locale) {
            return null;
        }
    }
}

