/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.driver.xmla;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class XmlaOlap4jUtil {
    static final String LINE_SEP = System.getProperty("line.separator", "\n");
    static final String SOAP_PREFIX = "SOAP-ENV";
    static final String SOAP_NS = "http://schemas.xmlsoap.org/soap/envelope/";
    static final String XMLA_PREFIX = "xmla";
    static final String XMLA_NS = "urn:schemas-microsoft-com:xml-analysis";
    static final String MDDATASET_NS = "urn:schemas-microsoft-com:xml-analysis:mddataset";
    static final String ROWSET_NS = "urn:schemas-microsoft-com:xml-analysis:rowset";
    static final String XSD_PREFIX = "xsd";
    static final String XMLNS = "xmlns";
    static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    static final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    static final String FULL_SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    static final String DEFER_NODE_EXPANSION = "http://apache.org/xml/features/dom/defer-node-expansion";
    static final String SCHEMA_LOCATION = "http://apache.org/xml/properties/schema/external-schemaLocation";

    XmlaOlap4jUtil() {
    }

    static Document parse(byte[] in) throws SAXException, IOException {
        InputSource source = new InputSource(new ByteArrayInputStream(in));
        DOMParser parser = XmlaOlap4jUtil.getParser(null, null, false);
        try {
            parser.parse(source);
            XmlaOlap4jUtil.checkForParseError(parser);
        }
        catch (SAXParseException ex) {
            XmlaOlap4jUtil.checkForParseError(parser, ex);
        }
        return parser.getDocument();
    }

    static DOMParser getParser(String schemaLocationPropertyValue, EntityResolver entityResolver, boolean validate) throws SAXNotRecognizedException, SAXNotSupportedException {
        boolean doingValidation = validate || schemaLocationPropertyValue != null;
        DOMParser parser = new DOMParser();
        parser.setEntityResolver(entityResolver);
        parser.setErrorHandler((ErrorHandler)new SAXErrorHandler());
        parser.setFeature(DEFER_NODE_EXPANSION, false);
        parser.setFeature(NAMESPACES_FEATURE_ID, true);
        parser.setFeature(SCHEMA_VALIDATION_FEATURE_ID, doingValidation);
        parser.setFeature(VALIDATION_FEATURE_ID, doingValidation);
        if (schemaLocationPropertyValue != null) {
            parser.setProperty(SCHEMA_LOCATION, (Object)schemaLocationPropertyValue.replace('\\', '/'));
        }
        return parser;
    }

    static void checkForParseError(DOMParser parser, Throwable t) {
        ErrorHandler errorHandler = parser.getErrorHandler();
        if (errorHandler instanceof SAXErrorHandler) {
            SAXErrorHandler saxEH = (SAXErrorHandler)errorHandler;
            List<SAXErrorHandler.ErrorInfo> errors = saxEH.getErrors();
            if (errors != null && errors.size() > 0) {
                String errorStr = SAXErrorHandler.formatErrorInfos(saxEH);
                throw new RuntimeException(errorStr, t);
            }
        } else {
            System.out.println("errorHandler=" + errorHandler);
        }
    }

    static void checkForParseError(DOMParser parser) {
        XmlaOlap4jUtil.checkForParseError(parser, null);
    }

    static List<Node> listOf(final NodeList nodeList) {
        return new AbstractList<Node>(){

            @Override
            public Node get(int index) {
                return nodeList.item(index);
            }

            @Override
            public int size() {
                return nodeList.getLength();
            }
        };
    }

    static String gatherText(Element element) {
        StringBuilder buf = new StringBuilder();
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            buf.append(childNodes.item(i).getTextContent());
        }
        return buf.toString();
    }

    static Element findChild(Element element, String ns, String tag) {
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Element child;
            if (!(childNodes.item(i) instanceof Element) || !(child = (Element)childNodes.item(i)).getLocalName().equals(tag) || ns != null && !child.getNamespaceURI().equals(ns)) continue;
            return child;
        }
        return null;
    }

    static String stringElement(Element row, String name) {
        NodeList childNodes = row.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (!name.equals(node.getLocalName())) continue;
            return node.getTextContent();
        }
        return null;
    }

    static Integer integerElement(Element row, String name) {
        return Integer.valueOf(XmlaOlap4jUtil.stringElement(row, name));
    }

    static int intElement(Element row, String name) {
        return XmlaOlap4jUtil.integerElement(row, name);
    }

    static Double doubleElement(Element row, String name) {
        return Double.valueOf(XmlaOlap4jUtil.stringElement(row, name));
    }

    static boolean booleanElement(Element row, String name) {
        return "true".equals(XmlaOlap4jUtil.stringElement(row, name));
    }

    static Float floatElement(Element row, String name) {
        return Float.valueOf(XmlaOlap4jUtil.stringElement(row, name));
    }

    static long longElement(Element row, String name) {
        return Long.valueOf(XmlaOlap4jUtil.stringElement(row, name));
    }

    static List<Element> childElements(Element memberNode) {
        ArrayList<Element> list = new ArrayList<Element>();
        NodeList childNodes = memberNode.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (!(childNode instanceof Element)) continue;
            list.add((Element)childNode);
        }
        return list;
    }

    static List<Element> findChildren(Element element, String ns, String tag) {
        ArrayList<Element> list = new ArrayList<Element>();
        for (Node node : XmlaOlap4jUtil.listOf(element.getChildNodes())) {
            if (!tag.equals(node.getLocalName()) || ns != null && !node.getNamespaceURI().equals(ns)) continue;
            list.add((Element)node);
        }
        return list;
    }

    public static String toString(Node node, boolean prettyPrint) {
        if (node == null) {
            return null;
        }
        try {
            Document doc = node.getOwnerDocument();
            OutputFormat format = doc != null ? new OutputFormat(doc, null, prettyPrint) : new OutputFormat("xml", null, prettyPrint);
            if (prettyPrint) {
                format.setLineSeparator(LINE_SEP);
            } else {
                format.setLineSeparator("");
            }
            StringWriter writer = new StringWriter(1000);
            XMLSerializer serial = new XMLSerializer((Writer)writer, format);
            serial.asDOMSerializer();
            if (node instanceof Document) {
                serial.serialize((Document)node);
            } else if (node instanceof Element) {
                format.setOmitXMLDeclaration(true);
                serial.serialize((Element)node);
            } else if (node instanceof DocumentFragment) {
                format.setOmitXMLDeclaration(true);
                serial.serialize((DocumentFragment)node);
            } else {
                if (node instanceof Text) {
                    Text text = (Text)node;
                    return text.getData();
                }
                if (node instanceof Attr) {
                    Attr attr = (Attr)node;
                    String name = attr.getName();
                    String value = attr.getValue();
                    writer.write(name);
                    writer.write("=\"");
                    writer.write(value);
                    writer.write("\"");
                    if (prettyPrint) {
                        writer.write(LINE_SEP);
                    }
                } else {
                    writer.write("node class = " + node.getClass().getName());
                    if (prettyPrint) {
                        writer.write(LINE_SEP);
                    } else {
                        writer.write(32);
                    }
                    writer.write("XmlUtil.toString: fix me: ");
                    writer.write(node.toString());
                    if (prettyPrint) {
                        writer.write(LINE_SEP);
                    }
                }
            }
            return writer.toString();
        }
        catch (Exception ex) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SAXErrorHandler
    implements ErrorHandler {
        public static final String WARNING_STRING = "WARNING";
        public static final String ERROR_STRING = "ERROR";
        public static final String FATAL_ERROR_STRING = "FATAL";
        public static final short SEVERITY_WARNING = 1;
        public static final short SEVERITY_ERROR = 2;
        public static final short SEVERITY_FATAL_ERROR = 3;
        private List<ErrorInfo> errors;

        public void printErrorInfos(PrintStream out) {
            if (this.errors != null) {
                for (ErrorInfo error : this.errors) {
                    out.println(SAXErrorHandler.formatErrorInfo(error));
                }
            }
        }

        public static String formatErrorInfos(SAXErrorHandler saxEH) {
            if (!saxEH.hasErrors()) {
                return "";
            }
            StringBuilder buf = new StringBuilder(512);
            for (ErrorInfo error : saxEH.getErrors()) {
                buf.append(SAXErrorHandler.formatErrorInfo(error));
                buf.append(LINE_SEP);
            }
            return buf.toString();
        }

        public static String formatErrorInfo(ErrorInfo ei) {
            StringBuilder buf = new StringBuilder(128);
            buf.append("[");
            switch (ei.severity) {
                case 1: {
                    buf.append(WARNING_STRING);
                    break;
                }
                case 2: {
                    buf.append(ERROR_STRING);
                    break;
                }
                case 3: {
                    buf.append(FATAL_ERROR_STRING);
                }
            }
            buf.append(']');
            String systemId = ei.exception.getSystemId();
            if (systemId != null) {
                int index = systemId.lastIndexOf(47);
                if (index != -1) {
                    systemId = systemId.substring(index + 1);
                }
                buf.append(systemId);
            }
            buf.append(':');
            buf.append(ei.exception.getLineNumber());
            buf.append(':');
            buf.append(ei.exception.getColumnNumber());
            buf.append(": ");
            buf.append(ei.exception.getMessage());
            return buf.toString();
        }

        public List<ErrorInfo> getErrors() {
            return this.errors;
        }

        public boolean hasErrors() {
            return this.errors != null;
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            this.addError(new ErrorInfo(1, exception));
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            this.addError(new ErrorInfo(2, exception));
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            this.addError(new ErrorInfo(3, exception));
        }

        protected void addError(ErrorInfo ei) {
            if (this.errors == null) {
                this.errors = new ArrayList<ErrorInfo>();
            }
            this.errors.add(ei);
        }

        public String getFirstError() {
            return this.hasErrors() ? SAXErrorHandler.formatErrorInfo(this.errors.get(0)) : "";
        }

        public static class ErrorInfo {
            public SAXParseException exception;
            public short severity;

            ErrorInfo(short severity, SAXParseException exception) {
                this.severity = severity;
                this.exception = exception;
            }
        }
    }
}

