/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.Options;
import org.apache.jasper.compiler.BeanRepository;
import org.apache.jasper.compiler.Collector;
import org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.jasper.compiler.Generator;
import org.apache.jasper.compiler.Node;
import org.apache.jasper.compiler.PageInfo;
import org.apache.jasper.compiler.ParserController;
import org.apache.jasper.compiler.ScriptingVariabler;
import org.apache.jasper.compiler.ServletWriter;
import org.apache.jasper.compiler.Validator;
import org.apache.jasper.runtime.HttpJspBase;
import org.apache.jasper.runtime.JspRuntimeLibrary;
import org.apache.jasper.servlet.JspServletWrapper;
import org.apache.jasper.util.SystemLogHandler;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.PatternSet;

public class Compiler {
    static Object javacLock;
    protected JspCompilationContext ctxt;
    private ErrorDispatcher errDispatcher;
    private PageInfo pageInfo;
    private JspServletWrapper jsw;
    private JasperAntLogger logger;
    protected Project project = null;
    protected Options options;
    protected Node.Nodes pageNodes;

    public Compiler(JspCompilationContext ctxt) {
        this(ctxt, null);
    }

    public Compiler(JspCompilationContext ctxt, JspServletWrapper jsw) {
        this.jsw = jsw;
        this.ctxt = ctxt;
        this.options = ctxt.getOptions();
    }

    private Project getProject() {
        if (this.project != null) {
            return this.project;
        }
        this.project = new Project();
        this.logger = new JasperAntLogger();
        this.logger.setOutputPrintStream(System.out);
        this.logger.setErrorPrintStream(System.err);
        if (Constants.jasperLog.getVerbosityLevel() >= 4) {
            this.logger.setMessageOutputLevel(3);
        } else {
            this.logger.setMessageOutputLevel(2);
        }
        this.project.addBuildListener((BuildListener)this.logger);
        if (System.getProperty("catalina.home") != null) {
            this.project.setBasedir(System.getProperty("catalina.home"));
        }
        if (this.options.getCompiler() != null) {
            Constants.jasperLog.log("Compiler " + this.options.getCompiler(), 3);
            this.project.setProperty("build.compiler", this.options.getCompiler());
        }
        this.project.init();
        return this.project;
    }

    public void generateJava() throws FileNotFoundException, JasperException, Exception {
        if (this.errDispatcher == null) {
            this.errDispatcher = new ErrorDispatcher();
        }
        this.pageInfo = new PageInfo(new BeanRepository(this.ctxt.getClassLoader()));
        String javaFileName = this.ctxt.getServletJavaFileName();
        String javaEncoding = this.ctxt.getOptions().getJavaEncoding();
        OutputStreamWriter osw = null;
        try {
            osw = new OutputStreamWriter((OutputStream)new FileOutputStream(javaFileName), javaEncoding);
        }
        catch (UnsupportedEncodingException ex) {
            this.errDispatcher.jspError("jsp.error.needAlternateJavaEncoding", javaEncoding);
        }
        ServletWriter writer = new ServletWriter(new PrintWriter(osw));
        this.ctxt.setWriter(writer);
        ParserController parserCtl = new ParserController(this.ctxt, this);
        this.pageNodes = parserCtl.parse(this.ctxt.getJspFile());
        Validator.validate(this, this.pageNodes);
        Collector.collect(this, this.pageNodes);
        ScriptingVariabler.set(this.pageNodes);
        Generator.generate(writer, this, this.pageNodes);
        writer.close();
        this.ctxt.setWriter(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateClass() throws FileNotFoundException, JasperException, Exception {
        BuildException error;
        boolean success;
        StringBuffer errorReport;
        StringBuffer info;
        String javaFileName;
        block13: {
            if (this.errDispatcher == null) {
                this.errDispatcher = new ErrorDispatcher();
            }
            String javaEncoding = this.ctxt.getOptions().getJavaEncoding();
            javaFileName = this.ctxt.getServletJavaFileName();
            String classpath = this.ctxt.getClassPath();
            info = new StringBuffer();
            info.append("Compile: javaFileName=" + javaFileName + "\n");
            info.append("    classpath=" + classpath + "\n");
            String sep = System.getProperty("path.separator");
            errorReport = new StringBuffer();
            success = true;
            SystemLogHandler.setThread();
            this.getProject();
            Javac javac = (Javac)this.project.createTask("javac");
            Path path = new Path(this.project);
            path.setPath(System.getProperty("java.class.path"));
            StringTokenizer tokenizer = new StringTokenizer(classpath, sep);
            while (tokenizer.hasMoreElements()) {
                String pathElement = JspRuntimeLibrary.decode((String)tokenizer.nextToken());
                File repository = new File(pathElement);
                path.setLocation(repository);
                info.append("     cp=" + repository + "\n");
            }
            Path srcPath = new Path(this.project);
            srcPath.setLocation(this.options.getScratchDir());
            info.append("     work dir=" + this.options.getScratchDir() + "\n");
            javac.setEncoding(javaEncoding);
            javac.setClasspath(path);
            javac.setDebug(this.ctxt.getOptions().getClassDebugInfo());
            javac.setSrcdir(srcPath);
            javac.setTempdir(this.options.getScratchDir());
            javac.setOptimize(!this.ctxt.getOptions().getClassDebugInfo());
            javac.setFork(this.ctxt.getOptions().getFork());
            info.append("    srcDir=" + srcPath + "\n");
            if (this.options.getCompiler() != null) {
                javac.setCompiler(this.options.getCompiler());
                info.append("    compiler=" + this.options.getCompiler() + "\n");
            }
            PatternSet.NameEntry includes = javac.createInclude();
            includes.setName(this.ctxt.getJspPath());
            info.append("    include=" + this.ctxt.getJspPath() + "\n");
            error = null;
            try {
                if (this.ctxt.getOptions().getFork()) {
                    javac.execute();
                    break block13;
                }
                Object object = javacLock;
                synchronized (object) {
                    javac.execute();
                }
            }
            catch (BuildException e) {
                success = false;
                error = e;
                info.append("Exception compiling " + e.toString() + "\n");
            }
        }
        errorReport.append(this.logger.getReport());
        String errorCapture = SystemLogHandler.unsetThread();
        if (errorCapture != null) {
            errorReport.append(System.getProperty("line.separator"));
            errorReport.append(errorCapture);
        }
        if (!this.ctxt.keepGenerated()) {
            File javaFile = new File(javaFileName);
            javaFile.delete();
        }
        if (!success) {
            Constants.jasperLog.log("Error compiling file: " + javaFileName + " " + errorReport, 1);
            Constants.jasperLog.log("Info: " + info.toString(), 1);
            if (error != null) {
                Constants.jasperLog.log("Exception: ", (Throwable)error);
                error.printStackTrace();
            }
            this.errDispatcher.javacError(errorReport.toString(), javaFileName, this.pageNodes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compile() throws FileNotFoundException, JasperException, Exception {
        try {
            this.generateJava();
            this.generateClass();
            Object var2_1 = null;
            this.errDispatcher = null;
            this.logger = null;
            this.project = null;
            this.pageInfo = null;
            this.pageNodes = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.errDispatcher = null;
            this.logger = null;
            this.project = null;
            this.pageInfo = null;
            this.pageNodes = null;
            throw throwable;
        }
    }

    public boolean isOutDated() {
        return this.isOutDated(true);
    }

    public boolean isOutDated(boolean checkClass) {
        String jsp = this.ctxt.getJspFile();
        long jspRealLastModified = 0L;
        try {
            URL jspUrl = this.ctxt.getResource(jsp);
            if (jspUrl == null) {
                this.ctxt.incrementRemoved();
                return false;
            }
            URLConnection conn = jspUrl.openConnection();
            jspRealLastModified = conn.getLastModified();
            conn.getInputStream().close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
        File targetFile = checkClass ? new File(this.ctxt.getClassFileName()) : new File(this.ctxt.getServletJavaFileName());
        if (!targetFile.exists()) {
            return true;
        }
        long targetLastModified = targetFile.lastModified();
        if (targetLastModified < jspRealLastModified) {
            return true;
        }
        if (this.jsw == null) {
            return false;
        }
        Servlet servlet = null;
        try {
            servlet = this.jsw.getServlet();
        }
        catch (ServletException ex1) {
        }
        catch (IOException ex2) {
            // empty catch block
        }
        if (servlet == null) {
            return true;
        }
        List includes = null;
        if (servlet instanceof HttpJspBase) {
            includes = ((HttpJspBase)servlet).getIncludes();
        }
        if (includes == null) {
            return false;
        }
        Iterator it = includes.iterator();
        while (it.hasNext()) {
            String include = (String)it.next();
            try {
                URL includeUrl = this.ctxt.getResource(include);
                if (includeUrl == null) {
                    return true;
                }
                URLConnection includeUrlConn = includeUrl.openConnection();
                long includeLastModified = includeUrlConn.getLastModified();
                includeUrlConn.getInputStream().close();
                if (includeLastModified <= targetLastModified) continue;
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                return true;
            }
        }
        return false;
    }

    public ErrorDispatcher getErrorDispatcher() {
        return this.errDispatcher;
    }

    public PageInfo getPageInfo() {
        return this.pageInfo;
    }

    public JspCompilationContext getCompilationContext() {
        return this.ctxt;
    }

    public void removeGeneratedFiles() {
        try {
            String classFileName = this.ctxt.getServletClassName();
            if (classFileName != null) {
                File classFile = new File(classFileName);
                classFile.delete();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            String javaFileName = this.ctxt.getServletJavaFileName();
            if (javaFileName != null) {
                File javaFile = new File(javaFileName);
                javaFile.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        System.setErr((PrintStream)new SystemLogHandler(System.err));
        javacLock = new Object();
    }

    class JasperAntLogger
    extends DefaultLogger {
        private StringBuffer reportBuf = new StringBuffer();

        JasperAntLogger() {
        }

        protected void printMessage(String message, PrintStream stream, int priority) {
        }

        protected void log(String message) {
            this.reportBuf.append(message);
            this.reportBuf.append(System.getProperty("line.separator"));
        }

        protected String getReport() {
            String report = this.reportBuf.toString();
            this.reportBuf.setLength(0);
            return report;
        }
    }
}

