/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import junit.framework.Assert;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.mdx.MdxVisitor;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Member;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.fun.CrossJoinFunDef;
import mondrian.olap.fun.TestMember;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.SetType;
import mondrian.olap.type.TupleType;
import mondrian.olap.type.Type;
import mondrian.test.FoodMartTestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrossJoinTest
extends FoodMartTestCase {
    static Member[] m1 = new Member[]{new TestMember("a"), new TestMember("b"), new TestMember("c")};
    static Member[] m2 = new Member[]{new TestMember("A"), new TestMember("B"), new TestMember("C"), new TestMember("D")};
    static Member[][] m3 = new Member[][]{{new TestMember("k"), new TestMember("l")}, {new TestMember("m"), new TestMember("n")}};
    static Member[][] m4 = new Member[][]{{new TestMember("U"), new TestMember("V")}, {new TestMember("W"), new TestMember("X")}, {new TestMember("Y"), new TestMember("Z")}};
    static final Comparator<Member[]> memberComparator = new Comparator<Member[]>(){

        @Override
        public int compare(Member[] ma1, Member[] ma2) {
            for (int i = 0; i < ma1.length; ++i) {
                int c = ma1[i].compareTo(ma2[i]);
                if (c < 0) {
                    return c;
                }
                if (c <= 0) continue;
                return c;
            }
            return 0;
        }
    };
    private CrossJoinFunDef crossJoinFunDef;

    public CrossJoinTest() {
    }

    public CrossJoinTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.crossJoinFunDef = new CrossJoinFunDef(new NullFunDef());
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testIterMemberIterMemberIterCalc() {
        if (!Util.Retrowoven) {
            CrossJoinFunDef crossJoinFunDef = this.crossJoinFunDef;
            crossJoinFunDef.getClass();
            CrossJoinFunDef.IterMemberIterMemberIterCalc calc = crossJoinFunDef.new CrossJoinFunDef.IterMemberIterMemberIterCalc(this.getResolvedFunCall(), null);
            this.doMemberMemberIterTest(calc);
        }
    }

    public void testIterMemberListMemberIterCalc() {
        if (!Util.Retrowoven) {
            CrossJoinFunDef crossJoinFunDef = this.crossJoinFunDef;
            crossJoinFunDef.getClass();
            CrossJoinFunDef.IterMemberListMemberIterCalc calc = crossJoinFunDef.new CrossJoinFunDef.IterMemberListMemberIterCalc(this.getResolvedFunCall(), null);
            this.doMemberMemberIterTest(calc);
        }
    }

    public void testListMemberIterMemberIterCalc() {
        if (!Util.Retrowoven) {
            CrossJoinFunDef crossJoinFunDef = this.crossJoinFunDef;
            crossJoinFunDef.getClass();
            CrossJoinFunDef.ListMemberIterMemberIterCalc calc = crossJoinFunDef.new CrossJoinFunDef.ListMemberIterMemberIterCalc(this.getResolvedFunCall(), null);
            this.doMemberMemberIterTest(calc);
        }
    }

    public void testListMemberListMemberIterCalc() {
        if (!Util.Retrowoven) {
            CrossJoinFunDef crossJoinFunDef = this.crossJoinFunDef;
            crossJoinFunDef.getClass();
            CrossJoinFunDef.ListMemberListMemberIterCalc calc = crossJoinFunDef.new CrossJoinFunDef.ListMemberListMemberIterCalc(this.getResolvedFunCall(), null);
            this.doMemberMemberIterTest(calc);
        }
    }

    protected void doMemberMemberIterTest(CrossJoinFunDef.BaseMemberMemberIterCalc calc) {
        List<Member> l1 = this.makeListMember(m1);
        String s1 = this.toString(l1);
        String e1 = "{a,b,c}";
        Assert.assertEquals((String)s1, (String)e1);
        List<Member> l2 = this.makeListMember(m2);
        String s2 = this.toString(l2);
        String e2 = "{A,B,C,D}";
        Assert.assertEquals((String)s2, (String)e2);
        Iterable<Member[]> iter = calc.makeIterable(l1, l2);
        String s = this.toString(iter);
        String e = "{[a,A],[a,B],[a,C],[a,D],[b,A],[b,B],[b,C],[b,D],[c,A],[c,B],[c,C],[c,D]}";
        Assert.assertEquals((String)s, (String)e);
    }

    public void testIterMemberIterMemberArrayIterCalc() {
        if (!Util.Retrowoven) {
            CrossJoinFunDef crossJoinFunDef = this.crossJoinFunDef;
            crossJoinFunDef.getClass();
            CrossJoinFunDef.IterMemberIterMemberArrayIterCalc calc = crossJoinFunDef.new CrossJoinFunDef.IterMemberIterMemberArrayIterCalc(this.getResolvedFunCall(), null);
            this.doMemberMemberArrayIterTest(calc);
        }
    }

    public void testIterMemberListMemberArrayIterCalc() {
        if (!Util.Retrowoven) {
            CrossJoinFunDef crossJoinFunDef = this.crossJoinFunDef;
            crossJoinFunDef.getClass();
            CrossJoinFunDef.IterMemberListMemberArrayIterCalc calc = crossJoinFunDef.new CrossJoinFunDef.IterMemberListMemberArrayIterCalc(this.getResolvedFunCall(), null);
            this.doMemberMemberArrayIterTest(calc);
        }
    }

    public void testListMemberIterMemberArrayIterCalc() {
        if (!Util.Retrowoven) {
            CrossJoinFunDef crossJoinFunDef = this.crossJoinFunDef;
            crossJoinFunDef.getClass();
            CrossJoinFunDef.ListMemberIterMemberArrayIterCalc calc = crossJoinFunDef.new CrossJoinFunDef.ListMemberIterMemberArrayIterCalc(this.getResolvedFunCall(), null);
            this.doMemberMemberArrayIterTest(calc);
        }
    }

    public void testListMemberListMemberArrayIterCalc() {
        if (!Util.Retrowoven) {
            CrossJoinFunDef crossJoinFunDef = this.crossJoinFunDef;
            crossJoinFunDef.getClass();
            CrossJoinFunDef.ListMemberListMemberArrayIterCalc calc = crossJoinFunDef.new CrossJoinFunDef.ListMemberListMemberArrayIterCalc(this.getResolvedFunCall(), null);
            this.doMemberMemberArrayIterTest(calc);
        }
    }

    protected void doMemberMemberArrayIterTest(CrossJoinFunDef.BaseMemberMemberArrayIterCalc calc) {
        List<Member> l1 = this.makeListMember(m1);
        String s1 = this.toString(l1);
        String e1 = "{a,b,c}";
        Assert.assertEquals((String)s1, (String)e1);
        List<Member[]> l3 = this.makeListMemberArray(m3);
        String s3 = this.toString(l3);
        String e3 = "{[k,l],[m,n]}";
        Assert.assertEquals((String)s3, (String)e3);
        Iterable<Member[]> iter = calc.makeIterable(l1, l3);
        String s = this.toString(iter);
        String e = "{[a,k,l],[a,m,n],[b,k,l],[b,m,n],[c,k,l],[c,m,n]}";
        Assert.assertEquals((String)s, (String)e);
    }

    public void testIterMemberArrayIterMemberIterCalc() {
        if (!Util.Retrowoven) {
            CrossJoinFunDef crossJoinFunDef = this.crossJoinFunDef;
            crossJoinFunDef.getClass();
            CrossJoinFunDef.IterMemberArrayIterMemberIterCalc calc = crossJoinFunDef.new CrossJoinFunDef.IterMemberArrayIterMemberIterCalc(this.getResolvedFunCall(), null);
            this.doMemberArrayMemberIterTest(calc);
        }
    }

    public void testIterMemberArrayListMemberIterCalc() {
        if (!Util.Retrowoven) {
            CrossJoinFunDef crossJoinFunDef = this.crossJoinFunDef;
            crossJoinFunDef.getClass();
            CrossJoinFunDef.IterMemberArrayListMemberIterCalc calc = crossJoinFunDef.new CrossJoinFunDef.IterMemberArrayListMemberIterCalc(this.getResolvedFunCall(), null);
            this.doMemberArrayMemberIterTest(calc);
        }
    }

    public void testListMemberArrayIterMemberIterCalc() {
        if (!Util.Retrowoven) {
            CrossJoinFunDef crossJoinFunDef = this.crossJoinFunDef;
            crossJoinFunDef.getClass();
            CrossJoinFunDef.ListMemberArrayIterMemberIterCalc calc = crossJoinFunDef.new CrossJoinFunDef.ListMemberArrayIterMemberIterCalc(this.getResolvedFunCall(), null);
            this.doMemberArrayMemberIterTest(calc);
        }
    }

    public void testListMemberArrayListMemberIterCalc() {
        if (!Util.Retrowoven) {
            CrossJoinFunDef crossJoinFunDef = this.crossJoinFunDef;
            crossJoinFunDef.getClass();
            CrossJoinFunDef.ListMemberArrayListMemberIterCalc calc = crossJoinFunDef.new CrossJoinFunDef.ListMemberArrayListMemberIterCalc(this.getResolvedFunCall(), null);
            this.doMemberArrayMemberIterTest(calc);
        }
    }

    protected void doMemberArrayMemberIterTest(CrossJoinFunDef.BaseMemberArrayMemberIterCalc calc) {
        List<Member[]> l3 = this.makeListMemberArray(m3);
        String s3 = this.toString(l3);
        String e3 = "{[k,l],[m,n]}";
        Assert.assertEquals((String)s3, (String)e3);
        List<Member> l2 = this.makeListMember(m2);
        String s2 = this.toString(l2);
        String e2 = "{A,B,C,D}";
        Assert.assertEquals((String)s2, (String)e2);
        Iterable<Member[]> iter = calc.makeIterable(l3, l2);
        String s = this.toString(iter);
        String e = "{[k,l,A],[k,l,B],[k,l,C],[k,l,D],[m,n,A],[m,n,B],[m,n,C],[m,n,D]}";
        Assert.assertEquals((String)s, (String)e);
    }

    public void testIterMemberArrayIterMemberArrayIterCalc() {
        if (!Util.Retrowoven) {
            CrossJoinFunDef crossJoinFunDef = this.crossJoinFunDef;
            crossJoinFunDef.getClass();
            CrossJoinFunDef.IterMemberArrayIterMemberArrayIterCalc calc = crossJoinFunDef.new CrossJoinFunDef.IterMemberArrayIterMemberArrayIterCalc(this.getResolvedFunCall(), null);
            this.doMemberArrayMemberArrayIterTest(calc);
        }
    }

    public void testIterMemberArrayListMemberArrayIterCalc() {
        if (!Util.Retrowoven) {
            CrossJoinFunDef crossJoinFunDef = this.crossJoinFunDef;
            crossJoinFunDef.getClass();
            CrossJoinFunDef.IterMemberArrayListMemberArrayIterCalc calc = crossJoinFunDef.new CrossJoinFunDef.IterMemberArrayListMemberArrayIterCalc(this.getResolvedFunCall(), null);
            this.doMemberArrayMemberArrayIterTest(calc);
        }
    }

    public void testListMemberArrayIterMemberArrayIterCalc() {
        if (!Util.Retrowoven) {
            CrossJoinFunDef crossJoinFunDef = this.crossJoinFunDef;
            crossJoinFunDef.getClass();
            CrossJoinFunDef.ListMemberArrayIterMemberArrayIterCalc calc = crossJoinFunDef.new CrossJoinFunDef.ListMemberArrayIterMemberArrayIterCalc(this.getResolvedFunCall(), null);
            this.doMemberArrayMemberArrayIterTest(calc);
        }
    }

    public void testListMemberArrayListMemberArrayIterCalc() {
        if (!Util.Retrowoven) {
            CrossJoinFunDef crossJoinFunDef = this.crossJoinFunDef;
            crossJoinFunDef.getClass();
            CrossJoinFunDef.ListMemberArrayListMemberArrayIterCalc calc = crossJoinFunDef.new CrossJoinFunDef.ListMemberArrayListMemberArrayIterCalc(this.getResolvedFunCall(), null);
            this.doMemberArrayMemberArrayIterTest(calc);
        }
    }

    protected void doMemberArrayMemberArrayIterTest(CrossJoinFunDef.BaseMemberArrayMemberArrayIterCalc calc) {
        List<Member[]> l4 = this.makeListMemberArray(m4);
        String s4 = this.toString(l4);
        String e4 = "{[U,V],[W,X],[Y,Z]}";
        Assert.assertEquals((String)s4, (String)e4);
        List<Member[]> l3 = this.makeListMemberArray(m3);
        String s3 = this.toString(l3);
        String e3 = "{[k,l],[m,n]}";
        Assert.assertEquals((String)s3, (String)e3);
        Iterable<Member[]> iter = calc.makeIterable(l4, l3);
        String s = this.toString(iter);
        String e = "{[U,V,k,l],[U,V,m,n],[W,X,k,l],[W,X,m,n],[Y,Z,k,l],[Y,Z,m,n]}";
        Assert.assertEquals((String)s, (String)e);
    }

    public void testImmutableListMemberListMemberListCalc() {
        CrossJoinFunDef crossJoinFunDef = this.crossJoinFunDef;
        crossJoinFunDef.getClass();
        CrossJoinFunDef.ImmutableListMemberListMemberListCalc calc = crossJoinFunDef.new CrossJoinFunDef.ImmutableListMemberListMemberListCalc(this.getResolvedFunCall(), null);
        this.doMemberMemberListTest(calc);
    }

    protected void doMemberMemberListTest(CrossJoinFunDef.BaseListCalc calc) {
        List<Member> l1 = this.makeListMember(m1);
        String s1 = this.toString(l1);
        String e1 = "{a,b,c}";
        Assert.assertEquals((String)s1, (String)e1);
        List<Member> l2 = this.makeListMember(m2);
        String s2 = this.toString(l2);
        String e2 = "{A,B,C,D}";
        Assert.assertEquals((String)s2, (String)e2);
        List<Member[]> list = calc.makeList(l1, l2);
        String s = this.toString(list);
        String e = "{[a,A],[a,B],[a,C],[a,D],[b,A],[b,B],[b,C],[b,D],[c,A],[c,B],[c,C],[c,D]}";
        Assert.assertEquals((String)s, (String)e);
        List<Member[]> subList = list.subList(0, 12);
        s = this.toString(subList);
        Assert.assertEquals((String)s, (String)e);
        subList = list.subList(5, 12);
        s = this.toString(subList);
        e = "{[b,B],[b,C],[b,D],[c,A],[c,B],[c,C],[c,D]}";
        Assert.assertEquals((String)s, (String)e);
        subList = list.subList(0, 8);
        Assert.assertEquals((int)8, (int)subList.size());
        s = this.toString(subList);
        e = "{[a,A],[a,B],[a,C],[a,D],[b,A],[b,B],[b,C],[b,D]}";
        Assert.assertEquals((String)s, (String)e);
        subList = list.subList(0, 12);
        Assert.assertEquals((int)12, (int)subList.size());
        subList = subList.subList(4, 10);
        Assert.assertEquals((int)6, (int)subList.size());
        s = this.toString(subList);
        e = "{[b,A],[b,B],[b,C],[b,D],[c,A],[c,B]}";
        Assert.assertEquals((String)s, (String)e);
        subList = subList.subList(1, 4);
        Assert.assertEquals((int)3, (int)subList.size());
        s = this.toString(subList);
        e = "{[b,B],[b,C],[b,D]}";
        Assert.assertEquals((String)s, (String)e);
        subList = subList.subList(1, 2);
        Assert.assertEquals((int)1, (int)subList.size());
        s = this.toString(subList);
        e = "{[b,C]}";
        Assert.assertEquals((String)s, (String)e);
        subList = subList.subList(0, 1);
        Assert.assertEquals((int)1, (int)subList.size());
        s = this.toString(subList);
        e = "{[b,C]}";
        Assert.assertEquals((String)s, (String)e);
        subList = subList.subList(0, 0);
        Assert.assertEquals((int)0, (int)subList.size());
        s = this.toString(subList);
        e = "{}";
        Assert.assertEquals((String)s, (String)e);
    }

    public void testImmutableListMemberListMemberArrayListCalc() {
        CrossJoinFunDef crossJoinFunDef = this.crossJoinFunDef;
        crossJoinFunDef.getClass();
        CrossJoinFunDef.ImmutableListMemberListMemberArrayListCalc calc = crossJoinFunDef.new CrossJoinFunDef.ImmutableListMemberListMemberArrayListCalc(this.getResolvedFunCall(), null);
        this.doMemberMemberArrayListTest(calc);
    }

    protected void doMemberMemberArrayListTest(CrossJoinFunDef.BaseListCalc calc) {
        List<Member> l1 = this.makeListMember(m1);
        String s1 = this.toString(l1);
        String e1 = "{a,b,c}";
        Assert.assertEquals((String)s1, (String)e1);
        List<Member[]> l3 = this.makeListMemberArray(m3);
        String s3 = this.toString(l3);
        String e3 = "{[k,l],[m,n]}";
        Assert.assertEquals((String)s3, (String)e3);
        List<Member[]> list = calc.makeList(l1, l3);
        String s = this.toString(list);
        String e = "{[a,k,l],[a,m,n],[b,k,l],[b,m,n],[c,k,l],[c,m,n]}";
        Assert.assertEquals((String)s, (String)e);
        List<Member[]> subList = list.subList(0, 6);
        s = this.toString(subList);
        Assert.assertEquals((int)6, (int)subList.size());
        Assert.assertEquals((String)s, (String)e);
        subList = subList.subList(0, 6);
        s = this.toString(subList);
        Assert.assertEquals((int)6, (int)subList.size());
        Assert.assertEquals((String)s, (String)e);
        subList = list.subList(1, 5);
        s = this.toString(subList);
        e = "{[a,m,n],[b,k,l],[b,m,n],[c,k,l]}";
        Assert.assertEquals((int)4, (int)subList.size());
        Assert.assertEquals((String)s, (String)e);
        subList = subList.subList(1, 3);
        s = this.toString(subList);
        e = "{[b,k,l],[b,m,n]}";
        Assert.assertEquals((int)2, (int)subList.size());
        Assert.assertEquals((String)s, (String)e);
        subList = subList.subList(1, 2);
        s = this.toString(subList);
        e = "{[b,m,n]}";
        Assert.assertEquals((int)1, (int)subList.size());
        Assert.assertEquals((String)s, (String)e);
        subList = list.subList(4, 4);
        s = this.toString(subList);
        e = "{}";
        Assert.assertEquals((int)0, (int)subList.size());
        Assert.assertEquals((String)s, (String)e);
    }

    public void testImmutableListMemberArrayListMemberListCalc() {
        CrossJoinFunDef crossJoinFunDef = this.crossJoinFunDef;
        crossJoinFunDef.getClass();
        CrossJoinFunDef.ImmutableListMemberArrayListMemberListCalc calc = crossJoinFunDef.new CrossJoinFunDef.ImmutableListMemberArrayListMemberListCalc(this.getResolvedFunCall(), null);
        this.doMemberArrayMemberListTest(calc);
    }

    protected void doMemberArrayMemberListTest(CrossJoinFunDef.BaseListCalc calc) {
        List<Member[]> l3 = this.makeListMemberArray(m3);
        String s3 = this.toString(l3);
        String e3 = "{[k,l],[m,n]}";
        Assert.assertEquals((String)s3, (String)e3);
        List<Member> l2 = this.makeListMember(m2);
        String s2 = this.toString(l2);
        String e2 = "{A,B,C,D}";
        Assert.assertEquals((String)s2, (String)e2);
        List<Member[]> list = calc.makeList(l3, l2);
        String s = this.toString(list);
        String e = "{[k,l,A],[k,l,B],[k,l,C],[k,l,D],[m,n,A],[m,n,B],[m,n,C],[m,n,D]}";
        Assert.assertEquals((String)s, (String)e);
        List<Member[]> subList = list.subList(0, 8);
        s = this.toString(subList);
        Assert.assertEquals((int)8, (int)subList.size());
        Assert.assertEquals((String)s, (String)e);
        subList = list.subList(1, 7);
        s = this.toString(subList);
        e = "{[k,l,B],[k,l,C],[k,l,D],[m,n,A],[m,n,B],[m,n,C]}";
        Assert.assertEquals((int)6, (int)subList.size());
        Assert.assertEquals((String)s, (String)e);
        subList = list.subList(4, 5);
        s = this.toString(subList);
        e = "{[m,n,A]}";
        Assert.assertEquals((int)1, (int)subList.size());
        Assert.assertEquals((String)s, (String)e);
        subList = subList.subList(0, 1);
        s = this.toString(subList);
        e = "{[m,n,A]}";
        Assert.assertEquals((int)1, (int)subList.size());
        Assert.assertEquals((String)s, (String)e);
        subList = subList.subList(0, 0);
        s = this.toString(subList);
        e = "{}";
        Assert.assertEquals((int)0, (int)subList.size());
        Assert.assertEquals((String)s, (String)e);
        subList = list.subList(0, 8);
        s = this.toString(subList);
        e = "{[k,l,A],[k,l,B],[k,l,C],[k,l,D],[m,n,A],[m,n,B],[m,n,C],[m,n,D]}";
        Assert.assertEquals((int)8, (int)subList.size());
        Assert.assertEquals((String)s, (String)e);
        subList = subList.subList(0, 8);
        s = this.toString(subList);
        e = "{[k,l,A],[k,l,B],[k,l,C],[k,l,D],[m,n,A],[m,n,B],[m,n,C],[m,n,D]}";
        Assert.assertEquals((int)8, (int)subList.size());
        Assert.assertEquals((String)s, (String)e);
        subList = subList.subList(1, 7);
        s = this.toString(subList);
        e = "{[k,l,B],[k,l,C],[k,l,D],[m,n,A],[m,n,B],[m,n,C]}";
        Assert.assertEquals((int)6, (int)subList.size());
        Assert.assertEquals((String)s, (String)e);
        subList = subList.subList(1, 5);
        s = this.toString(subList);
        e = "{[k,l,C],[k,l,D],[m,n,A],[m,n,B]}";
        Assert.assertEquals((int)4, (int)subList.size());
        Assert.assertEquals((String)s, (String)e);
        subList = subList.subList(1, 3);
        s = this.toString(subList);
        e = "{[k,l,D],[m,n,A]}";
        Assert.assertEquals((int)2, (int)subList.size());
        Assert.assertEquals((String)s, (String)e);
    }

    public void testImmutableListMemberArrayListMemberArrayListCalc() {
        CrossJoinFunDef crossJoinFunDef = this.crossJoinFunDef;
        crossJoinFunDef.getClass();
        CrossJoinFunDef.ImmutableListMemberArrayListMemberArrayListCalc calc = crossJoinFunDef.new CrossJoinFunDef.ImmutableListMemberArrayListMemberArrayListCalc(this.getResolvedFunCall(), null);
        this.doMemberArrayMemberArrayListTest(calc);
    }

    protected void doMemberArrayMemberArrayListTest(CrossJoinFunDef.BaseListCalc calc) {
        List<Member[]> l4 = this.makeListMemberArray(m4);
        String s4 = this.toString(l4);
        String e4 = "{[U,V],[W,X],[Y,Z]}";
        Assert.assertEquals((String)s4, (String)e4);
        List<Member[]> l3 = this.makeListMemberArray(m3);
        String s3 = this.toString(l3);
        String e3 = "{[k,l],[m,n]}";
        Assert.assertEquals((String)s3, (String)e3);
        List<Member[]> list = calc.makeList(l4, l3);
        String s = this.toString(list);
        String e = "{[U,V,k,l],[U,V,m,n],[W,X,k,l],[W,X,m,n],[Y,Z,k,l],[Y,Z,m,n]}";
        Assert.assertEquals((String)s, (String)e);
        List<Member[]> subList = list.subList(0, 6);
        s = this.toString(subList);
        Assert.assertEquals((int)6, (int)subList.size());
        Assert.assertEquals((String)s, (String)e);
        subList = subList.subList(0, 6);
        s = this.toString(subList);
        Assert.assertEquals((int)6, (int)subList.size());
        Assert.assertEquals((String)s, (String)e);
        subList = subList.subList(1, 5);
        s = this.toString(subList);
        e = "{[U,V,m,n],[W,X,k,l],[W,X,m,n],[Y,Z,k,l]}";
        Assert.assertEquals((int)4, (int)subList.size());
        Assert.assertEquals((String)s, (String)e);
        subList = subList.subList(2, 4);
        s = this.toString(subList);
        e = "{[W,X,m,n],[Y,Z,k,l]}";
        Assert.assertEquals((int)2, (int)subList.size());
        Assert.assertEquals((String)s, (String)e);
        subList = subList.subList(1, 2);
        s = this.toString(subList);
        e = "{[Y,Z,k,l]}";
        Assert.assertEquals((int)1, (int)subList.size());
        Assert.assertEquals((String)s, (String)e);
        subList = list.subList(1, 4);
        s = this.toString(subList);
        e = "{[U,V,m,n],[W,X,k,l],[W,X,m,n]}";
        Assert.assertEquals((int)3, (int)subList.size());
        Assert.assertEquals((String)s, (String)e);
        subList = list.subList(2, 4);
        s = this.toString(subList);
        e = "{[W,X,k,l],[W,X,m,n]}";
        Assert.assertEquals((int)2, (int)subList.size());
        Assert.assertEquals((String)s, (String)e);
        subList = list.subList(2, 3);
        s = this.toString(subList);
        e = "{[W,X,k,l]}";
        Assert.assertEquals((int)1, (int)subList.size());
        Assert.assertEquals((String)s, (String)e);
        subList = list.subList(4, 4);
        s = this.toString(subList);
        e = "{}";
        Assert.assertEquals((int)0, (int)subList.size());
        Assert.assertEquals((String)s, (String)e);
    }

    public void testMutableListMemberListMemberListCalc() {
        CrossJoinFunDef crossJoinFunDef = this.crossJoinFunDef;
        crossJoinFunDef.getClass();
        CrossJoinFunDef.MutableListMemberListMemberListCalc calc = crossJoinFunDef.new CrossJoinFunDef.MutableListMemberListMemberListCalc(this.getResolvedFunCall(), null);
        this.doMMemberMemberListTest(calc);
    }

    protected void doMMemberMemberListTest(CrossJoinFunDef.BaseListCalc calc) {
        List<Member> l1 = this.makeListMember(m1);
        String s1 = this.toString(l1);
        String e1 = "{a,b,c}";
        Assert.assertEquals((String)s1, (String)e1);
        List<Member> l2 = this.makeListMember(m2);
        String s2 = this.toString(l2);
        String e2 = "{A,B,C,D}";
        Assert.assertEquals((String)s2, (String)e2);
        List<Member[]> list = calc.makeList(l1, l2);
        String s = this.toString(list);
        String e = "{[a,A],[a,B],[a,C],[a,D],[b,A],[b,B],[b,C],[b,D],[c,A],[c,B],[c,C],[c,D]}";
        Assert.assertEquals((String)s, (String)e);
        Collections.reverse(list);
        s = this.toString(list);
        e = "{[c,D],[c,C],[c,B],[c,A],[b,D],[b,C],[b,B],[b,A],[a,D],[a,C],[a,B],[a,A]}";
        Assert.assertEquals((String)s, (String)e);
        Comparator<Member[]> c = new Comparator<Member[]>(){

            @Override
            public int compare(Member[] ma1, Member[] ma2) {
                int c = ma1[0].compareTo(ma2[0]);
                if (c < 0) {
                    return c;
                }
                if (c > 0) {
                    return c;
                }
                return ma1[1].compareTo(ma2[1]);
            }
        };
        Collections.sort(list, c);
        s = this.toString(list);
        e = "{[a,A],[a,B],[a,C],[a,D],[b,A],[b,B],[b,C],[b,D],[c,A],[c,B],[c,C],[c,D]}";
        Assert.assertEquals((String)s, (String)e);
        Member[] members = list.remove(1);
        String m = this.toString(members);
        s = this.toString(list);
        e = "{[a,A],[a,C],[a,D],[b,A],[b,B],[b,C],[b,D],[c,A],[c,B],[c,C],[c,D]}";
        Assert.assertEquals((String)s, (String)e);
    }

    public void testMutableListMemberListMemberArrayListCalc() {
        CrossJoinFunDef crossJoinFunDef = this.crossJoinFunDef;
        crossJoinFunDef.getClass();
        CrossJoinFunDef.MutableListMemberListMemberArrayListCalc calc = crossJoinFunDef.new CrossJoinFunDef.MutableListMemberListMemberArrayListCalc(this.getResolvedFunCall(), null);
        this.doMMemberMemberArrayListTest(calc);
    }

    protected void doMMemberMemberArrayListTest(CrossJoinFunDef.BaseListCalc calc) {
        List<Member> l1 = this.makeListMember(m1);
        String s1 = this.toString(l1);
        String e1 = "{a,b,c}";
        Assert.assertEquals((String)s1, (String)e1);
        List<Member[]> l3 = this.makeListMemberArray(m3);
        String s3 = this.toString(l3);
        String e3 = "{[k,l],[m,n]}";
        Assert.assertEquals((String)s3, (String)e3);
        List<Member[]> list = calc.makeList(l1, l3);
        String s = this.toString(list);
        String e = "{[a,k,l],[a,m,n],[b,k,l],[b,m,n],[c,k,l],[c,m,n]}";
        Assert.assertEquals((String)s, (String)e);
        Collections.reverse(list);
        s = this.toString(list);
        e = "{[c,m,n],[c,k,l],[b,m,n],[b,k,l],[a,m,n],[a,k,l]}";
        Assert.assertEquals((String)s, (String)e);
        Collections.sort(list, memberComparator);
        s = this.toString(list);
        e = "{[a,k,l],[a,m,n],[b,k,l],[b,m,n],[c,k,l],[c,m,n]}";
        Assert.assertEquals((String)s, (String)e);
        Member[] members = list.remove(1);
        s = this.toString(list);
        e = "{[a,k,l],[b,k,l],[b,m,n],[c,k,l],[c,m,n]}";
        Assert.assertEquals((String)s, (String)e);
    }

    public void testMutableListMemberArrayListMemberListCalc() {
        CrossJoinFunDef crossJoinFunDef = this.crossJoinFunDef;
        crossJoinFunDef.getClass();
        CrossJoinFunDef.MutableListMemberArrayListMemberListCalc calc = crossJoinFunDef.new CrossJoinFunDef.MutableListMemberArrayListMemberListCalc(this.getResolvedFunCall(), null);
        this.doMMemberArrayMemberListTest(calc);
    }

    protected void doMMemberArrayMemberListTest(CrossJoinFunDef.BaseListCalc calc) {
        List<Member[]> l1 = this.makeListMemberArray(m3);
        String s1 = this.toString(l1);
        String e1 = "{[k,l],[m,n]}";
        Assert.assertEquals((String)s1, (String)e1);
        List<Member> l2 = this.makeListMember(m1);
        String s2 = this.toString(l2);
        String e2 = "{a,b,c}";
        Assert.assertEquals((String)s2, (String)e2);
        List<Member[]> list = calc.makeList(l1, l2);
        String s = this.toString(list);
        String e = "{[k,l,a],[k,l,b],[k,l,c],[m,n,a],[m,n,b],[m,n,c]}";
        Assert.assertEquals((String)s, (String)e);
        Collections.reverse(list);
        s = this.toString(list);
        e = "{[m,n,c],[m,n,b],[m,n,a],[k,l,c],[k,l,b],[k,l,a]}";
        Assert.assertEquals((String)s, (String)e);
        Collections.sort(list, memberComparator);
        s = this.toString(list);
        e = "{[k,l,a],[k,l,b],[k,l,c],[m,n,a],[m,n,b],[m,n,c]}";
        Assert.assertEquals((String)s, (String)e);
        Member[] members = list.remove(1);
        s = this.toString(list);
        e = "{[k,l,a],[k,l,c],[m,n,a],[m,n,b],[m,n,c]}";
        Assert.assertEquals((String)s, (String)e);
    }

    public void testMutableListMemberArrayListMemberArrayListCalc() {
        CrossJoinFunDef crossJoinFunDef = this.crossJoinFunDef;
        crossJoinFunDef.getClass();
        CrossJoinFunDef.MutableListMemberArrayListMemberArrayListCalc calc = crossJoinFunDef.new CrossJoinFunDef.MutableListMemberArrayListMemberArrayListCalc(this.getResolvedFunCall(), null);
        this.doMMemberArrayMemberArrayListTest(calc);
    }

    protected void doMMemberArrayMemberArrayListTest(CrossJoinFunDef.BaseListCalc calc) {
        List<Member[]> l1 = this.makeListMemberArray(m3);
        String s1 = this.toString(l1);
        String e1 = "{[k,l],[m,n]}";
        Assert.assertEquals((String)s1, (String)e1);
        List<Member[]> l2 = this.makeListMemberArray(m4);
        String s2 = this.toString(l2);
        String e2 = "{[U,V],[W,X],[Y,Z]}";
        Assert.assertEquals((String)s2, (String)e2);
        List<Member[]> list = calc.makeList(l1, l2);
        String s = this.toString(list);
        String e = "{[k,l,U,V],[k,l,W,X],[k,l,Y,Z],[m,n,U,V],[m,n,W,X],[m,n,Y,Z]}";
        Assert.assertEquals((String)s, (String)e);
        Collections.reverse(list);
        s = this.toString(list);
        e = "{[m,n,Y,Z],[m,n,W,X],[m,n,U,V],[k,l,Y,Z],[k,l,W,X],[k,l,U,V]}";
        Assert.assertEquals((String)s, (String)e);
        Collections.sort(list, memberComparator);
        s = this.toString(list);
        e = "{[k,l,U,V],[k,l,W,X],[k,l,Y,Z],[m,n,U,V],[m,n,W,X],[m,n,Y,Z]}";
        Assert.assertEquals((String)s, (String)e);
        Member[] members = list.remove(1);
        s = this.toString(list);
        e = "{[k,l,U,V],[k,l,Y,Z],[m,n,U,V],[m,n,W,X],[m,n,Y,Z]}";
        Assert.assertEquals((String)s, (String)e);
    }

    protected String toString(Iterable l) {
        StringBuffer buf = new StringBuffer(100);
        buf.append('{');
        int j = 0;
        for (Object o : l) {
            if (j++ > 0) {
                buf.append(',');
            }
            if (o instanceof Member) {
                buf.append(o);
                continue;
            }
            Member[] members = (Member[])o;
            buf.append('[');
            int k = 0;
            for (Member m : members) {
                if (k++ > 0) {
                    buf.append(',');
                }
                buf.append(m);
            }
            buf.append(']');
        }
        buf.append('}');
        return buf.toString();
    }

    protected String toString(Member[] members) {
        StringBuffer buf = new StringBuffer(100);
        buf.append('[');
        boolean firstTimeInner = true;
        for (Member m : members) {
            if (!firstTimeInner) {
                buf.append(',');
            }
            buf.append(m);
            firstTimeInner = false;
        }
        buf.append(']');
        return buf.toString();
    }

    protected List<Member> makeListMember(Member[] ms) {
        return new ArrayList<Member>(Arrays.asList(ms));
    }

    protected List<Member[]> makeListMemberArray(Member[][] ms) {
        return new ArrayList<Member[]>(Arrays.asList(ms));
    }

    protected ResolvedFunCall getResolvedFunCall() {
        TestFunDef funDef = new TestFunDef();
        Exp[] args = new Exp[]{};
        SetType returnType = new SetType(new TupleType(new Type[]{new MemberType(null, null, null, null), new MemberType(null, null, null, null)}));
        return new ResolvedFunCall(funDef, args, returnType);
    }

    public static class TestExp
    implements Exp {
        Type type = new SetType(new MemberType(null, null, null, null));

        TestExp() {
        }

        public Exp clone() {
            throw new UnsupportedOperationException();
        }

        public int getCategory() {
            throw new UnsupportedOperationException();
        }

        public Type getType() {
            return this.type;
        }

        public void unparse(PrintWriter pw) {
            throw new UnsupportedOperationException();
        }

        public Exp accept(Validator validator) {
            throw new UnsupportedOperationException();
        }

        public Calc accept(ExpCompiler compiler) {
            throw new UnsupportedOperationException();
        }

        public Object accept(MdxVisitor visitor) {
            throw new UnsupportedOperationException();
        }
    }

    public static class NullFunDef
    implements FunDef {
        NullFunDef() {
        }

        public Syntax getSyntax() {
            return Syntax.Function;
        }

        public String getName() {
            return "";
        }

        public String getDescription() {
            return "";
        }

        public int getReturnCategory() {
            return 0;
        }

        public int[] getParameterCategories() {
            return new int[0];
        }

        public Exp createCall(Validator validator, Exp[] args) {
            return null;
        }

        public String getSignature() {
            return "";
        }

        public void unparse(Exp[] args, PrintWriter pw) {
        }

        public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
            return null;
        }
    }

    public static class TestFunDef
    implements FunDef {
        TestFunDef() {
        }

        public Syntax getSyntax() {
            throw new UnsupportedOperationException();
        }

        public String getName() {
            throw new UnsupportedOperationException();
        }

        public String getDescription() {
            throw new UnsupportedOperationException();
        }

        public int getReturnCategory() {
            throw new UnsupportedOperationException();
        }

        public int[] getParameterCategories() {
            throw new UnsupportedOperationException();
        }

        public Exp createCall(Validator validator, Exp[] args) {
            throw new UnsupportedOperationException();
        }

        public String getSignature() {
            throw new UnsupportedOperationException();
        }

        public void unparse(Exp[] args, PrintWriter pw) {
            throw new UnsupportedOperationException();
        }

        public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
            throw new UnsupportedOperationException();
        }
    }
}

