/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.CalcWriter;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ResultStyle;
import mondrian.calc.impl.DelegatingExpCompiler;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Member;
import mondrian.olap.Validator;
import mondrian.olap.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultStyleCompiler
extends DelegatingExpCompiler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ExpCompiler generateCompiler(Evaluator evaluator, Validator validator, List<ResultStyle> resultStyles) {
        Object context = ExpCompiler.Factory.getFactory().removeContext();
        try {
            ExpCompiler expCompiler = ExpCompiler.Factory.getExpCompiler(evaluator, validator, resultStyles);
            return expCompiler;
        }
        finally {
            ExpCompiler.Factory.getFactory().restoreContext(context);
        }
    }

    public ResultStyleCompiler(Evaluator evaluator, Validator validator, List<ResultStyle> resultStyles) {
        super(ResultStyleCompiler.generateCompiler(evaluator, validator, resultStyles));
    }

    @Override
    public Calc compile(Exp exp) {
        List<ResultStyle> resultStyles = this.getAcceptableResultStyles();
        return this.compileAs(exp, null, resultStyles);
    }

    @Override
    public Calc compileAs(Exp exp, Type resultType, List<ResultStyle> resultStyles) {
        if (resultStyles.size() > 0) {
            boolean foundIterable = false;
            boolean foundList = false;
            boolean foundMutableList = false;
            for (ResultStyle resultStyle : resultStyles) {
                switch (resultStyle) {
                    case LIST: {
                        foundList = true;
                        break;
                    }
                    case MUTABLE_LIST: {
                        foundMutableList = true;
                        break;
                    }
                    case ITERABLE: {
                        foundIterable = true;
                    }
                }
            }
            if (foundIterable || foundList || foundMutableList) {
                Calc calcIter = this.compileAs(exp, resultType, ResultStyle.ITERABLE_ONLY);
                Calc calcList = this.compileAs(exp, resultType, ResultStyle.LIST_ONLY);
                Calc calcMList = this.compileAs(exp, resultType, ResultStyle.MUTABLELIST_ONLY);
                return new MultiCalc(calcIter, calcList, calcMList, !foundList && !foundIterable);
            }
        }
        return this.compile(exp);
    }

    static {
        System.out.println("ResultStyleCompiler being used");
    }

    static class MultiCalc
    implements Calc {
        static int counter = 0;
        final Calc calcIter;
        final Calc calcList;
        final Calc calcMList;
        final boolean onlyMutableList;
        int lineNumber;
        int cnt;

        MultiCalc(Calc calcIter, Calc calcList, Calc calcMList, boolean onlyMutableList) {
            this.calcIter = calcIter;
            this.calcList = calcList;
            this.calcMList = calcMList;
            this.onlyMutableList = onlyMutableList;
            this.lineNumber = -1;
            this.cnt = counter++;
        }

        protected boolean finalEval() {
            StackTraceElement[] stEls = new Throwable().getStackTrace();
            for (int i = stEls.length - 1; i > 0; --i) {
                StackTraceElement stEl = stEls[i];
                if (!stEl.getClassName().equals("mondrian.rolap.RolapResult")) continue;
                int ln = stEl.getLineNumber();
                if (this.lineNumber == -1) {
                    this.lineNumber = ln;
                    return false;
                }
                return this.lineNumber != ln;
            }
            throw new AssertionError((Object)"MultiCalc.finalEval: MISS");
        }

        public Object evaluate(Evaluator evaluator) {
            Evaluator eval1 = evaluator.push();
            Evaluator eval2 = evaluator.push();
            Object valueIter = this.calcIter.evaluate(evaluator);
            Object valueList = this.calcList.evaluate(eval1);
            Object valueMList = this.calcMList.evaluate(eval2);
            if (this.finalEval()) {
                if (!this.compare(valueIter, valueList)) {
                    throw new RuntimeException("MultiCalc.evaluator: ERROR Iter-List");
                }
                if (!this.compare(valueIter, valueMList)) {
                    throw new RuntimeException("MultiCalc.evaluator: ERROR Iter-MList");
                }
            }
            return this.onlyMutableList ? valueMList : valueIter;
        }

        public boolean dependsOn(Dimension dimension) {
            return this.calcIter.dependsOn(dimension);
        }

        public Type getType() {
            return this.calcIter.getType();
        }

        public void accept(CalcWriter calcWriter) {
            this.calcIter.accept(calcWriter);
        }

        public ResultStyle getResultStyle() {
            return this.calcIter.getResultStyle();
        }

        protected boolean compare(Object v1, Object v2) {
            if (v1 == null) {
                return v2 == null;
            }
            if (v2 == null) {
                return false;
            }
            if (!(v1 instanceof Iterable)) {
                return false;
            }
            if (!(v2 instanceof Iterable)) {
                return false;
            }
            Iterable iter1 = (Iterable)v1;
            Iterable iter2 = (Iterable)v2;
            Iterator it1 = iter1.iterator();
            Iterator it2 = iter2.iterator();
            while (it1.hasNext()) {
                Object[] ma2;
                Object[] ma1;
                if (!it2.hasNext()) {
                    return false;
                }
                Object o1 = it1.next();
                Object o2 = it2.next();
                if (o1 == null) {
                    if (o2 == null) continue;
                    return false;
                }
                if (o2 == null) {
                    return false;
                }
                if (!(o1 instanceof Member ? !o1.equals(o2) : !Arrays.equals(ma1 = (Member[])o1, ma2 = (Member[])o2))) continue;
                return false;
            }
            return !it2.hasNext();
        }

        protected void print(Member[] ma) {
            StringBuilder buf = new StringBuilder(100);
            if (ma == null) {
                buf.append("null");
            } else {
                for (int i = 0; i < ma.length; ++i) {
                    Member m = ma[i];
                    if (i > 0) {
                        buf.append(',');
                    }
                    buf.append(m.getUniqueName());
                    buf.append(' ');
                }
            }
            System.out.println(buf.toString());
        }
    }
}

