/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.type;

import java.util.ArrayList;
import junit.framework.TestCase;
import mondrian.olap.Connection;
import mondrian.olap.Cube;
import mondrian.olap.Dimension;
import mondrian.olap.Hierarchy;
import mondrian.olap.Id;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.OlapElement;
import mondrian.olap.SchemaReader;
import mondrian.olap.fun.Resolver;
import mondrian.olap.type.BooleanType;
import mondrian.olap.type.DateTimeType;
import mondrian.olap.type.DecimalType;
import mondrian.olap.type.DimensionType;
import mondrian.olap.type.HierarchyType;
import mondrian.olap.type.LevelType;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.NullType;
import mondrian.olap.type.NumericType;
import mondrian.olap.type.ScalarType;
import mondrian.olap.type.SetType;
import mondrian.olap.type.StringType;
import mondrian.olap.type.TupleType;
import mondrian.olap.type.Type;
import mondrian.olap.type.TypeUtil;
import mondrian.test.TestContext;

public class TypeTest
extends TestCase {
    TestContext testContext = null;

    protected void setUp() throws Exception {
        this.testContext = TestContext.instance();
    }

    public void testConversions() {
        Type[] types;
        Connection connection = this.testContext.getConnection();
        Cube salesCube = this.getCubeWithName("Sales", connection.getSchema().getCubes());
        TypeTest.assertTrue((salesCube != null ? 1 : 0) != 0);
        OlapElement customersDimension = null;
        for (Dimension dimension : salesCube.getDimensions()) {
            if (!dimension.getName().equals("Customers")) continue;
            customersDimension = dimension;
        }
        TypeTest.assertTrue((customersDimension != null ? 1 : 0) != 0);
        Hierarchy hierarchy = customersDimension.getHierarchy();
        Member member = hierarchy.getDefaultMember();
        Level level = member.getLevel();
        MemberType memberType = new MemberType((Dimension)customersDimension, hierarchy, level, member);
        LevelType levelType = new LevelType((Dimension)customersDimension, hierarchy, level);
        HierarchyType hierarchyType = new HierarchyType((Dimension)customersDimension, hierarchy);
        DimensionType dimensionType = new DimensionType((Dimension)customersDimension);
        StringType stringType = new StringType();
        ScalarType scalarType = new ScalarType();
        NumericType numericType = new NumericType();
        DateTimeType dateTimeType = new DateTimeType();
        DecimalType decimalType = new DecimalType(10, 2);
        DecimalType integerType = new DecimalType(7, 0);
        NullType nullType = new NullType();
        MemberType unknownMemberType = MemberType.Unknown;
        TupleType tupleType = new TupleType(new Type[]{memberType, unknownMemberType});
        SetType tupleSetType = new SetType(tupleType);
        SetType setType = new SetType(memberType);
        LevelType unknownLevelType = LevelType.Unknown;
        HierarchyType unknownHierarchyType = HierarchyType.Unknown;
        DimensionType unknownDimensionType = DimensionType.Unknown;
        BooleanType booleanType = new BooleanType();
        for (Type type : types = new Type[]{memberType, levelType, hierarchyType, dimensionType, numericType, dateTimeType, decimalType, integerType, scalarType, nullType, stringType, booleanType, tupleType, tupleSetType, setType, unknownDimensionType, unknownHierarchyType, unknownLevelType, unknownMemberType}) {
            String desc = type.toString() + ":" + type.getClass();
            TypeTest.assertEquals((String)desc, (Object)type, (Object)type.computeCommonType(type, null));
            int[] conversionCount = new int[]{0};
            TypeTest.assertEquals((String)desc, (Object)type, (Object)type.computeCommonType(type, conversionCount));
            TypeTest.assertEquals((int)0, (int)conversionCount[0]);
            if (!(type instanceof ScalarType)) continue;
            TypeTest.assertEquals((Object)type, (Object)type.computeCommonType(nullType, null));
            TypeTest.assertEquals((Object)type, (Object)type.computeCommonType(nullType, conversionCount));
            TypeTest.assertEquals((int)0, (int)conversionCount[0]);
        }
        for (Type fromType : types) {
            for (Type toType : types) {
                ArrayList<Resolver.Conversion> conversions;
                int toCategory;
                boolean canConvert;
                Type type = fromType.computeCommonType(toType, null);
                Type type2 = toType.computeCommonType(fromType, null);
                String desc = "symmetric, from " + fromType + ", to " + toType;
                TypeTest.assertEquals((String)desc, (Object)type, (Object)type2);
                int[] conversionCount = new int[]{0};
                int[] conversionCount2 = new int[]{0};
                type = fromType.computeCommonType(toType, conversionCount);
                type2 = toType.computeCommonType(fromType, conversionCount2);
                if (conversionCount[0] == 0 && conversionCount2[0] == 0) {
                    TypeTest.assertEquals((String)desc, (Object)type, (Object)type2);
                }
                if (!(!(canConvert = TypeUtil.canConvert(fromType, toCategory = TypeUtil.typeToCategory(toType), conversions = new ArrayList<Resolver.Conversion>())) || conversions.size() != 0 || type != null || fromType == memberType && toType == tupleType || fromType == tupleSetType && toType == setType || fromType == setType && toType == tupleSetType)) {
                    TypeTest.fail((String)("can convert from " + fromType + " to " + toType + ", but their most general type is null"));
                }
                if (canConvert || type == null || !type.equals(toType)) continue;
                TypeTest.fail((String)("cannot convert from " + fromType + " to " + toType + ", but they have a most general type " + type));
            }
        }
    }

    public void testCommonTypeWhenSetTypeHavingMemberTypeAndTupleType() {
        MemberType measureMemberType = this.getMemberTypeHavingMeasureInIt(this.getUnitSalesMeasure());
        MemberType genderMemberType = this.getMemberTypeHavingMaleChild(this.getMaleChild());
        MemberType storeMemberType = this.getStoreMemberType(this.getStoreChild());
        TupleType tupleType = new TupleType(new Type[]{storeMemberType, genderMemberType});
        SetType setTypeWithMember = new SetType(measureMemberType);
        SetType setTypeWithTuple = new SetType(tupleType);
        Type type1 = setTypeWithMember.computeCommonType(setTypeWithTuple, null);
        TypeTest.assertNotNull((Object)type1);
        TypeTest.assertTrue((boolean)(((SetType)type1).getElementType() instanceof TupleType));
        Type type2 = setTypeWithTuple.computeCommonType(setTypeWithMember, null);
        TypeTest.assertNotNull((Object)type2);
        TypeTest.assertTrue((boolean)(((SetType)type2).getElementType() instanceof TupleType));
        TypeTest.assertEquals((Object)type1, (Object)type2);
    }

    public void testCommonTypeOfMemberandTupleTypeIsTupleType() {
        MemberType measureMemberType = this.getMemberTypeHavingMeasureInIt(this.getUnitSalesMeasure());
        MemberType genderMemberType = this.getMemberTypeHavingMaleChild(this.getMaleChild());
        MemberType storeMemberType = this.getStoreMemberType(this.getStoreChild());
        TupleType tupleType = new TupleType(new Type[]{storeMemberType, genderMemberType});
        Type type1 = measureMemberType.computeCommonType(tupleType, null);
        TypeTest.assertNotNull((Object)type1);
        TypeTest.assertTrue((boolean)(type1 instanceof TupleType));
        Type type2 = tupleType.computeCommonType(measureMemberType, null);
        TypeTest.assertNotNull((Object)type2);
        TypeTest.assertTrue((boolean)(type2 instanceof TupleType));
        TypeTest.assertEquals((Object)type1, (Object)type2);
    }

    public void testCommonTypeBetweenTuplesOfDifferentSizesIsATupleType() {
        MemberType measureMemberType = this.getMemberTypeHavingMeasureInIt(this.getUnitSalesMeasure());
        MemberType genderMemberType = this.getMemberTypeHavingMaleChild(this.getMaleChild());
        MemberType storeMemberType = this.getStoreMemberType(this.getStoreChild());
        TupleType tupleTypeLarger = new TupleType(new Type[]{storeMemberType, genderMemberType, measureMemberType});
        TupleType tupleTypeSmaller = new TupleType(new Type[]{storeMemberType, genderMemberType});
        Type type1 = tupleTypeSmaller.computeCommonType(tupleTypeLarger, null);
        TypeTest.assertNotNull((Object)type1);
        TypeTest.assertTrue((boolean)(type1 instanceof TupleType));
        TypeTest.assertTrue((boolean)(((TupleType)type1).elementTypes[0] instanceof MemberType));
        TypeTest.assertTrue((boolean)(((TupleType)type1).elementTypes[1] instanceof MemberType));
        TypeTest.assertTrue((boolean)(((TupleType)type1).elementTypes[2] instanceof ScalarType));
        Type type2 = tupleTypeLarger.computeCommonType(tupleTypeSmaller, null);
        TypeTest.assertNotNull((Object)type2);
        TypeTest.assertTrue((boolean)(type2 instanceof TupleType));
        TypeTest.assertTrue((boolean)(((TupleType)type2).elementTypes[0] instanceof MemberType));
        TypeTest.assertTrue((boolean)(((TupleType)type2).elementTypes[1] instanceof MemberType));
        TypeTest.assertTrue((boolean)(((TupleType)type2).elementTypes[2] instanceof ScalarType));
        TypeTest.assertEquals((Object)type1, (Object)type2);
    }

    private MemberType getStoreMemberType(Member storeChild) {
        return new MemberType(storeChild.getDimension(), storeChild.getDimension().getHierarchy(), storeChild.getLevel(), storeChild);
    }

    private Member getStoreChild() {
        ArrayList<Id.Segment> storeParts = new ArrayList<Id.Segment>();
        storeParts.add(new Id.Segment("Store", Id.Quoting.UNQUOTED));
        storeParts.add(new Id.Segment("All Stores", Id.Quoting.UNQUOTED));
        storeParts.add(new Id.Segment("USA", Id.Quoting.UNQUOTED));
        storeParts.add(new Id.Segment("CA", Id.Quoting.UNQUOTED));
        return this.getSalesCubeSchemaReader().getMemberByUniqueName(storeParts, false);
    }

    private MemberType getMemberTypeHavingMaleChild(Member maleChild) {
        return new MemberType(maleChild.getDimension(), maleChild.getDimension().getHierarchy(), maleChild.getLevel(), maleChild);
    }

    private MemberType getMemberTypeHavingMeasureInIt(Member unitSalesMeasure) {
        return new MemberType(unitSalesMeasure.getDimension(), unitSalesMeasure.getDimension().getHierarchy(), unitSalesMeasure.getDimension().getHierarchy().getLevels()[0], unitSalesMeasure);
    }

    private Member getMaleChild() {
        ArrayList<Id.Segment> genderParts = new ArrayList<Id.Segment>();
        genderParts.add(new Id.Segment("Gender", Id.Quoting.UNQUOTED));
        genderParts.add(new Id.Segment("M", Id.Quoting.UNQUOTED));
        return this.getSalesCubeSchemaReader().getMemberByUniqueName(genderParts, false);
    }

    private Member getUnitSalesMeasure() {
        ArrayList<Id.Segment> measureParts = new ArrayList<Id.Segment>();
        measureParts.add(new Id.Segment("Measures", Id.Quoting.UNQUOTED));
        measureParts.add(new Id.Segment("Unit Sales", Id.Quoting.UNQUOTED));
        return this.getSalesCubeSchemaReader().getMemberByUniqueName(measureParts, false);
    }

    private SchemaReader getSalesCubeSchemaReader() {
        return this.getCubeWithName("Sales", this.getSchemaReader().getCubes()).getSchemaReader(this.testContext.getConnection().getRole());
    }

    private SchemaReader getSchemaReader() {
        return this.testContext.getConnection().getSchemaReader();
    }

    private Cube getCubeWithName(String cubeName, Cube[] cubes) {
        Cube resultCube = null;
        for (Cube cube : cubes) {
            if (!cubeName.equals(cube.getName())) continue;
            resultCube = cube;
            break;
        }
        return resultCube;
    }
}

