/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.List;
import mondrian.olap.CacheControl;
import mondrian.olap.Connection;
import mondrian.olap.Cube;
import mondrian.olap.Id;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Query;
import mondrian.olap.Result;
import mondrian.olap.Util;
import mondrian.rolap.BitKey;
import mondrian.rolap.FastBatchingCellReader;
import mondrian.rolap.GroupingSetsCollector;
import mondrian.rolap.MemberCacheHelper;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.SmartMemberReader;
import mondrian.rolap.StarPredicate;
import mondrian.rolap.agg.AndPredicate;
import mondrian.rolap.agg.CellRequest;
import mondrian.rolap.agg.GroupingSet;
import mondrian.rolap.agg.OrPredicate;
import mondrian.rolap.agg.ValueColumnPredicate;
import mondrian.spi.Dialect;
import mondrian.test.FoodMartTestCase;
import mondrian.test.SqlPattern;
import mondrian.test.TestContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchTestCase
extends FoodMartTestCase {
    protected final String tableTime = "time_by_day";
    protected final String tableProductClass = "product_class";
    protected final String tableCustomer = "customer";
    protected final String fieldYear = "the_year";
    protected final String fieldProductFamily = "product_family";
    protected final String fieldProductDepartment = "product_department";
    protected final String[] fieldValuesYear = new String[]{"1997"};
    protected final String[] fieldValuesProductFamily = new String[]{"Food", "Non-Consumable", "Drink"};
    protected final String[] fieldValueProductDepartment = new String[]{"Alcoholic Beverages", "Baked Goods", "Baking Goods", "Beverages", "Breakfast Foods", "Canned Foods", "Canned Products", "Carousel", "Checkout", "Dairy", "Deli", "Eggs", "Frozen Foods", "Health and Hygiene", "Household", "Meat", "Packaged Foods", "Periodicals", "Produce", "Seafood", "Snack Foods", "Snacks", "Starchy Foods"};
    protected final String[] fieldValuesGender = new String[]{"M", "F"};
    protected final String cubeNameSales = "Sales";
    protected final String measureUnitSales = "[Measures].[Unit Sales]";
    protected String fieldGender = "gender";

    public BatchTestCase(String name) {
        super(name);
    }

    public BatchTestCase() {
    }

    protected FastBatchingCellReader.Batch createBatch(FastBatchingCellReader fbcr, String[] tableNames, String[] fieldNames, String[][] fieldValues, String cubeName, String measure) {
        ArrayList<String> values = new ArrayList<String>();
        for (int i = 0; i < tableNames.length; ++i) {
            values.add(fieldValues[i][0]);
        }
        FastBatchingCellReader fastBatchingCellReader = fbcr;
        fastBatchingCellReader.getClass();
        FastBatchingCellReader.Batch batch = new FastBatchingCellReader.Batch(fastBatchingCellReader, this.createRequest(cubeName, measure, tableNames, fieldNames, values.toArray(new String[values.size()])));
        this.addRequests(batch, cubeName, measure, tableNames, fieldNames, fieldValues, new ArrayList<String>(), 0);
        return batch;
    }

    protected FastBatchingCellReader.Batch createBatch(FastBatchingCellReader fbcr, String[] tableNames, String[] fieldNames, String[][] fieldValues, String cubeName, String measure, CellRequestConstraint constraint) {
        ArrayList<String> values = new ArrayList<String>();
        for (int i = 0; i < tableNames.length; ++i) {
            values.add(fieldValues[i][0]);
        }
        FastBatchingCellReader fastBatchingCellReader = fbcr;
        fastBatchingCellReader.getClass();
        FastBatchingCellReader.Batch batch = new FastBatchingCellReader.Batch(fastBatchingCellReader, this.createRequest(cubeName, measure, tableNames, fieldNames, values.toArray(new String[values.size()]), constraint));
        this.addRequests(batch, cubeName, measure, tableNames, fieldNames, fieldValues, new ArrayList<String>(), 0, constraint);
        return batch;
    }

    private void addRequests(FastBatchingCellReader.Batch batch, String cubeName, String measure, String[] tableNames, String[] fieldNames, String[][] fieldValues, List<String> selectedValues, int currPos) {
        if (currPos < fieldNames.length) {
            for (int j = 0; j < fieldValues[currPos].length; ++j) {
                selectedValues.add(fieldValues[currPos][j]);
                this.addRequests(batch, cubeName, measure, tableNames, fieldNames, fieldValues, selectedValues, currPos + 1);
                selectedValues.remove(fieldValues[currPos][j]);
            }
        } else {
            batch.add(this.createRequest(cubeName, measure, tableNames, fieldNames, selectedValues.toArray(new String[selectedValues.size()])));
        }
    }

    private void addRequests(FastBatchingCellReader.Batch batch, String cubeName, String measure, String[] tableNames, String[] fieldNames, String[][] fieldValues, List<String> selectedValues, int currPos, CellRequestConstraint constraint) {
        if (currPos < fieldNames.length) {
            for (int j = 0; j < fieldValues[currPos].length; ++j) {
                selectedValues.add(fieldValues[currPos][j]);
                this.addRequests(batch, cubeName, measure, tableNames, fieldNames, fieldValues, selectedValues, currPos + 1, constraint);
                selectedValues.remove(fieldValues[currPos][j]);
            }
        } else {
            batch.add(this.createRequest(cubeName, measure, tableNames, fieldNames, selectedValues.toArray(new String[selectedValues.size()]), constraint));
        }
    }

    protected GroupingSet getGroupingSet(String[] tableNames, String[] fieldNames, String[][] fieldValues, String cubeName, String measure) {
        FastBatchingCellReader.Batch batch = this.createBatch(new FastBatchingCellReader(this.getCube(cubeName)), tableNames, fieldNames, fieldValues, cubeName, measure);
        GroupingSetsCollector collector = new GroupingSetsCollector(true);
        batch.loadAggregation(collector);
        return collector.getGroupingSets().get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void assertRequestSql(CellRequest[] requests, SqlPattern[] patterns) {
        String warnDialect;
        RolapStar star = requests[0].getMeasure().getStar();
        String cubeName = requests[0].getMeasure().getCubeName();
        RolapCube cube = this.lookupCube(cubeName);
        Dialect sqlDialect = star.getSqlQueryDialect();
        Dialect.DatabaseProduct d = sqlDialect.getDatabaseProduct();
        SqlPattern sqlPattern = SqlPattern.getPattern(d, patterns);
        if (d == Dialect.DatabaseProduct.UNKNOWN) {
            return;
        }
        boolean patternFound = false;
        for (SqlPattern pattern : patterns) {
            Bomb bomb;
            if (!pattern.hasDatabaseProduct(d)) continue;
            patternFound = true;
            this.clearCache(cube);
            String sql = sqlPattern.getSql();
            String trigger = sqlPattern.getTriggerSql();
            switch (d) {
                case ORACLE: {
                    sql = sql.replaceAll(" =as= ", " ");
                    trigger = trigger.replaceAll(" =as= ", " ");
                    break;
                }
                case TERADATA: {
                    sql = sql.replaceAll(" =as= ", " as ");
                    trigger = trigger.replaceAll(" =as= ", " as ");
                }
            }
            RolapUtil.threadHooks.set(new TriggerHook(trigger));
            try {
                FastBatchingCellReader fbcr = new FastBatchingCellReader(this.getCube(cubeName));
                for (CellRequest request : requests) {
                    fbcr.recordCellRequest(request);
                }
                fbcr.loadAggregations();
                bomb = null;
            }
            catch (Bomb e) {
                bomb = e;
            }
            finally {
                RolapUtil.threadHooks.set(null);
            }
            if (bomb == null) {
                BatchTestCase.fail((String)("expected query [" + sql + "] did not occur"));
            }
            TestContext.assertEqualsVerbose(BatchTestCase.replaceQuotes(sql), BatchTestCase.replaceQuotes(bomb.sql));
        }
        if (!patternFound && (warnDialect = MondrianProperties.instance().WarnIfNoPatternForDialect.get()).equals(d.toString())) {
            System.out.println("[No expected sqls found for dialect \"" + sqlDialect.toString() + "\" and test not run]");
        }
    }

    private RolapCube lookupCube(String cubeName) {
        Connection connection = TestContext.instance().getConnection();
        for (Cube cube : connection.getSchema().getCubes()) {
            if (!cube.getName().equals(cubeName)) continue;
            return (RolapCube)cube;
        }
        return null;
    }

    protected void assertQuerySql(String mdxQuery, SqlPattern[] patterns) {
        this.assertQuerySqlOrNot(this.getTestContext(), mdxQuery, patterns, false, false, true);
    }

    protected void assertQuerySql(TestContext testContext, String mdxQuery, SqlPattern[] patterns) {
        this.assertQuerySqlOrNot(testContext, mdxQuery, patterns, false, false, true);
    }

    protected void assertNoQuerySql(String mdxQuery, SqlPattern[] patterns) {
        this.assertQuerySqlOrNot(this.getTestContext(), mdxQuery, patterns, true, false, true);
    }

    protected void assertQuerySql(String mdxQuery, SqlPattern[] patterns, boolean clearCache) {
        this.assertQuerySqlOrNot(this.getTestContext(), mdxQuery, patterns, false, false, clearCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assertQuerySqlOrNot(TestContext testContext, String mdxQuery, SqlPattern[] patterns, boolean negative, boolean bypassSchemaCache, boolean clearCache) {
        String warnDialect;
        Connection connection = testContext.getConnection();
        mdxQuery = testContext.upgradeQuery(mdxQuery);
        Dialect dialect = testContext.getDialect();
        Dialect.DatabaseProduct d = dialect.getDatabaseProduct();
        boolean patternFound = false;
        for (SqlPattern sqlPattern : patterns) {
            Bomb bomb;
            if (!sqlPattern.hasDatabaseProduct(d)) continue;
            patternFound = true;
            String sql = sqlPattern.getSql();
            String trigger = sqlPattern.getTriggerSql();
            sql = this.dialectize(d, sql);
            trigger = this.dialectize(d, trigger);
            RolapUtil.threadHooks.set(new TriggerHook(trigger));
            try {
                if (bypassSchemaCache) {
                    connection = testContext.getFoodMartConnection(false);
                }
                Query query = connection.parseQuery(mdxQuery);
                if (clearCache) {
                    this.clearCache((RolapCube)query.getCube());
                }
                Result result = connection.execute(query);
                Util.discard((Object)result);
                bomb = null;
            }
            catch (Bomb e) {
                bomb = e;
            }
            finally {
                RolapUtil.threadHooks.set(null);
            }
            if (negative) {
                if (bomb == null) continue;
                BatchTestCase.fail((String)("forbidden query [" + sql + "] detected"));
                continue;
            }
            if (bomb == null) {
                BatchTestCase.fail((String)("expected query [" + sql + "] did not occur"));
            }
            BatchTestCase.assertEquals((String)BatchTestCase.replaceQuotes(sql), (String)BatchTestCase.replaceQuotes(bomb.sql));
        }
        if (!patternFound && (warnDialect = MondrianProperties.instance().WarnIfNoPatternForDialect.get()).equals(d.toString())) {
            System.out.println("[No expected sqls found for dialect \"" + dialect.toString() + "\" and test not run]");
        }
    }

    protected String dialectize(Dialect.DatabaseProduct d, String sql) {
        switch (d) {
            case ORACLE: {
                return sql.replaceAll(" =as= ", " ");
            }
            case TERADATA: {
                return sql.replaceAll(" =as= ", " as ");
            }
            case DERBY: {
                return sql.replaceAll("`", "\"");
            }
        }
        return sql;
    }

    private void clearCache(RolapCube cube) {
        Cube salesCube = this.getConnection().getSchema().lookupCube("Sales", true);
        RolapHierarchy hierarchy = (RolapHierarchy)salesCube.lookupHierarchy(new Id.Segment("Store", Id.Quoting.UNQUOTED), false);
        SmartMemberReader memberReader = (SmartMemberReader)hierarchy.getMemberReader();
        MemberCacheHelper cacheHelper = memberReader.cacheHelper;
        cacheHelper.mapLevelToMembers.cache.clear();
        cacheHelper.mapMemberToChildren.cache.clear();
        cube.clearCachedAggregations(true);
        CacheControl cacheControl = this.getConnection().getCacheControl(null);
        CacheControl.CellRegion measuresRegion = cacheControl.createMeasuresRegion(cube);
        cacheControl.flush(measuresRegion);
    }

    private static String replaceQuotes(String s) {
        s = s.replace('`', '\"');
        s = s.replace('\'', '\"');
        return s;
    }

    CellRequest createRequest(String cube, String measure, String table, String column, String value) {
        return this.createRequest(cube, measure, new String[]{table}, new String[]{column}, new String[]{value});
    }

    CellRequest createRequest(String cube, String measureName, String[] tables, String[] columns, String[] values) {
        RolapStar.Measure starMeasure = this.getMeasure(cube, measureName);
        CellRequest request = new CellRequest(starMeasure, false, false);
        RolapStar star = starMeasure.getStar();
        for (int i = 0; i < tables.length; ++i) {
            String table = tables[i];
            if (table == null || table.length() <= 0) continue;
            String column = columns[i];
            String value = values[i];
            RolapStar.Column storeTypeColumn = star.lookupColumn(table, column);
            request.addConstrainedColumn(storeTypeColumn, new ValueColumnPredicate(storeTypeColumn, value));
        }
        return request;
    }

    CellRequest createRequest(String cube, String measure, String table, String column, String value, CellRequestConstraint aggConstraint) {
        return this.createRequest(cube, measure, new String[]{table}, new String[]{column}, new String[]{value}, aggConstraint);
    }

    CellRequest createRequest(String cube, String measureName, String[] tables, String[] columns, String[] values, CellRequestConstraint aggConstraint) {
        RolapStar.Measure starMeasure = this.getMeasure(cube, measureName);
        CellRequest request = this.createRequest(cube, measureName, tables, columns, values);
        RolapStar star = starMeasure.getStar();
        request.addAggregateList(aggConstraint.getBitKey(star), aggConstraint.toPredicate(star));
        return request;
    }

    static CellRequestConstraint makeConstraintYearQuarterMonth(List<String[]> values) {
        String[] aggConstraintTables = new String[]{"time_by_day", "time_by_day", "time_by_day"};
        String[] aggConstraintColumns = new String[]{"the_year", "quarter", "month_of_year"};
        ArrayList<String[]> aggConstraintValues = new ArrayList<String[]>();
        for (String[] value : values) {
            assert (value.length == 3);
            aggConstraintValues.add(value);
        }
        return new CellRequestConstraint(aggConstraintTables, aggConstraintColumns, aggConstraintValues);
    }

    static CellRequestConstraint makeConstraintCountryState(List<String[]> values) {
        String[] aggConstraintTables = new String[]{"store", "store"};
        String[] aggConstraintColumns = new String[]{"store_country", "store_state"};
        ArrayList<String[]> aggConstraintValues = new ArrayList<String[]>();
        for (String[] value : values) {
            assert (value.length == 2);
            aggConstraintValues.add(value);
        }
        return new CellRequestConstraint(aggConstraintTables, aggConstraintColumns, aggConstraintValues);
    }

    static CellRequestConstraint makeConstraintProductFamilyDepartment(List<String[]> values) {
        String[] aggConstraintTables = new String[]{"product_class", "product_class"};
        String[] aggConstraintColumns = new String[]{"product_family", "product_department"};
        ArrayList<String[]> aggConstraintValues = new ArrayList<String[]>();
        for (String[] value : values) {
            assert (value.length == 2);
            aggConstraintValues.add(value);
        }
        return new CellRequestConstraint(aggConstraintTables, aggConstraintColumns, aggConstraintValues);
    }

    protected RolapStar.Measure getMeasure(String cube, String measureName) {
        Connection connection = this.getFoodMartConnection();
        boolean fail = true;
        Cube salesCube = connection.getSchema().lookupCube(cube, true);
        Member measure = salesCube.getSchemaReader(null).getMemberByUniqueName(Util.parseIdentifier(measureName), true);
        return RolapStar.getStarMeasure(measure);
    }

    protected Connection getFoodMartConnection() {
        return TestContext.instance().getFoodMartConnection();
    }

    protected RolapCube getCube(String cube) {
        Connection connection = this.getFoodMartConnection();
        boolean fail = true;
        return (RolapCube)connection.getSchema().lookupCube(cube, true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CellRequestConstraint {
        String[] tables;
        String[] columns;
        List<String[]> valueList;

        CellRequestConstraint(String[] tables, String[] columns, List<String[]> valueList) {
            this.tables = tables;
            this.columns = columns;
            this.valueList = valueList;
        }

        BitKey getBitKey(RolapStar star) {
            return star.getBitKey(this.tables, this.columns);
        }

        StarPredicate toPredicate(RolapStar star) {
            RolapStar.Column[] starColumn = new RolapStar.Column[this.tables.length];
            for (int i = 0; i < this.tables.length; ++i) {
                String table = this.tables[i];
                String column = this.columns[i];
                starColumn[i] = star.lookupColumn(table, column);
            }
            ArrayList<StarPredicate> orPredList = new ArrayList<StarPredicate>();
            for (String[] values : this.valueList) {
                assert (values.length == this.tables.length);
                ArrayList<StarPredicate> andPredList = new ArrayList<StarPredicate>();
                for (int i = 0; i < values.length; ++i) {
                    andPredList.add(new ValueColumnPredicate(starColumn[i], values[i]));
                }
                StarPredicate predicate = andPredList.size() == 1 ? (StarPredicate)andPredList.get(0) : new AndPredicate(andPredList);
                orPredList.add(predicate);
            }
            return orPredList.size() == 1 ? (StarPredicate)orPredList.get(0) : new OrPredicate(orPredList);
        }
    }

    private static class TriggerHook
    implements RolapUtil.ExecuteQueryHook {
        private final String trigger;

        public TriggerHook(String trigger) {
            this.trigger = trigger;
        }

        private boolean matchTrigger(String sql) {
            if (this.trigger == null) {
                return true;
            }
            String s = BatchTestCase.replaceQuotes(sql);
            String t = BatchTestCase.replaceQuotes(this.trigger);
            return s.startsWith(t);
        }

        public void onExecuteQuery(String sql) {
            if (this.matchTrigger(sql)) {
                throw new Bomb(sql);
            }
        }
    }

    static class Bomb
    extends Error {
        final String sql;

        Bomb(String sql) {
            this.sql = sql;
        }
    }
}

