/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import mondrian.olap.CacheControl;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.Util;
import mondrian.rolap.BitKey;
import mondrian.rolap.CacheControlImpl;
import mondrian.rolap.CellReader;
import mondrian.rolap.RolapCacheRegion;
import mondrian.rolap.RolapCell;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapCubeHierarchy;
import mondrian.rolap.RolapCubeLevel;
import mondrian.rolap.RolapCubeMember;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapStoredMeasure;
import mondrian.rolap.StarPredicate;
import mondrian.rolap.agg.CellRequest;
import mondrian.rolap.agg.MemberColumnPredicate;
import mondrian.rolap.agg.OrPredicate;
import mondrian.rolap.agg.RangeColumnPredicate;
import mondrian.rolap.agg.ValueColumnPredicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RolapAggregationManager {
    protected RolapAggregationManager() {
    }

    public static CellRequest makeRequest(Member[] members) {
        return RolapAggregationManager.makeCellRequest(members, false, false, null);
    }

    public static CellRequest makeDrillThroughRequest(Member[] members, boolean extendedContext, RolapCube cube) {
        assert (cube != null);
        return RolapAggregationManager.makeCellRequest(members, true, extendedContext, cube);
    }

    public static CellRequest makeRequest(RolapEvaluator evaluator) {
        Member[] currentMembers = evaluator.getMembers();
        List<List<Member[]>> aggregationLists = evaluator.getAggregationLists();
        RolapStoredMeasure measure = (RolapStoredMeasure)currentMembers[0];
        RolapStar.Measure starMeasure = (RolapStar.Measure)measure.getStarMeasure();
        assert (starMeasure != null);
        int starColumnCount = starMeasure.getStar().getColumnCount();
        CellRequest request = RolapAggregationManager.makeCellRequest(currentMembers, false, false, null);
        if (aggregationLists == null) {
            return request;
        }
        for (List<Member[]> aggregationList : aggregationLists) {
            BitKey compoundBitKey = BitKey.Factory.makeBitKey(starColumnCount);
            compoundBitKey.clear();
            LinkedHashMap<BitKey, List<RolapCubeMember[]>> compoundGroupMap = new LinkedHashMap<BitKey, List<RolapCubeMember[]>>();
            ArrayList<RolapMember[]> rolapAggregationList = new ArrayList<RolapMember[]>();
            for (Member[] members : aggregationList) {
                RolapMember[] rolapMembers = new RolapMember[members.length];
                System.arraycopy(members, 0, rolapMembers, 0, members.length);
                rolapAggregationList.add(rolapMembers);
            }
            boolean unsatisfiable = RolapAggregationManager.makeCompoundGroup(starColumnCount, measure.getCube(), rolapAggregationList, compoundGroupMap);
            if (unsatisfiable) {
                return null;
            }
            StarPredicate compoundPredicate = RolapAggregationManager.makeCompoundPredicate(compoundGroupMap, measure.getCube());
            if (compoundPredicate == null) continue;
            for (BitKey bitKey : compoundGroupMap.keySet()) {
                compoundBitKey = compoundBitKey.or(bitKey);
            }
            request.addAggregateList(compoundBitKey, compoundPredicate);
        }
        return request;
    }

    private static CellRequest makeCellRequest(Member[] members, boolean drillThrough, boolean extendedContext, RolapCube cube) {
        RolapStoredMeasure measure;
        assert (drillThrough == (cube != null));
        if (extendedContext) assert (drillThrough);
        if (drillThrough) {
            if ((cube = RolapCell.chooseDrillThroughCube(members, cube)) == null) {
                return null;
            }
            measure = members[0] instanceof RolapStoredMeasure ? (RolapStoredMeasure)members[0] : (RolapStoredMeasure)cube.getMeasures().get(0);
        } else if (members[0] instanceof RolapStoredMeasure) {
            measure = (RolapStoredMeasure)members[0];
        } else {
            return null;
        }
        RolapStar.Measure starMeasure = (RolapStar.Measure)measure.getStarMeasure();
        assert (starMeasure != null);
        CellRequest request = new CellRequest(starMeasure, extendedContext, drillThrough);
        if (extendedContext) {
            for (int i = 1; i < members.length; ++i) {
                RolapCubeMember member = (RolapCubeMember)members[i];
                RolapAggregationManager.addNonConstrainingColumns(member, measure.getCube(), request);
                RolapCubeLevel level = member.getLevel();
                boolean needToReturnNull = level.getLevelReader().constrainRequest(member, measure.getCube(), request);
                if (!needToReturnNull) continue;
                return null;
            }
        } else {
            for (int i = 1; i < members.length; ++i) {
                RolapCubeMember member;
                RolapCubeLevel level;
                boolean needToReturnNull;
                if (!(members[i] instanceof RolapCubeMember) || !(needToReturnNull = (level = (member = (RolapCubeMember)members[i]).getLevel()).getLevelReader().constrainRequest(member, measure.getCube(), request))) continue;
                return null;
            }
        }
        return request;
    }

    private static void addNonConstrainingColumns(RolapCubeMember member, RolapCube baseCube, CellRequest request) {
        RolapCubeHierarchy hierarchy = member.getHierarchy();
        Level[] levels = hierarchy.getLevels();
        int depth = member.getLevel().getDepth();
        for (int j = levels.length - 1; j > depth; --j) {
            RolapCubeLevel level = (RolapCubeLevel)levels[j];
            RolapStar.Column column = level.getBaseStarKeyColumn(baseCube);
            if (column == null) continue;
            request.addConstrainedColumn(column, null);
            if (!request.extendedContext || level.getNameExp() == null) continue;
            RolapStar.Column nameColumn = column.getNameColumn();
            Util.assertTrue(nameColumn != null);
            request.addConstrainedColumn(nameColumn, null);
        }
    }

    private static boolean makeCompoundGroup(int starColumnCount, RolapCube baseCube, List<RolapMember[]> aggregationList, Map<BitKey, List<RolapCubeMember[]>> compoundGroupMap) {
        int unsatisfiableTupleCount = 0;
        for (RolapMember[] aggregation : aggregationList) {
            if (aggregation.length <= 0 || !(aggregation[0] instanceof RolapCubeMember)) {
                ++unsatisfiableTupleCount;
                continue;
            }
            boolean isTuple = true;
            BitKey bitKey = BitKey.Factory.makeBitKey(starColumnCount);
            RolapCubeMember[] tuple = new RolapCubeMember[aggregation.length];
            int i = 0;
            for (RolapMember member : aggregation) {
                tuple[i] = (RolapCubeMember)member;
                ++i;
            }
            boolean tupleUnsatisfiable = false;
            for (RolapCubeMember member : tuple) {
                tupleUnsatisfiable = RolapAggregationManager.makeCompoundGroupForMember(member, baseCube, bitKey);
                if (!tupleUnsatisfiable) continue;
                ++unsatisfiableTupleCount;
                break;
            }
            if (tupleUnsatisfiable || bitKey.isEmpty()) continue;
            RolapAggregationManager.addTupleToCompoundGroupMap(tuple, bitKey, compoundGroupMap);
        }
        return unsatisfiableTupleCount == aggregationList.size();
    }

    private static void addTupleToCompoundGroupMap(RolapCubeMember[] tuple, BitKey bitKey, Map<BitKey, List<RolapCubeMember[]>> compoundGroupMap) {
        List<RolapCubeMember[]> compoundGroup = compoundGroupMap.get(bitKey);
        if (compoundGroup == null) {
            compoundGroup = new ArrayList<RolapCubeMember[]>();
            compoundGroupMap.put(bitKey, compoundGroup);
        }
        compoundGroup.add(tuple);
    }

    private static boolean makeCompoundGroupForMember(RolapCubeMember member, RolapCube baseCube, BitKey bitKey) {
        boolean memberUnsatisfiable = false;
        for (RolapCubeMember levelMember = member; levelMember != null; levelMember = levelMember.getParentMember()) {
            RolapCubeLevel level = levelMember.getLevel();
            if (level.isAll()) continue;
            RolapStar.Column column = level.getBaseStarKeyColumn(baseCube);
            if (column != null) {
                bitKey.set(column.getBitPosition());
                continue;
            }
            memberUnsatisfiable = true;
            break;
        }
        return memberUnsatisfiable;
    }

    private static StarPredicate makeCompoundPredicate(Map<BitKey, List<RolapCubeMember[]>> compoundGroupMap, RolapCube baseCube) {
        ArrayList<StarPredicate> compoundPredicateList = new ArrayList<StarPredicate>();
        for (List<RolapCubeMember[]> group : compoundGroupMap.values()) {
            StarPredicate compoundGroupPredicate = null;
            for (RolapCubeMember[] tuple : group) {
                StarPredicate tuplePredicate = null;
                for (RolapCubeMember member : tuple) {
                    tuplePredicate = RolapAggregationManager.makeCompoundPredicateForMember(member, baseCube, tuplePredicate);
                }
                if (tuplePredicate == null) continue;
                if (compoundGroupPredicate == null) {
                    compoundGroupPredicate = tuplePredicate;
                    continue;
                }
                compoundGroupPredicate = compoundGroupPredicate.or(tuplePredicate);
            }
            if (compoundGroupPredicate == null) continue;
            compoundPredicateList.add(compoundGroupPredicate);
        }
        StarPredicate compoundPredicate = null;
        if (compoundPredicateList.size() > 1) {
            compoundPredicate = new OrPredicate(compoundPredicateList);
        } else if (compoundPredicateList.size() == 1) {
            compoundPredicate = (StarPredicate)compoundPredicateList.get(0);
        }
        return compoundPredicate;
    }

    private static StarPredicate makeCompoundPredicateForMember(RolapCubeMember member, RolapCube baseCube, StarPredicate memberPredicate) {
        while (member != null) {
            RolapCubeLevel level = member.getLevel();
            if (!level.isAll()) {
                RolapStar.Column column = level.getBaseStarKeyColumn(baseCube);
                memberPredicate = memberPredicate == null ? new ValueColumnPredicate(column, member.getKey()) : memberPredicate.and(new ValueColumnPredicate(column, member.getKey()));
            }
            if (member.getLevel().isUnique()) break;
            member = member.getParentMember();
        }
        return memberPredicate;
    }

    public abstract Object getCellFromCache(CellRequest var1);

    public abstract Object getCellFromCache(CellRequest var1, PinSet var2);

    public abstract String getDrillThroughSql(CellRequest var1, boolean var2);

    public CacheControl getCacheControl(final PrintWriter pw) {
        return new CacheControlImpl(){

            protected void flushNonUnion(CacheControl.CellRegion region) {
                List<RolapStar> starList = 1.getStarList(region);
                for (RolapStar star : starList) {
                    star.flush(this, region);
                }
            }

            public void flush(CacheControl.CellRegion region) {
                if (pw != null) {
                    pw.println("Cache state before flush:");
                    this.printCacheState(pw, region);
                    pw.println();
                }
                super.flush(region);
                if (pw != null) {
                    pw.println("Cache state after flush:");
                    this.printCacheState(pw, region);
                    pw.println();
                }
            }

            public void trace(String message) {
                if (pw != null) {
                    pw.println(message);
                }
            }
        };
    }

    public static RolapCacheRegion makeCacheRegion(RolapStar star, CacheControl.CellRegion region) {
        List<Member> measureList = CacheControlImpl.findMeasures(region);
        ArrayList<RolapStar.Measure> starMeasureList = new ArrayList<RolapStar.Measure>();
        RolapCube baseCube = null;
        for (Member measure : measureList) {
            if (!(measure instanceof RolapStoredMeasure)) continue;
            RolapStoredMeasure storedMeasure = (RolapStoredMeasure)measure;
            RolapStar.Measure starMeasure = (RolapStar.Measure)storedMeasure.getStarMeasure();
            assert (starMeasure != null);
            if (star != starMeasure.getStar()) continue;
            baseCube = storedMeasure.getCube();
            starMeasureList.add(starMeasure);
        }
        RolapCacheRegion cacheRegion = new RolapCacheRegion(star, starMeasureList);
        if (region instanceof CacheControlImpl.CrossjoinCellRegion) {
            CacheControlImpl.CrossjoinCellRegion crossjoin = (CacheControlImpl.CrossjoinCellRegion)region;
            for (CacheControl.CellRegion component : crossjoin.getComponents()) {
                RolapAggregationManager.constrainCacheRegion(cacheRegion, baseCube, component);
            }
        } else {
            RolapAggregationManager.constrainCacheRegion(cacheRegion, baseCube, region);
        }
        return cacheRegion;
    }

    private static void constrainCacheRegion(RolapCacheRegion cacheRegion, RolapCube baseCube, CacheControl.CellRegion region) {
        if (region instanceof CacheControlImpl.MemberCellRegion) {
            CacheControlImpl.MemberCellRegion memberCellRegion = (CacheControlImpl.MemberCellRegion)region;
            List<Member> memberList = memberCellRegion.getMemberList();
            for (Member member : memberList) {
                if (member.isMeasure()) continue;
                RolapCubeMember rolapMember = (RolapCubeMember)member;
                RolapCubeLevel level = rolapMember.getLevel();
                RolapStar.Column column = level.getBaseStarKeyColumn(baseCube);
                level.getLevelReader().constrainRegion(new MemberColumnPredicate(column, rolapMember), baseCube, cacheRegion);
            }
        } else if (region instanceof CacheControlImpl.MemberRangeCellRegion) {
            CacheControlImpl.MemberRangeCellRegion rangeRegion = (CacheControlImpl.MemberRangeCellRegion)region;
            RolapCubeLevel level = (RolapCubeLevel)rangeRegion.getLevel();
            RolapStar.Column column = level.getBaseStarKeyColumn(baseCube);
            level.getLevelReader().constrainRegion(new RangeColumnPredicate(column, rangeRegion.getLowerInclusive(), rangeRegion.getLowerBound() == null ? null : new MemberColumnPredicate(column, rangeRegion.getLowerBound()), rangeRegion.getUpperInclusive(), rangeRegion.getUpperBound() == null ? null : new MemberColumnPredicate(column, rangeRegion.getUpperBound())), baseCube, cacheRegion);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public CellReader getCacheCellReader() {
        return new CellReader(){

            public Object get(RolapEvaluator evaluator) {
                CellRequest request = RolapAggregationManager.makeRequest(evaluator);
                if (request == null || request.isUnsatisfiable()) {
                    return Util.nullValue;
                }
                return RolapAggregationManager.this.getCellFromCache(request);
            }

            public int getMissCount() {
                return 0;
            }

            public boolean isDirty() {
                return false;
            }
        };
    }

    public abstract PinSet createPinSet();

    public static interface PinSet {
    }
}

