/*
 * Decompiled with CFR 0.152.
 */
package mondrian.test;

import java.util.List;
import junit.framework.Assert;
import mondrian.olap.Access;
import mondrian.olap.Axis;
import mondrian.olap.Connection;
import mondrian.olap.Cube;
import mondrian.olap.Dimension;
import mondrian.olap.Hierarchy;
import mondrian.olap.Id;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.Position;
import mondrian.olap.Result;
import mondrian.olap.Role;
import mondrian.olap.RoleImpl;
import mondrian.olap.Schema;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.test.DelegatingTestContext;
import mondrian.test.FoodMartTestCase;
import mondrian.test.TestContext;

public class AccessControlTest
extends FoodMartTestCase {
    private static final String BiServer1574Role1 = "<Role name=\"role1\">\n <SchemaGrant access=\"none\">\n  <CubeGrant cube=\"Warehouse\" access=\"all\">\n   <HierarchyGrant hierarchy=\"[Store Size in SQFT]\" access=\"custom\" rollupPolicy=\"partial\">\n    <MemberGrant member=\"[Store Size in SQFT].[20319]\" access=\"all\"/>\n    <MemberGrant member=\"[Store Size in SQFT].[21215]\" access=\"none\"/>\n   </HierarchyGrant>\n   <HierarchyGrant hierarchy=\"[Store Type]\" access=\"custom\" rollupPolicy=\"partial\">\n    <MemberGrant member=\"[Store Type].[Supermarket]\" access=\"all\"/>\n   </HierarchyGrant>\n  </CubeGrant>\n </SchemaGrant>\n</Role>";
    private final TestContext rollupTestContext = TestContext.create(null, null, null, null, null, "<Role name=\"Role1\">\n  <SchemaGrant access=\"none\">\n    <CubeGrant cube=\"Sales\" access=\"all\">\n      <HierarchyGrant hierarchy=\"[Store]\" access=\"custom\" rollupPolicy=\"partial\">\n        <MemberGrant member=\"[Store].[USA]\" access=\"all\"/>\n        <MemberGrant member=\"[Store].[USA].[CA]\" access=\"none\"/>\n      </HierarchyGrant>\n    </CubeGrant>\n  </SchemaGrant>\n</Role>").withRole("Role1");

    public AccessControlTest(String name) {
        super(name);
    }

    public void testGrantDimensionNone() {
        Connection connection = this.getTestContext().getFoodMartConnection(false);
        TestContext testContext = this.getTestContext(connection);
        RoleImpl role = ((RoleImpl)connection.getRole()).makeMutableClone();
        Schema schema = connection.getSchema();
        Cube salesCube = schema.lookupCube("Sales", true);
        SchemaReader schemaReader = salesCube.getSchemaReader(role);
        Dimension genderDimension = (Dimension)schemaReader.lookupCompound(salesCube, Id.Segment.toList("Gender"), true, 2);
        role.grant(genderDimension, Access.NONE);
        role.makeImmutable();
        connection.setRole(role);
        testContext.assertAxisThrows("[Gender].children", "MDX object '[Gender]' not found in cube 'Sales'");
    }

    public void testRoleMemberAccessNonExistentMemberFails() {
        TestContext testContext = TestContext.create(null, null, null, null, null, "<Role name=\"Role1\">\n  <SchemaGrant access=\"none\">\n    <CubeGrant cube=\"Sales\" access=\"all\">\n      <HierarchyGrant hierarchy=\"[Store]\" access=\"custom\" rollupPolicy=\"partial\">\n        <MemberGrant member=\"[Store].[USA].[Non Existent]\" access=\"all\"/>\n      </HierarchyGrant>\n    </CubeGrant>\n  </SchemaGrant>\n</Role>").withRole("Role1");
        testContext.assertThrows("select {[Store].Children} on 0 from [Sales]", "Member '[Store].[USA].[Non Existent]' not found");
    }

    public void testRoleMemberAccess() {
        Connection connection = this.getRestrictedConnection();
        this.assertMemberAccess(connection, Access.CUSTOM, "[Store].[USA]");
        this.assertMemberAccess(connection, Access.ALL, "[Store].[Mexico]");
        this.assertMemberAccess(connection, Access.NONE, "[Store].[Mexico].[DF]");
        this.assertMemberAccess(connection, Access.NONE, "[Store].[Mexico].[DF].[Mexico City]");
        this.assertMemberAccess(connection, Access.NONE, "[Store].[Canada]");
        this.assertMemberAccess(connection, Access.NONE, "[Store].[Canada].[BC].[Vancouver]");
        this.assertMemberAccess(connection, Access.ALL, "[Store].[USA].[CA].[Los Angeles]");
        this.assertMemberAccess(connection, Access.NONE, "[Store].[USA].[CA].[San Diego]");
        this.assertMemberAccess(connection, Access.NONE, "[Store].[USA].[OR].[Portland]");
        this.assertMemberAccess(connection, Access.NONE, "[Store].[USA].[WA].[Seattle]");
        this.assertMemberAccess(connection, Access.NONE, "[Store].[USA].[WA]");
        this.assertMemberAccess(connection, Access.NONE, "[Store].[All Stores]");
    }

    private void assertMemberAccess(Connection connection, Access expectedAccess, String memberName) {
        Role role = connection.getRole();
        Schema schema = connection.getSchema();
        boolean fail = true;
        Cube salesCube = schema.lookupCube("Sales", true);
        SchemaReader schemaReader = salesCube.getSchemaReader(null);
        Member member = schemaReader.getMemberByUniqueName(Util.parseIdentifier(memberName), true);
        Access actualAccess = role.getAccess(member);
        Assert.assertEquals((String)memberName, (Object)((Object)expectedAccess), (Object)((Object)actualAccess));
    }

    private void assertCubeAccess(Connection connection, Access expectedAccess, String cubeName) {
        Role role = connection.getRole();
        Schema schema = connection.getSchema();
        boolean fail = true;
        Cube cube = schema.lookupCube(cubeName, true);
        Access actualAccess = role.getAccess(cube);
        Assert.assertEquals((String)cubeName, (Object)((Object)expectedAccess), (Object)((Object)actualAccess));
    }

    private void assertHierarchyAccess(Connection connection, Access expectedAccess, String cubeName, String hierarchyName) {
        Role role = connection.getRole();
        Schema schema = connection.getSchema();
        boolean fail = true;
        Cube cube = schema.lookupCube(cubeName, true);
        SchemaReader schemaReader = cube.getSchemaReader(null);
        Hierarchy hierarchy = (Hierarchy)schemaReader.lookupCompound(cube, Util.parseIdentifier(hierarchyName), true, 3);
        Access actualAccess = role.getAccess(hierarchy);
        Assert.assertEquals((String)cubeName, (Object)((Object)expectedAccess), (Object)((Object)actualAccess));
    }

    private Role.HierarchyAccess getHierarchyAccess(Connection connection, String cubeName, String hierarchyName) {
        Role role = connection.getRole();
        Schema schema = connection.getSchema();
        boolean fail = true;
        Cube cube = schema.lookupCube(cubeName, true);
        SchemaReader schemaReader = cube.getSchemaReader(null);
        Hierarchy hierarchy = (Hierarchy)schemaReader.lookupCompound(cube, Util.parseIdentifier(hierarchyName), true, 3);
        return role.getAccessDetails(hierarchy);
    }

    public void testGrantHierarchy1a() {
        this.getRestrictedTestContext().assertAxisReturns("[Store].level.members", AccessControlTest.fold("[Store].[All Stores].[Mexico]\n[Store].[All Stores].[USA]"));
    }

    public void testGrantHierarchy1aAllMembers() {
        this.getRestrictedTestContext().assertAxisReturns("[Store].level.allmembers", AccessControlTest.fold("[Store].[All Stores].[Mexico]\n[Store].[All Stores].[USA]"));
    }

    public void testGrantHierarchy1b() {
        this.getRestrictedTestContext().assertAxisReturns("[Store].defaultMember", "[Store].[All Stores].[Mexico]");
    }

    public void testGrantHierarchy1c() {
        this.getRestrictedTestContext().assertAxisReturns("[Customers].defaultMember", "[Customers].[All Customers].[Canada].[BC]");
    }

    public void testGrantHierarchy2() {
        TestContext testContext = this.getRestrictedTestContext();
        testContext.assertAxisReturns("[Store].[All Stores].[USA].children", "[Store].[All Stores].[USA].[CA]");
        testContext.assertAxisReturns("[Store].[USA].children", "[Store].[All Stores].[USA].[CA]");
        testContext.assertAxisReturns("[Store].[USA].[CA].children", AccessControlTest.fold("[Store].[All Stores].[USA].[CA].[Los Angeles]\n[Store].[All Stores].[USA].[CA].[San Francisco]"));
    }

    public void testGrantHierarchy3() {
        TestContext testContext = this.getRestrictedTestContext();
        testContext.assertAxisThrows("[Store].[USA].[WA]", "not found");
    }

    private TestContext getRestrictedTestContext() {
        return new DelegatingTestContext(this.getTestContext()){

            public Connection getConnection() {
                return AccessControlTest.this.getRestrictedConnection();
            }
        };
    }

    public void testGrantHierarchy4() {
        TestContext testContext = this.getRestrictedTestContext();
        testContext.assertAxisThrows("[Store].[USA].[OR].children", "not found");
    }

    public void testGrantHierarchy5() {
        TestContext testContext = this.getRestrictedTestContext();
        testContext.assertAxisThrows("[Store].[All Stores]", "not found");
        testContext.assertAxisReturns("[Store].members", AccessControlTest.fold("[Store].[All Stores].[Mexico]\n[Store].[All Stores].[Mexico].[Guerrero]\n[Store].[All Stores].[Mexico].[Guerrero].[Acapulco]\n[Store].[All Stores].[Mexico].[Guerrero].[Acapulco].[Store 1]\n[Store].[All Stores].[Mexico].[Jalisco]\n[Store].[All Stores].[Mexico].[Jalisco].[Guadalajara]\n[Store].[All Stores].[Mexico].[Jalisco].[Guadalajara].[Store 5]\n[Store].[All Stores].[Mexico].[Veracruz]\n[Store].[All Stores].[Mexico].[Veracruz].[Orizaba]\n[Store].[All Stores].[Mexico].[Veracruz].[Orizaba].[Store 10]\n[Store].[All Stores].[Mexico].[Yucatan]\n[Store].[All Stores].[Mexico].[Yucatan].[Merida]\n[Store].[All Stores].[Mexico].[Yucatan].[Merida].[Store 8]\n[Store].[All Stores].[Mexico].[Zacatecas]\n[Store].[All Stores].[Mexico].[Zacatecas].[Camacho]\n[Store].[All Stores].[Mexico].[Zacatecas].[Camacho].[Store 4]\n[Store].[All Stores].[Mexico].[Zacatecas].[Hidalgo]\n[Store].[All Stores].[Mexico].[Zacatecas].[Hidalgo].[Store 12]\n[Store].[All Stores].[Mexico].[Zacatecas].[Hidalgo].[Store 18]\n[Store].[All Stores].[USA]\n[Store].[All Stores].[USA].[CA]\n[Store].[All Stores].[USA].[CA].[Los Angeles]\n[Store].[All Stores].[USA].[CA].[Los Angeles].[Store 7]\n[Store].[All Stores].[USA].[CA].[San Francisco]\n[Store].[All Stores].[USA].[CA].[San Francisco].[Store 14]"));
    }

    public void testGrantHierarchy6() {
        this.getRestrictedTestContext().assertAxisReturns("[Customers].[USA].[CA].parent", "");
    }

    public void testGrantHierarchy7() {
        TestContext testContext = this.getRestrictedTestContext();
        testContext.assertAxisThrows("[Customers].[Canada].children", "MDX object '[Customers].[Canada]' not found in cube 'Sales'");
    }

    public void testGrantHierarchy8() {
        TestContext testContext = this.getRestrictedTestContext();
        testContext.assertAxisThrows("[Customers].[USA].[CA].[San Francisco].[Catherine Abel]", "not found");
        testContext.assertAxisReturns("[Customers].[USA].[CA].[San Francisco].children", "");
        Axis axis = testContext.executeAxis("[Customers].members");
        Assert.assertEquals((int)122, (int)axis.getPositions().size());
    }

    public void testGrantHierarchy8AllMembers() {
        TestContext testContext = this.getRestrictedTestContext();
        testContext.assertAxisThrows("[Customers].[USA].[CA].[San Francisco].[Catherine Abel]", "not found");
        testContext.assertAxisReturns("[Customers].[USA].[CA].[San Francisco].children", "");
        Axis axis = testContext.executeAxis("[Customers].allmembers");
        Assert.assertEquals((int)122, (int)axis.getPositions().size());
    }

    public void testGrantHierarchy9() {
        RestrictedTestContext tc = new RestrictedTestContext();
        tc.assertQueryReturns("with member [Measures].[California Unit Sales] as  'Aggregate({[Store].[USA].[CA].children}, [Measures].[Unit Sales])'\nselect {[Measures].[California Unit Sales]} on columns,\n {[Gender].children} on rows\nfrom Sales\nwhere ([Marital Status].[S])", AccessControlTest.fold("Axis #0:\n{[Marital Status].[All Marital Status].[S]}\nAxis #1:\n{[Measures].[California Unit Sales]}\nAxis #2:\n{[Gender].[All Gender].[F]}\n{[Gender].[All Gender].[M]}\nRow #0: 6,636\nRow #1: 7,329\n"));
    }

    public void testGrantHierarchyA() {
        RestrictedTestContext tc = new RestrictedTestContext();
        tc.assertQueryReturns("select {[Unit Sales]} on columns,\n{[Store].[USA], [Store].[USA].children} on rows\nfrom [Sales]", AccessControlTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Store].[All Stores].[USA]}\n{[Store].[All Stores].[USA].[CA]}\nRow #0: 266,773\nRow #1: 74,748\n"));
    }

    public void _testSharedObjectsInGrantMappingsBug() {
        TestContext testContext = new TestContext(){

            public Connection getConnection() {
                boolean mustGet = true;
                Connection connection = super.getConnection();
                Schema schema = connection.getSchema();
                Cube salesCube = schema.lookupCube("Sales", mustGet);
                Cube warehouseCube = schema.lookupCube("Warehouse", mustGet);
                Hierarchy measuresInSales = salesCube.lookupHierarchy(new Id.Segment("Measures", Id.Quoting.UNQUOTED), false);
                Hierarchy storeInWarehouse = warehouseCube.lookupHierarchy(new Id.Segment("Store", Id.Quoting.UNQUOTED), false);
                RoleImpl role = new RoleImpl();
                role.grant(schema, Access.NONE);
                role.grant(salesCube, Access.NONE);
                Role.RollupPolicy rollupPolicy = Role.RollupPolicy.FULL;
                role.grant(measuresInSales, Access.ALL, null, null, rollupPolicy);
                role.grant(warehouseCube, Access.NONE);
                role.grant(storeInWarehouse.getDimension(), Access.ALL);
                role.makeImmutable();
                connection.setRole(role);
                return connection;
            }
        };
        testContext.assertExprThrows("[Store].DefaultMember", "'[Store]' not found in cube 'Sales'");
    }

    public void testNoAccessToCube() {
        RestrictedTestContext tc = new RestrictedTestContext();
        tc.assertThrows("select from [HR]", "MDX cube 'HR' not found");
    }

    private Connection getRestrictedConnection() {
        return this.getRestrictedConnection(true);
    }

    private Connection getRestrictedConnection(boolean restrictCustomers) {
        Connection connection = this.getTestContext().getFoodMartConnection(false);
        RoleImpl role = new RoleImpl();
        Schema schema = connection.getSchema();
        boolean fail = true;
        Cube salesCube = schema.lookupCube("Sales", true);
        SchemaReader schemaReader = salesCube.getSchemaReader(null);
        Hierarchy storeHierarchy = salesCube.lookupHierarchy(new Id.Segment("Store", Id.Quoting.UNQUOTED), false);
        role.grant(schema, Access.ALL_DIMENSIONS);
        role.grant(salesCube, Access.ALL);
        Level nationLevel = Util.lookupHierarchyLevel(storeHierarchy, "Store Country");
        Role.RollupPolicy rollupPolicy = Role.RollupPolicy.FULL;
        role.grant(storeHierarchy, Access.CUSTOM, nationLevel, null, rollupPolicy);
        role.grant(schemaReader.getMemberByUniqueName(Util.parseIdentifier("[Store].[All Stores].[USA].[OR]"), true), Access.ALL);
        role.grant(schemaReader.getMemberByUniqueName(Util.parseIdentifier("[Store].[All Stores].[USA]"), true), Access.NONE);
        role.grant(schemaReader.getMemberByUniqueName(Util.parseIdentifier("[Store].[All Stores].[USA].[CA].[San Francisco]"), true), Access.ALL);
        role.grant(schemaReader.getMemberByUniqueName(Util.parseIdentifier("[Store].[All Stores].[USA].[CA].[Los Angeles]"), true), Access.ALL);
        role.grant(schemaReader.getMemberByUniqueName(Util.parseIdentifier("[Store].[All Stores].[Mexico]"), true), Access.ALL);
        role.grant(schemaReader.getMemberByUniqueName(Util.parseIdentifier("[Store].[All Stores].[Mexico].[DF]"), true), Access.NONE);
        role.grant(schemaReader.getMemberByUniqueName(Util.parseIdentifier("[Store].[All Stores].[Canada]"), true), Access.NONE);
        if (restrictCustomers) {
            Hierarchy customersHierarchy = salesCube.lookupHierarchy(new Id.Segment("Customers", Id.Quoting.UNQUOTED), false);
            Level stateProvinceLevel = Util.lookupHierarchyLevel(customersHierarchy, "State Province");
            Level customersCityLevel = Util.lookupHierarchyLevel(customersHierarchy, "City");
            role.grant(customersHierarchy, Access.CUSTOM, stateProvinceLevel, customersCityLevel, rollupPolicy);
            role.grant(schemaReader.getMemberByUniqueName(Util.parseIdentifier("[Customers].[All Customers]"), true), Access.ALL);
        }
        Cube hrCube = schema.lookupCube("HR", true);
        role.grant(hrCube, Access.NONE);
        role.makeImmutable();
        connection.setRole(role);
        return connection;
    }

    public void testRollupPolicyBasic() {
        this.rollupTestContext.assertQueryReturns("select {[Store].[USA], [Store].[USA].Children} on 0\nfrom [Sales]", AccessControlTest.fold("Axis #0:\n{}\nAxis #1:\n{[Store].[All Stores].[USA]}\n{[Store].[All Stores].[USA].[OR]}\n{[Store].[All Stores].[USA].[WA]}\nRow #0: 192,025\nRow #0: 67,659\nRow #0: 124,366\n"));
    }

    public void testRollupPolicyAll() {
        this.rollupTestContext.assertExprReturns("([Store].[All Stores])", "192,025");
    }

    public void testRollupPolicyAllAsDefault() {
        this.rollupTestContext.assertExprReturns("([Store])", "192,025");
    }

    public void testRollupPolicyAllAsParent() {
        this.rollupTestContext.assertExprReturns("([Store].[USA].Parent)", "192,025");
    }

    public void testRollupBottomLevel() {
        this.rollupPolicyBottom(Role.RollupPolicy.FULL, "74,748", "36,759", "266,773");
        this.rollupPolicyBottom(Role.RollupPolicy.PARTIAL, "72,739", "35,775", "264,764");
        this.rollupPolicyBottom(Role.RollupPolicy.HIDDEN, "", "", "");
    }

    private void rollupPolicyBottom(Role.RollupPolicy rollupPolicy, String v1, String v2, String v3) {
        TestContext testContext = TestContext.create(null, null, null, null, null, "<Role name=\"Role1\">\n  <SchemaGrant access=\"none\">\n    <CubeGrant cube=\"Sales\" access=\"all\">\n      <HierarchyGrant hierarchy=\"[Customers]\" access=\"custom\" rollupPolicy=\"" + (Object)((Object)rollupPolicy) + "\" bottomLevel=\"[Customers].[City]\">\n" + "        <MemberGrant member=\"[Customers].[USA]\" access=\"all\"/>\n" + "        <MemberGrant member=\"[Customers].[USA].[CA].[Los Angeles]\" access=\"none\"/>\n" + "      </HierarchyGrant>\n" + "    </CubeGrant>\n" + "  </SchemaGrant>\n" + "</Role>").withRole("Role1");
        testContext.assertExprReturns("([Customers].[USA].[CA].[San Francisco])", "88");
        testContext.assertExprThrows("([Customers].[USA].[CA].[Los Angeles])", "MDX object '[Customers].[USA].[CA].[Los Angeles]' not found in cube 'Sales'");
        testContext.assertExprReturns("([Customers].[USA].[CA])", v1);
        testContext.assertExprReturns("([Customers].[USA].[CA], [Gender].[F])", v2);
        testContext.assertExprReturns("([Customers].[USA])", v3);
        this.checkQuery(testContext, "select [Customers].Children on 0, [Gender].Members on 1 from [Sales]");
    }

    private void checkQuery(TestContext testContext, String mdx) {
        Result result = testContext.executeQuery(mdx);
        SchemaReader schemaReader = testContext.getConnection().getSchemaReader();
        for (Axis axis : result.getAxes()) {
            for (Position position : axis.getPositions()) {
                for (Member member : position) {
                    Member accessControlledParent = schemaReader.getMemberParent(member);
                    if (member.getParentMember() == null) {
                        AccessControlTest.assertNull((Object)accessControlledParent);
                    }
                    List<Member> accessControlledChildren = schemaReader.getMemberChildren(member);
                    AccessControlTest.assertNotNull(accessControlledChildren);
                }
            }
        }
    }

    public void testRollupPolicyNegative() {
        TestContext testContext = TestContext.create(null, null, null, null, null, "<Role name=\"Role1\">\n  <SchemaGrant access=\"none\">\n    <CubeGrant cube=\"Sales\" access=\"all\">\n      <HierarchyGrant hierarchy=\"[Customers]\" access=\"custom\" rollupPolicy=\"bad\" bottomLevel=\"[Customers].[City]\">\n        <MemberGrant member=\"[Customers].[USA]\" access=\"all\"/>\n        <MemberGrant member=\"[Customers].[USA].[CA].[Los Angeles]\" access=\"none\"/>\n      </HierarchyGrant>\n    </CubeGrant>\n  </SchemaGrant>\n</Role>").withRole("Role1");
        testContext.assertThrows("select from [Sales]", "Illegal rollupPolicy value 'bad'");
    }

    public void testRollupPolicyGreatGrandchildInvisible() {
        this.rollupPolicyGreatGrandchildInvisible(Role.RollupPolicy.FULL, "266,773", "74,748");
        this.rollupPolicyGreatGrandchildInvisible(Role.RollupPolicy.PARTIAL, "266,767", "74,742");
        this.rollupPolicyGreatGrandchildInvisible(Role.RollupPolicy.HIDDEN, "", "");
    }

    private void rollupPolicyGreatGrandchildInvisible(Role.RollupPolicy policy, String v1, String v2) {
        TestContext testContext = TestContext.create(null, null, null, null, null, "<Role name=\"Role1\">\n  <SchemaGrant access=\"none\">\n    <CubeGrant cube=\"Sales\" access=\"all\">\n      <HierarchyGrant hierarchy=\"[Customers]\" access=\"custom\" rollupPolicy=\"" + (Object)((Object)policy) + "\">\n" + "        <MemberGrant member=\"[Customers].[USA]\" access=\"all\"/>\n" + "        <MemberGrant member=\"[Customers].[USA].[CA].[San Francisco].[Gladys Evans]\" access=\"none\"/>\n" + "      </HierarchyGrant>\n" + "    </CubeGrant>\n" + "  </SchemaGrant>\n" + "</Role>").withRole("Role1");
        testContext.assertExprReturns("[Measures].[Unit Sales]", v1);
        testContext.assertExprReturns("([Measures].[Unit Sales], [Customers].[USA])", v1);
        testContext.assertExprReturns("([Measures].[Unit Sales], [Customers].[USA].[CA])", v2);
    }

    public void testRollupPolicySimultaneous() {
        this.rollupPolicySimultaneous(Role.RollupPolicy.FULL, "266,773", "74,748", "25,635");
        this.rollupPolicySimultaneous(Role.RollupPolicy.PARTIAL, "72,631", "72,631", "25,635");
        this.rollupPolicySimultaneous(Role.RollupPolicy.HIDDEN, "", "", "");
    }

    private void rollupPolicySimultaneous(Role.RollupPolicy policy, String v1, String v2, String v3) {
        TestContext testContext = TestContext.create(null, null, null, null, null, "<Role name=\"Role1\">\n  <SchemaGrant access=\"none\">\n    <CubeGrant cube=\"Sales\" access=\"all\">\n      <HierarchyGrant hierarchy=\"[Customers]\" access=\"custom\" rollupPolicy=\"" + (Object)((Object)policy) + "\">\n" + "        <MemberGrant member=\"[Customers].[USA]\" access=\"all\"/>\n" + "        <MemberGrant member=\"[Customers].[USA].[CA].[San Francisco].[Gladys Evans]\" access=\"none\"/>\n" + "      </HierarchyGrant>\n" + "      <HierarchyGrant hierarchy=\"[Store]\" access=\"custom\" rollupPolicy=\"" + (Object)((Object)policy) + "\">\n" + "        <MemberGrant member=\"[Store].[USA].[CA]\" access=\"all\"/>\n" + "        <MemberGrant member=\"[Store].[USA].[CA].[San Francisco].[Store 14]\" access=\"none\"/>\n" + "      </HierarchyGrant>\n" + "    </CubeGrant>\n" + "  </SchemaGrant>\n" + "</Role>").withRole("Role1");
        testContext.assertExprReturns("[Measures].[Unit Sales]", v1);
        testContext.assertExprReturns("([Measures].[Unit Sales], [Customers].[USA])", v1);
        testContext.assertExprReturns("([Measures].[Unit Sales], [Customers].[USA].[CA])", v2);
        testContext.assertExprReturns("([Measures].[Unit Sales], [Customers].[USA].[CA], [Store].[USA].[CA])", v2);
        testContext.assertExprReturns("([Measures].[Unit Sales], [Customers].[USA].[CA], [Store].[USA].[CA].[San Diego])", v3);
    }

    public void testUnionRole() {
        String message;
        Connection connection;
        TestContext testContext = TestContext.create(null, null, null, null, null, "<Role name=\"Role1\">\n  <SchemaGrant access=\"none\">\n    <CubeGrant cube=\"Sales\" access=\"all\">\n      <HierarchyGrant hierarchy=\"[Customers]\" access=\"custom\" rollupPolicy=\"Partial\">\n        <MemberGrant member=\"[Customers].[USA].[CA]\" access=\"all\"/>\n        <MemberGrant member=\"[Customers].[USA].[CA].[San Francisco].[Gladys Evans]\" access=\"none\"/>\n      </HierarchyGrant>\n      <HierarchyGrant hierarchy=\"[Promotion Media]\" access=\"all\"/>\n      <HierarchyGrant hierarchy=\"[Marital Status]\" access=\"none\"/>\n      <HierarchyGrant hierarchy=\"[Gender]\" access=\"none\"/>\n      <HierarchyGrant hierarchy=\"[Store]\" access=\"custom\" rollupPolicy=\"Partial\" topLevel=\"[Store].[Store State]\"/>\n    </CubeGrant>\n    <CubeGrant cube=\"Warehouse\" access=\"all\"/>\n  </SchemaGrant>\n</Role>\n<Role name=\"Role2\">\n  <SchemaGrant access=\"none\">\n    <CubeGrant cube=\"Sales\" access=\"none\">\n      <HierarchyGrant hierarchy=\"[Customers]\" access=\"custom\" rollupPolicy=\"Hidden\">\n        <MemberGrant member=\"[Customers].[USA]\" access=\"all\"/>\n        <MemberGrant member=\"[Customers].[USA].[CA]\" access=\"none\"/>\n        <MemberGrant member=\"[Customers].[USA].[OR]\" access=\"none\"/>\n        <MemberGrant member=\"[Customers].[USA].[OR].[Portland]\" access=\"all\"/>\n      </HierarchyGrant>\n      <HierarchyGrant hierarchy=\"[Store]\" access=\"all\" rollupPolicy=\"Hidden\"/>\n    </CubeGrant>\n  </SchemaGrant>\n</Role>\n");
        try {
            connection = testContext.withRole("Role3,Role2").getConnection();
            AccessControlTest.fail((String)("expected exception, got " + connection));
        }
        catch (RuntimeException e) {
            message = e.getMessage();
            AccessControlTest.assertTrue((String)message, (message.indexOf("Role 'Role3' not found") >= 0 ? 1 : 0) != 0);
        }
        try {
            connection = testContext.withRole("Role1,Role3").getConnection();
            AccessControlTest.fail((String)("expected exception, got " + connection));
        }
        catch (RuntimeException e) {
            message = e.getMessage();
            AccessControlTest.assertTrue((String)message, (message.indexOf("Role 'Role3' not found") >= 0 ? 1 : 0) != 0);
        }
        connection = testContext.withRole("Role1,Role2").getConnection();
        this.assertCubeAccess(connection, Access.ALL, "Sales");
        this.assertCubeAccess(connection, Access.ALL, "Warehouse");
        this.assertCubeAccess(connection, Access.NONE, "Warehouse and Sales");
        this.assertHierarchyAccess(connection, Access.CUSTOM, "Sales", "[Customers]");
        this.assertHierarchyAccess(connection, Access.ALL, "Sales", "[Store]");
        this.assertHierarchyAccess(connection, Access.ALL, "Sales", "[Promotion Media]");
        this.assertHierarchyAccess(connection, Access.NONE, "Sales", "[Marital Status]");
        Role.HierarchyAccess hierarchyAccess = this.getHierarchyAccess(connection, "Sales", "[Store]");
        AccessControlTest.assertEquals((Object)((Object)Role.RollupPolicy.PARTIAL), (Object)((Object)hierarchyAccess.getRollupPolicy()));
        AccessControlTest.assertEquals((int)0, (int)hierarchyAccess.getTopLevelDepth());
        AccessControlTest.assertEquals((int)4, (int)hierarchyAccess.getBottomLevelDepth());
        this.assertMemberAccess(connection, Access.ALL, "[Customers].[USA]");
        this.assertMemberAccess(connection, Access.ALL, "[Customers].[USA].[CA]");
        this.assertMemberAccess(connection, Access.ALL, "[Customers].[USA].[OR].[Portland]");
        this.assertMemberAccess(connection, Access.CUSTOM, "[Customers].[USA].[OR]");
        this.assertMemberAccess(connection, Access.NONE, "[Customers].[USA].[OR].[Beaverton]");
        String mdx = "select Hierarchize(\n{[Customers].[USA].Children,\n [Customers].[USA].[OR].Children}) on 0\nfrom [Sales]";
        testContext.assertQueryReturns(mdx, AccessControlTest.fold("Axis #0:\n{}\nAxis #1:\n{[Customers].[All Customers].[USA].[CA]}\n{[Customers].[All Customers].[USA].[OR]}\n{[Customers].[All Customers].[USA].[OR].[Albany]}\n{[Customers].[All Customers].[USA].[OR].[Beaverton]}\n{[Customers].[All Customers].[USA].[OR].[Corvallis]}\n{[Customers].[All Customers].[USA].[OR].[Lake Oswego]}\n{[Customers].[All Customers].[USA].[OR].[Lebanon]}\n{[Customers].[All Customers].[USA].[OR].[Milwaukie]}\n{[Customers].[All Customers].[USA].[OR].[Oregon City]}\n{[Customers].[All Customers].[USA].[OR].[Portland]}\n{[Customers].[All Customers].[USA].[OR].[Salem]}\n{[Customers].[All Customers].[USA].[OR].[W. Linn]}\n{[Customers].[All Customers].[USA].[OR].[Woodburn]}\n{[Customers].[All Customers].[USA].[WA]}\nRow #0: 74,748\nRow #0: 67,659\nRow #0: 6,806\nRow #0: 4,558\nRow #0: 9,539\nRow #0: 4,910\nRow #0: 9,596\nRow #0: 5,145\nRow #0: 3,708\nRow #0: 3,583\nRow #0: 7,678\nRow #0: 4,175\nRow #0: 7,961\nRow #0: 124,366\n"));
        testContext.withRole("Role1").assertThrows(mdx, "MDX object '[Customers].[USA].[OR]' not found in cube 'Sales'");
        testContext.withRole("Role2").assertThrows(mdx, "MDX cube 'Sales' not found");
        testContext.withRole("Role1,Role2").assertQueryReturns(mdx, AccessControlTest.fold("Axis #0:\n{}\nAxis #1:\n{[Customers].[All Customers].[USA].[CA]}\n{[Customers].[All Customers].[USA].[OR]}\n{[Customers].[All Customers].[USA].[OR].[Portland]}\n{[Customers].[All Customers].[USA].[WA]}\nRow #0: 74,742\nRow #0: 3,583\nRow #0: 3,583\nRow #0: 124,366\n"));
        this.checkQuery(testContext.withRole("Role1,Role2"), mdx);
    }

    public void testNonEmptyAccess() {
        TestContext testContext = TestContext.create(null, null, null, null, null, "<Role name=\"Role1\">\n  <SchemaGrant access=\"none\">\n    <CubeGrant cube=\"Sales\" access=\"all\">\n      <HierarchyGrant hierarchy=\"[Product]\" access=\"custom\">\n        <MemberGrant member=\"[Product].[Drink]\" access=\"all\"/>\n      </HierarchyGrant>\n    </CubeGrant>\n  </SchemaGrant>\n</Role>").withRole("Role1");
        String expected = AccessControlTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Gender].[All Gender], [Product].[All Products].[Drink]}\nRow #0: 24,597\n");
        String mdx = "select {[Measures].[Unit Sales]} ON COLUMNS,  Crossjoin({[Gender].[All Gender]}, [Product].[All Products].Children) ON ROWS from [Sales]";
        testContext.assertQueryReturns("select {[Measures].[Unit Sales]} ON COLUMNS,  Crossjoin({[Gender].[All Gender]}, [Product].[All Products].Children) ON ROWS from [Sales]", expected);
        this.checkQuery(testContext, "select {[Measures].[Unit Sales]} ON COLUMNS,  Crossjoin({[Gender].[All Gender]}, [Product].[All Products].Children) ON ROWS from [Sales]");
        String mdx2 = "select {[Measures].[Unit Sales]} ON COLUMNS, NON EMPTY Crossjoin({[Gender].[All Gender]}, [Product].[All Products].Children) ON ROWS from [Sales]";
        testContext.assertQueryReturns("select {[Measures].[Unit Sales]} ON COLUMNS, NON EMPTY Crossjoin({[Gender].[All Gender]}, [Product].[All Products].Children) ON ROWS from [Sales]", expected);
        this.checkQuery(testContext, "select {[Measures].[Unit Sales]} ON COLUMNS, NON EMPTY Crossjoin({[Gender].[All Gender]}, [Product].[All Products].Children) ON ROWS from [Sales]");
    }

    public void testNonEmptyAccessLevelMembers() {
        TestContext testContext = TestContext.create(null, null, null, null, null, "<Role name=\"Role1\">\n  <SchemaGrant access=\"none\">\n    <CubeGrant cube=\"Sales\" access=\"all\">\n      <HierarchyGrant hierarchy=\"[Product]\" access=\"custom\">\n        <MemberGrant member=\"[Product].[Drink]\" access=\"all\"/>\n      </HierarchyGrant>\n    </CubeGrant>\n  </SchemaGrant>\n</Role>").withRole("Role1");
        String expected = AccessControlTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Gender].[All Gender], [Product].[All Products].[Drink]}\nRow #0: 24,597\n");
        String mdx = "select {[Measures].[Unit Sales]} ON COLUMNS,  Crossjoin({[Gender].[All Gender]}, [Product].[Product Family].Members) ON ROWS from [Sales]";
        testContext.assertQueryReturns("select {[Measures].[Unit Sales]} ON COLUMNS,  Crossjoin({[Gender].[All Gender]}, [Product].[Product Family].Members) ON ROWS from [Sales]", expected);
        this.checkQuery(testContext, "select {[Measures].[Unit Sales]} ON COLUMNS,  Crossjoin({[Gender].[All Gender]}, [Product].[Product Family].Members) ON ROWS from [Sales]");
        String mdx2 = "select {[Measures].[Unit Sales]} ON COLUMNS, NON EMPTY Crossjoin({[Gender].[All Gender]}, [Product].[Product Family].Members) ON ROWS from [Sales]";
        testContext.assertQueryReturns("select {[Measures].[Unit Sales]} ON COLUMNS, NON EMPTY Crossjoin({[Gender].[All Gender]}, [Product].[Product Family].Members) ON ROWS from [Sales]", expected);
        this.checkQuery(testContext, "select {[Measures].[Unit Sales]} ON COLUMNS, NON EMPTY Crossjoin({[Gender].[All Gender]}, [Product].[Product Family].Members) ON ROWS from [Sales]");
    }

    public void testGoodman() {
        String query = "select {[Measures].[Unit Sales]} ON COLUMNS,\nHierarchize(Union(Union(Union({[Store].[All Stores]}, [Store].[All Stores].Children), [Store].[All Stores].[USA].Children), [Store].[All Stores].[USA].[CA].Children)) ON ROWS\nfrom [Sales]\nwhere [Time].[1997]";
        TestContext testContext = AccessControlTest.goodmanContext(Role.RollupPolicy.PARTIAL);
        testContext.assertQueryReturns("select {[Measures].[Unit Sales]} ON COLUMNS,\nHierarchize(Union(Union(Union({[Store].[All Stores]}, [Store].[All Stores].Children), [Store].[All Stores].[USA].Children), [Store].[All Stores].[USA].[CA].Children)) ON ROWS\nfrom [Sales]\nwhere [Time].[1997]", AccessControlTest.fold("Axis #0:\n{[Time].[1997]}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Store].[All Stores]}\n{[Store].[All Stores].[USA]}\n{[Store].[All Stores].[USA].[CA]}\n{[Store].[All Stores].[USA].[CA].[Alameda]}\n{[Store].[All Stores].[USA].[CA].[Beverly Hills]}\n{[Store].[All Stores].[USA].[CA].[Los Angeles]}\n{[Store].[All Stores].[USA].[CA].[San Diego]}\n{[Store].[All Stores].[USA].[CA].[San Francisco]}\n{[Store].[All Stores].[USA].[OR]}\nRow #0: 100,827\nRow #1: 100,827\nRow #2: 74,748\nRow #3: \nRow #4: 21,333\nRow #5: 25,663\nRow #6: 25,635\nRow #7: 2,117\nRow #8: 26,079\n"));
        AccessControlTest.goodmanContext(Role.RollupPolicy.FULL).assertQueryReturns("select {[Measures].[Unit Sales]} ON COLUMNS,\nHierarchize(Union(Union(Union({[Store].[All Stores]}, [Store].[All Stores].Children), [Store].[All Stores].[USA].Children), [Store].[All Stores].[USA].[CA].Children)) ON ROWS\nfrom [Sales]\nwhere [Time].[1997]", AccessControlTest.fold("Axis #0:\n{[Time].[1997]}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Store].[All Stores]}\n{[Store].[All Stores].[USA]}\n{[Store].[All Stores].[USA].[CA]}\n{[Store].[All Stores].[USA].[CA].[Alameda]}\n{[Store].[All Stores].[USA].[CA].[Beverly Hills]}\n{[Store].[All Stores].[USA].[CA].[Los Angeles]}\n{[Store].[All Stores].[USA].[CA].[San Diego]}\n{[Store].[All Stores].[USA].[CA].[San Francisco]}\n{[Store].[All Stores].[USA].[OR]}\nRow #0: 266,773\nRow #1: 266,773\nRow #2: 74,748\nRow #3: \nRow #4: 21,333\nRow #5: 25,663\nRow #6: 25,635\nRow #7: 2,117\nRow #8: 67,659\n"));
        AccessControlTest.goodmanContext(Role.RollupPolicy.HIDDEN).assertQueryReturns("select {[Measures].[Unit Sales]} ON COLUMNS,\nHierarchize(Union(Union(Union({[Store].[All Stores]}, [Store].[All Stores].Children), [Store].[All Stores].[USA].Children), [Store].[All Stores].[USA].[CA].Children)) ON ROWS\nfrom [Sales]\nwhere [Time].[1997]", AccessControlTest.fold("Axis #0:\n{[Time].[1997]}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Store].[All Stores]}\n{[Store].[All Stores].[USA]}\n{[Store].[All Stores].[USA].[CA]}\n{[Store].[All Stores].[USA].[CA].[Alameda]}\n{[Store].[All Stores].[USA].[CA].[Beverly Hills]}\n{[Store].[All Stores].[USA].[CA].[Los Angeles]}\n{[Store].[All Stores].[USA].[CA].[San Diego]}\n{[Store].[All Stores].[USA].[CA].[San Francisco]}\n{[Store].[All Stores].[USA].[OR]}\nRow #0: \nRow #1: \nRow #2: 74,748\nRow #3: \nRow #4: 21,333\nRow #5: 25,663\nRow #6: 25,635\nRow #7: 2,117\nRow #8: \n"));
        this.checkQuery(testContext, "select {[Measures].[Unit Sales]} ON COLUMNS,\nHierarchize(Union(Union(Union({[Store].[All Stores]}, [Store].[All Stores].Children), [Store].[All Stores].[USA].Children), [Store].[All Stores].[USA].[CA].Children)) ON ROWS\nfrom [Sales]\nwhere [Time].[1997]");
    }

    private static TestContext goodmanContext(Role.RollupPolicy policy) {
        return TestContext.create(null, null, null, null, null, "<Role name=\"California manager\">\n  <SchemaGrant access=\"none\">\n    <CubeGrant cube=\"Sales\" access=\"all\">\n      <HierarchyGrant hierarchy=\"[Store]\" rollupPolicy=\"" + policy.name().toLowerCase() + "\" access=\"custom\">\n" + "        <MemberGrant member=\"[Store].[USA].[CA]\" access=\"all\"/>\n" + "        <MemberGrant member=\"[Store].[USA].[OR].[Portland]\" access=\"all\"/>\n" + "      </HierarchyGrant>" + "    </CubeGrant>\n" + "  </SchemaGrant>\n" + "</Role>").withRole("California manager");
    }

    public void testBug1949935() {
        TestContext testContext = TestContext.create(null, null, null, null, null, "<Role name=\"California manager\">\n  <SchemaGrant access=\"none\">\n    <CubeGrant cube=\"Sales\" access=\"all\">\n      <HierarchyGrant hierarchy=\"[Store]\" access=\"none\" />\n    </CubeGrant>\n    <CubeGrant cube=\"Sales Ragged\" access=\"all\">\n      <HierarchyGrant hierarchy=\"[Store]\" access=\"custom\" />\n    </CubeGrant>\n  </SchemaGrant>\n</Role>").withRole("California manager");
        this.assertHierarchyAccess(testContext.getConnection(), Access.NONE, "Sales", "Store");
        this.assertHierarchyAccess(testContext.getConnection(), Access.CUSTOM, "Sales Ragged", "Store");
    }

    public void testPartialRollupParentChildHierarchy() {
        TestContext testContext = TestContext.create(null, null, null, null, null, "<Role name=\"Buggy Role\">\n  <SchemaGrant access=\"none\">\n    <CubeGrant cube=\"HR\" access=\"all\">\n      <HierarchyGrant hierarchy=\"[Employees]\" access=\"custom\"\n                      rollupPolicy=\"partial\">\n        <MemberGrant\n            member=\"[Employees].[All Employees].[Sheri Nowmer].[Darren Stanz]\"\n            access=\"all\"/>\n      </HierarchyGrant>\n      <HierarchyGrant hierarchy=\"[Store]\" access=\"custom\"\n                      rollupPolicy=\"partial\">\n        <MemberGrant member=\"[Store].[All Stores].[USA].[CA]\" access=\"all\"/>\n      </HierarchyGrant>\n    </CubeGrant>\n  </SchemaGrant>\n</Role>").withRole("Buggy Role");
        String mdx = "select\n  {[Measures].[Number of Employees]} on columns,\n  {[Store]} on rows\nfrom HR";
        testContext.assertQueryReturns("select\n  {[Measures].[Number of Employees]} on columns,\n  {[Store]} on rows\nfrom HR", AccessControlTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Number of Employees]}\nAxis #2:\n{[Store].[All Stores]}\nRow #0: 1\n"));
        this.checkQuery(testContext, "select\n  {[Measures].[Number of Employees]} on columns,\n  {[Store]} on rows\nfrom HR");
        String mdx2 = "select\n  {[Measures].[Number of Employees]} on columns,\n  {[Employees]} on rows\nfrom HR";
        testContext.assertQueryReturns("select\n  {[Measures].[Number of Employees]} on columns,\n  {[Employees]} on rows\nfrom HR", AccessControlTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Number of Employees]}\nAxis #2:\n{[Employees].[All Employees]}\nRow #0: 1\n"));
        this.checkQuery(testContext, "select\n  {[Measures].[Number of Employees]} on columns,\n  {[Employees]} on rows\nfrom HR");
    }

    public void testBugBiserver1574() {
        TestContext testContext = TestContext.create(null, null, null, null, null, BiServer1574Role1).withRole("role1");
        String mdx = "select {([Measures].[Store Invoice], [Store Size in SQFT].[All Store Size in SQFTs])} ON COLUMNS,\n  {[Warehouse].[All Warehouses]} ON ROWS\nfrom [Warehouse]";
        this.checkQuery(testContext, "select {([Measures].[Store Invoice], [Store Size in SQFT].[All Store Size in SQFTs])} ON COLUMNS,\n  {[Warehouse].[All Warehouses]} ON ROWS\nfrom [Warehouse]");
        testContext.assertQueryReturns("select {([Measures].[Store Invoice], [Store Size in SQFT].[All Store Size in SQFTs])} ON COLUMNS,\n  {[Warehouse].[All Warehouses]} ON ROWS\nfrom [Warehouse]", AccessControlTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Store Invoice], [Store Size in SQFT].[All Store Size in SQFTs]}\nAxis #2:\n{[Warehouse].[All Warehouses]}\nRow #0: 4,042.96\n"));
    }

    public void testBug2028231() {
        TestContext testContext = TestContext.create(null, null, null, null, null, BiServer1574Role1).withRole("role1");
        testContext.assertQueryReturns("select hierarchize(    crossjoin({[Store Size in SQFT], [Store Size in SQFT].Children}, {[Product]})) on 0,[Store Type].Members on 1 from [Warehouse]", AccessControlTest.fold("Axis #0:\n{}\nAxis #1:\n{[Store Size in SQFT].[All Store Size in SQFTs], [Product].[All Products]}\n{[Store Size in SQFT].[All Store Size in SQFTs].[20319], [Product].[All Products]}\nAxis #2:\n{[Store Type].[All Store Types]}\n{[Store Type].[All Store Types].[Supermarket]}\nRow #0: 4,042.96\nRow #0: 4,042.96\nRow #1: 4,042.96\nRow #1: 4,042.96\n"));
        testContext.assertQueryReturns("select hierarchize(    { ([Store Size in SQFT], [Product]),\n      ([Store Size in SQFT].[20319], [Product].[Food]),\n      ([Store Size in SQFT], [Product].[Drink].[Dairy]),\n      ([Store Size in SQFT].[20319], [Product]) }\n) on 0,[Store Type].Members on 1 from [Warehouse]", AccessControlTest.fold("Axis #0:\n{}\nAxis #1:\n{[Store Size in SQFT].[All Store Size in SQFTs], [Product].[All Products]}\n{[Store Size in SQFT].[All Store Size in SQFTs], [Product].[All Products].[Drink].[Dairy]}\n{[Store Size in SQFT].[All Store Size in SQFTs].[20319], [Product].[All Products]}\n{[Store Size in SQFT].[All Store Size in SQFTs].[20319], [Product].[All Products].[Food]}\nAxis #2:\n{[Store Type].[All Store Types]}\n{[Store Type].[All Store Types].[Supermarket]}\nRow #0: 4,042.96\nRow #0: 82.454\nRow #0: 4,042.96\nRow #0: 2,696.758\nRow #1: 4,042.96\nRow #1: 82.454\nRow #1: 4,042.96\nRow #1: 2,696.758\n"));
        testContext.assertQueryReturns("select non empty hierarchize(union(  union(    crossjoin({[Store Size in SQFT]}, {[Product]}),    crossjoin({[Store Size in SQFT], [Store Size in SQFT].Children}, {[Product]}),    all),  union(    crossjoin({[Store Size in SQFT].Parent}, {[Product].[Drink]}),    crossjoin({[Store Size in SQFT].Children}, {[Product].[Food]}),    all),  all)) on 0,[Store Type].Members on 1 from [Warehouse]", AccessControlTest.fold("Axis #0:\n{}\nAxis #1:\n{[Store Size in SQFT].[All Store Size in SQFTs], [Product].[All Products]}\n{[Store Size in SQFT].[All Store Size in SQFTs], [Product].[All Products]}\n{[Store Size in SQFT].[All Store Size in SQFTs].[20319], [Product].[All Products]}\n{[Store Size in SQFT].[All Store Size in SQFTs].[20319], [Product].[All Products].[Food]}\nAxis #2:\n{[Store Type].[All Store Types]}\n{[Store Type].[All Store Types].[Supermarket]}\nRow #0: 4,042.96\nRow #0: 4,042.96\nRow #0: 4,042.96\nRow #0: 2,696.758\nRow #1: 4,042.96\nRow #1: 4,042.96\nRow #1: 4,042.96\nRow #1: 2,696.758\n"));
        testContext.assertQueryReturns("select Hierarchize(\n  CrossJoin\n(    CrossJoin(\n      {[Product].[All Products],        [Product].[Food],\n       [Product].[Food].[Eggs],\n       [Product].[Drink].[Dairy]},\n      [Store Type].MEMBERS),\n    [Store Size in SQFT].MEMBERS),\n  PRE) on 0\nfrom [Warehouse]", AccessControlTest.fold("Axis #0:\n{}\nAxis #1:\n{[Product].[All Products], [Store Type].[All Store Types], [Store Size in SQFT].[All Store Size in SQFTs]}\n{[Product].[All Products], [Store Type].[All Store Types], [Store Size in SQFT].[All Store Size in SQFTs].[20319]}\n{[Product].[All Products], [Store Type].[All Store Types].[Supermarket], [Store Size in SQFT].[All Store Size in SQFTs]}\n{[Product].[All Products], [Store Type].[All Store Types].[Supermarket], [Store Size in SQFT].[All Store Size in SQFTs].[20319]}\n{[Product].[All Products].[Drink].[Dairy], [Store Type].[All Store Types], [Store Size in SQFT].[All Store Size in SQFTs]}\n{[Product].[All Products].[Drink].[Dairy], [Store Type].[All Store Types], [Store Size in SQFT].[All Store Size in SQFTs].[20319]}\n{[Product].[All Products].[Drink].[Dairy], [Store Type].[All Store Types].[Supermarket], [Store Size in SQFT].[All Store Size in SQFTs]}\n{[Product].[All Products].[Drink].[Dairy], [Store Type].[All Store Types].[Supermarket], [Store Size in SQFT].[All Store Size in SQFTs].[20319]}\n{[Product].[All Products].[Food], [Store Type].[All Store Types], [Store Size in SQFT].[All Store Size in SQFTs]}\n{[Product].[All Products].[Food], [Store Type].[All Store Types], [Store Size in SQFT].[All Store Size in SQFTs].[20319]}\n{[Product].[All Products].[Food], [Store Type].[All Store Types].[Supermarket], [Store Size in SQFT].[All Store Size in SQFTs]}\n{[Product].[All Products].[Food], [Store Type].[All Store Types].[Supermarket], [Store Size in SQFT].[All Store Size in SQFTs].[20319]}\n{[Product].[All Products].[Food].[Eggs], [Store Type].[All Store Types], [Store Size in SQFT].[All Store Size in SQFTs]}\n{[Product].[All Products].[Food].[Eggs], [Store Type].[All Store Types], [Store Size in SQFT].[All Store Size in SQFTs].[20319]}\n{[Product].[All Products].[Food].[Eggs], [Store Type].[All Store Types].[Supermarket], [Store Size in SQFT].[All Store Size in SQFTs]}\n{[Product].[All Products].[Food].[Eggs], [Store Type].[All Store Types].[Supermarket], [Store Size in SQFT].[All Store Size in SQFTs].[20319]}\nRow #0: 4,042.96\nRow #0: 4,042.96\nRow #0: 4,042.96\nRow #0: 4,042.96\nRow #0: 82.454\nRow #0: 82.454\nRow #0: 82.454\nRow #0: 82.454\nRow #0: 2,696.758\nRow #0: 2,696.758\nRow #0: 2,696.758\nRow #0: 2,696.758\nRow #0: \nRow #0: \nRow #0: \nRow #0: \n"));
    }

    public void testBug2031158() {
        this.propSaver.set(this.propSaver.properties.EnableNativeCrossJoin, true);
        this.propSaver.set(this.propSaver.properties.EnableNativeFilter, true);
        this.propSaver.set(this.propSaver.properties.EnableNativeNonEmpty, true);
        this.propSaver.set(this.propSaver.properties.EnableNativeTopCount, true);
        this.propSaver.set(this.propSaver.properties.ExpandNonNative, true);
        this.checkBug2031158();
        this.propSaver.reset();
        this.checkBug2031158();
    }

    private void checkBug2031158() {
        TestContext testContext = TestContext.create(null, null, null, null, null, BiServer1574Role1).withRole("role1");
        testContext.assertQueryReturns("select non empty {[Measures].[Units Ordered],\n            [Measures].[Units Shipped]} on 0,\nnon empty hierarchize(\n    union(\n        crossjoin(\n            {[Store Size in SQFT]},\n            {[Product].[Drink],\n             [Product].[Food],\n             [Product].[Drink].[Dairy]}),\n        crossjoin(\n            {[Store Size in SQFT].[20319]},\n            {[Product].Children}))) on 1\nfrom [Warehouse]", AccessControlTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Units Ordered]}\n{[Measures].[Units Shipped]}\nAxis #2:\n{[Store Size in SQFT].[All Store Size in SQFTs], [Product].[All Products].[Drink]}\n{[Store Size in SQFT].[All Store Size in SQFTs], [Product].[All Products].[Drink].[Dairy]}\n{[Store Size in SQFT].[All Store Size in SQFTs], [Product].[All Products].[Food]}\n{[Store Size in SQFT].[All Store Size in SQFTs].[20319], [Product].[All Products].[Drink]}\n{[Store Size in SQFT].[All Store Size in SQFTs].[20319], [Product].[All Products].[Food]}\n{[Store Size in SQFT].[All Store Size in SQFTs].[20319], [Product].[All Products].[Non-Consumable]}\nRow #0: 865.0\nRow #0: 767.0\nRow #1: 195.0\nRow #1: 182.0\nRow #2: 6065.0\nRow #2: 5723.0\nRow #3: 865.0\nRow #3: 767.0\nRow #4: 6065.0\nRow #4: 5723.0\nRow #5: 2179.0\nRow #5: 2025.0\n"));
    }

    public void testVirtualCube() {
        TestContext testContext = TestContext.create(null, null, null, null, null, "<Role name=\"VCRole\">\n  <SchemaGrant access=\"none\">\n    <CubeGrant cube=\"Warehouse and Sales\" access=\"all\">\n      <HierarchyGrant hierarchy=\"[Store]\" access=\"custom\"\n          topLevel=\"[Store].[Store Country]\">\n        <MemberGrant member=\"[Store].[USA].[CA]\" access=\"all\"/>\n        <MemberGrant member=\"[Store].[USA].[CA].[Los Angeles]\" access=\"none\"/>\n      </HierarchyGrant>\n      <HierarchyGrant hierarchy=\"[Customers]\" access=\"custom\"\n          topLevel=\"[Customers].[State Province]\" bottomLevel=\"[Customers].[City]\">\n        <MemberGrant member=\"[Customers].[USA].[CA]\" access=\"all\"/>\n        <MemberGrant member=\"[Customers].[USA].[CA].[Los Angeles]\" access=\"none\"/>\n      </HierarchyGrant>\n      <HierarchyGrant hierarchy=\"[Gender]\" access=\"none\"/>\n    </CubeGrant>\n  </SchemaGrant>\n</Role>").withRole("VCRole");
        testContext.assertQueryReturns("select [Store].Members on 0 from [Warehouse and Sales]", AccessControlTest.fold("Axis #0:\n{}\nAxis #1:\n{[Store].[All Stores].[USA]}\n{[Store].[All Stores].[USA].[CA]}\n{[Store].[All Stores].[USA].[CA].[Alameda]}\n{[Store].[All Stores].[USA].[CA].[Alameda].[HQ]}\n{[Store].[All Stores].[USA].[CA].[Beverly Hills]}\n{[Store].[All Stores].[USA].[CA].[Beverly Hills].[Store 6]}\n{[Store].[All Stores].[USA].[CA].[San Diego]}\n{[Store].[All Stores].[USA].[CA].[San Diego].[Store 24]}\n{[Store].[All Stores].[USA].[CA].[San Francisco]}\n{[Store].[All Stores].[USA].[CA].[San Francisco].[Store 14]}\nRow #0: 159,167.84\nRow #0: 159,167.84\nRow #0: \nRow #0: \nRow #0: 45,750.24\nRow #0: 45,750.24\nRow #0: 54,431.14\nRow #0: 54,431.14\nRow #0: 4,441.18\nRow #0: 4,441.18\n"));
    }

    public void testBugBiserver2491() {
        String BiServer2491Role2 = "<Role name=\"role2\"> <SchemaGrant access=\"none\">  <CubeGrant cube=\"Sales\" access=\"all\">   <HierarchyGrant hierarchy=\"[Store]\" access=\"custom\" rollupPolicy=\"partial\">    <MemberGrant member=\"[Store].[USA].[CA]\" access=\"all\"/>    <MemberGrant member=\"[Store].[USA].[CA].[Los Angeles]\" access=\"none\"/>   </HierarchyGrant>  </CubeGrant> </SchemaGrant></Role>";
        TestContext testContext = TestContext.create(null, null, null, null, null, "<Role name=\"role2\"> <SchemaGrant access=\"none\">  <CubeGrant cube=\"Sales\" access=\"all\">   <HierarchyGrant hierarchy=\"[Store]\" access=\"custom\" rollupPolicy=\"partial\">    <MemberGrant member=\"[Store].[USA].[CA]\" access=\"all\"/>    <MemberGrant member=\"[Store].[USA].[CA].[Los Angeles]\" access=\"none\"/>   </HierarchyGrant>  </CubeGrant> </SchemaGrant></Role>").withRole("role2");
        String firstBrokenMdx = "select [Measures].[Unit Sales] ON COLUMNS, {[Store].[Store Country].Members} ON ROWS from [Sales]";
        this.checkQuery(testContext, "select [Measures].[Unit Sales] ON COLUMNS, {[Store].[Store Country].Members} ON ROWS from [Sales]");
        testContext.assertQueryReturns("select [Measures].[Unit Sales] ON COLUMNS, {[Store].[Store Country].Members} ON ROWS from [Sales]", AccessControlTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Store].[All Stores].[USA]}\nRow #0: 49,085\n"));
        String secondBrokenMdx = "select [Measures].[Unit Sales] ON COLUMNS, Descendants([Store],[Store].[Store Name]) ON ROWS from [Sales]";
        this.checkQuery(testContext, "select [Measures].[Unit Sales] ON COLUMNS, Descendants([Store],[Store].[Store Name]) ON ROWS from [Sales]");
        testContext.assertQueryReturns("select [Measures].[Unit Sales] ON COLUMNS, Descendants([Store],[Store].[Store Name]) ON ROWS from [Sales]", AccessControlTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Store].[All Stores].[USA].[CA].[Alameda].[HQ]}\n{[Store].[All Stores].[USA].[CA].[Beverly Hills].[Store 6]}\n{[Store].[All Stores].[USA].[CA].[San Diego].[Store 24]}\n{[Store].[All Stores].[USA].[CA].[San Francisco].[Store 14]}\nRow #0: \nRow #1: 21,333\nRow #2: 25,635\nRow #3: 2,117\n"));
    }

    private class RestrictedTestContext
    extends TestContext {
        private RestrictedTestContext() {
        }

        public synchronized Connection getFoodMartConnection() {
            return AccessControlTest.this.getRestrictedConnection(false);
        }
    }
}

