/*
 * Decompiled with CFR 0.152.
 */
package mondrian.test;

import junit.framework.Test;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import mondrian.olap.CacheControl;
import mondrian.olap.Connection;
import mondrian.olap.Cube;
import mondrian.olap.MondrianProperties;
import mondrian.rolap.agg.AggregationManager;
import mondrian.rolap.agg.CountingAggregationManager;
import mondrian.test.FoodMartTestCase;
import mondrian.test.TestContext;
import mondrian.test.clearview.CVBasicTest;
import mondrian.test.clearview.GrandTotalTest;
import mondrian.test.clearview.MemHungryTest;
import mondrian.test.clearview.MetricFilterTest;
import mondrian.test.clearview.MiscTest;
import mondrian.test.clearview.MultiDimTest;
import mondrian.test.clearview.MultiDimVCTest;
import mondrian.test.clearview.MultiLevelTest;
import mondrian.test.clearview.MultiLevelVCTest;
import mondrian.test.clearview.PartialCacheTest;
import mondrian.test.clearview.PartialCacheVCTest;
import mondrian.test.clearview.PredicateFilterTest;
import mondrian.test.clearview.QueryAllTest;
import mondrian.test.clearview.QueryAllVCTest;
import mondrian.test.clearview.SubTotalTest;
import mondrian.test.clearview.SummaryMetricPercentTest;
import mondrian.test.clearview.SummaryTest;
import mondrian.test.clearview.TopBottomTest;

public class CacheHitTest
extends FoodMartTestCase {
    public void testSmallSetSequential() throws Exception {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)PartialCacheTest.suite());
        suite.addTest((Test)MultiLevelTest.suite());
        suite.addTest((Test)MultiDimTest.suite());
        suite.addTest((Test)QueryAllTest.suite());
        System.out.println("== " + this.getName() + " ==");
        this.runTestSuiteInOrder(suite, 50);
        this.clearCache("Sales");
    }

    public void testSmallSetRandom() throws Exception {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)PartialCacheTest.suite());
        suite.addTest((Test)MultiLevelTest.suite());
        suite.addTest((Test)MultiDimTest.suite());
        suite.addTest((Test)QueryAllTest.suite());
        System.out.println("== " + this.getName() + " ==");
        this.runRandomSuite(suite, 200);
        this.clearCache("Sales");
    }

    public void testSmallSetVCSequential() throws Exception {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)PartialCacheVCTest.suite());
        suite.addTest((Test)MultiLevelVCTest.suite());
        suite.addTest((Test)MultiDimVCTest.suite());
        suite.addTest((Test)QueryAllVCTest.suite());
        System.out.println("== " + this.getName() + " ==");
        this.runTestSuiteInOrder(suite, 50);
        this.clearCache("Warehouse and Sales");
    }

    public void testSmallSetVCRandom() throws Exception {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)PartialCacheVCTest.suite());
        suite.addTest((Test)MultiLevelVCTest.suite());
        suite.addTest((Test)MultiDimVCTest.suite());
        suite.addTest((Test)QueryAllVCTest.suite());
        System.out.println("== " + this.getName() + " ==");
        this.runRandomSuite(suite, 200);
        this.clearCache("Warehouse and Sales");
    }

    public void testBigSetRandom() throws Exception {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)MemHungryTest.suite());
        suite.addTest((Test)PartialCacheTest.suite());
        suite.addTest((Test)MultiLevelTest.suite());
        suite.addTest((Test)MultiDimTest.suite());
        suite.addTest((Test)QueryAllTest.suite());
        suite.addTest((Test)PartialCacheVCTest.suite());
        suite.addTest((Test)MultiLevelVCTest.suite());
        suite.addTest((Test)MultiDimVCTest.suite());
        suite.addTest((Test)QueryAllVCTest.suite());
        suite.addTest((Test)CVBasicTest.suite());
        suite.addTest((Test)GrandTotalTest.suite());
        suite.addTest((Test)MetricFilterTest.suite());
        suite.addTest((Test)MiscTest.suite());
        suite.addTest((Test)PredicateFilterTest.suite());
        suite.addTest((Test)SubTotalTest.suite());
        suite.addTest((Test)SummaryMetricPercentTest.suite());
        suite.addTest((Test)SummaryTest.suite());
        suite.addTest((Test)TopBottomTest.suite());
        System.out.println("== " + this.getName() + " ==");
        this.runRandomSuite(suite, 200);
        this.clearCache("Sales");
        this.clearCache("Warehouse and Sales");
    }

    public void runRandomSuite(TestSuite suite, int n) throws Exception {
        TestResult tres = new TestResult();
        boolean origCacheHitCounters = MondrianProperties.instance().EnableCacheHitCounters.get();
        MondrianProperties.instance().EnableCacheHitCounters.set(true);
        AggregationManager aggMngr = AggregationManager.instance();
        assert (aggMngr instanceof CountingAggregationManager);
        ((CountingAggregationManager)aggMngr).resetCounters();
        for (int i = 0; i < n; ++i) {
            int suiteIdx = (int)(Math.random() * (double)suite.testCount());
            TestSuite test = (TestSuite)suite.testAt(suiteIdx);
            int testIdx = (int)(Math.random() * (double)test.testCount());
            test.testAt(testIdx).run(tres);
        }
        this.report((CountingAggregationManager)aggMngr);
        MondrianProperties.instance().EnableCacheHitCounters.set(origCacheHitCounters);
    }

    public void runTestSuiteInOrder(TestSuite suite, int numIter) throws Exception {
        TestResult tres = new TestResult();
        boolean origCacheHitCounters = MondrianProperties.instance().EnableCacheHitCounters.get();
        MondrianProperties.instance().EnableCacheHitCounters.set(true);
        AggregationManager aggMngr = AggregationManager.instance();
        assert (aggMngr instanceof CountingAggregationManager);
        ((CountingAggregationManager)aggMngr).resetCounters();
        for (int i = 0; i < numIter; ++i) {
            TestSuite test = (TestSuite)suite.testAt(i % suite.testCount());
            for (int j = 0; j < test.testCount(); ++j) {
                test.testAt(j).run(tres);
            }
        }
        this.report((CountingAggregationManager)aggMngr);
        MondrianProperties.instance().EnableCacheHitCounters.set(origCacheHitCounters);
    }

    public void report(CountingAggregationManager am) {
        System.out.println("Number of requests: " + am.getRequestCount());
        System.out.println("Number of misses: " + am.getMissCount());
        System.out.println("Hit ratio ---> " + am.getHitRatio());
    }

    public void clearCache(String cube) {
        TestContext testContext = this.getTestContext();
        CacheControl cacheControl = testContext.getConnection().getCacheControl(null);
        Connection connection = testContext.getConnection();
        Cube salesCube = connection.getSchema().lookupCube(cube, true);
        CacheControl.CellRegion measuresRegion = cacheControl.createMeasuresRegion(salesCube);
        cacheControl.flush(measuresRegion);
    }
}

