/*
 * Decompiled with CFR 0.152.
 */
package mondrian.xmla.test;

import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mondrian.olap.Util;
import mondrian.rolap.RolapConnectionProperties;
import mondrian.spi.CatalogLocator;
import mondrian.spi.impl.CatalogLocatorImpl;
import mondrian.test.DiffRepository;
import mondrian.test.TestContext;
import mondrian.xmla.DataSourcesConfig;
import org.apache.log4j.Logger;
import org.eigenbase.xom.DOMWrapper;
import org.eigenbase.xom.Parser;
import org.eigenbase.xom.XOMUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlaTestContext {
    private static final Logger LOGGER = Logger.getLogger(XmlaTestContext.class);
    public static final String CATALOG_NAME = "FoodMart";
    public static final String DATASOURCE_NAME = "MondrianFoodMart";
    public static final String DATASOURCE_DESCRIPTION = "Mondrian FoodMart Test data source";
    public static final String DATASOURCE_INFO = "Provider=Mondrian;DataSource=MondrianFoodMart;";
    public static final Map<String, String> ENV = new HashMap<String, String>(){
        {
            this.put("catalog", XmlaTestContext.CATALOG_NAME);
            this.put("datasource", XmlaTestContext.DATASOURCE_INFO);
        }
    };
    private static DataSourcesConfig.DataSources DATASOURCES;
    public static final CatalogLocator CATALOG_LOCATOR;
    private String connectString;

    public String getConnectString() {
        if (this.connectString != null) {
            return this.connectString;
        }
        this.connectString = TestContext.instance().getConnectString();
        this.connectString = this.connectString.replaceAll("&", "&amp;");
        return this.connectString;
    }

    public DataSourcesConfig.DataSources dataSources() {
        if (DATASOURCES != null) {
            return DATASOURCES;
        }
        Util.PropertyList connectProperties = Util.parseConnectString(this.getConnectString());
        String catalogUrl = connectProperties.get(RolapConnectionProperties.Catalog.name());
        StringReader dsConfigReader = new StringReader("<?xml version=\"1.0\"?><DataSources>   <DataSource>       <DataSourceName>Provider=Mondrian;DataSource=MondrianFoodMart;</DataSourceName>       <DataSourceDescription>Mondrian FoodMart Test data source</DataSourceDescription>       <URL>http://localhost:8080/mondrian/xmla</URL>       <DataSourceInfo>" + this.getConnectString() + "</DataSourceInfo>" + "       <ProviderName>Mondrian</ProviderName>" + "       <ProviderType>MDP</ProviderType>" + "       <AuthenticationMode>Unauthenticated</AuthenticationMode>" + "       <Catalogs>" + "          <Catalog name='FoodMart'><Definition>" + catalogUrl + "</Definition></Catalog>" + "       </Catalogs>" + "   </DataSource>" + "</DataSources>");
        try {
            Parser xmlParser = XOMUtil.createDefaultParser();
            DOMWrapper def = xmlParser.parse((Reader)dsConfigReader);
            DATASOURCES = new DataSourcesConfig.DataSources(def);
        }
        catch (Exception e) {
            // empty catch block
        }
        return DATASOURCES;
    }

    public static String xmlFromTemplate(String xmlText, Map<String, String> env) {
        StringBuffer buf = new StringBuffer();
        Pattern pattern = Pattern.compile("\\$\\{([^}]+)\\}");
        Matcher matcher = pattern.matcher(xmlText);
        while (matcher.find()) {
            String varName = matcher.group(1);
            String varValue = env.get(varName);
            if (varValue != null) {
                matcher.appendReplacement(buf, varValue);
                continue;
            }
            matcher.appendReplacement(buf, "\\${$1}");
        }
        matcher.appendTail(buf);
        return buf.toString();
    }

    public String[][] defaultRequests() {
        URL refUrl = DiffRepository.class.getClassLoader().getResource("mondrian/xmla/test/XmlaTest.ref.xml");
        DiffRepository diffRepos = new DiffRepository(refUrl);
        ArrayList<String[]> stringList = new ArrayList<String[]>();
        for (String testName : diffRepos.getTestCaseNames()) {
            String templateRequest = diffRepos.get(testName, "request");
            String request = XmlaTestContext.xmlFromTemplate(templateRequest, ENV);
            stringList.add(new String[]{testName, request});
        }
        return (String[][])stringList.toArray((T[])new String[stringList.size()][]);
    }

    static {
        CATALOG_LOCATOR = new CatalogLocatorImpl();
    }
}

