/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.ofc;

import net.sf.jasperreports.components.ofc.BarChartXmlFactory;
import net.sf.jasperreports.components.ofc.BarDataset;
import net.sf.jasperreports.components.ofc.BarSeries;
import net.sf.jasperreports.components.ofc.DefaultBarSeries;
import net.sf.jasperreports.components.ofc.DesignBarDataset;
import net.sf.jasperreports.components.ofc.DesignPieDataset;
import net.sf.jasperreports.components.ofc.PieChartXmlFactory;
import net.sf.jasperreports.components.ofc.PieDataset;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.component.XmlDigesterConfigurer;
import net.sf.jasperreports.engine.xml.JRExpressionFactory;
import org.apache.commons.digester.Digester;

public class ChartsDigester
implements XmlDigesterConfigurer {
    public void configureDigester(Digester digester) {
        this.setPieChartRules(digester);
        this.setBarChartRules(digester);
    }

    protected void setBarChartRules(Digester digester) {
        String barChartPattern = "*/componentElement/barChart";
        digester.addFactoryCreate(barChartPattern, BarChartXmlFactory.class.getName());
        String titleExpressionPattern = barChartPattern + "/titleExpression";
        digester.addFactoryCreate(titleExpressionPattern, JRExpressionFactory.StringExpressionFactory.class.getName());
        digester.addCallMethod(titleExpressionPattern, "setText", 0);
        digester.addSetNext(titleExpressionPattern, "setTitleExpression", JRExpression.class.getName());
        String barDatasetPattern = barChartPattern + "/barDataset";
        digester.addObjectCreate(barDatasetPattern, DesignBarDataset.class.getName());
        digester.addSetNext(barDatasetPattern, "setDataset", BarDataset.class.getName());
        String barSeriesPattern = barDatasetPattern + "/barSeries";
        digester.addObjectCreate(barSeriesPattern, DefaultBarSeries.class.getName());
        digester.addSetNext(barSeriesPattern, "addSeries", BarSeries.class.getName());
        String seriesExpressionPattern = barSeriesPattern + "/seriesExpression";
        digester.addFactoryCreate(seriesExpressionPattern, JRExpressionFactory.StringExpressionFactory.class.getName());
        digester.addCallMethod(seriesExpressionPattern, "setText", 0);
        digester.addSetNext(seriesExpressionPattern, "setSeriesExpression", JRExpression.class.getName());
        String categoryExpressionPattern = barSeriesPattern + "/categoryExpression";
        digester.addFactoryCreate(categoryExpressionPattern, JRExpressionFactory.StringExpressionFactory.class.getName());
        digester.addCallMethod(categoryExpressionPattern, "setText", 0);
        digester.addSetNext(categoryExpressionPattern, "setCategoryExpression", JRExpression.class.getName());
        String valueExpressionPattern = barSeriesPattern + "/valueExpression";
        digester.addFactoryCreate(valueExpressionPattern, JRExpressionFactory.NumberExpressionFactory.class.getName());
        digester.addCallMethod(valueExpressionPattern, "setText", 0);
        digester.addSetNext(valueExpressionPattern, "setValueExpression", JRExpression.class.getName());
    }

    protected void setPieChartRules(Digester digester) {
        String pieChartPattern = "*/componentElement/pieChart";
        digester.addFactoryCreate(pieChartPattern, PieChartXmlFactory.class.getName());
        String pieDatasetPattern = pieChartPattern + "/pieDataset";
        digester.addObjectCreate(pieDatasetPattern, DesignPieDataset.class.getName());
        digester.addSetNext(pieDatasetPattern, "setDataset", PieDataset.class.getName());
        String keyExpressionPattern = pieDatasetPattern + "/keyExpression";
        digester.addFactoryCreate(keyExpressionPattern, JRExpressionFactory.StringExpressionFactory.class.getName());
        digester.addCallMethod(keyExpressionPattern, "setText", 0);
        digester.addSetNext(keyExpressionPattern, "setKeyExpression", JRExpression.class.getName());
        String valueExpressionPattern = pieDatasetPattern + "/valueExpression";
        digester.addFactoryCreate(valueExpressionPattern, JRExpressionFactory.NumberExpressionFactory.class.getName());
        digester.addCallMethod(valueExpressionPattern, "setText", 0);
        digester.addSetNext(valueExpressionPattern, "setValueExpression", JRExpression.class.getName());
        String titleExpressionPattern = pieChartPattern + "/titleExpression";
        digester.addFactoryCreate(titleExpressionPattern, JRExpressionFactory.StringExpressionFactory.class.getName());
        digester.addCallMethod(titleExpressionPattern, "setText", 0);
        digester.addSetNext(titleExpressionPattern, "setTitleExpression", JRExpression.class.getName());
    }
}

