/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.table;

import java.util.List;
import net.sf.jasperreports.components.sort.SortElement;
import net.sf.jasperreports.components.table.Cell;
import net.sf.jasperreports.components.table.Column;
import net.sf.jasperreports.components.table.ColumnFactory;
import net.sf.jasperreports.components.table.ColumnVisitor;
import net.sf.jasperreports.components.table.CompiledCell;
import net.sf.jasperreports.components.table.StandardBaseColumn;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionChunk;
import net.sf.jasperreports.engine.JRTextField;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignGenericElement;
import net.sf.jasperreports.engine.design.JRDesignGenericElementParameter;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.PositionTypeEnum;
import net.sf.jasperreports.engine.util.JRCloneUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardColumn
extends StandardBaseColumn
implements Column {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_DETAIL = "detail";
    private Cell detail;

    public StandardColumn() {
    }

    public StandardColumn(Column column, ColumnFactory factory) {
        super(column, factory);
        Cell columnCell = column.getDetailCell();
        if (columnCell != null) {
            this.detail = new CompiledCell(columnCell, factory.getBaseObjectFactory());
        }
    }

    @Override
    public Cell getDetailCell() {
        return this.detail;
    }

    public void setDetailCell(Cell detail) {
        Cell old = this.detail;
        this.detail = detail;
        List<JRChild> children = detail.getChildren();
        for (JRChild child : children) {
            JRExpressionChunk[] chunks;
            JRTextField tf;
            JRExpression expression;
            if (!(child instanceof JRTextField) || (expression = (tf = (JRTextField)child).getExpression()) == null || (chunks = expression.getChunks()) == null || chunks.length != 1 || chunks[0].getType() != 3 && chunks[0].getType() != 4) continue;
            this.addGenericElementToHeader(chunks[0]);
            break;
        }
        this.getEventSupport().firePropertyChange(PROPERTY_DETAIL, old, this.detail);
    }

    @Override
    public <R> R visitColumn(ColumnVisitor<R> visitor) {
        return visitor.visitColumn(this);
    }

    @Override
    public Object clone() {
        StandardColumn clone = (StandardColumn)super.clone();
        clone.detail = JRCloneUtils.nullSafeClone(this.detail);
        return clone;
    }

    public void addGenericElementToHeader(JRExpressionChunk chunk) {
        Cell header = this.getColumnHeader();
        if (header != null) {
            JRDesignGenericElement genericElement = new JRDesignGenericElement(header.getDefaultStyleProvider());
            genericElement.setGenericType(SortElement.SORT_ELEMENT_TYPE);
            genericElement.getPropertiesMap().setProperty("controlParameter", "true");
            genericElement.setPositionType(PositionTypeEnum.FIX_RELATIVE_TO_TOP);
            genericElement.setX(0);
            genericElement.setY(0);
            genericElement.setHeight(header.getHeight());
            genericElement.setMode(ModeEnum.TRANSPARENT);
            JRDesignGenericElementParameter paramSortColumnName = new JRDesignGenericElementParameter();
            paramSortColumnName.setName("sortColumnName");
            JRDesignExpression paramSortColumnValueExpression = new JRDesignExpression();
            paramSortColumnValueExpression.setText("\"" + chunk.getText() + "\"");
            paramSortColumnName.setValueExpression(paramSortColumnValueExpression);
            genericElement.addParameter(paramSortColumnName);
            JRDesignGenericElementParameter paramColumnType = new JRDesignGenericElementParameter();
            paramColumnType.setName("sortColumnType");
            JRDesignExpression paramColumnTypeValueExpression = new JRDesignExpression();
            paramColumnTypeValueExpression.setText("\"" + (chunk.getType() == 3 ? "Field" : "Variable") + "\"");
            paramColumnType.setValueExpression(paramColumnTypeValueExpression);
            genericElement.addParameter(paramColumnType);
            JRDesignGenericElementParameter paramHorizontalAlign = new JRDesignGenericElementParameter();
            paramHorizontalAlign.setName("sortHandlerHorizontalAlign");
            JRDesignExpression paramHorizontalAlignValueExpression = new JRDesignExpression();
            paramHorizontalAlignValueExpression.setText("\"Right\"");
            paramHorizontalAlign.setValueExpression(paramHorizontalAlignValueExpression);
            genericElement.addParameter(paramHorizontalAlign);
            JRDesignGenericElementParameter paramVerticalAlign = new JRDesignGenericElementParameter();
            paramVerticalAlign.setName("sortHandlerVerticalAlign");
            JRDesignExpression paramVerticalAlignValueExpression = new JRDesignExpression();
            paramVerticalAlignValueExpression.setText("\"Middle\"");
            paramVerticalAlign.setValueExpression(paramVerticalAlignValueExpression);
            genericElement.addParameter(paramVerticalAlign);
            header.getChildren().add(genericElement);
        }
    }
}

