/*
 * Decompiled with CFR 0.152.
 */
package ofc4j.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import ofc4j.OFC;
import ofc4j.model.Text;
import ofc4j.model.axis.XAxis;
import ofc4j.model.axis.YAxis;
import ofc4j.model.elements.Element;

public class Chart {
    private Text title;
    private XAxis x_axis;
    private YAxis y_axis;
    private YAxis y_axis_right;
    private Text y_legend;
    private Text x_legend;
    private String bg_colour;
    private Collection<Element> elements = new HashSet<Element>();

    public XAxis getXAxis() {
        return this.x_axis;
    }

    public Chart() {
    }

    public Chart(String titleText) {
        this(titleText, null);
    }

    public Chart(String titleText, String style) {
        this.setTitle(new Text(titleText, style));
    }

    public Chart setXAxis(XAxis x_axis) {
        this.x_axis = x_axis;
        return this;
    }

    public YAxis getYAxis() {
        return this.y_axis;
    }

    public Chart setYAxis(YAxis y_axis) {
        this.y_axis = y_axis;
        return this;
    }

    public Chart setYAxisRight(YAxis y_axis_right) {
        this.y_axis_right = y_axis_right;
        return this;
    }

    public YAxis getYAxisRight() {
        return this.y_axis_right;
    }

    public Text getTitle() {
        return this.title;
    }

    public Chart setTitle(Text title) {
        this.title = title;
        return this;
    }

    public Text getXLegend() {
        return this.x_legend;
    }

    public Chart setXLegend(Text x_legend) {
        this.x_legend = x_legend;
        return this;
    }

    public Text getYLegend() {
        return this.y_legend;
    }

    public Chart setYLegend(Text y_legend) {
        this.y_legend = y_legend;
        return this;
    }

    public String getBackgroundColour() {
        return this.bg_colour;
    }

    public Chart setBackgroundColour(String bg_colour) {
        this.bg_colour = bg_colour;
        return this;
    }

    public Collection<Element> getElements() {
        return this.elements;
    }

    public Chart setElements(Collection<Element> elements) {
        this.elements.clear();
        this.elements.addAll(elements);
        return this;
    }

    public Chart addElements(Element ... e) {
        this.elements.addAll(Arrays.asList(e));
        return this;
    }

    public Chart addElements(Collection<Element> coll) {
        this.elements.addAll(coll);
        return this;
    }

    public boolean removeElement(Element e) {
        return this.elements.remove(e);
    }

    public Element getElementByText(String text) {
        for (Element e : this.getElements()) {
            if (!text.equals(e.getText())) continue;
            return e;
        }
        return null;
    }

    public String toString() {
        return OFC.instance.render(this);
    }
}

