/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.undo;

import it.businesslogic.ireport.CrosstabReportElement;
import it.businesslogic.ireport.ReportElement;
import it.businesslogic.ireport.TransformationType;
import it.businesslogic.ireport.UndoOperation;
import it.businesslogic.ireport.crosstab.CrosstabCell;
import it.businesslogic.ireport.crosstab.CrosstabGroup;
import it.businesslogic.ireport.crosstab.gui.CrosstabEditorPanel;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.event.CrosstabLayoutChangedEvent;
import java.awt.Point;
import java.util.Vector;

public class CrosstabRowDraggedOperation
implements UndoOperation {
    private int delta = 0;
    private CrosstabEditorPanel editor = null;
    private CrosstabReportElement crosstabElement;
    private int draggedLineIndex = 0;

    public CrosstabRowDraggedOperation(CrosstabEditorPanel editor, CrosstabReportElement element, int draggedLineIndex, int delta) {
        this.setEditor(editor);
        this.setCrosstabElement(element);
        this.setDraggedLineIndex(draggedLineIndex);
        this.setDelta(delta);
    }

    public void redo() {
        int j;
        int i;
        if (this.editor == null) {
            return;
        }
        int readyToDragCellVertically = this.draggedLineIndex;
        for (int j2 = 0; j2 < this.getCrosstabElement().getElements().size(); ++j2) {
            ReportElement re = (ReportElement)this.getCrosstabElement().getElements().elementAt(j2);
            re.setRelativePosition(new Point(re.getPosition().x - re.getCell().getLeft() - 10, re.getPosition().y - re.getCell().getTop() - 10));
        }
        Vector cells = (Vector)this.getEditor().getRowBands().elementAt(readyToDragCellVertically - 1);
        for (i = 0; i < cells.size(); ++i) {
            CrosstabCell cell = (CrosstabCell)cells.elementAt(i);
            cell.setHeight(cell.getHeight() + this.delta);
        }
        for (j = readyToDragCellVertically; j < this.getEditor().getRowBands().size(); ++j) {
            cells = (Vector)this.getEditor().getRowBands().elementAt(j);
            for (int i2 = 0; i2 < cells.size(); ++i2) {
                CrosstabCell cell = (CrosstabCell)cells.elementAt(i2);
                if (cell.getTopIndex() >= readyToDragCellVertically) {
                    cell.setTop(cell.getTop() + this.delta);
                    continue;
                }
                cell.setHeight(cell.getHeight() + this.delta);
            }
        }
        for (i = 0; i < this.getCrosstabElement().getColumnGroups().size(); ++i) {
            CrosstabGroup group = (CrosstabGroup)this.getCrosstabElement().getColumnGroups().elementAt(i);
            group.setSize(group.getHeaderCell().getHeight());
        }
        for (j = 0; j < this.getCrosstabElement().getElements().size(); ++j) {
            ReportElement re = (ReportElement)this.getCrosstabElement().getElements().elementAt(j);
            re.getPosition().x = re.getRelativePosition().x + re.getCell().getLeft() + 10;
            re.getPosition().y = re.getRelativePosition().y + re.getCell().getTop() + 10;
            re.setPosition(re.position);
            re.trasform(new Point(0, 0), TransformationType.TRANSFORMATION_RESIZE_SE);
        }
        for (i = readyToDragCellVertically; i < this.getEditor().getRows().size(); ++i) {
            int rowPosition = (Integer)this.getEditor().getRows().get(i) + this.delta;
            this.getEditor().getRows().set(i, new Integer(rowPosition));
        }
        MainFrame.getMainInstance().getActiveReportFrame().setIsDocDirty(true);
        this.getCrosstabElement().fireCrosstabLayoutChangedListenerCrosstabLayoutChanged(new CrosstabLayoutChangedEvent(this, this.getCrosstabElement()));
    }

    public void undo() {
        if (this.editor == null) {
            return;
        }
        this.delta *= -1;
        this.redo();
        this.delta *= -1;
    }

    public String toString() {
        return "row resize";
    }

    public int getDelta() {
        return this.delta;
    }

    public void setDelta(int delta) {
        this.delta = delta;
    }

    public int getDraggedLineIndex() {
        return this.draggedLineIndex;
    }

    public void setDraggedLineIndex(int draggedLineIndex) {
        this.draggedLineIndex = draggedLineIndex;
    }

    public CrosstabReportElement getCrosstabElement() {
        return this.crosstabElement;
    }

    public void setCrosstabElement(CrosstabReportElement crosstabElement) {
        this.crosstabElement = crosstabElement;
    }

    public CrosstabEditorPanel getEditor() {
        return this.editor;
    }

    public void setEditor(CrosstabEditorPanel editor) {
        this.editor = editor;
    }
}

