/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.util.Map;
import net.sf.jasperreports.engine.JRScriptletException;
import net.sf.jasperreports.engine.fill.JRFillField;
import net.sf.jasperreports.engine.fill.JRFillGroup;
import net.sf.jasperreports.engine.fill.JRFillParameter;
import net.sf.jasperreports.engine.fill.JRFillVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JRAbstractScriptlet {
    protected Map<String, JRFillParameter> parametersMap;
    protected Map<String, JRFillField> fieldsMap;
    protected Map<String, JRFillVariable> variablesMap;
    protected JRFillGroup[] groups;

    public void setData(Map<String, JRFillParameter> parsm, Map<String, JRFillField> fldsm, Map<String, JRFillVariable> varsm, JRFillGroup[] grps) {
        this.parametersMap = parsm;
        this.fieldsMap = fldsm;
        this.variablesMap = varsm;
        this.groups = grps;
    }

    public Object getParameterValue(String parameterName) throws JRScriptletException {
        return this.getParameterValue(parameterName, true);
    }

    public Object getParameterValue(String parameterName, boolean mustBeDeclared) throws JRScriptletException {
        JRFillParameter parameter = this.parametersMap.get(parameterName);
        if (parameter == null) {
            if (mustBeDeclared) {
                throw new JRScriptletException("Parameter not found : " + parameterName);
            }
            return ((Map)this.parametersMap.get("REPORT_PARAMETERS_MAP").getValue()).get(parameterName);
        }
        return parameter.getValue();
    }

    public Object getFieldValue(String fieldName) throws JRScriptletException {
        JRFillField field = this.fieldsMap.get(fieldName);
        if (field == null) {
            throw new JRScriptletException("Field not found : " + fieldName);
        }
        return field.getValue();
    }

    public Object getVariableValue(String variableName) throws JRScriptletException {
        JRFillVariable variable = this.variablesMap.get(variableName);
        if (variable == null) {
            throw new JRScriptletException("Variable not found : " + variableName);
        }
        return variable.getValue();
    }

    public void setVariableValue(String variableName, Object value) throws JRScriptletException {
        JRFillVariable variable = this.variablesMap.get(variableName);
        if (variable == null) {
            throw new JRScriptletException("Variable not found : " + variableName);
        }
        if (value != null && !variable.getValueClass().isInstance(value)) {
            throw new JRScriptletException("Incompatible value assigned to variable " + variableName + ". Expected " + variable.getValueClassName() + ".");
        }
        variable.setValue(value);
    }

    public void callBeforeReportInit() throws JRScriptletException {
        this.beforeReportInit();
        this.beforePageInit();
        this.beforeColumnInit();
        if (this.groups != null && this.groups.length > 0) {
            for (int i = 0; i < this.groups.length; ++i) {
                this.beforeGroupInit(this.groups[i].getName());
            }
        }
    }

    public void callAfterReportInit() throws JRScriptletException {
        if (this.groups != null && this.groups.length > 0) {
            for (int i = this.groups.length - 1; i >= 0; --i) {
                this.afterGroupInit(this.groups[i].getName());
            }
        }
        this.afterColumnInit();
        this.afterPageInit();
        this.afterReportInit();
    }

    public void callBeforePageInit() throws JRScriptletException {
        this.beforePageInit();
        this.beforeColumnInit();
    }

    public void callAfterPageInit() throws JRScriptletException {
        this.afterColumnInit();
        this.afterPageInit();
    }

    public void callBeforeColumnInit() throws JRScriptletException {
        this.beforeColumnInit();
    }

    public void callAfterColumnInit() throws JRScriptletException {
        this.afterColumnInit();
    }

    public void callBeforeGroupInit() throws JRScriptletException {
        if (this.groups != null && this.groups.length > 0) {
            JRFillGroup group = null;
            for (int i = 0; i < this.groups.length; ++i) {
                group = this.groups[i];
                if (!group.hasChanged()) continue;
                this.beforeGroupInit(group.getName());
            }
        }
    }

    public void callAfterGroupInit() throws JRScriptletException {
        if (this.groups != null && this.groups.length > 0) {
            JRFillGroup group = null;
            for (int i = this.groups.length - 1; i >= 0; --i) {
                group = this.groups[i];
                if (!group.hasChanged()) continue;
                this.afterGroupInit(group.getName());
            }
        }
    }

    public void callBeforeDetailEval() throws JRScriptletException {
        this.beforeDetailEval();
    }

    public void callAfterDetailEval() throws JRScriptletException {
        this.afterDetailEval();
    }

    public abstract void beforeReportInit() throws JRScriptletException;

    public abstract void afterReportInit() throws JRScriptletException;

    public abstract void beforePageInit() throws JRScriptletException;

    public abstract void afterPageInit() throws JRScriptletException;

    public abstract void beforeColumnInit() throws JRScriptletException;

    public abstract void afterColumnInit() throws JRScriptletException;

    public abstract void beforeGroupInit(String var1) throws JRScriptletException;

    public abstract void afterGroupInit(String var1) throws JRScriptletException;

    public abstract void beforeDetailEval() throws JRScriptletException;

    public abstract void afterDetailEval() throws JRScriptletException;
}

