/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.geom.Dimension2D;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRImageRenderer;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintElementIndex;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintGraphicElement;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRWrappingSvgRenderer;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.base.JRBaseLineBox;
import net.sf.jasperreports.engine.base.JRBoxPen;
import net.sf.jasperreports.engine.export.CutsInfo;
import net.sf.jasperreports.engine.export.ElementGridCell;
import net.sf.jasperreports.engine.export.ExporterNature;
import net.sf.jasperreports.engine.export.GenericElementHandlerEnviroment;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.JRGridLayout;
import net.sf.jasperreports.engine.export.JRHyperlinkProducer;
import net.sf.jasperreports.engine.export.JRXlsAbstractExporter;
import net.sf.jasperreports.engine.export.LengthUtil;
import net.sf.jasperreports.engine.export.OccupiedGridCell;
import net.sf.jasperreports.engine.export.data.BooleanTextValue;
import net.sf.jasperreports.engine.export.data.DateTextValue;
import net.sf.jasperreports.engine.export.data.NumberTextValue;
import net.sf.jasperreports.engine.export.data.StringTextValue;
import net.sf.jasperreports.engine.export.data.TextValue;
import net.sf.jasperreports.engine.export.data.TextValueHandler;
import net.sf.jasperreports.engine.export.ooxml.GenericElementXlsxHandler;
import net.sf.jasperreports.engine.export.ooxml.JRXlsxExporterContext;
import net.sf.jasperreports.engine.export.ooxml.JRXlsxExporterNature;
import net.sf.jasperreports.engine.export.ooxml.XlsxCellHelper;
import net.sf.jasperreports.engine.export.ooxml.XlsxContentTypesHelper;
import net.sf.jasperreports.engine.export.ooxml.XlsxDrawingHelper;
import net.sf.jasperreports.engine.export.ooxml.XlsxDrawingRelsHelper;
import net.sf.jasperreports.engine.export.ooxml.XlsxRelsHelper;
import net.sf.jasperreports.engine.export.ooxml.XlsxRunHelper;
import net.sf.jasperreports.engine.export.ooxml.XlsxSheetHelper;
import net.sf.jasperreports.engine.export.ooxml.XlsxSheetRelsHelper;
import net.sf.jasperreports.engine.export.ooxml.XlsxStyleHelper;
import net.sf.jasperreports.engine.export.ooxml.XlsxWorkbookHelper;
import net.sf.jasperreports.engine.export.ooxml.XlsxZip;
import net.sf.jasperreports.engine.export.zip.ExportZipEntry;
import net.sf.jasperreports.engine.export.zip.FileBufferedZipEntry;
import net.sf.jasperreports.engine.type.LineDirectionEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.util.JRDataUtils;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRTypeSniffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRXlsxExporter
extends JRXlsAbstractExporter {
    private static final Log log = LogFactory.getLog(JRXlsxExporter.class);
    public static final String XLSX_EXPORTER_KEY = "net.sf.jasperreports.xlsx";
    protected static final String XLSX_EXPORTER_PROPERTIES_PREFIX = "net.sf.jasperreports.export.xlsx.";
    protected static final String JR_PAGE_ANCHOR_PREFIX = "JR_PAGE_ANCHOR_";
    public static final String IMAGE_NAME_PREFIX = "img_";
    protected static final int IMAGE_NAME_PREFIX_LEGTH = "img_".length();
    protected XlsxZip xlsxZip;
    protected XlsxWorkbookHelper wbHelper;
    protected XlsxRelsHelper relsHelper;
    protected XlsxContentTypesHelper ctHelper;
    protected XlsxSheetHelper sheetHelper;
    protected XlsxSheetRelsHelper sheetRelsHelper;
    protected XlsxDrawingHelper drawingHelper;
    protected XlsxDrawingRelsHelper drawingRelsHelper;
    protected XlsxStyleHelper styleHelper;
    protected XlsxCellHelper cellHelper;
    protected JRExportProgressMonitor progressMonitor;
    protected Map<String, String> rendererToImagePathMap;
    protected List<JRPrintElementIndex> imagesToProcess;
    protected int tableIndex;
    protected boolean startPage;
    protected LinkedList<Color> backcolorStack = new LinkedList();
    protected Color backcolor = null;
    private XlsxRunHelper runHelper;
    protected ExporterNature nature;
    protected String sheetAutoFilter;

    @Override
    protected void setParameters() {
        super.setParameters();
        this.nature = new JRXlsxExporterNature(this.filter, this.isIgnoreGraphics, this.isIgnorePageMargins);
    }

    public static JRPrintImage getImage(List<JasperPrint> jasperPrintList, String imageName) throws JRException {
        return JRXlsxExporter.getImage(jasperPrintList, JRXlsxExporter.getPrintElementIndex(imageName));
    }

    public static JRPrintImage getImage(List<JasperPrint> jasperPrintList, JRPrintElementIndex imageIndex) throws JRException {
        JasperPrint report = jasperPrintList.get(imageIndex.getReportIndex());
        JRPrintPage page = report.getPages().get(imageIndex.getPageIndex());
        Integer[] elementIndexes = imageIndex.getAddressArray();
        JRPrintElement element = page.getElements().get(elementIndexes[0]);
        for (int i = 1; i < elementIndexes.length; ++i) {
            JRPrintFrame frame = (JRPrintFrame)element;
            element = frame.getElements().get(elementIndexes[i]);
        }
        if (element instanceof JRGenericPrintElement) {
            JRGenericPrintElement genericPrintElement = (JRGenericPrintElement)element;
            return ((GenericElementXlsxHandler)GenericElementHandlerEnviroment.getHandler(genericPrintElement.getGenericType(), XLSX_EXPORTER_KEY)).getImage(genericPrintElement);
        }
        return (JRPrintImage)element;
    }

    protected void exportStyledText(JRStyle style, JRStyledText styledText, Locale locale) {
        String text = styledText.getText();
        int runLimit = 0;
        AttributedCharacterIterator iterator = styledText.getAttributedString().getIterator();
        while (runLimit < styledText.length() && (runLimit = iterator.getRunLimit()) <= styledText.length()) {
            this.runHelper.export(style, iterator.getAttributes(), text.substring(iterator.getIndex(), runLimit), locale);
            iterator.setIndex(runLimit);
        }
    }

    protected String getImagePath(JRRenderable renderer, boolean isLazy, JRExporterGridCell gridCell) {
        String imagePath = null;
        if (renderer != null) {
            if (renderer.getType() == 0 && this.rendererToImagePathMap.containsKey(renderer.getId())) {
                imagePath = this.rendererToImagePathMap.get(renderer.getId());
            } else {
                String imageName;
                JRPrintElementIndex imageIndex = this.getElementIndex(gridCell);
                this.imagesToProcess.add(imageIndex);
                String mimeType = JRTypeSniffer.getImageMimeType(renderer.getImageType());
                if (mimeType == null) {
                    mimeType = "image/jpeg";
                }
                String extension = mimeType.substring(mimeType.lastIndexOf(47) + 1);
                imagePath = imageName = IMAGE_NAME_PREFIX + imageIndex.toString() + "." + extension;
                this.rendererToImagePathMap.put(renderer.getId(), imagePath);
            }
        }
        return imagePath;
    }

    protected JRPrintElementIndex getElementIndex(JRExporterGridCell gridCell) {
        JRPrintElementIndex imageIndex = new JRPrintElementIndex(this.reportIndex, this.pageIndex, gridCell.getWrapper().getAddress());
        return imageIndex;
    }

    public static JRPrintElementIndex getPrintElementIndex(String imageName) {
        if (!imageName.startsWith(IMAGE_NAME_PREFIX)) {
            throw new JRRuntimeException("Invalid image name: " + imageName);
        }
        return JRPrintElementIndex.parsePrintElementIndex(imageName.substring(IMAGE_NAME_PREFIX_LEGTH));
    }

    protected void setBackcolor(Color color) {
        this.backcolorStack.addLast(this.backcolor);
        this.backcolor = color;
    }

    protected void restoreBackcolor() {
        this.backcolor = this.backcolorStack.removeLast();
    }

    protected String getHyperlinkTarget(JRPrintHyperlink link) {
        String target = null;
        switch (link.getHyperlinkTargetValue()) {
            case SELF: {
                target = "_self";
                break;
            }
            default: {
                target = "_blank";
            }
        }
        return target;
    }

    protected String getHyperlinkURL(JRPrintHyperlink link) {
        String href;
        block10: {
            JRHyperlinkProducer customHandler;
            block9: {
                href = null;
                customHandler = this.getCustomHandler(link);
                if (customHandler != null) break block9;
                switch (link.getHyperlinkTypeValue()) {
                    case REFERENCE: {
                        if (link.getHyperlinkReference() != null) {
                            href = link.getHyperlinkReference();
                            break;
                        }
                        break block10;
                    }
                    case LOCAL_ANCHOR: {
                        break;
                    }
                    case LOCAL_PAGE: {
                        break;
                    }
                    case REMOTE_ANCHOR: {
                        if (link.getHyperlinkReference() != null && link.getHyperlinkAnchor() != null) {
                            href = link.getHyperlinkReference() + "#" + link.getHyperlinkAnchor();
                            break;
                        }
                        break block10;
                    }
                    case REMOTE_PAGE: {
                        break;
                    }
                }
                break block10;
            }
            href = customHandler.getHyperlink(link);
        }
        return href;
    }

    protected String getExporterPropertiesPrefix() {
        return XLSX_EXPORTER_PROPERTIES_PREFIX;
    }

    @Override
    protected void addBlankCell(JRExporterGridCell gridCell, int colIndex, int rowIndex) throws JRException {
        this.cellHelper.exportHeader(gridCell, rowIndex, colIndex);
        this.cellHelper.exportFooter();
    }

    @Override
    protected void closeWorkbook(OutputStream os) throws JRException {
        this.closeSheet();
        this.styleHelper.export();
        this.styleHelper.close();
        try {
            this.wbHelper.exportFooter();
            this.wbHelper.close();
            if (this.imagesToProcess != null && this.imagesToProcess.size() > 0) {
                for (JRPrintElementIndex imageIndex : this.imagesToProcess) {
                    String mimeType;
                    JRPrintImage image = JRXlsxExporter.getImage((List<JasperPrint>)this.jasperPrintList, imageIndex);
                    JRRenderable renderer = image.getRenderer();
                    if (renderer.getType() == 1) {
                        renderer = new JRWrappingSvgRenderer(renderer, new Dimension(image.getWidth(), image.getHeight()), ModeEnum.OPAQUE == image.getModeValue() ? image.getBackcolor() : null);
                    }
                    if ((mimeType = JRTypeSniffer.getImageMimeType(renderer.getImageType())) == null) {
                        mimeType = "image/jpeg";
                    }
                    String extension = mimeType.substring(mimeType.lastIndexOf(47) + 1);
                    String imageName = IMAGE_NAME_PREFIX + imageIndex.toString() + "." + extension;
                    this.xlsxZip.addEntry(new FileBufferedZipEntry("xl/media/" + imageName, renderer.getImageData()));
                }
            }
            this.relsHelper.exportFooter();
            this.relsHelper.close();
            this.ctHelper.exportFooter();
            this.ctHelper.close();
            this.xlsxZip.zipEntries(os);
            this.xlsxZip.dispose();
        }
        catch (IOException e) {
            throw new JRException(e);
        }
    }

    @Override
    protected void createSheet(String name) {
        this.closeSheet();
        this.wbHelper.exportSheet(this.sheetIndex + 1, name);
        this.ctHelper.exportSheet(this.sheetIndex + 1);
        this.relsHelper.exportSheet(this.sheetIndex + 1);
        ExportZipEntry sheetRelsEntry = this.xlsxZip.addSheetRels(this.sheetIndex + 1);
        Writer sheetRelsWriter = sheetRelsEntry.getWriter();
        this.sheetRelsHelper = new XlsxSheetRelsHelper(sheetRelsWriter);
        ExportZipEntry sheetEntry = this.xlsxZip.addSheet(this.sheetIndex + 1);
        Writer sheetWriter = sheetEntry.getWriter();
        this.sheetHelper = new XlsxSheetHelper(sheetWriter, this.sheetRelsHelper, this.isCollapseRowSpan);
        ExportZipEntry drawingRelsEntry = this.xlsxZip.addDrawingRels(this.sheetIndex + 1);
        Writer drawingRelsWriter = drawingRelsEntry.getWriter();
        this.drawingRelsHelper = new XlsxDrawingRelsHelper(drawingRelsWriter);
        ExportZipEntry drawingEntry = this.xlsxZip.addDrawing(this.sheetIndex + 1);
        Writer drawingWriter = drawingEntry.getWriter();
        this.drawingHelper = new XlsxDrawingHelper(drawingWriter, this.drawingRelsHelper);
        this.cellHelper = new XlsxCellHelper(sheetWriter, this.styleHelper);
        this.runHelper = new XlsxRunHelper(sheetWriter, this.fontMap, null);
        this.sheetHelper.exportHeader(this.gridRowFreezeIndex, this.gridColumnFreezeIndex, this.jasperPrint);
        this.sheetRelsHelper.exportHeader(this.sheetIndex + 1);
        this.drawingHelper.exportHeader();
        this.drawingRelsHelper.exportHeader();
    }

    protected void closeSheet() {
        if (this.sheetHelper != null) {
            this.sheetHelper.exportFooter(this.sheetIndex, this.jasperPrint, this.isIgnorePageMargins, this.sheetAutoFilter == null ? this.autoFilter : this.sheetAutoFilter);
            this.sheetHelper.close();
            this.sheetRelsHelper.exportFooter();
            this.sheetRelsHelper.close();
            this.drawingHelper.exportFooter();
            this.drawingHelper.close();
            this.drawingRelsHelper.exportFooter();
            this.drawingRelsHelper.close();
        }
        this.sheetAutoFilter = null;
    }

    @Override
    protected void exportFrame(JRPrintFrame frame, JRExporterGridCell gridCell, int colIndex, int rowIndex) throws JRException {
        this.cellHelper.exportHeader(gridCell, rowIndex, colIndex);
        this.sheetHelper.exportMergedCells(rowIndex, colIndex, gridCell.getRowSpan(), gridCell.getColSpan());
        this.cellHelper.exportFooter();
    }

    @Override
    public void exportImage(JRPrintImage image, JRExporterGridCell gridCell, int colIndex, int rowIndex, int emptyCols, int yCutsRow, JRGridLayout layout) throws JRException {
        int topPadding = Math.max(image.getLineBox().getTopPadding(), this.getImageBorderCorrection(image.getLineBox().getTopPen()));
        int leftPadding = Math.max(image.getLineBox().getLeftPadding(), this.getImageBorderCorrection(image.getLineBox().getLeftPen()));
        int bottomPadding = Math.max(image.getLineBox().getBottomPadding(), this.getImageBorderCorrection(image.getLineBox().getBottomPen()));
        int rightPadding = Math.max(image.getLineBox().getRightPadding(), this.getImageBorderCorrection(image.getLineBox().getRightPen()));
        int availableImageWidth = image.getWidth() - leftPadding - rightPadding;
        availableImageWidth = availableImageWidth < 0 ? 0 : availableImageWidth;
        int availableImageHeight = image.getHeight() - topPadding - bottomPadding;
        availableImageHeight = availableImageHeight < 0 ? 0 : availableImageHeight;
        this.cellHelper.exportHeader(gridCell, rowIndex, colIndex);
        JRRenderable renderer = image.getRenderer();
        if (renderer != null && availableImageWidth > 0 && availableImageHeight > 0) {
            if (renderer.getType() == 0) {
                renderer = JRImageRenderer.getOnErrorRendererForImageData(renderer, image.getOnErrorTypeValue());
            }
        } else {
            renderer = null;
        }
        if (renderer != null) {
            Dimension2D dimension;
            int width = availableImageWidth;
            int height = availableImageHeight;
            double normalWidth = availableImageWidth;
            double normalHeight = availableImageHeight;
            JRRenderable tmpRenderer = JRImageRenderer.getOnErrorRendererForDimension(renderer, image.getOnErrorTypeValue());
            Dimension2D dimension2D = dimension = tmpRenderer == null ? null : tmpRenderer.getDimension();
            if (tmpRenderer == renderer && dimension != null) {
                normalWidth = dimension.getWidth();
                normalHeight = dimension.getHeight();
            }
            double cropTop = 0.0;
            double cropLeft = 0.0;
            double cropBottom = 0.0;
            double cropRight = 0.0;
            block0 : switch (image.getScaleImageValue()) {
                case FILL_FRAME: {
                    width = availableImageWidth;
                    height = availableImageHeight;
                    break;
                }
                case CLIP: {
                    switch (image.getHorizontalAlignmentValue()) {
                        case RIGHT: {
                            cropLeft = 100000.0 * ((double)availableImageWidth - normalWidth) / (double)availableImageWidth;
                            cropRight = 0.0;
                            break;
                        }
                        case CENTER: {
                            cropRight = cropLeft = 100000.0 * ((double)availableImageWidth - normalWidth) / (double)availableImageWidth / 2.0;
                            break;
                        }
                        default: {
                            cropLeft = 0.0;
                            cropRight = 100000.0 * ((double)availableImageWidth - normalWidth) / (double)availableImageWidth;
                        }
                    }
                    switch (image.getVerticalAlignmentValue()) {
                        case TOP: {
                            cropTop = 0.0;
                            cropBottom = 100000.0 * ((double)availableImageHeight - normalHeight) / (double)availableImageHeight;
                            break block0;
                        }
                        case MIDDLE: {
                            cropBottom = cropTop = 100000.0 * ((double)availableImageHeight - normalHeight) / (double)availableImageHeight / 2.0;
                            break block0;
                        }
                    }
                    cropTop = 100000.0 * ((double)availableImageHeight - normalHeight) / (double)availableImageHeight;
                    cropBottom = 0.0;
                    break;
                }
                default: {
                    if (availableImageHeight <= 0) break;
                    double ratio = normalWidth / normalHeight;
                    if (ratio > (double)availableImageWidth / (double)availableImageHeight) {
                        width = availableImageWidth;
                        height = (int)((double)width / ratio);
                        switch (image.getVerticalAlignmentValue()) {
                            case TOP: {
                                cropTop = 0.0;
                                cropBottom = 100000 * (availableImageHeight - height) / availableImageHeight;
                                break block0;
                            }
                            case MIDDLE: {
                                cropBottom = cropTop = (double)(100000 * (availableImageHeight - height) / availableImageHeight / 2);
                                break block0;
                            }
                        }
                        cropTop = 100000 * (availableImageHeight - height) / availableImageHeight;
                        cropBottom = 0.0;
                        break;
                    }
                    height = availableImageHeight;
                    width = (int)(ratio * (double)height);
                    switch (image.getHorizontalAlignmentValue()) {
                        case RIGHT: {
                            cropLeft = 100000 * (availableImageWidth - width) / availableImageWidth;
                            cropRight = 0.0;
                            break block0;
                        }
                        case CENTER: {
                            cropRight = cropLeft = (double)(100000 * (availableImageWidth - width) / availableImageWidth / 2);
                            break block0;
                        }
                    }
                    cropLeft = 0.0;
                    cropRight = 100000 * (availableImageWidth - width) / availableImageWidth;
                }
            }
            String imageName = this.getImagePath(renderer, image.isLazy(), gridCell);
            this.drawingRelsHelper.exportImage(imageName);
            this.sheetHelper.exportMergedCells(rowIndex, colIndex, gridCell.getRowSpan(), gridCell.getColSpan());
            this.drawingHelper.write("<xdr:twoCellAnchor editAs=\"oneCell\">\n");
            this.drawingHelper.write("<xdr:from><xdr:col>" + colIndex + "</xdr:col><xdr:colOff>" + LengthUtil.emu(leftPadding) + "</xdr:colOff><xdr:row>" + rowIndex + "</xdr:row><xdr:rowOff>" + LengthUtil.emu(topPadding) + "</xdr:rowOff></xdr:from>\n");
            this.drawingHelper.write("<xdr:to><xdr:col>" + (colIndex + gridCell.getColSpan()) + "</xdr:col><xdr:colOff>" + LengthUtil.emu(-rightPadding) + "</xdr:colOff><xdr:row>" + (rowIndex + (this.isCollapseRowSpan ? 1 : gridCell.getRowSpan())) + "</xdr:row><xdr:rowOff>" + LengthUtil.emu(-bottomPadding) + "</xdr:rowOff></xdr:to>\n");
            this.drawingHelper.write("<xdr:pic>\n");
            this.drawingHelper.write("<xdr:nvPicPr><xdr:cNvPr id=\"" + (image.hashCode() > 0 ? image.hashCode() : -image.hashCode()) + "\" name=\"Picture\">\n");
            String href = this.getHyperlinkURL(image);
            if (href != null) {
                this.drawingHelper.exportHyperlink(href);
            }
            this.drawingHelper.write("</xdr:cNvPr><xdr:cNvPicPr/></xdr:nvPicPr>\n");
            this.drawingHelper.write("<xdr:blipFill>\n");
            this.drawingHelper.write("<a:blip r:embed=\"" + imageName + "\"/>");
            this.drawingHelper.write("<a:srcRect");
            this.drawingHelper.write("/>");
            this.drawingHelper.write("<a:stretch><a:fillRect");
            this.drawingHelper.write(" l=\"" + (int)cropLeft + "\"");
            this.drawingHelper.write(" t=\"" + (int)cropTop + "\"");
            this.drawingHelper.write(" r=\"" + (int)cropRight + "\"");
            this.drawingHelper.write(" b=\"" + (int)cropBottom + "\"");
            this.drawingHelper.write("/></a:stretch>\n");
            this.drawingHelper.write("</xdr:blipFill>\n");
            this.drawingHelper.write("<xdr:spPr><a:xfrm><a:off x=\"0\" y=\"0\"/><a:ext cx=\"" + LengthUtil.emu(0.0f) + "\" cy=\"" + LengthUtil.emu(0.0f) + "\"/>");
            this.drawingHelper.write("</a:xfrm><a:prstGeom prst=\"rect\"></a:prstGeom>\n");
            this.drawingHelper.write("</xdr:spPr>\n");
            this.drawingHelper.write("</xdr:pic>\n");
            this.drawingHelper.write("<xdr:clientData/>\n");
            this.drawingHelper.write("</xdr:twoCellAnchor>\n");
        }
        this.cellHelper.exportFooter();
    }

    @Override
    protected void exportLine(JRPrintLine line, JRExporterGridCell gridCell, int colIndex, int rowIndex) throws JRException {
        JRBaseLineBox box = new JRBaseLineBox(null);
        JRBoxPen pen = null;
        float ratio = line.getWidth() / line.getHeight();
        pen = ratio > 1.0f ? (line.getDirectionValue() == LineDirectionEnum.TOP_DOWN ? box.getTopPen() : box.getBottomPen()) : (line.getDirectionValue() == LineDirectionEnum.TOP_DOWN ? box.getLeftPen() : box.getRightPen());
        pen.setLineColor(line.getLinePen().getLineColor());
        pen.setLineStyle(line.getLinePen().getLineStyleValue());
        pen.setLineWidth(line.getLinePen().getLineWidth());
        gridCell.setBox(box);
        this.cellHelper.exportHeader(gridCell, rowIndex, colIndex);
        this.sheetHelper.exportMergedCells(rowIndex, colIndex, gridCell.getRowSpan(), gridCell.getColSpan());
        this.cellHelper.exportFooter();
    }

    @Override
    protected void exportRectangle(JRPrintGraphicElement rectangle, JRExporterGridCell gridCell, int colIndex, int rowIndex) throws JRException {
        JRBaseLineBox box = new JRBaseLineBox(null);
        JRBoxPen pen = box.getPen();
        pen.setLineColor(rectangle.getLinePen().getLineColor());
        pen.setLineStyle(rectangle.getLinePen().getLineStyleValue());
        pen.setLineWidth(rectangle.getLinePen().getLineWidth());
        gridCell.setBox(box);
        this.cellHelper.exportHeader(gridCell, rowIndex, colIndex);
        this.sheetHelper.exportMergedCells(rowIndex, colIndex, gridCell.getRowSpan(), gridCell.getColSpan());
        this.cellHelper.exportFooter();
    }

    @Override
    public void exportText(final JRPrintText text, JRExporterGridCell gridCell, int colIndex, int rowIndex) throws JRException {
        String href;
        final JRStyledText styledText = this.getStyledText(text);
        final int textLength = styledText == null ? 0 : styledText.length();
        String textStr = styledText.getText();
        TextValue textValue = null;
        String pattern = null;
        if (this.isDetectCellType) {
            textValue = this.getTextValue(text, textStr);
            if (textValue instanceof NumberTextValue) {
                pattern = ((NumberTextValue)textValue).getPattern();
            } else if (textValue instanceof DateTextValue) {
                pattern = ((DateTextValue)textValue).getPattern();
            }
        }
        this.cellHelper.exportHeader(gridCell, rowIndex, colIndex, textValue, this.getConvertedPattern(text, pattern), this.getTextLocale(text), this.isWrapText(gridCell.getElement()), this.isCellHidden(gridCell.getElement()), this.isCellLocked(gridCell.getElement()));
        this.sheetHelper.exportMergedCells(rowIndex, colIndex, gridCell.getRowSpan(), gridCell.getColSpan());
        String textFormula = this.getFormula(text);
        if (textFormula != null) {
            this.sheetHelper.write("<f>" + textFormula + "</f>\n");
        }
        if ((href = this.getHyperlinkURL(text)) != null) {
            this.sheetHelper.exportHyperlink(rowIndex, colIndex, href);
        }
        TextValueHandler handler = new TextValueHandler(){

            public void handle(BooleanTextValue textValue) throws JRException {
                this.writeText();
            }

            public void handle(DateTextValue textValue) throws JRException {
                Date date = textValue.getValue();
                JRXlsxExporter.this.sheetHelper.write("<v>" + (date == null ? "" : Double.valueOf(JRDataUtils.getExcelSerialDayNumber(date, JRXlsxExporter.this.getTextLocale(text), JRXlsxExporter.this.getTextTimeZone(text)))) + "</v>");
            }

            public void handle(NumberTextValue textValue) throws JRException {
                Number number = textValue.getValue();
                JRXlsxExporter.this.sheetHelper.write("<v>" + (number == null ? "" : number) + "</v>");
            }

            public void handle(StringTextValue textValue) throws JRException {
                this.writeText();
            }

            private void writeText() throws JRException {
                JRXlsxExporter.this.sheetHelper.write("<is>");
                if (textLength > 0) {
                    JRXlsxExporter.this.exportStyledText(text.getStyle(), styledText, JRXlsxExporter.this.getTextLocale(text));
                }
                JRXlsxExporter.this.sheetHelper.write("</is>");
            }
        };
        if (textValue != null) {
            textValue.handle(handler);
        } else {
            handler.handle((StringTextValue)null);
        }
        this.sheetHelper.flush();
        this.cellHelper.exportFooter();
    }

    @Override
    protected void exportGenericElement(JRGenericPrintElement element, JRExporterGridCell gridCell, int colIndex, int rowIndex, int emptyCols, int yCutsRow, JRGridLayout layout) throws JRException {
        GenericElementXlsxHandler handler = (GenericElementXlsxHandler)GenericElementHandlerEnviroment.getHandler(element.getGenericType(), XLSX_EXPORTER_KEY);
        if (handler != null) {
            ExporterContext exporterContext = new ExporterContext();
            handler.exportElement(exporterContext, element, gridCell, colIndex, rowIndex);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("No XLSX generic element handler for " + element.getGenericType()));
        }
    }

    @Override
    protected ExporterNature getNature() {
        return this.nature;
    }

    @Override
    protected void openWorkbook(OutputStream os) throws JRException {
        this.rendererToImagePathMap = new HashMap<String, String>();
        this.imagesToProcess = new ArrayList<JRPrintElementIndex>();
        try {
            this.xlsxZip = new XlsxZip();
            this.wbHelper = new XlsxWorkbookHelper(this.xlsxZip.getWorkbookEntry().getWriter());
            this.wbHelper.exportHeader();
            this.relsHelper = new XlsxRelsHelper(this.xlsxZip.getRelsEntry().getWriter());
            this.relsHelper.exportHeader();
            this.ctHelper = new XlsxContentTypesHelper(this.xlsxZip.getContentTypesEntry().getWriter());
            this.ctHelper.exportHeader();
            this.styleHelper = new XlsxStyleHelper(this.xlsxZip.getStylesEntry().getWriter(), this.fontMap, this.getExporterKey(), this.isWhitePageBackground, this.isIgnoreCellBorder, this.isIgnoreCellBackground, this.isFontSizeFixEnabled);
        }
        catch (IOException e) {
            throw new JRException(e);
        }
    }

    @Override
    protected void setColumnWidths(CutsInfo xCuts) {
        for (int col = 0; col < xCuts.size() - 1; ++col) {
            int width = xCuts.getCustomWidth(col) != null ? xCuts.getCustomWidth(col) : xCuts.getCutOffset(col + 1) - xCuts.getCutOffset(col);
            this.setColumnWidth(col, !this.isRemoveEmptySpaceBetweenColumns || xCuts.isCutNotEmpty(col) || xCuts.isCutSpanned(col) || !xCuts.isAutoFit(col) ? width : 0);
        }
    }

    @Override
    protected void removeColumn(int col) {
    }

    @Override
    protected void setBackground() {
    }

    @Override
    protected void setCell(JRExporterGridCell gridCell, int colIndex, int rowIndex) {
    }

    @Override
    protected void addOccupiedCell(OccupiedGridCell occupiedGridCell, int colIndex, int rowIndex) {
        ElementGridCell elementGridCell = (ElementGridCell)occupiedGridCell.getOccupier();
        this.cellHelper.exportHeader(elementGridCell, rowIndex, colIndex);
        this.cellHelper.exportFooter();
    }

    @Override
    protected void setColumnWidth(int col, int width) {
        this.sheetHelper.exportColumn(col, width);
    }

    @Override
    protected void setRowHeight(int rowIndex, int rowHeight) throws JRException {
        this.sheetHelper.exportRow(rowHeight);
    }

    @Override
    protected String getExporterKey() {
        return XLSX_EXPORTER_KEY;
    }

    @Override
    protected void setFreezePane(int rowIndex, int colIndex, boolean isRowEdge, boolean isColumnEdge) {
    }

    @Override
    protected void setSheetName(String sheetName) {
    }

    @Override
    protected void setAutoFilter(String autoFilterRange) {
        this.sheetAutoFilter = autoFilterRange;
    }

    protected class ExporterContext
    extends JRAbstractExporter.BaseExporterContext
    implements JRXlsxExporterContext {
        protected ExporterContext() {
        }

        public String getExportPropertiesPrefix() {
            return JRXlsxExporter.XLSX_EXPORTER_PROPERTIES_PREFIX;
        }
    }
}

