/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.io.Serializable;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRCloneable;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRSection;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;
import net.sf.jasperreports.engine.util.JRCloneUtils;

public class JRBaseSection
implements JRSection,
JRChangeEventsSupport,
Serializable {
    private static final long serialVersionUID = 10200L;
    protected JRBand[] bands;
    private transient JRPropertyChangeSupport eventSupport;

    protected JRBaseSection() {
    }

    protected JRBaseSection(JRBand band) {
        this.bands = new JRBand[]{band};
    }

    protected JRBaseSection(JRSection section, JRBaseObjectFactory factory) {
        factory.put(section, this);
        JRBand[] jrBands = section.getBands();
        if (jrBands != null && jrBands.length > 0) {
            this.bands = new JRBand[jrBands.length];
            for (int i = 0; i < jrBands.length; ++i) {
                this.bands[i] = factory.getBand(jrBands[i]);
            }
        }
    }

    public JRBand[] getBands() {
        return this.bands;
    }

    public Object clone() {
        JRBaseSection clone = null;
        try {
            clone = (JRBaseSection)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new JRRuntimeException(e);
        }
        clone.bands = (JRBand[])JRCloneUtils.cloneArray((JRCloneable[])this.bands);
        clone.eventSupport = null;
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JRPropertyChangeSupport getEventSupport() {
        JRBaseSection jRBaseSection = this;
        synchronized (jRBaseSection) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport(this);
            }
        }
        return this.eventSupport;
    }
}

