/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.olap4j.Axis;
import org.olap4j.mdx.AxisNode;
import org.olap4j.mdx.CallNode;
import org.olap4j.mdx.CubeNode;
import org.olap4j.mdx.DimensionNode;
import org.olap4j.mdx.IdentifierNode;
import org.olap4j.mdx.LiteralNode;
import org.olap4j.mdx.MemberNode;
import org.olap4j.mdx.ParseTreeNode;
import org.olap4j.mdx.SelectNode;
import org.olap4j.mdx.Syntax;
import org.olap4j.metadata.Member;
import org.olap4j.query.Query;
import org.olap4j.query.QueryAxis;
import org.olap4j.query.QueryDimension;
import org.olap4j.query.Selection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class Olap4jNodeConverter {
    Olap4jNodeConverter() {
    }

    public static SelectNode toOlap4j(Query query) {
        List<IdentifierNode> list = Collections.emptyList();
        List<ParseTreeNode> withList = Collections.emptyList();
        ArrayList<QueryAxis> axisList = new ArrayList<QueryAxis>();
        axisList.add(query.getAxes().get(Axis.COLUMNS));
        axisList.add(query.getAxes().get(Axis.ROWS));
        AxisNode filterAxis = null;
        if (query.getAxes().containsKey(Axis.FILTER)) {
            QueryAxis axis = query.getAxes().get(Axis.FILTER);
            if (!axis.dimensions.isEmpty()) {
                filterAxis = Olap4jNodeConverter.toOlap4j(axis);
            }
        }
        return new SelectNode(null, withList, Olap4jNodeConverter.toOlap4j(axisList), new CubeNode(null, query.getCube()), filterAxis, list);
    }

    private static CallNode generateSetCall(ParseTreeNode ... args) {
        return new CallNode(null, "{}", Syntax.Braces, args);
    }

    private static CallNode generateListSetCall(List<ParseTreeNode> cnodes) {
        return new CallNode(null, "{}", Syntax.Braces, cnodes);
    }

    private static CallNode generateListTupleCall(List<ParseTreeNode> cnodes) {
        return new CallNode(null, "()", Syntax.Parentheses, cnodes);
    }

    protected static CallNode getMemberSet(QueryDimension dimension) {
        return new CallNode(null, "{}", Syntax.Braces, Olap4jNodeConverter.toOlap4j(dimension));
    }

    protected static CallNode crossJoin(QueryDimension dim1, QueryDimension dim2) {
        return new CallNode(null, "CrossJoin", Syntax.Function, Olap4jNodeConverter.getMemberSet(dim1), Olap4jNodeConverter.getMemberSet(dim2));
    }

    private static AxisNode toOlap4j(QueryAxis axis) {
        CallNode callNode = null;
        int numDimensions = axis.getDimensions().size();
        if (axis.getLocation() == Axis.FILTER) {
            ArrayList<ParseTreeNode> members = new ArrayList<ParseTreeNode>();
            for (int dimNo = 0; dimNo < numDimensions; ++dimNo) {
                QueryDimension dimension = axis.getDimensions().get(dimNo);
                if (dimension.getSelections().size() != 1) continue;
                members.addAll(Olap4jNodeConverter.toOlap4j(dimension));
            }
            callNode = Olap4jNodeConverter.generateListTupleCall(members);
        } else if (numDimensions == 1) {
            QueryDimension dimension = axis.getDimensions().get(0);
            List<ParseTreeNode> members = Olap4jNodeConverter.toOlap4j(dimension);
            callNode = Olap4jNodeConverter.generateListSetCall(members);
        } else if (numDimensions == 2) {
            callNode = Olap4jNodeConverter.crossJoin(axis.getDimensions().get(0), axis.getDimensions().get(1));
        } else {
            List<QueryDimension> dims = axis.getDimensions();
            callNode = Olap4jNodeConverter.getMemberSet(dims.get(dims.size() - 1));
            for (int i = dims.size() - 2; i >= 0; --i) {
                CallNode memberSet = Olap4jNodeConverter.getMemberSet(dims.get(i));
                callNode = new CallNode(null, "CrossJoin", Syntax.Function, memberSet, callNode);
            }
        }
        return new AxisNode(null, axis.isNonEmpty(), axis.getLocation(), new ArrayList<IdentifierNode>(), callNode);
    }

    private static List<ParseTreeNode> toOlap4j(QueryDimension dimension) {
        ArrayList<ParseTreeNode> members = new ArrayList<ParseTreeNode>();
        for (Selection selection : dimension.getSelections()) {
            members.add(Olap4jNodeConverter.toOlap4j(selection));
        }
        if (dimension.getSortOrder() != null) {
            CallNode currentMemberNode = new CallNode(null, "CurrentMember", Syntax.Property, new DimensionNode(null, dimension.getDimension()));
            CallNode currentMemberNameNode = new CallNode(null, "Name", Syntax.Property, currentMemberNode);
            ArrayList<ParseTreeNode> orderedList = new ArrayList<ParseTreeNode>();
            orderedList.add(new CallNode(null, "Order", Syntax.Function, Olap4jNodeConverter.generateListSetCall(members), currentMemberNameNode, LiteralNode.createSymbol(null, dimension.getSortOrder().name())));
            return orderedList;
        }
        return members;
    }

    private static ParseTreeNode toOlap4j(Selection selection) {
        try {
            return Olap4jNodeConverter.toOlap4j(selection.getMember(), selection.getOperator());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static ParseTreeNode toOlap4j(Member member, Selection.Operator oper) {
        ParseTreeNode node = null;
        try {
            switch (oper) {
                case MEMBER: {
                    node = new MemberNode(null, member);
                    break;
                }
                case SIBLINGS: {
                    node = new CallNode(null, "Siblings", Syntax.Property, new MemberNode(null, member));
                    break;
                }
                case CHILDREN: {
                    node = new CallNode(null, "Children", Syntax.Property, new MemberNode(null, member));
                    break;
                }
                case INCLUDE_CHILDREN: {
                    node = Olap4jNodeConverter.generateSetCall(new MemberNode(null, member), Olap4jNodeConverter.toOlap4j(member, Selection.Operator.CHILDREN));
                    break;
                }
                case DESCENDANTS: {
                    node = new CallNode(null, "Descendants", Syntax.Function, new MemberNode(null, member));
                    break;
                }
                case ANCESTORS: {
                    node = new CallNode(null, "Ascendants", Syntax.Function, new MemberNode(null, member));
                    break;
                }
                default: {
                    System.out.println("NOT IMPLEMENTED: " + (Object)((Object)oper));
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return node;
    }

    private static List<AxisNode> toOlap4j(List<QueryAxis> axes) {
        ArrayList<AxisNode> axisList = new ArrayList<AxisNode>();
        for (QueryAxis axis : axes) {
            axisList.add(Olap4jNodeConverter.toOlap4j(axis));
        }
        return axisList;
    }
}

