/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.table.navi;

import com.tonbeller.jpivot.mondrian.MondrianLevel;
import com.tonbeller.jpivot.olap.model.Hierarchy;
import com.tonbeller.jpivot.olap.model.Level;
import com.tonbeller.jpivot.olap.model.Member;
import com.tonbeller.jpivot.olap.model.OlapModel;
import com.tonbeller.jpivot.olap.model.VisitorSupportSloppy;
import com.tonbeller.jpivot.olap.navi.DrillReplace;
import com.tonbeller.jpivot.olap.query.DrillReplaceExt;
import com.tonbeller.jpivot.table.TableComponent;
import com.tonbeller.jpivot.table.navi.DrillExpandPositionUI;
import com.tonbeller.jpivot.table.navi.DrillExpandUI;
import com.tonbeller.jpivot.table.span.PropertyHeading;
import com.tonbeller.jpivot.table.span.Span;
import com.tonbeller.jpivot.table.span.SpanVisitor;
import com.tonbeller.jpivot.xmla.XMLA_Level;
import java.util.HashMap;

public class DrillReplaceUI
extends DrillExpandUI {
    public static final String ID = "drillReplace";
    DrillReplace extension;

    public String getId() {
        return ID;
    }

    public DrillReplaceUI() {
        this.isDrillReplace = true;
    }

    protected boolean canCollapse(Span span) {
        CanCollapse cc = new CanCollapse();
        span.getObject().accept(cc);
        return cc.result && this.isZooming(span.getObject());
    }

    private boolean isZooming(Object object) {
        if (object == null) {
            return false;
        }
        boolean result = false;
        if (object instanceof MondrianLevel) {
            result = !((MondrianLevel)object).isZooming();
        } else if (object instanceof XMLA_Level) {
            result = !((XMLA_Level)object).isZooming();
        }
        return result;
    }

    protected void collapse(Span span) {
        DoCollapse dc = new DoCollapse();
        span.getObject().accept(dc);
    }

    protected boolean canExpand(Span span) {
        if (DrillReplaceUI.positionContainsMember(span)) {
            return this.extension.canDrillDown((Member)span.getMember().getRootDecoree());
        }
        return false;
    }

    protected void expand(Span span) {
        this.extension.drillDown((Member)span.getMember().getRootDecoree());
    }

    protected boolean initializeExtension() {
        OlapModel om = this.table.getOlapModel();
        this.extension = (DrillReplace)om.getExtension(ID);
        return this.extension != null;
    }

    protected String getCollapseImage() {
        return "drill-replace-collapse";
    }

    protected String getExpandImage() {
        return "drill-replace-expand";
    }

    protected String getOtherImage() {
        return "drill-replace-other";
    }

    protected boolean canZoom(Span span) {
        return false;
    }

    protected void zoom_out(Span span) {
    }

    protected String getZoomOutImage() {
        return null;
    }

    public void setEnabled(boolean enabled) {
        DrillExpandPositionUI dp;
        HashMap extensions;
        this.enabled = enabled;
        this.setDirty(true);
        TableComponent table = this.table;
        if (table != null && (extensions = (HashMap)table.getExtensions()) != null && (dp = (DrillExpandPositionUI)extensions.get("drillPosition")) != null) {
            dp.setEnabled(!enabled);
        }
    }

    protected boolean isExceeded() {
        return false;
    }

    class DoCollapse
    extends VisitorSupportSloppy
    implements SpanVisitor {
        DoCollapse() {
        }

        public void visitHierarchy(Hierarchy v) {
            DrillReplaceUI.this.extension.drillUp(v);
        }

        public void visitLevel(Level v) {
            ((DrillReplaceExt)DrillReplaceUI.this.extension).drillUp(v);
        }

        public void visitPropertyHeading(PropertyHeading heading) {
        }
    }

    class CanCollapse
    extends VisitorSupportSloppy
    implements SpanVisitor {
        boolean result = false;

        CanCollapse() {
        }

        public void visitHierarchy(Hierarchy v) {
            this.result = DrillReplaceUI.this.extension.canDrillUp(v);
        }

        public void visitLevel(Level v) {
            this.result = DrillReplaceUI.this.extension.canDrillUp(v.getHierarchy());
        }

        public void visitPropertyHeading(PropertyHeading heading) {
        }
    }
}

