/*
 * Decompiled with CFR 0.152.
 */
package org.testng.spring.test;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ConfigurableApplicationContext;
import org.testng.spring.test.AbstractSpringContextNGTests;

public abstract class AbstractDependencyInjectionSpringContextNGTests
extends AbstractSpringContextNGTests {
    private boolean populateProtectedVariables = false;
    private boolean dependencyCheck = true;
    protected ConfigurableApplicationContext applicationContext;
    protected String[] managedVariableNames;
    private int loadCount = 0;

    public void setPopulateProtectedVariables(boolean populateFields) {
        this.populateProtectedVariables = populateFields;
    }

    public boolean isPopulateProtectedVariables() {
        return this.populateProtectedVariables;
    }

    public void setDependencyCheck(boolean dependencyCheck) {
        this.dependencyCheck = dependencyCheck;
    }

    public boolean isDependencyCheck() {
        return this.dependencyCheck;
    }

    public final int getLoadCount() {
        return this.loadCount;
    }

    public void setDirty() {
        this.setDirty(this.getConfigLocations());
    }

    protected final void setUp() throws Exception {
        this.applicationContext = this.getContext(this.contextKey());
        if (this.isPopulateProtectedVariables()) {
            if (this.managedVariableNames == null) {
                this.initManagedVariableNames();
            }
            this.populateProtectedVariables();
        } else {
            this.applicationContext.getBeanFactory().autowireBeanProperties((Object)this, 2, this.isDependencyCheck());
        }
        try {
            this.onSetUp();
        }
        catch (Exception ex) {
            this.logger.error((Object)"Setup error", (Throwable)ex);
            throw ex;
        }
    }

    protected Object contextKey() {
        return this.getConfigLocations();
    }

    protected ConfigurableApplicationContext loadContextLocations(String[] locations) {
        ++this.loadCount;
        return super.loadContextLocations(locations);
    }

    protected void initManagedVariableNames() throws IllegalAccessException {
        LinkedList<String> managedVarNames = new LinkedList<String>();
        Class<?> clazz = this.getClass();
        do {
            Field[] fields = clazz.getDeclaredFields();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Found " + fields.length + " fields on " + clazz));
            }
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                field.setAccessible(true);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Candidate field: " + field));
                }
                if (Modifier.isStatic(field.getModifiers()) || !Modifier.isProtected(field.getModifiers())) continue;
                Object oldValue = field.get(this);
                if (oldValue == null) {
                    managedVarNames.add(field.getName());
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)("Added managed variable '" + field.getName() + "'"));
                    continue;
                }
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Rejected managed variable '" + field.getName() + "'"));
            }
        } while ((clazz = clazz.getSuperclass()) != AbstractSpringContextNGTests.class);
        this.managedVariableNames = managedVarNames.toArray(new String[managedVarNames.size()]);
    }

    protected void populateProtectedVariables() throws IllegalAccessException {
        for (int i = 0; i < this.managedVariableNames.length; ++i) {
            Object bean = null;
            try {
                Field field = this.findField(this.getClass(), this.managedVariableNames[i]);
                bean = this.applicationContext.getBean(this.managedVariableNames[i], field.getType());
                field.setAccessible(true);
                field.set(this, bean);
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Populated field: " + field));
                continue;
            }
            catch (NoSuchFieldException ex) {
                this.logger.warn((Object)("No field with name '" + this.managedVariableNames[i] + "'"));
                continue;
            }
            catch (NoSuchBeanDefinitionException ex) {
                this.logger.warn((Object)("No bean with name '" + this.managedVariableNames[i] + "'"));
            }
        }
    }

    private Field findField(Class clazz, String name) throws NoSuchFieldException {
        try {
            return clazz.getDeclaredField(name);
        }
        catch (NoSuchFieldException ex) {
            Class superclass = clazz.getSuperclass();
            if (superclass != AbstractSpringContextNGTests.class) {
                return this.findField(superclass, name);
            }
            throw ex;
        }
    }

    protected void onSetUp() throws Exception {
    }

    protected final void tearDown() {
        try {
            this.onTearDown();
        }
        catch (Exception ex) {
            this.logger.error((Object)"onTearDown error", (Throwable)ex);
        }
    }

    protected void onTearDown() throws Exception {
    }

    protected abstract String[] getConfigLocations();
}

