/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.theme;

import com.liferay.portal.model.Layout;
import com.liferay.portal.theme.RequestVars;
import com.liferay.portal.theme.ThemeDisplay;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class NavItem
implements Serializable {
    private RequestVars _vars;
    private Layout _layout;
    private List _children;

    public static NavItem fromLayout(RequestVars vars, Layout layout) {
        return new NavItem(vars, layout);
    }

    public static List fromLayouts(RequestVars vars, List layouts) {
        if (layouts == null) {
            return null;
        }
        ArrayList<NavItem> navItems = new ArrayList<NavItem>(layouts.size());
        int i = 0;
        while (i < layouts.size()) {
            Layout layout = (Layout)layouts.get(i);
            navItems.add(NavItem.fromLayout(vars, layout));
            ++i;
        }
        return navItems;
    }

    public boolean isSelected() {
        ThemeDisplay themeDisplay = this._vars.getThemeDisplay();
        return this._layout.isSelected(themeDisplay.isTilesSelectable(), themeDisplay.getLayout(), this._vars.getAncestorLayoutId());
    }

    public String getName() {
        return this._layout.getName(this._vars.getThemeDisplay().getLocale());
    }

    public String getTarget() {
        return this._layout.getTarget();
    }

    public String getTitle() {
        return this._layout.getTitle(this._vars.getThemeDisplay().getLocale());
    }

    public String getURL() throws Exception {
        return this.getResetLayoutURL();
    }

    public String getRegularURL() throws Exception {
        return this._layout.getRegularURL(this._vars.getRequest());
    }

    public String getResetMaxStateURL() throws Exception {
        return this._layout.getResetMaxStateURL(this._vars.getRequest());
    }

    public String getResetLayoutURL() throws Exception {
        return this._layout.getResetLayoutURL(this._vars.getRequest());
    }

    public List getChildren() throws Exception {
        if (this._children == null) {
            ThemeDisplay themeDisplay = this._vars.getThemeDisplay();
            List layouts = this._layout.getChildren(themeDisplay.getPermissionChecker());
            this._children = NavItem.fromLayouts(this._vars, layouts);
        }
        return this._children;
    }

    public boolean hasChildren() throws Exception {
        return this.getChildren().size() > 0;
    }

    public NavItem(RequestVars vars, Layout layout) {
        this._vars = vars;
        this._layout = layout;
    }
}

