/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.ofc;

import java.io.IOException;
import net.sf.jasperreports.components.ofc.PieChartComponent;
import net.sf.jasperreports.components.ofc.PieDataset;
import net.sf.jasperreports.engine.JRElementDataset;
import net.sf.jasperreports.engine.component.Component;
import net.sf.jasperreports.engine.component.ComponentKey;
import net.sf.jasperreports.engine.component.ComponentXmlWriter;
import net.sf.jasperreports.engine.component.ComponentsEnvironment;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.type.JREnum;
import net.sf.jasperreports.engine.util.JRXmlWriteHelper;
import net.sf.jasperreports.engine.util.XmlNamespace;
import net.sf.jasperreports.engine.xml.JRXmlWriter;

public class PieChartXmlWriter
implements ComponentXmlWriter {
    public void writeToXml(ComponentKey componentKey, Component component, JRXmlWriter reportWriter) throws IOException {
        PieChartComponent chart = (PieChartComponent)component;
        JRXmlWriteHelper writer = reportWriter.getXmlWriteHelper();
        String namespaceURI = componentKey.getNamespace();
        String schemaLocation = ComponentsEnvironment.getComponentsBundle((String)namespaceURI).getXmlParser().getPublicSchemaLocation();
        XmlNamespace namespace = new XmlNamespace(namespaceURI, componentKey.getNamespacePrefix(), schemaLocation);
        writer.startElement("pieChart", namespace);
        writer.addAttribute("evaluationTime", (JREnum)chart.getEvaluationTime(), (JREnum)EvaluationTimeEnum.NOW);
        if (chart.getEvaluationTime() == EvaluationTimeEnum.GROUP) {
            writer.addEncodedAttribute("evaluationGroup", chart.getEvaluationGroup());
        }
        PieDataset dataset = chart.getDataset();
        writer.startElement("pieDataset");
        reportWriter.writeElementDataset((JRElementDataset)dataset);
        writer.writeExpression("keyExpression", dataset.getKeyExpression(), false);
        writer.writeExpression("valueExpression", dataset.getValueExpression(), false);
        writer.closeElement();
        writer.writeExpression("titleExpression", chart.getTitleExpression(), false);
        writer.closeElement();
    }
}

