/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.method;

import java.io.Serializable;
import org.springframework.binding.method.Parameter;
import org.springframework.binding.method.Parameters;
import org.springframework.core.style.ToStringCreator;

public class MethodSignature
implements Serializable {
    private String methodName;
    private Parameters parameters;

    public MethodSignature(String methodName) {
        this(methodName, Parameters.NONE);
    }

    public MethodSignature(String methodName, Parameter parameter) {
        this(methodName, new Parameters(parameter));
    }

    public MethodSignature(String methodName, Parameters parameters) {
        this.methodName = methodName;
        this.parameters = parameters;
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MethodSignature)) {
            return false;
        }
        MethodSignature other = (MethodSignature)obj;
        return this.methodName.equals(this.methodName) && this.parameters.equals(other.parameters);
    }

    public int hashCode() {
        return this.methodName.hashCode() + this.parameters.hashCode();
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("methodName", (Object)this.methodName).append("parameters", (Object)this.parameters).toString();
    }
}

