/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.messaging.saaj.soap.dom4j;

import com.sun.xml.messaging.saaj.soap.Envelope;
import com.sun.xml.messaging.saaj.soap.EnvelopeFactory;
import com.sun.xml.messaging.saaj.soap.SOAPVersionMismatchException;
import com.sun.xml.messaging.saaj.soap.dom4j.EnvelopeElementFactory;
import com.sun.xml.messaging.saaj.soap.dom4j.EnvelopeImpl;
import com.sun.xml.messaging.saaj.soap.dom4j.NameImpl;
import com.sun.xml.messaging.saaj.util.JAXMStreamSource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.soap.SOAPException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.stream.StreamSource;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.DocumentResult;
import org.dom4j.io.DocumentSource;
import org.dom4j.io.SAXContentHandler;
import org.dom4j.io.SAXReader;

public class EnvelopeFactoryImpl
extends EnvelopeFactory {
    public Envelope createEnvelope() throws SOAPException {
        return new EnvelopeImpl(true, true);
    }

    public Envelope createEnvelope(Source src) throws SOAPException {
        Element e = null;
        try {
            if (src instanceof DocumentSource) {
                DocumentSource ds = (DocumentSource)src;
                e = ds.getDocument().getRootElement();
            } else if (!(src instanceof StreamSource)) {
                Transformer transformer = EnvelopeFactory.newTransformer();
                DocumentResult result = new DocumentResult(new SAXContentHandler(EnvelopeElementFactory.getInstance()));
                transformer.transform(src, (Result)result);
                Document doc = result.getDocument();
                e = doc.getRootElement();
            } else {
                StreamSource streamSource = (StreamSource)src;
                if (streamSource instanceof JAXMStreamSource) {
                    ((JAXMStreamSource)src).reset();
                }
                SAXReader reader = new SAXReader(EnvelopeElementFactory.getInstance());
                Document document = null;
                reader.setMergeAdjacentText(true);
                document = streamSource.getInputStream() != null ? reader.read(streamSource.getInputStream()) : reader.read(streamSource.getReader());
                e = document.getRootElement();
            }
        }
        catch (Exception ex) {
            throw new SOAPException("Unable to create envelope from given source: " + ex.getMessage());
        }
        if (e instanceof Envelope) {
            return (Envelope)e;
        }
        if (e.getName().equalsIgnoreCase("Envelope") && !e.getNamespaceURI().equals(NameImpl.soapNamespace)) {
            throw new SOAPVersionMismatchException("Unable to create envelope from given source because the namespace was not recognized");
        }
        throw new SOAPException("Unable to create envelope from given source because the root element is not named \"Envelope\"");
    }

    private byte[] readFully(InputStream istream) throws IOException {
        byte[] buf = new byte[1024];
        int num = 0;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        while ((num = istream.read(buf)) != -1) {
            bout.write(buf, 0, num);
        }
        return bout.toByteArray();
    }
}

