/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JROrigin;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRReportTemplate;
import net.sf.jasperreports.engine.JRScriptlet;
import net.sf.jasperreports.engine.JRSection;
import net.sf.jasperreports.engine.JRSortField;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.base.JRBaseReport;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JRDesignQuery;
import net.sf.jasperreports.engine.design.JRDesignSection;
import net.sf.jasperreports.engine.design.JRDesignVariable;
import net.sf.jasperreports.engine.design.events.PropagationChangeListener;
import net.sf.jasperreports.engine.type.BandTypeEnum;
import net.sf.jasperreports.engine.type.OrientationEnum;
import net.sf.jasperreports.engine.type.PrintOrderEnum;
import net.sf.jasperreports.engine.type.RunDirectionEnum;
import net.sf.jasperreports.engine.util.JRElementsVisitor;
import net.sf.jasperreports.engine.util.JRVisitorSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JasperDesign
extends JRBaseReport {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_BACKGROUND = "background";
    public static final String PROPERTY_BOTTOM_MARGIN = "bottomMargin";
    public static final String PROPERTY_COLUMN_COUNT = "columnCount";
    public static final String PROPERTY_COLUMN_FOOTER = "columnFooter";
    public static final String PROPERTY_COLUMN_HEADER = "columnHeader";
    public static final String PROPERTY_COLUMN_SPACING = "columnSpacing";
    public static final String PROPERTY_COLUMN_WIDTH = "columnWidth";
    public static final String PROPERTY_DATASETS = "datasets";
    public static final String PROPERTY_DEFAULT_FONT = "defaultFont";
    public static final String PROPERTY_DEFAULT_STLYE = "defaultStyle";
    public static final String PROPERTY_DETAIL = "detail";
    public static final String PROPERTY_FLOAT_COLUMN_FOOTER = "floatColumnFooter";
    public static final String PROPERTY_FONTS = "fonts";
    public static final String PROPERTY_FORMAT_FACTORY_CLASS = "formatFactoryClass";
    public static final String PROPERTY_IGNORE_PAGINATION = "ignorePagination";
    public static final String PROPERTY_IMPORTS = "imports";
    public static final String PROPERTY_LANGUAGE = "language";
    public static final String PROPERTY_LAST_PAGE_FOOTER = "lastPageFooter";
    public static final String PROPERTY_LEFT_MARGIN = "leftMargin";
    public static final String PROPERTY_MAIN_DATASET = "mainDataset";
    public static final String PROPERTY_NAME = "name";
    public static final String PROPERTY_NO_DATA = "noData";
    public static final String PROPERTY_ORIENTATION = "orientation";
    public static final String PROPERTY_PAGE_FOOTER = "pageFooter";
    public static final String PROPERTY_PAGE_HEADER = "pageHeader";
    public static final String PROPERTY_PAGE_HEIGHT = "pageHeight";
    public static final String PROPERTY_PAGE_WIDTH = "pageWidth";
    public static final String PROPERTY_PRINT_ORDER = "printOrder";
    public static final String PROPERTY_COLUMN_DIRECTION = "columnDirection";
    public static final String PROPERTY_RIGHT_MARGIN = "rightMargin";
    public static final String PROPERTY_STYLES = "styles";
    public static final String PROPERTY_SUMMARY = "summary";
    public static final String PROPERTY_SUMMARY_NEW_PAGE = "summaryNewPage";
    public static final String PROPERTY_SUMMARY_WITH_PAGE_HEADER_AND_FOOTER = "summaryWithPageHeaderAndFooter";
    public static final String PROPERTY_TEMPLATES = "templates";
    public static final String PROPERTY_TITLE = "title";
    public static final String PROPERTY_TITLE_NEW_PAGE = "titleNewPage";
    public static final String PROPERTY_TOP_MARGIN = "topMargin";
    private List<JRReportTemplate> templateList = new ArrayList<JRReportTemplate>();
    private Map<String, JRStyle> stylesMap = new HashMap<String, JRStyle>();
    private List<JRStyle> stylesList = new ArrayList<JRStyle>();
    private JRDesignDataset mainDesignDataset;
    private Map<String, JRDataset> datasetMap = new HashMap<String, JRDataset>();
    private List<JRDataset> datasetList = new ArrayList<JRDataset>();

    public JasperDesign() {
        this.setMainDataset(new JRDesignDataset(true));
        this.detailSection = new JRDesignSection(new JROrigin(BandTypeEnum.DETAIL));
    }

    public void setName(String name) {
        String old = this.name;
        this.name = name;
        this.mainDesignDataset.setName(name);
        this.getEventSupport().firePropertyChange(PROPERTY_NAME, old, this.name);
    }

    public void setLanguage(String language) {
        String old = this.language;
        this.language = language;
        this.getEventSupport().firePropertyChange(PROPERTY_LANGUAGE, old, this.language);
    }

    public void setColumnCount(int columnCount) {
        int old = this.columnCount;
        this.columnCount = columnCount;
        this.getEventSupport().firePropertyChange(PROPERTY_COLUMN_COUNT, old, this.columnCount);
    }

    public void setPrintOrder(PrintOrderEnum printOrderValue) {
        PrintOrderEnum old = this.printOrderValue;
        this.printOrderValue = printOrderValue;
        this.getEventSupport().firePropertyChange(PROPERTY_PRINT_ORDER, old, this.printOrderValue);
    }

    public void setColumnDirection(RunDirectionEnum columnDirection) {
        RunDirectionEnum old = this.columnDirection;
        this.columnDirection = columnDirection;
        this.getEventSupport().firePropertyChange(PROPERTY_COLUMN_DIRECTION, old, this.columnDirection);
    }

    public void setPageWidth(int pageWidth) {
        int old = this.pageWidth;
        this.pageWidth = pageWidth;
        this.getEventSupport().firePropertyChange(PROPERTY_PAGE_WIDTH, old, this.pageWidth);
    }

    public void setPageHeight(int pageHeight) {
        int old = this.pageHeight;
        this.pageHeight = pageHeight;
        this.getEventSupport().firePropertyChange(PROPERTY_PAGE_HEIGHT, old, this.pageHeight);
    }

    public void setOrientation(OrientationEnum orientationValue) {
        OrientationEnum old = this.orientationValue;
        this.orientationValue = orientationValue;
        this.getEventSupport().firePropertyChange(PROPERTY_ORIENTATION, old, this.orientationValue);
    }

    public void setColumnWidth(int columnWidth) {
        int old = this.columnWidth;
        this.columnWidth = columnWidth;
        this.getEventSupport().firePropertyChange(PROPERTY_COLUMN_WIDTH, old, this.columnWidth);
    }

    public void setColumnSpacing(int columnSpacing) {
        int old = this.columnSpacing;
        this.columnSpacing = columnSpacing;
        this.getEventSupport().firePropertyChange(PROPERTY_COLUMN_SPACING, old, this.columnSpacing);
    }

    public void setLeftMargin(int leftMargin) {
        int old = this.leftMargin;
        this.leftMargin = leftMargin;
        this.getEventSupport().firePropertyChange(PROPERTY_LEFT_MARGIN, old, this.leftMargin);
    }

    public void setRightMargin(int rightMargin) {
        int old = this.rightMargin;
        this.rightMargin = rightMargin;
        this.getEventSupport().firePropertyChange(PROPERTY_RIGHT_MARGIN, old, this.rightMargin);
    }

    public void setTopMargin(int topMargin) {
        int old = this.topMargin;
        this.topMargin = topMargin;
        this.getEventSupport().firePropertyChange(PROPERTY_TOP_MARGIN, old, this.topMargin);
    }

    public void setBottomMargin(int bottomMargin) {
        int old = this.bottomMargin;
        this.bottomMargin = bottomMargin;
        this.getEventSupport().firePropertyChange(PROPERTY_BOTTOM_MARGIN, old, this.bottomMargin);
    }

    public void setBackground(JRBand background) {
        JRBand old = this.background;
        this.background = background;
        this.setBandOrigin(this.background, BandTypeEnum.BACKGROUND);
        this.getEventSupport().firePropertyChange(PROPERTY_BACKGROUND, old, this.background);
    }

    public void setTitle(JRBand title) {
        JRBand old = this.title;
        this.title = title;
        this.setBandOrigin(this.title, BandTypeEnum.TITLE);
        this.getEventSupport().firePropertyChange(PROPERTY_TITLE, old, this.title);
    }

    public void setTitleNewPage(boolean isTitleNewPage) {
        boolean old = this.isTitleNewPage;
        this.isTitleNewPage = isTitleNewPage;
        this.getEventSupport().firePropertyChange(PROPERTY_TITLE_NEW_PAGE, old, this.isTitleNewPage);
    }

    public void setSummary(JRBand summary) {
        JRBand old = this.summary;
        this.summary = summary;
        this.setBandOrigin(this.summary, BandTypeEnum.SUMMARY);
        this.getEventSupport().firePropertyChange(PROPERTY_SUMMARY, old, this.summary);
    }

    public void setNoData(JRBand noData) {
        JRBand old = this.noData;
        this.noData = noData;
        this.setBandOrigin(this.noData, BandTypeEnum.NO_DATA);
        this.getEventSupport().firePropertyChange(PROPERTY_NO_DATA, old, this.noData);
    }

    public void setSummaryNewPage(boolean isSummaryNewPage) {
        boolean old = this.isSummaryNewPage;
        this.isSummaryNewPage = isSummaryNewPage;
        this.getEventSupport().firePropertyChange(PROPERTY_SUMMARY_NEW_PAGE, old, this.isSummaryNewPage);
    }

    public void setSummaryWithPageHeaderAndFooter(boolean isSummaryWithPageHeaderAndFooter) {
        boolean old = this.isSummaryWithPageHeaderAndFooter;
        this.isSummaryWithPageHeaderAndFooter = isSummaryWithPageHeaderAndFooter;
        this.getEventSupport().firePropertyChange(PROPERTY_SUMMARY_WITH_PAGE_HEADER_AND_FOOTER, old, this.isSummaryWithPageHeaderAndFooter);
    }

    public void setFloatColumnFooter(boolean isFloatColumnFooter) {
        boolean old = this.isFloatColumnFooter;
        this.isFloatColumnFooter = isFloatColumnFooter;
        this.getEventSupport().firePropertyChange(PROPERTY_FLOAT_COLUMN_FOOTER, old, this.isFloatColumnFooter);
    }

    public void setPageHeader(JRBand pageHeader) {
        JRBand old = this.pageHeader;
        this.pageHeader = pageHeader;
        this.setBandOrigin(this.pageHeader, BandTypeEnum.PAGE_HEADER);
        this.getEventSupport().firePropertyChange(PROPERTY_PAGE_HEADER, old, this.pageHeader);
    }

    public void setPageFooter(JRBand pageFooter) {
        JRBand old = this.pageFooter;
        this.pageFooter = pageFooter;
        this.setBandOrigin(this.pageFooter, BandTypeEnum.PAGE_FOOTER);
        this.getEventSupport().firePropertyChange(PROPERTY_PAGE_FOOTER, old, this.pageFooter);
    }

    public void setLastPageFooter(JRBand lastPageFooter) {
        JRBand old = this.lastPageFooter;
        this.lastPageFooter = lastPageFooter;
        this.setBandOrigin(this.lastPageFooter, BandTypeEnum.LAST_PAGE_FOOTER);
        this.getEventSupport().firePropertyChange(PROPERTY_LAST_PAGE_FOOTER, old, this.lastPageFooter);
    }

    public void setColumnHeader(JRBand columnHeader) {
        JRBand old = this.columnHeader;
        this.columnHeader = columnHeader;
        this.setBandOrigin(this.columnHeader, BandTypeEnum.COLUMN_HEADER);
        this.getEventSupport().firePropertyChange(PROPERTY_COLUMN_HEADER, old, this.columnHeader);
    }

    public void setColumnFooter(JRBand columnFooter) {
        JRBand old = this.columnFooter;
        this.columnFooter = columnFooter;
        this.setBandOrigin(this.columnFooter, BandTypeEnum.COLUMN_FOOTER);
        this.getEventSupport().firePropertyChange(PROPERTY_COLUMN_FOOTER, old, this.columnFooter);
    }

    public void setScriptletClass(String scriptletClass) {
        this.mainDesignDataset.setScriptletClass(scriptletClass);
    }

    public void setFormatFactoryClass(String formatFactoryClass) {
        String old = this.formatFactoryClass;
        this.formatFactoryClass = formatFactoryClass;
        this.getEventSupport().firePropertyChange(PROPERTY_FORMAT_FACTORY_CLASS, old, this.formatFactoryClass);
    }

    public void setResourceBundle(String resourceBundle) {
        this.mainDesignDataset.setResourceBundle(resourceBundle);
    }

    public void addImport(String value) {
        if (this.importsSet == null) {
            this.importsSet = new HashSet();
        }
        if (this.importsSet.add(value)) {
            this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_IMPORTS, value, this.importsSet.size() - 1);
        }
    }

    public void removeImport(String value) {
        if (this.importsSet != null && this.importsSet.remove(value)) {
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_IMPORTS, value, -1);
        }
    }

    public void resetDefaultStyle() {
        for (int i = this.stylesList.size() - 1; i >= 0; --i) {
            JRStyle style = this.stylesList.get(i);
            if (!style.isDefault()) continue;
            this.setDefaultStyle(style);
            return;
        }
        this.setDefaultStyle(null);
    }

    public void setDefaultStyle(JRStyle style) {
        JRStyle old = this.defaultStyle;
        this.defaultStyle = style;
        this.getEventSupport().firePropertyChange(PROPERTY_DEFAULT_STLYE, old, this.defaultStyle);
    }

    @Override
    public JRStyle[] getStyles() {
        JRStyle[] stylesArray = new JRStyle[this.stylesList.size()];
        this.stylesList.toArray(stylesArray);
        return stylesArray;
    }

    public List<JRStyle> getStylesList() {
        return this.stylesList;
    }

    public Map<String, JRStyle> getStylesMap() {
        return this.stylesMap;
    }

    public void addStyle(JRStyle style) throws JRException {
        this.addStyle(this.stylesList.size(), style);
    }

    public void addStyle(int index, JRStyle style) throws JRException {
        if (this.stylesMap.containsKey(style.getName())) {
            throw new JRException("Duplicate declaration of report style : " + style.getName());
        }
        this.stylesList.add(index, style);
        this.stylesMap.put(style.getName(), style);
        if (style.isDefault()) {
            this.resetDefaultStyle();
        }
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_STYLES, style, index);
    }

    public JRStyle removeStyle(String styleName) {
        return this.removeStyle(this.stylesMap.get(styleName));
    }

    public JRStyle removeStyle(JRStyle style) {
        if (style != null) {
            int idx;
            if (style.isDefault()) {
                this.resetDefaultStyle();
            }
            if ((idx = this.stylesList.indexOf(style)) >= 0) {
                this.stylesList.remove(idx);
                this.stylesMap.remove(style.getName());
                this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_STYLES, style, idx);
            }
        }
        return style;
    }

    public List<JRScriptlet> getScriptletsList() {
        return this.mainDesignDataset.getScriptletsList();
    }

    public Map<String, JRScriptlet> getScriptletsMap() {
        return this.mainDesignDataset.getScriptletsMap();
    }

    public void addScriptlet(JRScriptlet scriptlet) throws JRException {
        this.mainDesignDataset.addScriptlet(scriptlet);
    }

    public JRScriptlet removeScriptlet(String scriptletName) {
        return this.mainDesignDataset.removeScriptlet(scriptletName);
    }

    public JRScriptlet removeScriptlet(JRScriptlet scriptlet) {
        return this.mainDesignDataset.removeScriptlet(scriptlet);
    }

    public List<JRParameter> getParametersList() {
        return this.mainDesignDataset.getParametersList();
    }

    public Map<String, JRParameter> getParametersMap() {
        return this.mainDesignDataset.getParametersMap();
    }

    public void addParameter(JRParameter parameter) throws JRException {
        this.mainDesignDataset.addParameter(parameter);
    }

    public JRParameter removeParameter(String parameterName) {
        return this.mainDesignDataset.removeParameter(parameterName);
    }

    public JRParameter removeParameter(JRParameter parameter) {
        return this.mainDesignDataset.removeParameter(parameter);
    }

    public void setQuery(JRDesignQuery query) {
        this.mainDesignDataset.setQuery(query);
    }

    public List<JRField> getFieldsList() {
        return this.mainDesignDataset.getFieldsList();
    }

    public Map<String, JRField> getFieldsMap() {
        return this.mainDesignDataset.getFieldsMap();
    }

    public void addField(JRField field) throws JRException {
        this.mainDesignDataset.addField(field);
    }

    public JRField removeField(String fieldName) {
        return this.mainDesignDataset.removeField(fieldName);
    }

    public JRField removeField(JRField field) {
        return this.mainDesignDataset.removeField(field);
    }

    public List<JRSortField> getSortFieldsList() {
        return this.mainDesignDataset.getSortFieldsList();
    }

    public void addSortField(JRSortField sortField) throws JRException {
        this.mainDesignDataset.addSortField(sortField);
    }

    public JRSortField removeSortField(String fieldName) {
        return this.mainDesignDataset.removeSortField(fieldName);
    }

    public JRSortField removeSortField(JRSortField sortField) {
        return this.mainDesignDataset.removeSortField(sortField);
    }

    public List<JRVariable> getVariablesList() {
        return this.mainDesignDataset.getVariablesList();
    }

    public Map<String, JRVariable> getVariablesMap() {
        return this.mainDesignDataset.getVariablesMap();
    }

    public void addVariable(JRDesignVariable variable) throws JRException {
        this.mainDesignDataset.addVariable(variable);
    }

    public JRVariable removeVariable(String variableName) {
        return this.mainDesignDataset.removeVariable(variableName);
    }

    public JRVariable removeVariable(JRVariable variable) {
        return this.mainDesignDataset.removeVariable(variable);
    }

    public List<JRGroup> getGroupsList() {
        return this.mainDesignDataset.getGroupsList();
    }

    public Map<String, JRGroup> getGroupsMap() {
        return this.mainDesignDataset.getGroupsMap();
    }

    public void addGroup(JRDesignGroup group) throws JRException {
        this.mainDesignDataset.addGroup(group);
    }

    public JRGroup removeGroup(String groupName) {
        return this.mainDesignDataset.removeGroup(groupName);
    }

    public JRGroup removeGroup(JRGroup group) {
        return this.mainDesignDataset.removeGroup(group);
    }

    public Collection<?> getExpressions() {
        return JRExpressionCollector.collectExpressions(this);
    }

    @Override
    public JRDataset[] getDatasets() {
        JRDataset[] datasetArray = new JRDataset[this.datasetList.size()];
        this.datasetList.toArray(datasetArray);
        return datasetArray;
    }

    public List<JRDataset> getDatasetsList() {
        return this.datasetList;
    }

    public Map<String, JRDataset> getDatasetMap() {
        return this.datasetMap;
    }

    public void addDataset(JRDesignDataset dataset) throws JRException {
        this.addDataset(this.datasetList.size(), dataset);
    }

    public void addDataset(int index, JRDesignDataset dataset) throws JRException {
        if (this.datasetMap.containsKey(dataset.getName())) {
            throw new JRException("Duplicate declaration of dataset : " + dataset.getName());
        }
        this.datasetList.add(index, dataset);
        this.datasetMap.put(dataset.getName(), dataset);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_DATASETS, dataset, index);
    }

    public JRDataset removeDataset(String datasetName) {
        return this.removeDataset(this.datasetMap.get(datasetName));
    }

    public JRDataset removeDataset(JRDataset dataset) {
        int idx;
        if (dataset != null && (idx = this.datasetList.indexOf(dataset)) >= 0) {
            this.datasetList.remove(idx);
            this.datasetMap.remove(dataset.getName());
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_DATASETS, dataset, idx);
        }
        return dataset;
    }

    public JRDesignDataset getMainDesignDataset() {
        return this.mainDesignDataset;
    }

    public void setMainDataset(JRDesignDataset dataset) {
        JRBand old = this.background;
        this.mainDesignDataset = dataset;
        this.mainDataset = this.mainDesignDataset;
        this.mainDesignDataset.setName(this.getName());
        this.mainDesignDataset.getEventSupport().addPropertyChangeListener(new PropagationChangeListener(this.getEventSupport()));
        this.getEventSupport().firePropertyChange(PROPERTY_MAIN_DATASET, old, this.mainDataset);
    }

    public void preprocess() {
        for (JRDesignCrosstab jRDesignCrosstab : this.getCrosstabs()) {
            jRDesignCrosstab.preprocess();
        }
    }

    protected List<JRCrosstab> getCrosstabs() {
        final ArrayList<JRCrosstab> crosstabs = new ArrayList<JRCrosstab>();
        JRElementsVisitor.visitReport(this, new JRVisitorSupport(){

            public void visitCrosstab(JRCrosstab crosstab) {
                crosstabs.add(crosstab);
            }
        });
        return crosstabs;
    }

    public void setIgnorePagination(boolean ignorePagination) {
        boolean old = this.ignorePagination;
        this.ignorePagination = ignorePagination;
        this.getEventSupport().firePropertyChange(PROPERTY_IGNORE_PAGINATION, old, this.ignorePagination);
    }

    public JRExpression getFilterExpression() {
        return this.mainDesignDataset.getFilterExpression();
    }

    public void setFilterExpression(JRExpression expression) {
        this.mainDesignDataset.setFilterExpression(expression);
    }

    public void addTemplate(JRReportTemplate template) {
        this.addTemplate(this.templateList.size(), template);
    }

    public void addTemplate(int index, JRReportTemplate template) {
        this.templateList.add(index, template);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_TEMPLATES, template, index);
    }

    public boolean removeTemplate(JRReportTemplate template) {
        int idx = this.templateList.indexOf(template);
        if (idx >= 0) {
            this.templateList.remove(idx);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_TEMPLATES, template, idx);
            return true;
        }
        return false;
    }

    @Override
    public JRReportTemplate[] getTemplates() {
        return this.templateList.toArray(new JRReportTemplate[this.templateList.size()]);
    }

    public List<JRReportTemplate> getTemplatesList() {
        return this.templateList;
    }

    protected void setBandOrigin(JRBand band, BandTypeEnum type) {
        if (band instanceof JRDesignBand) {
            JROrigin origin = new JROrigin(type);
            ((JRDesignBand)band).setOrigin(origin);
        }
    }

    protected void setSectionOrigin(JRSection section, BandTypeEnum type) {
        if (section instanceof JRDesignSection) {
            JROrigin origin = new JROrigin(type);
            ((JRDesignSection)section).setOrigin(origin);
        }
    }
}

